/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents how metadata stored in the AWS Glue Data Catalog is defined in a DataBrew dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataCatalogInputDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<DataCatalogInputDefinition.Builder, DataCatalogInputDefinition> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(DataCatalogInputDefinition::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(DataCatalogInputDefinition::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(DataCatalogInputDefinition::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<S3Location> TEMP_DIRECTORY_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("TempDirectory").getter(getter(DataCatalogInputDefinition::tempDirectory))
            .setter(setter(Builder::tempDirectory)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TempDirectory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, TABLE_NAME_FIELD, TEMP_DIRECTORY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String catalogId;

    private final String databaseName;

    private final String tableName;

    private final S3Location tempDirectory;

    private DataCatalogInputDefinition(BuilderImpl builder) {
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.tempDirectory = builder.tempDirectory;
    }

    /**
     * <p>
     * The unique identifier of the AWS account that holds the Data Catalog that stores the data.
     * </p>
     * 
     * @return The unique identifier of the AWS account that holds the Data Catalog that stores the data.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The name of a database in the Data Catalog.
     * </p>
     * 
     * @return The name of a database in the Data Catalog.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of a database table in the Data Catalog. This table corresponds to a DataBrew dataset.
     * </p>
     * 
     * @return The name of a database table in the Data Catalog. This table corresponds to a DataBrew dataset.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * An Amazon location that AWS Glue Data Catalog can use as a temporary directory.
     * </p>
     * 
     * @return An Amazon location that AWS Glue Data Catalog can use as a temporary directory.
     */
    public final S3Location tempDirectory() {
        return tempDirectory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(tempDirectory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCatalogInputDefinition)) {
            return false;
        }
        DataCatalogInputDefinition other = (DataCatalogInputDefinition) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tableName(), other.tableName()) && Objects.equals(tempDirectory(), other.tempDirectory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataCatalogInputDefinition").add("CatalogId", catalogId()).add("DatabaseName", databaseName())
                .add("TableName", tableName()).add("TempDirectory", tempDirectory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "TempDirectory":
            return Optional.ofNullable(clazz.cast(tempDirectory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataCatalogInputDefinition, T> g) {
        return obj -> g.apply((DataCatalogInputDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataCatalogInputDefinition> {
        /**
         * <p>
         * The unique identifier of the AWS account that holds the Data Catalog that stores the data.
         * </p>
         * 
         * @param catalogId
         *        The unique identifier of the AWS account that holds the Data Catalog that stores the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The name of a database in the Data Catalog.
         * </p>
         * 
         * @param databaseName
         *        The name of a database in the Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of a database table in the Data Catalog. This table corresponds to a DataBrew dataset.
         * </p>
         * 
         * @param tableName
         *        The name of a database table in the Data Catalog. This table corresponds to a DataBrew dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * An Amazon location that AWS Glue Data Catalog can use as a temporary directory.
         * </p>
         * 
         * @param tempDirectory
         *        An Amazon location that AWS Glue Data Catalog can use as a temporary directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tempDirectory(S3Location tempDirectory);

        /**
         * <p>
         * An Amazon location that AWS Glue Data Catalog can use as a temporary directory.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Location.Builder} avoiding the need to create
         * one manually via {@link S3Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #tempDirectory(S3Location)}.
         * 
         * @param tempDirectory
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tempDirectory(S3Location)
         */
        default Builder tempDirectory(Consumer<S3Location.Builder> tempDirectory) {
            return tempDirectory(S3Location.builder().applyMutation(tempDirectory).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private String tableName;

        private S3Location tempDirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(DataCatalogInputDefinition model) {
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            tableName(model.tableName);
            tempDirectory(model.tempDirectory);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final S3Location.Builder getTempDirectory() {
            return tempDirectory != null ? tempDirectory.toBuilder() : null;
        }

        @Override
        public final Builder tempDirectory(S3Location tempDirectory) {
            this.tempDirectory = tempDirectory;
            return this;
        }

        public final void setTempDirectory(S3Location.BuilderImpl tempDirectory) {
            this.tempDirectory = tempDirectory != null ? tempDirectory.build() : null;
        }

        @Override
        public DataCatalogInputDefinition build() {
            return new DataCatalogInputDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
