/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRecipeJobRequest extends DataBrewRequest implements
        ToCopyableBuilder<CreateRecipeJobRequest.Builder, CreateRecipeJobRequest> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(CreateRecipeJobRequest::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyArn").getter(getter(CreateRecipeJobRequest::encryptionKeyArn))
            .setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()).build();

    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionMode").getter(getter(CreateRecipeJobRequest::encryptionModeAsString))
            .setter(setter(Builder::encryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionMode").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateRecipeJobRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> LOG_SUBSCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogSubscription").getter(getter(CreateRecipeJobRequest::logSubscriptionAsString))
            .setter(setter(Builder::logSubscription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogSubscription").build()).build();

    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxCapacity").getter(getter(CreateRecipeJobRequest::maxCapacity)).setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()).build();

    private static final SdkField<Integer> MAX_RETRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRetries").getter(getter(CreateRecipeJobRequest::maxRetries)).setter(setter(Builder::maxRetries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetries").build()).build();

    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField
            .<List<Output>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(CreateRecipeJobRequest::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Output> builder(MarshallingType.SDK_POJO)
                                            .constructor(Output::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectName").getter(getter(CreateRecipeJobRequest::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()).build();

    private static final SdkField<RecipeReference> RECIPE_REFERENCE_FIELD = SdkField
            .<RecipeReference> builder(MarshallingType.SDK_POJO).memberName("RecipeReference")
            .getter(getter(CreateRecipeJobRequest::recipeReference)).setter(setter(Builder::recipeReference))
            .constructor(RecipeReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeReference").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateRecipeJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateRecipeJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(CreateRecipeJobRequest::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD,
            ENCRYPTION_KEY_ARN_FIELD, ENCRYPTION_MODE_FIELD, NAME_FIELD, LOG_SUBSCRIPTION_FIELD, MAX_CAPACITY_FIELD,
            MAX_RETRIES_FIELD, OUTPUTS_FIELD, PROJECT_NAME_FIELD, RECIPE_REFERENCE_FIELD, ROLE_ARN_FIELD, TAGS_FIELD,
            TIMEOUT_FIELD));

    private final String datasetName;

    private final String encryptionKeyArn;

    private final String encryptionMode;

    private final String name;

    private final String logSubscription;

    private final Integer maxCapacity;

    private final Integer maxRetries;

    private final List<Output> outputs;

    private final String projectName;

    private final RecipeReference recipeReference;

    private final String roleArn;

    private final Map<String, String> tags;

    private final Integer timeout;

    private CreateRecipeJobRequest(BuilderImpl builder) {
        super(builder);
        this.datasetName = builder.datasetName;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.encryptionMode = builder.encryptionMode;
        this.name = builder.name;
        this.logSubscription = builder.logSubscription;
        this.maxCapacity = builder.maxCapacity;
        this.maxRetries = builder.maxRetries;
        this.outputs = builder.outputs;
        this.projectName = builder.projectName;
        this.recipeReference = builder.recipeReference;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.timeout = builder.timeout;
    }

    /**
     * <p>
     * The name of the dataset that this job processes.
     * </p>
     * 
     * @return The name of the dataset that this job processes.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    /**
     * <p>
     * The encryption mode for the job, which can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SSE-KMS</code> - Server-side encryption with keys managed by AWS KMS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionMode}
     * will return {@link EncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionModeAsString}.
     * </p>
     * 
     * @return The encryption mode for the job, which can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SSE-KMS</code> - Server-side encryption with keys managed by AWS KMS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
     *         </p>
     *         </li>
     * @see EncryptionMode
     */
    public final EncryptionMode encryptionMode() {
        return EncryptionMode.fromValue(encryptionMode);
    }

    /**
     * <p>
     * The encryption mode for the job, which can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SSE-KMS</code> - Server-side encryption with keys managed by AWS KMS.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionMode}
     * will return {@link EncryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionModeAsString}.
     * </p>
     * 
     * @return The encryption mode for the job, which can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SSE-KMS</code> - Server-side encryption with keys managed by AWS KMS.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
     *         </p>
     *         </li>
     * @see EncryptionMode
     */
    public final String encryptionModeAsString() {
        return encryptionMode;
    }

    /**
     * <p>
     * A unique name for the job. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and space.
     * </p>
     * 
     * @return A unique name for the job. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and
     *         space.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log
     * stream for each job run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logSubscription}
     * will return {@link LogSubscription#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #logSubscriptionAsString}.
     * </p>
     * 
     * @return Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one
     *         log stream for each job run.
     * @see LogSubscription
     */
    public final LogSubscription logSubscription() {
        return LogSubscription.fromValue(logSubscription);
    }

    /**
     * <p>
     * Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log
     * stream for each job run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logSubscription}
     * will return {@link LogSubscription#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #logSubscriptionAsString}.
     * </p>
     * 
     * @return Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one
     *         log stream for each job run.
     * @see LogSubscription
     */
    public final String logSubscriptionAsString() {
        return logSubscription;
    }

    /**
     * <p>
     * The maximum number of nodes that DataBrew can consume when the job processes data.
     * </p>
     * 
     * @return The maximum number of nodes that DataBrew can consume when the job processes data.
     */
    public final Integer maxCapacity() {
        return maxCapacity;
    }

    /**
     * <p>
     * The maximum number of times to retry the job after a job run fails.
     * </p>
     * 
     * @return The maximum number of times to retry the job after a job run fails.
     */
    public final Integer maxRetries() {
        return maxRetries;
    }

    /**
     * Returns true if the Outputs property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more artifacts that represent the output from running the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOutputs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more artifacts that represent the output from running the job.
     */
    public final List<Output> outputs() {
        return outputs;
    }

    /**
     * <p>
     * Either the name of an existing project, or a combination of a recipe and a dataset to associate with the recipe.
     * </p>
     * 
     * @return Either the name of an existing project, or a combination of a recipe and a dataset to associate with the
     *         recipe.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * Returns the value of the RecipeReference property for this object.
     * 
     * @return The value of the RecipeReference property for this object.
     */
    public final RecipeReference recipeReference() {
        return recipeReference;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role to be assumed when DataBrew
     * runs the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role to be assumed when
     *         DataBrew runs the job.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata tags to apply to this job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata tags to apply to this job.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status of
     * <code>TIMEOUT</code>.
     * </p>
     * 
     * @return The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a
     *         status of <code>TIMEOUT</code>.
     */
    public final Integer timeout() {
        return timeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(logSubscriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(recipeReference());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRecipeJobRequest)) {
            return false;
        }
        CreateRecipeJobRequest other = (CreateRecipeJobRequest) obj;
        return Objects.equals(datasetName(), other.datasetName()) && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn())
                && Objects.equals(encryptionModeAsString(), other.encryptionModeAsString())
                && Objects.equals(name(), other.name())
                && Objects.equals(logSubscriptionAsString(), other.logSubscriptionAsString())
                && Objects.equals(maxCapacity(), other.maxCapacity()) && Objects.equals(maxRetries(), other.maxRetries())
                && hasOutputs() == other.hasOutputs() && Objects.equals(outputs(), other.outputs())
                && Objects.equals(projectName(), other.projectName())
                && Objects.equals(recipeReference(), other.recipeReference()) && Objects.equals(roleArn(), other.roleArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(timeout(), other.timeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRecipeJobRequest").add("DatasetName", datasetName())
                .add("EncryptionKeyArn", encryptionKeyArn()).add("EncryptionMode", encryptionModeAsString()).add("Name", name())
                .add("LogSubscription", logSubscriptionAsString()).add("MaxCapacity", maxCapacity())
                .add("MaxRetries", maxRetries()).add("Outputs", hasOutputs() ? outputs() : null)
                .add("ProjectName", projectName()).add("RecipeReference", recipeReference()).add("RoleArn", roleArn())
                .add("Tags", hasTags() ? tags() : null).add("Timeout", timeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "EncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        case "EncryptionMode":
            return Optional.ofNullable(clazz.cast(encryptionModeAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "LogSubscription":
            return Optional.ofNullable(clazz.cast(logSubscriptionAsString()));
        case "MaxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        case "MaxRetries":
            return Optional.ofNullable(clazz.cast(maxRetries()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "ProjectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "RecipeReference":
            return Optional.ofNullable(clazz.cast(recipeReference()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRecipeJobRequest, T> g) {
        return obj -> g.apply((CreateRecipeJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataBrewRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRecipeJobRequest> {
        /**
         * <p>
         * The name of the dataset that this job processes.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset that this job processes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The Amazon Resource Name (ARN) of an encryption key that is used to protect the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);

        /**
         * <p>
         * The encryption mode for the job, which can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SSE-KMS</code> - Server-side encryption with keys managed by AWS KMS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encryptionMode
         *        The encryption mode for the job, which can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SSE-KMS</code> - Server-side encryption with keys managed by AWS KMS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
         *        </p>
         *        </li>
         * @see EncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionMode
         */
        Builder encryptionMode(String encryptionMode);

        /**
         * <p>
         * The encryption mode for the job, which can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SSE-KMS</code> - Server-side encryption with keys managed by AWS KMS.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encryptionMode
         *        The encryption mode for the job, which can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SSE-KMS</code> - Server-side encryption with keys managed by AWS KMS.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SSE-S3</code> - Server-side encryption with keys managed by Amazon S3.
         *        </p>
         *        </li>
         * @see EncryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionMode
         */
        Builder encryptionMode(EncryptionMode encryptionMode);

        /**
         * <p>
         * A unique name for the job. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.), and
         * space.
         * </p>
         * 
         * @param name
         *        A unique name for the job. Valid characters are alphanumeric (A-Z, a-z, 0-9), hyphen (-), period (.),
         *        and space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log
         * stream for each job run.
         * </p>
         * 
         * @param logSubscription
         *        Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes
         *        one log stream for each job run.
         * @see LogSubscription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogSubscription
         */
        Builder logSubscription(String logSubscription);

        /**
         * <p>
         * Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes one log
         * stream for each job run.
         * </p>
         * 
         * @param logSubscription
         *        Enables or disables Amazon CloudWatch logging for the job. If logging is enabled, CloudWatch writes
         *        one log stream for each job run.
         * @see LogSubscription
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogSubscription
         */
        Builder logSubscription(LogSubscription logSubscription);

        /**
         * <p>
         * The maximum number of nodes that DataBrew can consume when the job processes data.
         * </p>
         * 
         * @param maxCapacity
         *        The maximum number of nodes that DataBrew can consume when the job processes data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Integer maxCapacity);

        /**
         * <p>
         * The maximum number of times to retry the job after a job run fails.
         * </p>
         * 
         * @param maxRetries
         *        The maximum number of times to retry the job after a job run fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRetries(Integer maxRetries);

        /**
         * <p>
         * One or more artifacts that represent the output from running the job.
         * </p>
         * 
         * @param outputs
         *        One or more artifacts that represent the output from running the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<Output> outputs);

        /**
         * <p>
         * One or more artifacts that represent the output from running the job.
         * </p>
         * 
         * @param outputs
         *        One or more artifacts that represent the output from running the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Output... outputs);

        /**
         * <p>
         * One or more artifacts that represent the output from running the job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Output>.Builder} avoiding the need to
         * create one manually via {@link List<Output>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Output>.Builder#build()} is called immediately and its
         * result is passed to {@link #outputs(List<Output>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on {@link List<Output>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(List<Output>)
         */
        Builder outputs(Consumer<Output.Builder>... outputs);

        /**
         * <p>
         * Either the name of an existing project, or a combination of a recipe and a dataset to associate with the
         * recipe.
         * </p>
         * 
         * @param projectName
         *        Either the name of an existing project, or a combination of a recipe and a dataset to associate with
         *        the recipe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * Sets the value of the RecipeReference property for this object.
         *
         * @param recipeReference
         *        The new value for the RecipeReference property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeReference(RecipeReference recipeReference);

        /**
         * Sets the value of the RecipeReference property for this object.
         *
         * This is a convenience that creates an instance of the {@link RecipeReference.Builder} avoiding the need to
         * create one manually via {@link RecipeReference#builder()}.
         *
         * When the {@link Consumer} completes, {@link RecipeReference.Builder#build()} is called immediately and its
         * result is passed to {@link #recipeReference(RecipeReference)}.
         * 
         * @param recipeReference
         *        a consumer that will call methods on {@link RecipeReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recipeReference(RecipeReference)
         */
        default Builder recipeReference(Consumer<RecipeReference.Builder> recipeReference) {
            return recipeReference(RecipeReference.builder().applyMutation(recipeReference).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role to be assumed when
         * DataBrew runs the job.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role to be assumed when
         *        DataBrew runs the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Metadata tags to apply to this job.
         * </p>
         * 
         * @param tags
         *        Metadata tags to apply to this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a status
         * of <code>TIMEOUT</code>.
         * </p>
         * 
         * @param timeout
         *        The job's timeout in minutes. A job that attempts to run longer than this timeout period ends with a
         *        status of <code>TIMEOUT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataBrewRequest.BuilderImpl implements Builder {
        private String datasetName;

        private String encryptionKeyArn;

        private String encryptionMode;

        private String name;

        private String logSubscription;

        private Integer maxCapacity;

        private Integer maxRetries;

        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();

        private String projectName;

        private RecipeReference recipeReference;

        private String roleArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Integer timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRecipeJobRequest model) {
            super(model);
            datasetName(model.datasetName);
            encryptionKeyArn(model.encryptionKeyArn);
            encryptionMode(model.encryptionMode);
            name(model.name);
            logSubscription(model.logSubscription);
            maxCapacity(model.maxCapacity);
            maxRetries(model.maxRetries);
            outputs(model.outputs);
            projectName(model.projectName);
            recipeReference(model.recipeReference);
            roleArn(model.roleArn);
            tags(model.tags);
            timeout(model.timeout);
        }

        public final String getDatasetName() {
            return datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        public final String getEncryptionMode() {
            return encryptionMode;
        }

        @Override
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        @Override
        public final Builder encryptionMode(EncryptionMode encryptionMode) {
            this.encryptionMode(encryptionMode == null ? null : encryptionMode.toString());
            return this;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getLogSubscription() {
            return logSubscription;
        }

        @Override
        public final Builder logSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
            return this;
        }

        @Override
        public final Builder logSubscription(LogSubscription logSubscription) {
            this.logSubscription(logSubscription == null ? null : logSubscription.toString());
            return this;
        }

        public final void setLogSubscription(String logSubscription) {
            this.logSubscription = logSubscription;
        }

        public final Integer getMaxCapacity() {
            return maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public final Integer getMaxRetries() {
            return maxRetries;
        }

        @Override
        public final Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        public final Collection<Output.Builder> getOutputs() {
            if (outputs instanceof SdkAutoConstructList) {
                return null;
            }
            return outputs != null ? outputs.stream().map(Output::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputListCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> Output.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = OutputListCopier.copyFromBuilder(outputs);
        }

        public final String getProjectName() {
            return projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final RecipeReference.Builder getRecipeReference() {
            return recipeReference != null ? recipeReference.toBuilder() : null;
        }

        @Override
        public final Builder recipeReference(RecipeReference recipeReference) {
            this.recipeReference = recipeReference;
            return this;
        }

        public final void setRecipeReference(RecipeReference.BuilderImpl recipeReference) {
            this.recipeReference = recipeReference != null ? recipeReference.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final Integer getTimeout() {
            return timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRecipeJobRequest build() {
            return new CreateRecipeJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
