/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelChildrenRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelChildrenResponse;
import software.amazon.awssdk.services.databasemigration.model.MetadataModelReference;

public class DescribeMetadataModelChildrenPublisher
implements SdkPublisher<DescribeMetadataModelChildrenResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeMetadataModelChildrenRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMetadataModelChildrenPublisher(DatabaseMigrationAsyncClient client, DescribeMetadataModelChildrenRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMetadataModelChildrenPublisher(DatabaseMigrationAsyncClient client, DescribeMetadataModelChildrenRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMetadataModelChildrenResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMetadataModelChildrenResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MetadataModelReference> metadataModelChildren() {
        Function<DescribeMetadataModelChildrenResponse, Iterator> getIterator = response -> {
            if (response != null && response.metadataModelChildren() != null) {
                return response.metadataModelChildren().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeMetadataModelChildrenResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeMetadataModelChildrenResponseFetcher
    implements AsyncPageFetcher<DescribeMetadataModelChildrenResponse> {
        private DescribeMetadataModelChildrenResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMetadataModelChildrenResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeMetadataModelChildrenResponse> nextPage(DescribeMetadataModelChildrenResponse previousPage) {
            if (previousPage == null) {
                return DescribeMetadataModelChildrenPublisher.this.client.describeMetadataModelChildren(DescribeMetadataModelChildrenPublisher.this.firstRequest);
            }
            return DescribeMetadataModelChildrenPublisher.this.client.describeMetadataModelChildren((DescribeMetadataModelChildrenRequest)((Object)DescribeMetadataModelChildrenPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

