/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.databasemigration.model.DocDbDataProviderSettings;
import software.amazon.awssdk.services.databasemigration.model.IbmDb2LuwDataProviderSettings;
import software.amazon.awssdk.services.databasemigration.model.IbmDb2zOsDataProviderSettings;
import software.amazon.awssdk.services.databasemigration.model.MariaDbDataProviderSettings;
import software.amazon.awssdk.services.databasemigration.model.MicrosoftSqlServerDataProviderSettings;
import software.amazon.awssdk.services.databasemigration.model.MongoDbDataProviderSettings;
import software.amazon.awssdk.services.databasemigration.model.MySqlDataProviderSettings;
import software.amazon.awssdk.services.databasemigration.model.OracleDataProviderSettings;
import software.amazon.awssdk.services.databasemigration.model.PostgreSqlDataProviderSettings;
import software.amazon.awssdk.services.databasemigration.model.RedshiftDataProviderSettings;
import software.amazon.awssdk.services.databasemigration.model.SybaseAseDataProviderSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataProviderSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataProviderSettings> {
    private static final SdkField<RedshiftDataProviderSettings> REDSHIFT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RedshiftSettings").getter(DataProviderSettings.getter(DataProviderSettings::redshiftSettings)).setter(DataProviderSettings.setter(Builder::redshiftSettings)).constructor(RedshiftDataProviderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftSettings").build()}).build();
    private static final SdkField<PostgreSqlDataProviderSettings> POSTGRE_SQL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PostgreSqlSettings").getter(DataProviderSettings.getter(DataProviderSettings::postgreSqlSettings)).setter(DataProviderSettings.setter(Builder::postgreSqlSettings)).constructor(PostgreSqlDataProviderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostgreSqlSettings").build()}).build();
    private static final SdkField<MySqlDataProviderSettings> MY_SQL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MySqlSettings").getter(DataProviderSettings.getter(DataProviderSettings::mySqlSettings)).setter(DataProviderSettings.setter(Builder::mySqlSettings)).constructor(MySqlDataProviderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MySqlSettings").build()}).build();
    private static final SdkField<OracleDataProviderSettings> ORACLE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OracleSettings").getter(DataProviderSettings.getter(DataProviderSettings::oracleSettings)).setter(DataProviderSettings.setter(Builder::oracleSettings)).constructor(OracleDataProviderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OracleSettings").build()}).build();
    private static final SdkField<SybaseAseDataProviderSettings> SYBASE_ASE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SybaseAseSettings").getter(DataProviderSettings.getter(DataProviderSettings::sybaseAseSettings)).setter(DataProviderSettings.setter(Builder::sybaseAseSettings)).constructor(SybaseAseDataProviderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SybaseAseSettings").build()}).build();
    private static final SdkField<MicrosoftSqlServerDataProviderSettings> MICROSOFT_SQL_SERVER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MicrosoftSqlServerSettings").getter(DataProviderSettings.getter(DataProviderSettings::microsoftSqlServerSettings)).setter(DataProviderSettings.setter(Builder::microsoftSqlServerSettings)).constructor(MicrosoftSqlServerDataProviderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MicrosoftSqlServerSettings").build()}).build();
    private static final SdkField<DocDbDataProviderSettings> DOC_DB_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocDbSettings").getter(DataProviderSettings.getter(DataProviderSettings::docDbSettings)).setter(DataProviderSettings.setter(Builder::docDbSettings)).constructor(DocDbDataProviderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocDbSettings").build()}).build();
    private static final SdkField<MariaDbDataProviderSettings> MARIA_DB_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MariaDbSettings").getter(DataProviderSettings.getter(DataProviderSettings::mariaDbSettings)).setter(DataProviderSettings.setter(Builder::mariaDbSettings)).constructor(MariaDbDataProviderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MariaDbSettings").build()}).build();
    private static final SdkField<IbmDb2LuwDataProviderSettings> IBM_DB2_LUW_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IbmDb2LuwSettings").getter(DataProviderSettings.getter(DataProviderSettings::ibmDb2LuwSettings)).setter(DataProviderSettings.setter(Builder::ibmDb2LuwSettings)).constructor(IbmDb2LuwDataProviderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IbmDb2LuwSettings").build()}).build();
    private static final SdkField<IbmDb2zOsDataProviderSettings> IBM_DB2_Z_OS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IbmDb2zOsSettings").getter(DataProviderSettings.getter(DataProviderSettings::ibmDb2zOsSettings)).setter(DataProviderSettings.setter(Builder::ibmDb2zOsSettings)).constructor(IbmDb2zOsDataProviderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IbmDb2zOsSettings").build()}).build();
    private static final SdkField<MongoDbDataProviderSettings> MONGO_DB_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MongoDbSettings").getter(DataProviderSettings.getter(DataProviderSettings::mongoDbSettings)).setter(DataProviderSettings.setter(Builder::mongoDbSettings)).constructor(MongoDbDataProviderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MongoDbSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REDSHIFT_SETTINGS_FIELD, POSTGRE_SQL_SETTINGS_FIELD, MY_SQL_SETTINGS_FIELD, ORACLE_SETTINGS_FIELD, SYBASE_ASE_SETTINGS_FIELD, MICROSOFT_SQL_SERVER_SETTINGS_FIELD, DOC_DB_SETTINGS_FIELD, MARIA_DB_SETTINGS_FIELD, IBM_DB2_LUW_SETTINGS_FIELD, IBM_DB2_Z_OS_SETTINGS_FIELD, MONGO_DB_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataProviderSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RedshiftDataProviderSettings redshiftSettings;
    private final PostgreSqlDataProviderSettings postgreSqlSettings;
    private final MySqlDataProviderSettings mySqlSettings;
    private final OracleDataProviderSettings oracleSettings;
    private final SybaseAseDataProviderSettings sybaseAseSettings;
    private final MicrosoftSqlServerDataProviderSettings microsoftSqlServerSettings;
    private final DocDbDataProviderSettings docDbSettings;
    private final MariaDbDataProviderSettings mariaDbSettings;
    private final IbmDb2LuwDataProviderSettings ibmDb2LuwSettings;
    private final IbmDb2zOsDataProviderSettings ibmDb2zOsSettings;
    private final MongoDbDataProviderSettings mongoDbSettings;
    private final Type type;

    private DataProviderSettings(BuilderImpl builder) {
        this.redshiftSettings = builder.redshiftSettings;
        this.postgreSqlSettings = builder.postgreSqlSettings;
        this.mySqlSettings = builder.mySqlSettings;
        this.oracleSettings = builder.oracleSettings;
        this.sybaseAseSettings = builder.sybaseAseSettings;
        this.microsoftSqlServerSettings = builder.microsoftSqlServerSettings;
        this.docDbSettings = builder.docDbSettings;
        this.mariaDbSettings = builder.mariaDbSettings;
        this.ibmDb2LuwSettings = builder.ibmDb2LuwSettings;
        this.ibmDb2zOsSettings = builder.ibmDb2zOsSettings;
        this.mongoDbSettings = builder.mongoDbSettings;
        this.type = builder.type;
    }

    public final RedshiftDataProviderSettings redshiftSettings() {
        return this.redshiftSettings;
    }

    public final PostgreSqlDataProviderSettings postgreSqlSettings() {
        return this.postgreSqlSettings;
    }

    public final MySqlDataProviderSettings mySqlSettings() {
        return this.mySqlSettings;
    }

    public final OracleDataProviderSettings oracleSettings() {
        return this.oracleSettings;
    }

    public final SybaseAseDataProviderSettings sybaseAseSettings() {
        return this.sybaseAseSettings;
    }

    public final MicrosoftSqlServerDataProviderSettings microsoftSqlServerSettings() {
        return this.microsoftSqlServerSettings;
    }

    public final DocDbDataProviderSettings docDbSettings() {
        return this.docDbSettings;
    }

    public final MariaDbDataProviderSettings mariaDbSettings() {
        return this.mariaDbSettings;
    }

    public final IbmDb2LuwDataProviderSettings ibmDb2LuwSettings() {
        return this.ibmDb2LuwSettings;
    }

    public final IbmDb2zOsDataProviderSettings ibmDb2zOsSettings() {
        return this.ibmDb2zOsSettings;
    }

    public final MongoDbDataProviderSettings mongoDbSettings() {
        return this.mongoDbSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.postgreSqlSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mySqlSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.oracleSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.sybaseAseSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.microsoftSqlServerSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.docDbSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mariaDbSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.ibmDb2LuwSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.ibmDb2zOsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mongoDbSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProviderSettings)) {
            return false;
        }
        DataProviderSettings other = (DataProviderSettings)obj;
        return Objects.equals(this.redshiftSettings(), other.redshiftSettings()) && Objects.equals(this.postgreSqlSettings(), other.postgreSqlSettings()) && Objects.equals(this.mySqlSettings(), other.mySqlSettings()) && Objects.equals(this.oracleSettings(), other.oracleSettings()) && Objects.equals(this.sybaseAseSettings(), other.sybaseAseSettings()) && Objects.equals(this.microsoftSqlServerSettings(), other.microsoftSqlServerSettings()) && Objects.equals(this.docDbSettings(), other.docDbSettings()) && Objects.equals(this.mariaDbSettings(), other.mariaDbSettings()) && Objects.equals(this.ibmDb2LuwSettings(), other.ibmDb2LuwSettings()) && Objects.equals(this.ibmDb2zOsSettings(), other.ibmDb2zOsSettings()) && Objects.equals(this.mongoDbSettings(), other.mongoDbSettings());
    }

    public final String toString() {
        return ToString.builder((String)"DataProviderSettings").add("RedshiftSettings", (Object)this.redshiftSettings()).add("PostgreSqlSettings", (Object)this.postgreSqlSettings()).add("MySqlSettings", (Object)this.mySqlSettings()).add("OracleSettings", (Object)this.oracleSettings()).add("SybaseAseSettings", (Object)this.sybaseAseSettings()).add("MicrosoftSqlServerSettings", (Object)this.microsoftSqlServerSettings()).add("DocDbSettings", (Object)this.docDbSettings()).add("MariaDbSettings", (Object)this.mariaDbSettings()).add("IbmDb2LuwSettings", (Object)this.ibmDb2LuwSettings()).add("IbmDb2zOsSettings", (Object)this.ibmDb2zOsSettings()).add("MongoDbSettings", (Object)this.mongoDbSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RedshiftSettings": {
                return Optional.ofNullable(clazz.cast(this.redshiftSettings()));
            }
            case "PostgreSqlSettings": {
                return Optional.ofNullable(clazz.cast(this.postgreSqlSettings()));
            }
            case "MySqlSettings": {
                return Optional.ofNullable(clazz.cast(this.mySqlSettings()));
            }
            case "OracleSettings": {
                return Optional.ofNullable(clazz.cast(this.oracleSettings()));
            }
            case "SybaseAseSettings": {
                return Optional.ofNullable(clazz.cast(this.sybaseAseSettings()));
            }
            case "MicrosoftSqlServerSettings": {
                return Optional.ofNullable(clazz.cast(this.microsoftSqlServerSettings()));
            }
            case "DocDbSettings": {
                return Optional.ofNullable(clazz.cast(this.docDbSettings()));
            }
            case "MariaDbSettings": {
                return Optional.ofNullable(clazz.cast(this.mariaDbSettings()));
            }
            case "IbmDb2LuwSettings": {
                return Optional.ofNullable(clazz.cast(this.ibmDb2LuwSettings()));
            }
            case "IbmDb2zOsSettings": {
                return Optional.ofNullable(clazz.cast(this.ibmDb2zOsSettings()));
            }
            case "MongoDbSettings": {
                return Optional.ofNullable(clazz.cast(this.mongoDbSettings()));
            }
        }
        return Optional.empty();
    }

    public static DataProviderSettings fromRedshiftSettings(RedshiftDataProviderSettings redshiftSettings) {
        return (DataProviderSettings)DataProviderSettings.builder().redshiftSettings(redshiftSettings).build();
    }

    public static DataProviderSettings fromRedshiftSettings(Consumer<RedshiftDataProviderSettings.Builder> redshiftSettings) {
        RedshiftDataProviderSettings.Builder builder = RedshiftDataProviderSettings.builder();
        redshiftSettings.accept(builder);
        return DataProviderSettings.fromRedshiftSettings((RedshiftDataProviderSettings)builder.build());
    }

    public static DataProviderSettings fromPostgreSqlSettings(PostgreSqlDataProviderSettings postgreSqlSettings) {
        return (DataProviderSettings)DataProviderSettings.builder().postgreSqlSettings(postgreSqlSettings).build();
    }

    public static DataProviderSettings fromPostgreSqlSettings(Consumer<PostgreSqlDataProviderSettings.Builder> postgreSqlSettings) {
        PostgreSqlDataProviderSettings.Builder builder = PostgreSqlDataProviderSettings.builder();
        postgreSqlSettings.accept(builder);
        return DataProviderSettings.fromPostgreSqlSettings((PostgreSqlDataProviderSettings)builder.build());
    }

    public static DataProviderSettings fromMySqlSettings(MySqlDataProviderSettings mySqlSettings) {
        return (DataProviderSettings)DataProviderSettings.builder().mySqlSettings(mySqlSettings).build();
    }

    public static DataProviderSettings fromMySqlSettings(Consumer<MySqlDataProviderSettings.Builder> mySqlSettings) {
        MySqlDataProviderSettings.Builder builder = MySqlDataProviderSettings.builder();
        mySqlSettings.accept(builder);
        return DataProviderSettings.fromMySqlSettings((MySqlDataProviderSettings)builder.build());
    }

    public static DataProviderSettings fromOracleSettings(OracleDataProviderSettings oracleSettings) {
        return (DataProviderSettings)DataProviderSettings.builder().oracleSettings(oracleSettings).build();
    }

    public static DataProviderSettings fromOracleSettings(Consumer<OracleDataProviderSettings.Builder> oracleSettings) {
        OracleDataProviderSettings.Builder builder = OracleDataProviderSettings.builder();
        oracleSettings.accept(builder);
        return DataProviderSettings.fromOracleSettings((OracleDataProviderSettings)builder.build());
    }

    public static DataProviderSettings fromSybaseAseSettings(SybaseAseDataProviderSettings sybaseAseSettings) {
        return (DataProviderSettings)DataProviderSettings.builder().sybaseAseSettings(sybaseAseSettings).build();
    }

    public static DataProviderSettings fromSybaseAseSettings(Consumer<SybaseAseDataProviderSettings.Builder> sybaseAseSettings) {
        SybaseAseDataProviderSettings.Builder builder = SybaseAseDataProviderSettings.builder();
        sybaseAseSettings.accept(builder);
        return DataProviderSettings.fromSybaseAseSettings((SybaseAseDataProviderSettings)builder.build());
    }

    public static DataProviderSettings fromMicrosoftSqlServerSettings(MicrosoftSqlServerDataProviderSettings microsoftSqlServerSettings) {
        return (DataProviderSettings)DataProviderSettings.builder().microsoftSqlServerSettings(microsoftSqlServerSettings).build();
    }

    public static DataProviderSettings fromMicrosoftSqlServerSettings(Consumer<MicrosoftSqlServerDataProviderSettings.Builder> microsoftSqlServerSettings) {
        MicrosoftSqlServerDataProviderSettings.Builder builder = MicrosoftSqlServerDataProviderSettings.builder();
        microsoftSqlServerSettings.accept(builder);
        return DataProviderSettings.fromMicrosoftSqlServerSettings((MicrosoftSqlServerDataProviderSettings)builder.build());
    }

    public static DataProviderSettings fromDocDbSettings(DocDbDataProviderSettings docDbSettings) {
        return (DataProviderSettings)DataProviderSettings.builder().docDbSettings(docDbSettings).build();
    }

    public static DataProviderSettings fromDocDbSettings(Consumer<DocDbDataProviderSettings.Builder> docDbSettings) {
        DocDbDataProviderSettings.Builder builder = DocDbDataProviderSettings.builder();
        docDbSettings.accept(builder);
        return DataProviderSettings.fromDocDbSettings((DocDbDataProviderSettings)builder.build());
    }

    public static DataProviderSettings fromMariaDbSettings(MariaDbDataProviderSettings mariaDbSettings) {
        return (DataProviderSettings)DataProviderSettings.builder().mariaDbSettings(mariaDbSettings).build();
    }

    public static DataProviderSettings fromMariaDbSettings(Consumer<MariaDbDataProviderSettings.Builder> mariaDbSettings) {
        MariaDbDataProviderSettings.Builder builder = MariaDbDataProviderSettings.builder();
        mariaDbSettings.accept(builder);
        return DataProviderSettings.fromMariaDbSettings((MariaDbDataProviderSettings)builder.build());
    }

    public static DataProviderSettings fromIbmDb2LuwSettings(IbmDb2LuwDataProviderSettings ibmDb2LuwSettings) {
        return (DataProviderSettings)DataProviderSettings.builder().ibmDb2LuwSettings(ibmDb2LuwSettings).build();
    }

    public static DataProviderSettings fromIbmDb2LuwSettings(Consumer<IbmDb2LuwDataProviderSettings.Builder> ibmDb2LuwSettings) {
        IbmDb2LuwDataProviderSettings.Builder builder = IbmDb2LuwDataProviderSettings.builder();
        ibmDb2LuwSettings.accept(builder);
        return DataProviderSettings.fromIbmDb2LuwSettings((IbmDb2LuwDataProviderSettings)builder.build());
    }

    public static DataProviderSettings fromIbmDb2zOsSettings(IbmDb2zOsDataProviderSettings ibmDb2zOsSettings) {
        return (DataProviderSettings)DataProviderSettings.builder().ibmDb2zOsSettings(ibmDb2zOsSettings).build();
    }

    public static DataProviderSettings fromIbmDb2zOsSettings(Consumer<IbmDb2zOsDataProviderSettings.Builder> ibmDb2zOsSettings) {
        IbmDb2zOsDataProviderSettings.Builder builder = IbmDb2zOsDataProviderSettings.builder();
        ibmDb2zOsSettings.accept(builder);
        return DataProviderSettings.fromIbmDb2zOsSettings((IbmDb2zOsDataProviderSettings)builder.build());
    }

    public static DataProviderSettings fromMongoDbSettings(MongoDbDataProviderSettings mongoDbSettings) {
        return (DataProviderSettings)DataProviderSettings.builder().mongoDbSettings(mongoDbSettings).build();
    }

    public static DataProviderSettings fromMongoDbSettings(Consumer<MongoDbDataProviderSettings.Builder> mongoDbSettings) {
        MongoDbDataProviderSettings.Builder builder = MongoDbDataProviderSettings.builder();
        mongoDbSettings.accept(builder);
        return DataProviderSettings.fromMongoDbSettings((MongoDbDataProviderSettings)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RedshiftSettings", REDSHIFT_SETTINGS_FIELD);
        map.put("PostgreSqlSettings", POSTGRE_SQL_SETTINGS_FIELD);
        map.put("MySqlSettings", MY_SQL_SETTINGS_FIELD);
        map.put("OracleSettings", ORACLE_SETTINGS_FIELD);
        map.put("SybaseAseSettings", SYBASE_ASE_SETTINGS_FIELD);
        map.put("MicrosoftSqlServerSettings", MICROSOFT_SQL_SERVER_SETTINGS_FIELD);
        map.put("DocDbSettings", DOC_DB_SETTINGS_FIELD);
        map.put("MariaDbSettings", MARIA_DB_SETTINGS_FIELD);
        map.put("IbmDb2LuwSettings", IBM_DB2_LUW_SETTINGS_FIELD);
        map.put("IbmDb2zOsSettings", IBM_DB2_Z_OS_SETTINGS_FIELD);
        map.put("MongoDbSettings", MONGO_DB_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataProviderSettings, T> g) {
        return obj -> g.apply((DataProviderSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        REDSHIFT_SETTINGS,
        POSTGRE_SQL_SETTINGS,
        MY_SQL_SETTINGS,
        ORACLE_SETTINGS,
        SYBASE_ASE_SETTINGS,
        MICROSOFT_SQL_SERVER_SETTINGS,
        DOC_DB_SETTINGS,
        MARIA_DB_SETTINGS,
        IBM_DB2_LUW_SETTINGS,
        IBM_DB2_Z_OS_SETTINGS,
        MONGO_DB_SETTINGS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private RedshiftDataProviderSettings redshiftSettings;
        private PostgreSqlDataProviderSettings postgreSqlSettings;
        private MySqlDataProviderSettings mySqlSettings;
        private OracleDataProviderSettings oracleSettings;
        private SybaseAseDataProviderSettings sybaseAseSettings;
        private MicrosoftSqlServerDataProviderSettings microsoftSqlServerSettings;
        private DocDbDataProviderSettings docDbSettings;
        private MariaDbDataProviderSettings mariaDbSettings;
        private IbmDb2LuwDataProviderSettings ibmDb2LuwSettings;
        private IbmDb2zOsDataProviderSettings ibmDb2zOsSettings;
        private MongoDbDataProviderSettings mongoDbSettings;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DataProviderSettings model) {
            this.redshiftSettings(model.redshiftSettings);
            this.postgreSqlSettings(model.postgreSqlSettings);
            this.mySqlSettings(model.mySqlSettings);
            this.oracleSettings(model.oracleSettings);
            this.sybaseAseSettings(model.sybaseAseSettings);
            this.microsoftSqlServerSettings(model.microsoftSqlServerSettings);
            this.docDbSettings(model.docDbSettings);
            this.mariaDbSettings(model.mariaDbSettings);
            this.ibmDb2LuwSettings(model.ibmDb2LuwSettings);
            this.ibmDb2zOsSettings(model.ibmDb2zOsSettings);
            this.mongoDbSettings(model.mongoDbSettings);
        }

        public final RedshiftDataProviderSettings.Builder getRedshiftSettings() {
            return this.redshiftSettings != null ? this.redshiftSettings.toBuilder() : null;
        }

        public final void setRedshiftSettings(RedshiftDataProviderSettings.BuilderImpl redshiftSettings) {
            RedshiftDataProviderSettings oldValue = this.redshiftSettings;
            this.redshiftSettings = redshiftSettings != null ? redshiftSettings.build() : null;
            this.handleUnionValueChange(Type.REDSHIFT_SETTINGS, oldValue, this.redshiftSettings);
        }

        @Override
        public final Builder redshiftSettings(RedshiftDataProviderSettings redshiftSettings) {
            RedshiftDataProviderSettings oldValue = this.redshiftSettings;
            this.redshiftSettings = redshiftSettings;
            this.handleUnionValueChange(Type.REDSHIFT_SETTINGS, oldValue, this.redshiftSettings);
            return this;
        }

        public final PostgreSqlDataProviderSettings.Builder getPostgreSqlSettings() {
            return this.postgreSqlSettings != null ? this.postgreSqlSettings.toBuilder() : null;
        }

        public final void setPostgreSqlSettings(PostgreSqlDataProviderSettings.BuilderImpl postgreSqlSettings) {
            PostgreSqlDataProviderSettings oldValue = this.postgreSqlSettings;
            this.postgreSqlSettings = postgreSqlSettings != null ? postgreSqlSettings.build() : null;
            this.handleUnionValueChange(Type.POSTGRE_SQL_SETTINGS, oldValue, this.postgreSqlSettings);
        }

        @Override
        public final Builder postgreSqlSettings(PostgreSqlDataProviderSettings postgreSqlSettings) {
            PostgreSqlDataProviderSettings oldValue = this.postgreSqlSettings;
            this.postgreSqlSettings = postgreSqlSettings;
            this.handleUnionValueChange(Type.POSTGRE_SQL_SETTINGS, oldValue, this.postgreSqlSettings);
            return this;
        }

        public final MySqlDataProviderSettings.Builder getMySqlSettings() {
            return this.mySqlSettings != null ? this.mySqlSettings.toBuilder() : null;
        }

        public final void setMySqlSettings(MySqlDataProviderSettings.BuilderImpl mySqlSettings) {
            MySqlDataProviderSettings oldValue = this.mySqlSettings;
            this.mySqlSettings = mySqlSettings != null ? mySqlSettings.build() : null;
            this.handleUnionValueChange(Type.MY_SQL_SETTINGS, oldValue, this.mySqlSettings);
        }

        @Override
        public final Builder mySqlSettings(MySqlDataProviderSettings mySqlSettings) {
            MySqlDataProviderSettings oldValue = this.mySqlSettings;
            this.mySqlSettings = mySqlSettings;
            this.handleUnionValueChange(Type.MY_SQL_SETTINGS, oldValue, this.mySqlSettings);
            return this;
        }

        public final OracleDataProviderSettings.Builder getOracleSettings() {
            return this.oracleSettings != null ? this.oracleSettings.toBuilder() : null;
        }

        public final void setOracleSettings(OracleDataProviderSettings.BuilderImpl oracleSettings) {
            OracleDataProviderSettings oldValue = this.oracleSettings;
            this.oracleSettings = oracleSettings != null ? oracleSettings.build() : null;
            this.handleUnionValueChange(Type.ORACLE_SETTINGS, oldValue, this.oracleSettings);
        }

        @Override
        public final Builder oracleSettings(OracleDataProviderSettings oracleSettings) {
            OracleDataProviderSettings oldValue = this.oracleSettings;
            this.oracleSettings = oracleSettings;
            this.handleUnionValueChange(Type.ORACLE_SETTINGS, oldValue, this.oracleSettings);
            return this;
        }

        public final SybaseAseDataProviderSettings.Builder getSybaseAseSettings() {
            return this.sybaseAseSettings != null ? this.sybaseAseSettings.toBuilder() : null;
        }

        public final void setSybaseAseSettings(SybaseAseDataProviderSettings.BuilderImpl sybaseAseSettings) {
            SybaseAseDataProviderSettings oldValue = this.sybaseAseSettings;
            this.sybaseAseSettings = sybaseAseSettings != null ? sybaseAseSettings.build() : null;
            this.handleUnionValueChange(Type.SYBASE_ASE_SETTINGS, oldValue, this.sybaseAseSettings);
        }

        @Override
        public final Builder sybaseAseSettings(SybaseAseDataProviderSettings sybaseAseSettings) {
            SybaseAseDataProviderSettings oldValue = this.sybaseAseSettings;
            this.sybaseAseSettings = sybaseAseSettings;
            this.handleUnionValueChange(Type.SYBASE_ASE_SETTINGS, oldValue, this.sybaseAseSettings);
            return this;
        }

        public final MicrosoftSqlServerDataProviderSettings.Builder getMicrosoftSqlServerSettings() {
            return this.microsoftSqlServerSettings != null ? this.microsoftSqlServerSettings.toBuilder() : null;
        }

        public final void setMicrosoftSqlServerSettings(MicrosoftSqlServerDataProviderSettings.BuilderImpl microsoftSqlServerSettings) {
            MicrosoftSqlServerDataProviderSettings oldValue = this.microsoftSqlServerSettings;
            this.microsoftSqlServerSettings = microsoftSqlServerSettings != null ? microsoftSqlServerSettings.build() : null;
            this.handleUnionValueChange(Type.MICROSOFT_SQL_SERVER_SETTINGS, oldValue, this.microsoftSqlServerSettings);
        }

        @Override
        public final Builder microsoftSqlServerSettings(MicrosoftSqlServerDataProviderSettings microsoftSqlServerSettings) {
            MicrosoftSqlServerDataProviderSettings oldValue = this.microsoftSqlServerSettings;
            this.microsoftSqlServerSettings = microsoftSqlServerSettings;
            this.handleUnionValueChange(Type.MICROSOFT_SQL_SERVER_SETTINGS, oldValue, this.microsoftSqlServerSettings);
            return this;
        }

        public final DocDbDataProviderSettings.Builder getDocDbSettings() {
            return this.docDbSettings != null ? this.docDbSettings.toBuilder() : null;
        }

        public final void setDocDbSettings(DocDbDataProviderSettings.BuilderImpl docDbSettings) {
            DocDbDataProviderSettings oldValue = this.docDbSettings;
            this.docDbSettings = docDbSettings != null ? docDbSettings.build() : null;
            this.handleUnionValueChange(Type.DOC_DB_SETTINGS, oldValue, this.docDbSettings);
        }

        @Override
        public final Builder docDbSettings(DocDbDataProviderSettings docDbSettings) {
            DocDbDataProviderSettings oldValue = this.docDbSettings;
            this.docDbSettings = docDbSettings;
            this.handleUnionValueChange(Type.DOC_DB_SETTINGS, oldValue, this.docDbSettings);
            return this;
        }

        public final MariaDbDataProviderSettings.Builder getMariaDbSettings() {
            return this.mariaDbSettings != null ? this.mariaDbSettings.toBuilder() : null;
        }

        public final void setMariaDbSettings(MariaDbDataProviderSettings.BuilderImpl mariaDbSettings) {
            MariaDbDataProviderSettings oldValue = this.mariaDbSettings;
            this.mariaDbSettings = mariaDbSettings != null ? mariaDbSettings.build() : null;
            this.handleUnionValueChange(Type.MARIA_DB_SETTINGS, oldValue, this.mariaDbSettings);
        }

        @Override
        public final Builder mariaDbSettings(MariaDbDataProviderSettings mariaDbSettings) {
            MariaDbDataProviderSettings oldValue = this.mariaDbSettings;
            this.mariaDbSettings = mariaDbSettings;
            this.handleUnionValueChange(Type.MARIA_DB_SETTINGS, oldValue, this.mariaDbSettings);
            return this;
        }

        public final IbmDb2LuwDataProviderSettings.Builder getIbmDb2LuwSettings() {
            return this.ibmDb2LuwSettings != null ? this.ibmDb2LuwSettings.toBuilder() : null;
        }

        public final void setIbmDb2LuwSettings(IbmDb2LuwDataProviderSettings.BuilderImpl ibmDb2LuwSettings) {
            IbmDb2LuwDataProviderSettings oldValue = this.ibmDb2LuwSettings;
            this.ibmDb2LuwSettings = ibmDb2LuwSettings != null ? ibmDb2LuwSettings.build() : null;
            this.handleUnionValueChange(Type.IBM_DB2_LUW_SETTINGS, oldValue, this.ibmDb2LuwSettings);
        }

        @Override
        public final Builder ibmDb2LuwSettings(IbmDb2LuwDataProviderSettings ibmDb2LuwSettings) {
            IbmDb2LuwDataProviderSettings oldValue = this.ibmDb2LuwSettings;
            this.ibmDb2LuwSettings = ibmDb2LuwSettings;
            this.handleUnionValueChange(Type.IBM_DB2_LUW_SETTINGS, oldValue, this.ibmDb2LuwSettings);
            return this;
        }

        public final IbmDb2zOsDataProviderSettings.Builder getIbmDb2zOsSettings() {
            return this.ibmDb2zOsSettings != null ? this.ibmDb2zOsSettings.toBuilder() : null;
        }

        public final void setIbmDb2zOsSettings(IbmDb2zOsDataProviderSettings.BuilderImpl ibmDb2zOsSettings) {
            IbmDb2zOsDataProviderSettings oldValue = this.ibmDb2zOsSettings;
            this.ibmDb2zOsSettings = ibmDb2zOsSettings != null ? ibmDb2zOsSettings.build() : null;
            this.handleUnionValueChange(Type.IBM_DB2_Z_OS_SETTINGS, oldValue, this.ibmDb2zOsSettings);
        }

        @Override
        public final Builder ibmDb2zOsSettings(IbmDb2zOsDataProviderSettings ibmDb2zOsSettings) {
            IbmDb2zOsDataProviderSettings oldValue = this.ibmDb2zOsSettings;
            this.ibmDb2zOsSettings = ibmDb2zOsSettings;
            this.handleUnionValueChange(Type.IBM_DB2_Z_OS_SETTINGS, oldValue, this.ibmDb2zOsSettings);
            return this;
        }

        public final MongoDbDataProviderSettings.Builder getMongoDbSettings() {
            return this.mongoDbSettings != null ? this.mongoDbSettings.toBuilder() : null;
        }

        public final void setMongoDbSettings(MongoDbDataProviderSettings.BuilderImpl mongoDbSettings) {
            MongoDbDataProviderSettings oldValue = this.mongoDbSettings;
            this.mongoDbSettings = mongoDbSettings != null ? mongoDbSettings.build() : null;
            this.handleUnionValueChange(Type.MONGO_DB_SETTINGS, oldValue, this.mongoDbSettings);
        }

        @Override
        public final Builder mongoDbSettings(MongoDbDataProviderSettings mongoDbSettings) {
            MongoDbDataProviderSettings oldValue = this.mongoDbSettings;
            this.mongoDbSettings = mongoDbSettings;
            this.handleUnionValueChange(Type.MONGO_DB_SETTINGS, oldValue, this.mongoDbSettings);
            return this;
        }

        public DataProviderSettings build() {
            return new DataProviderSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataProviderSettings> {
        public Builder redshiftSettings(RedshiftDataProviderSettings var1);

        default public Builder redshiftSettings(Consumer<RedshiftDataProviderSettings.Builder> redshiftSettings) {
            return this.redshiftSettings((RedshiftDataProviderSettings)((RedshiftDataProviderSettings.Builder)RedshiftDataProviderSettings.builder().applyMutation(redshiftSettings)).build());
        }

        public Builder postgreSqlSettings(PostgreSqlDataProviderSettings var1);

        default public Builder postgreSqlSettings(Consumer<PostgreSqlDataProviderSettings.Builder> postgreSqlSettings) {
            return this.postgreSqlSettings((PostgreSqlDataProviderSettings)((PostgreSqlDataProviderSettings.Builder)PostgreSqlDataProviderSettings.builder().applyMutation(postgreSqlSettings)).build());
        }

        public Builder mySqlSettings(MySqlDataProviderSettings var1);

        default public Builder mySqlSettings(Consumer<MySqlDataProviderSettings.Builder> mySqlSettings) {
            return this.mySqlSettings((MySqlDataProviderSettings)((MySqlDataProviderSettings.Builder)MySqlDataProviderSettings.builder().applyMutation(mySqlSettings)).build());
        }

        public Builder oracleSettings(OracleDataProviderSettings var1);

        default public Builder oracleSettings(Consumer<OracleDataProviderSettings.Builder> oracleSettings) {
            return this.oracleSettings((OracleDataProviderSettings)((OracleDataProviderSettings.Builder)OracleDataProviderSettings.builder().applyMutation(oracleSettings)).build());
        }

        public Builder sybaseAseSettings(SybaseAseDataProviderSettings var1);

        default public Builder sybaseAseSettings(Consumer<SybaseAseDataProviderSettings.Builder> sybaseAseSettings) {
            return this.sybaseAseSettings((SybaseAseDataProviderSettings)((SybaseAseDataProviderSettings.Builder)SybaseAseDataProviderSettings.builder().applyMutation(sybaseAseSettings)).build());
        }

        public Builder microsoftSqlServerSettings(MicrosoftSqlServerDataProviderSettings var1);

        default public Builder microsoftSqlServerSettings(Consumer<MicrosoftSqlServerDataProviderSettings.Builder> microsoftSqlServerSettings) {
            return this.microsoftSqlServerSettings((MicrosoftSqlServerDataProviderSettings)((MicrosoftSqlServerDataProviderSettings.Builder)MicrosoftSqlServerDataProviderSettings.builder().applyMutation(microsoftSqlServerSettings)).build());
        }

        public Builder docDbSettings(DocDbDataProviderSettings var1);

        default public Builder docDbSettings(Consumer<DocDbDataProviderSettings.Builder> docDbSettings) {
            return this.docDbSettings((DocDbDataProviderSettings)((DocDbDataProviderSettings.Builder)DocDbDataProviderSettings.builder().applyMutation(docDbSettings)).build());
        }

        public Builder mariaDbSettings(MariaDbDataProviderSettings var1);

        default public Builder mariaDbSettings(Consumer<MariaDbDataProviderSettings.Builder> mariaDbSettings) {
            return this.mariaDbSettings((MariaDbDataProviderSettings)((MariaDbDataProviderSettings.Builder)MariaDbDataProviderSettings.builder().applyMutation(mariaDbSettings)).build());
        }

        public Builder ibmDb2LuwSettings(IbmDb2LuwDataProviderSettings var1);

        default public Builder ibmDb2LuwSettings(Consumer<IbmDb2LuwDataProviderSettings.Builder> ibmDb2LuwSettings) {
            return this.ibmDb2LuwSettings((IbmDb2LuwDataProviderSettings)((IbmDb2LuwDataProviderSettings.Builder)IbmDb2LuwDataProviderSettings.builder().applyMutation(ibmDb2LuwSettings)).build());
        }

        public Builder ibmDb2zOsSettings(IbmDb2zOsDataProviderSettings var1);

        default public Builder ibmDb2zOsSettings(Consumer<IbmDb2zOsDataProviderSettings.Builder> ibmDb2zOsSettings) {
            return this.ibmDb2zOsSettings((IbmDb2zOsDataProviderSettings)((IbmDb2zOsDataProviderSettings.Builder)IbmDb2zOsDataProviderSettings.builder().applyMutation(ibmDb2zOsSettings)).build());
        }

        public Builder mongoDbSettings(MongoDbDataProviderSettings var1);

        default public Builder mongoDbSettings(Consumer<MongoDbDataProviderSettings.Builder> mongoDbSettings) {
            return this.mongoDbSettings((MongoDbDataProviderSettings)((MongoDbDataProviderSettings.Builder)MongoDbDataProviderSettings.builder().applyMutation(mongoDbSettings)).build());
        }
    }
}

