/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelMetadataModelCreationRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, CancelMetadataModelCreationRequest> {
    private static final SdkField<String> MIGRATION_PROJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MigrationProjectIdentifier").getter(CancelMetadataModelCreationRequest.getter(CancelMetadataModelCreationRequest::migrationProjectIdentifier)).setter(CancelMetadataModelCreationRequest.setter(Builder::migrationProjectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProjectIdentifier").build()}).build();
    private static final SdkField<String> REQUEST_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestIdentifier").getter(CancelMetadataModelCreationRequest.getter(CancelMetadataModelCreationRequest::requestIdentifier)).setter(CancelMetadataModelCreationRequest.setter(Builder::requestIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIGRATION_PROJECT_IDENTIFIER_FIELD, REQUEST_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CancelMetadataModelCreationRequest.memberNameToFieldInitializer();
    private final String migrationProjectIdentifier;
    private final String requestIdentifier;

    private CancelMetadataModelCreationRequest(BuilderImpl builder) {
        super(builder);
        this.migrationProjectIdentifier = builder.migrationProjectIdentifier;
        this.requestIdentifier = builder.requestIdentifier;
    }

    public final String migrationProjectIdentifier() {
        return this.migrationProjectIdentifier;
    }

    public final String requestIdentifier() {
        return this.requestIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelMetadataModelCreationRequest)) {
            return false;
        }
        CancelMetadataModelCreationRequest other = (CancelMetadataModelCreationRequest)((Object)obj);
        return Objects.equals(this.migrationProjectIdentifier(), other.migrationProjectIdentifier()) && Objects.equals(this.requestIdentifier(), other.requestIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"CancelMetadataModelCreationRequest").add("MigrationProjectIdentifier", (Object)this.migrationProjectIdentifier()).add("RequestIdentifier", (Object)this.requestIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MigrationProjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.migrationProjectIdentifier()));
            }
            case "RequestIdentifier": {
                return Optional.ofNullable(clazz.cast(this.requestIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("MigrationProjectIdentifier", MIGRATION_PROJECT_IDENTIFIER_FIELD);
        map.put("RequestIdentifier", REQUEST_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelMetadataModelCreationRequest, T> g) {
        return obj -> g.apply((CancelMetadataModelCreationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String migrationProjectIdentifier;
        private String requestIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelMetadataModelCreationRequest model) {
            super(model);
            this.migrationProjectIdentifier(model.migrationProjectIdentifier);
            this.requestIdentifier(model.requestIdentifier);
        }

        public final String getMigrationProjectIdentifier() {
            return this.migrationProjectIdentifier;
        }

        public final void setMigrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
        }

        @Override
        public final Builder migrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
            return this;
        }

        public final String getRequestIdentifier() {
            return this.requestIdentifier;
        }

        public final void setRequestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
        }

        @Override
        public final Builder requestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelMetadataModelCreationRequest build() {
            return new CancelMetadataModelCreationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelMetadataModelCreationRequest> {
        public Builder migrationProjectIdentifier(String var1);

        public Builder requestIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

