/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTargetSelectionRulesResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<GetTargetSelectionRulesResponse.Builder, GetTargetSelectionRulesResponse> {
    private static final SdkField<String> TARGET_SELECTION_RULES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetSelectionRules").getter(getter(GetTargetSelectionRulesResponse::targetSelectionRules))
            .setter(setter(Builder::targetSelectionRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSelectionRules").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_SELECTION_RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String targetSelectionRules;

    private GetTargetSelectionRulesResponse(BuilderImpl builder) {
        super(builder);
        this.targetSelectionRules = builder.targetSelectionRules;
    }

    /**
     * <p>
     * The JSON string representing the counterpart selection rules in the target.
     * </p>
     * 
     * @return The JSON string representing the counterpart selection rules in the target.
     */
    public final String targetSelectionRules() {
        return targetSelectionRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetSelectionRules());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTargetSelectionRulesResponse)) {
            return false;
        }
        GetTargetSelectionRulesResponse other = (GetTargetSelectionRulesResponse) obj;
        return Objects.equals(targetSelectionRules(), other.targetSelectionRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTargetSelectionRulesResponse").add("TargetSelectionRules", targetSelectionRules()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetSelectionRules":
            return Optional.ofNullable(clazz.cast(targetSelectionRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetSelectionRules", TARGET_SELECTION_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTargetSelectionRulesResponse, T> g) {
        return obj -> g.apply((GetTargetSelectionRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTargetSelectionRulesResponse> {
        /**
         * <p>
         * The JSON string representing the counterpart selection rules in the target.
         * </p>
         * 
         * @param targetSelectionRules
         *        The JSON string representing the counterpart selection rules in the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetSelectionRules(String targetSelectionRules);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private String targetSelectionRules;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTargetSelectionRulesResponse model) {
            super(model);
            targetSelectionRules(model.targetSelectionRules);
        }

        public final String getTargetSelectionRules() {
            return targetSelectionRules;
        }

        public final void setTargetSelectionRules(String targetSelectionRules) {
            this.targetSelectionRules = targetSelectionRules;
        }

        @Override
        public final Builder targetSelectionRules(String targetSelectionRules) {
            this.targetSelectionRules = targetSelectionRules;
            return this;
        }

        @Override
        public GetTargetSelectionRulesResponse build() {
            return new GetTargetSelectionRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
