/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that defines a DocumentDB endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocDbSettings implements SdkPojo, Serializable, ToCopyableBuilder<DocDbSettings.Builder, DocDbSettings> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(DocDbSettings::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(DocDbSettings::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(DocDbSettings::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(DocDbSettings::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(DocDbSettings::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> NESTING_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NestingLevel").getter(getter(DocDbSettings::nestingLevelAsString)).setter(setter(Builder::nestingLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NestingLevel").build()).build();

    private static final SdkField<Boolean> EXTRACT_DOC_ID_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExtractDocId").getter(getter(DocDbSettings::extractDocId)).setter(setter(Builder::extractDocId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtractDocId").build()).build();

    private static final SdkField<Integer> DOCS_TO_INVESTIGATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DocsToInvestigate").getter(getter(DocDbSettings::docsToInvestigate))
            .setter(setter(Builder::docsToInvestigate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocsToInvestigate").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(DocDbSettings::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecretsManagerAccessRoleArn")
            .getter(getter(DocDbSettings::secretsManagerAccessRoleArn))
            .setter(setter(Builder::secretsManagerAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerAccessRoleArn")
                    .build()).build();

    private static final SdkField<String> SECRETS_MANAGER_SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretsManagerSecretId").getter(getter(DocDbSettings::secretsManagerSecretId))
            .setter(setter(Builder::secretsManagerSecretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerSecretId").build())
            .build();

    private static final SdkField<Boolean> USE_UPDATE_LOOK_UP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseUpdateLookUp").getter(getter(DocDbSettings::useUpdateLookUp))
            .setter(setter(Builder::useUpdateLookUp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseUpdateLookUp").build()).build();

    private static final SdkField<Boolean> REPLICATE_SHARD_COLLECTIONS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("ReplicateShardCollections")
            .getter(getter(DocDbSettings::replicateShardCollections)).setter(setter(Builder::replicateShardCollections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicateShardCollections").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD,
            PASSWORD_FIELD, SERVER_NAME_FIELD, PORT_FIELD, DATABASE_NAME_FIELD, NESTING_LEVEL_FIELD, EXTRACT_DOC_ID_FIELD,
            DOCS_TO_INVESTIGATE_FIELD, KMS_KEY_ID_FIELD, SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD, SECRETS_MANAGER_SECRET_ID_FIELD,
            USE_UPDATE_LOOK_UP_FIELD, REPLICATE_SHARD_COLLECTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String username;

    private final String password;

    private final String serverName;

    private final Integer port;

    private final String databaseName;

    private final String nestingLevel;

    private final Boolean extractDocId;

    private final Integer docsToInvestigate;

    private final String kmsKeyId;

    private final String secretsManagerAccessRoleArn;

    private final String secretsManagerSecretId;

    private final Boolean useUpdateLookUp;

    private final Boolean replicateShardCollections;

    private DocDbSettings(BuilderImpl builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.serverName = builder.serverName;
        this.port = builder.port;
        this.databaseName = builder.databaseName;
        this.nestingLevel = builder.nestingLevel;
        this.extractDocId = builder.extractDocId;
        this.docsToInvestigate = builder.docsToInvestigate;
        this.kmsKeyId = builder.kmsKeyId;
        this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
        this.secretsManagerSecretId = builder.secretsManagerSecretId;
        this.useUpdateLookUp = builder.useUpdateLookUp;
        this.replicateShardCollections = builder.replicateShardCollections;
    }

    /**
     * <p>
     * The user name you use to access the DocumentDB source endpoint.
     * </p>
     * 
     * @return The user name you use to access the DocumentDB source endpoint.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * The password for the user account you use to access the DocumentDB source endpoint.
     * </p>
     * 
     * @return The password for the user account you use to access the DocumentDB source endpoint.
     */
    public final String password() {
        return password;
    }

    /**
     * <p>
     * The name of the server on the DocumentDB source endpoint.
     * </p>
     * 
     * @return The name of the server on the DocumentDB source endpoint.
     */
    public final String serverName() {
        return serverName;
    }

    /**
     * <p>
     * The port value for the DocumentDB source endpoint.
     * </p>
     * 
     * @return The port value for the DocumentDB source endpoint.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The database name on the DocumentDB source endpoint.
     * </p>
     * 
     * @return The database name on the DocumentDB source endpoint.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * Specifies either document or table mode.
     * </p>
     * <p>
     * Default value is <code>"none"</code>. Specify <code>"none"</code> to use document mode. Specify
     * <code>"one"</code> to use table mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nestingLevel} will
     * return {@link NestingLevelValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nestingLevelAsString}.
     * </p>
     * 
     * @return Specifies either document or table mode. </p>
     *         <p>
     *         Default value is <code>"none"</code>. Specify <code>"none"</code> to use document mode. Specify
     *         <code>"one"</code> to use table mode.
     * @see NestingLevelValue
     */
    public final NestingLevelValue nestingLevel() {
        return NestingLevelValue.fromValue(nestingLevel);
    }

    /**
     * <p>
     * Specifies either document or table mode.
     * </p>
     * <p>
     * Default value is <code>"none"</code>. Specify <code>"none"</code> to use document mode. Specify
     * <code>"one"</code> to use table mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nestingLevel} will
     * return {@link NestingLevelValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nestingLevelAsString}.
     * </p>
     * 
     * @return Specifies either document or table mode. </p>
     *         <p>
     *         Default value is <code>"none"</code>. Specify <code>"none"</code> to use document mode. Specify
     *         <code>"one"</code> to use table mode.
     * @see NestingLevelValue
     */
    public final String nestingLevelAsString() {
        return nestingLevel;
    }

    /**
     * <p>
     * Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to <code>"none"</code>.
     * </p>
     * <p>
     * Default value is <code>"false"</code>.
     * </p>
     * 
     * @return Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to <code>"none"</code>.
     *         </p>
     *         <p>
     *         Default value is <code>"false"</code>.
     */
    public final Boolean extractDocId() {
        return extractDocId;
    }

    /**
     * <p>
     * Indicates the number of documents to preview to determine the document organization. Use this setting when
     * <code>NestingLevel</code> is set to <code>"one"</code>.
     * </p>
     * <p>
     * Must be a positive value greater than <code>0</code>. Default value is <code>1000</code>.
     * </p>
     * 
     * @return Indicates the number of documents to preview to determine the document organization. Use this setting
     *         when <code>NestingLevel</code> is set to <code>"one"</code>. </p>
     *         <p>
     *         Must be a positive value greater than <code>0</code>. Default value is <code>1000</code>.
     */
    public final Integer docsToInvestigate() {
        return docsToInvestigate;
    }

    /**
     * <p>
     * The KMS key identifier that is used to encrypt the content on the replication instance. If you don't specify a
     * value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key. KMS creates the default
     * encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default
     * encryption key for each Amazon Web Services Region.
     * </p>
     * 
     * @return The KMS key identifier that is used to encrypt the content on the replication instance. If you don't
     *         specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key. KMS
     *         creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account
     *         has a different default encryption key for each Amazon Web Services Region.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the
     * required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow the
     * <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web Services
     * Secrets Manager secret that allows access to the DocumentDB endpoint.
     * </p>
     * <note>
     * <p>
     * You can specify one of two sets of values for these permissions. You can specify the values for this setting and
     * <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for <code>UserName</code>,
     * <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
     * information on creating this <code>SecretsManagerSecret</code> and the <code>SecretsManagerAccessRoleArn</code>
     * and <code>SecretsManagerSecretId</code> required to access it, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using
     * secrets to access Database Migration Service resources</a> in the <i>Database Migration Service User Guide</i>.
     * </p>
     * </note>
     * 
     * @return The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants
     *         the required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow
     *         the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web
     *         Services Secrets Manager secret that allows access to the DocumentDB endpoint.</p> <note>
     *         <p>
     *         You can specify one of two sets of values for these permissions. You can specify the values for this
     *         setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for
     *         <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can't
     *         specify both. For more information on creating this <code>SecretsManagerSecret</code> and the
     *         <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it,
     *         see <a
     *         href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager"
     *         >Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service
     *         User Guide</i>.
     *         </p>
     */
    public final String secretsManagerAccessRoleArn() {
        return secretsManagerAccessRoleArn;
    }

    /**
     * <p>
     * The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the DocumentDB
     * endpoint connection details.
     * </p>
     * 
     * @return The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the
     *         DocumentDB endpoint connection details.
     */
    public final String secretsManagerSecretId() {
        return secretsManagerSecretId;
    }

    /**
     * <p>
     * If <code>true</code>, DMS retrieves the entire document from the DocumentDB source during migration. This may
     * cause a migration failure if the server response exceeds bandwidth limits. To fetch only updates and deletes
     * during migration, set this parameter to <code>false</code>.
     * </p>
     * 
     * @return If <code>true</code>, DMS retrieves the entire document from the DocumentDB source during migration. This
     *         may cause a migration failure if the server response exceeds bandwidth limits. To fetch only updates and
     *         deletes during migration, set this parameter to <code>false</code>.
     */
    public final Boolean useUpdateLookUp() {
        return useUpdateLookUp;
    }

    /**
     * <p>
     * If <code>true</code>, DMS replicates data to shard collections. DMS only uses this setting if the target endpoint
     * is a DocumentDB elastic cluster.
     * </p>
     * <p>
     * When this setting is <code>true</code>, note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must set <code>TargetTablePrepMode</code> to <code>nothing</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DMS automatically sets <code>useUpdateLookup</code> to <code>false</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return If <code>true</code>, DMS replicates data to shard collections. DMS only uses this setting if the target
     *         endpoint is a DocumentDB elastic cluster.</p>
     *         <p>
     *         When this setting is <code>true</code>, note the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You must set <code>TargetTablePrepMode</code> to <code>nothing</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DMS automatically sets <code>useUpdateLookup</code> to <code>false</code>.
     *         </p>
     *         </li>
     */
    public final Boolean replicateShardCollections() {
        return replicateShardCollections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(nestingLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(extractDocId());
        hashCode = 31 * hashCode + Objects.hashCode(docsToInvestigate());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerSecretId());
        hashCode = 31 * hashCode + Objects.hashCode(useUpdateLookUp());
        hashCode = 31 * hashCode + Objects.hashCode(replicateShardCollections());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocDbSettings)) {
            return false;
        }
        DocDbSettings other = (DocDbSettings) obj;
        return Objects.equals(username(), other.username()) && Objects.equals(password(), other.password())
                && Objects.equals(serverName(), other.serverName()) && Objects.equals(port(), other.port())
                && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(nestingLevelAsString(), other.nestingLevelAsString())
                && Objects.equals(extractDocId(), other.extractDocId())
                && Objects.equals(docsToInvestigate(), other.docsToInvestigate()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(secretsManagerAccessRoleArn(), other.secretsManagerAccessRoleArn())
                && Objects.equals(secretsManagerSecretId(), other.secretsManagerSecretId())
                && Objects.equals(useUpdateLookUp(), other.useUpdateLookUp())
                && Objects.equals(replicateShardCollections(), other.replicateShardCollections());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocDbSettings").add("Username", username())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***").add("ServerName", serverName())
                .add("Port", port()).add("DatabaseName", databaseName()).add("NestingLevel", nestingLevelAsString())
                .add("ExtractDocId", extractDocId()).add("DocsToInvestigate", docsToInvestigate()).add("KmsKeyId", kmsKeyId())
                .add("SecretsManagerAccessRoleArn", secretsManagerAccessRoleArn())
                .add("SecretsManagerSecretId", secretsManagerSecretId()).add("UseUpdateLookUp", useUpdateLookUp())
                .add("ReplicateShardCollections", replicateShardCollections()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "NestingLevel":
            return Optional.ofNullable(clazz.cast(nestingLevelAsString()));
        case "ExtractDocId":
            return Optional.ofNullable(clazz.cast(extractDocId()));
        case "DocsToInvestigate":
            return Optional.ofNullable(clazz.cast(docsToInvestigate()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "SecretsManagerAccessRoleArn":
            return Optional.ofNullable(clazz.cast(secretsManagerAccessRoleArn()));
        case "SecretsManagerSecretId":
            return Optional.ofNullable(clazz.cast(secretsManagerSecretId()));
        case "UseUpdateLookUp":
            return Optional.ofNullable(clazz.cast(useUpdateLookUp()));
        case "ReplicateShardCollections":
            return Optional.ofNullable(clazz.cast(replicateShardCollections()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Username", USERNAME_FIELD);
        map.put("Password", PASSWORD_FIELD);
        map.put("ServerName", SERVER_NAME_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("NestingLevel", NESTING_LEVEL_FIELD);
        map.put("ExtractDocId", EXTRACT_DOC_ID_FIELD);
        map.put("DocsToInvestigate", DOCS_TO_INVESTIGATE_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("SecretsManagerAccessRoleArn", SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD);
        map.put("SecretsManagerSecretId", SECRETS_MANAGER_SECRET_ID_FIELD);
        map.put("UseUpdateLookUp", USE_UPDATE_LOOK_UP_FIELD);
        map.put("ReplicateShardCollections", REPLICATE_SHARD_COLLECTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocDbSettings, T> g) {
        return obj -> g.apply((DocDbSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocDbSettings> {
        /**
         * <p>
         * The user name you use to access the DocumentDB source endpoint.
         * </p>
         * 
         * @param username
         *        The user name you use to access the DocumentDB source endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The password for the user account you use to access the DocumentDB source endpoint.
         * </p>
         * 
         * @param password
         *        The password for the user account you use to access the DocumentDB source endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The name of the server on the DocumentDB source endpoint.
         * </p>
         * 
         * @param serverName
         *        The name of the server on the DocumentDB source endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * The port value for the DocumentDB source endpoint.
         * </p>
         * 
         * @param port
         *        The port value for the DocumentDB source endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The database name on the DocumentDB source endpoint.
         * </p>
         * 
         * @param databaseName
         *        The database name on the DocumentDB source endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * Specifies either document or table mode.
         * </p>
         * <p>
         * Default value is <code>"none"</code>. Specify <code>"none"</code> to use document mode. Specify
         * <code>"one"</code> to use table mode.
         * </p>
         * 
         * @param nestingLevel
         *        Specifies either document or table mode. </p>
         *        <p>
         *        Default value is <code>"none"</code>. Specify <code>"none"</code> to use document mode. Specify
         *        <code>"one"</code> to use table mode.
         * @see NestingLevelValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NestingLevelValue
         */
        Builder nestingLevel(String nestingLevel);

        /**
         * <p>
         * Specifies either document or table mode.
         * </p>
         * <p>
         * Default value is <code>"none"</code>. Specify <code>"none"</code> to use document mode. Specify
         * <code>"one"</code> to use table mode.
         * </p>
         * 
         * @param nestingLevel
         *        Specifies either document or table mode. </p>
         *        <p>
         *        Default value is <code>"none"</code>. Specify <code>"none"</code> to use document mode. Specify
         *        <code>"one"</code> to use table mode.
         * @see NestingLevelValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NestingLevelValue
         */
        Builder nestingLevel(NestingLevelValue nestingLevel);

        /**
         * <p>
         * Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to <code>"none"</code>.
         * </p>
         * <p>
         * Default value is <code>"false"</code>.
         * </p>
         * 
         * @param extractDocId
         *        Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to
         *        <code>"none"</code>. </p>
         *        <p>
         *        Default value is <code>"false"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extractDocId(Boolean extractDocId);

        /**
         * <p>
         * Indicates the number of documents to preview to determine the document organization. Use this setting when
         * <code>NestingLevel</code> is set to <code>"one"</code>.
         * </p>
         * <p>
         * Must be a positive value greater than <code>0</code>. Default value is <code>1000</code>.
         * </p>
         * 
         * @param docsToInvestigate
         *        Indicates the number of documents to preview to determine the document organization. Use this setting
         *        when <code>NestingLevel</code> is set to <code>"one"</code>. </p>
         *        <p>
         *        Must be a positive value greater than <code>0</code>. Default value is <code>1000</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder docsToInvestigate(Integer docsToInvestigate);

        /**
         * <p>
         * The KMS key identifier that is used to encrypt the content on the replication instance. If you don't specify
         * a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key. KMS creates the
         * default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different
         * default encryption key for each Amazon Web Services Region.
         * </p>
         * 
         * @param kmsKeyId
         *        The KMS key identifier that is used to encrypt the content on the replication instance. If you don't
         *        specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key.
         *        KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services
         *        account has a different default encryption key for each Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and grants the
         * required permissions to access the value in <code>SecretsManagerSecret</code>. The role must allow the
         * <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of the Amazon Web Services
         * Secrets Manager secret that allows access to the DocumentDB endpoint.
         * </p>
         * <note>
         * <p>
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting
         * and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for <code>UserName</code>,
         * <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
         * information on creating this <code>SecretsManagerSecret</code> and the
         * <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it, see
         * <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">
         * Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service User
         * Guide</i>.
         * </p>
         * </note>
         * 
         * @param secretsManagerAccessRoleArn
         *        The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the trusted entity and
         *        grants the required permissions to access the value in <code>SecretsManagerSecret</code>. The role
         *        must allow the <code>iam:PassRole</code> action. <code>SecretsManagerSecret</code> has the value of
         *        the Amazon Web Services Secrets Manager secret that allows access to the DocumentDB endpoint.</p>
         *        <note>
         *        <p>
         *        You can specify one of two sets of values for these permissions. You can specify the values for this
         *        setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for
         *        <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You
         *        can't specify both. For more information on creating this <code>SecretsManagerSecret</code> and the
         *        <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access
         *        it, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager"
         *        >Using secrets to access Database Migration Service resources</a> in the <i>Database Migration Service
         *        User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn);

        /**
         * <p>
         * The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the
         * DocumentDB endpoint connection details.
         * </p>
         * 
         * @param secretsManagerSecretId
         *        The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the
         *        DocumentDB endpoint connection details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerSecretId(String secretsManagerSecretId);

        /**
         * <p>
         * If <code>true</code>, DMS retrieves the entire document from the DocumentDB source during migration. This may
         * cause a migration failure if the server response exceeds bandwidth limits. To fetch only updates and deletes
         * during migration, set this parameter to <code>false</code>.
         * </p>
         * 
         * @param useUpdateLookUp
         *        If <code>true</code>, DMS retrieves the entire document from the DocumentDB source during migration.
         *        This may cause a migration failure if the server response exceeds bandwidth limits. To fetch only
         *        updates and deletes during migration, set this parameter to <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useUpdateLookUp(Boolean useUpdateLookUp);

        /**
         * <p>
         * If <code>true</code>, DMS replicates data to shard collections. DMS only uses this setting if the target
         * endpoint is a DocumentDB elastic cluster.
         * </p>
         * <p>
         * When this setting is <code>true</code>, note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You must set <code>TargetTablePrepMode</code> to <code>nothing</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DMS automatically sets <code>useUpdateLookup</code> to <code>false</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param replicateShardCollections
         *        If <code>true</code>, DMS replicates data to shard collections. DMS only uses this setting if the
         *        target endpoint is a DocumentDB elastic cluster.</p>
         *        <p>
         *        When this setting is <code>true</code>, note the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You must set <code>TargetTablePrepMode</code> to <code>nothing</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DMS automatically sets <code>useUpdateLookup</code> to <code>false</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicateShardCollections(Boolean replicateShardCollections);
    }

    static final class BuilderImpl implements Builder {
        private String username;

        private String password;

        private String serverName;

        private Integer port;

        private String databaseName;

        private String nestingLevel;

        private Boolean extractDocId;

        private Integer docsToInvestigate;

        private String kmsKeyId;

        private String secretsManagerAccessRoleArn;

        private String secretsManagerSecretId;

        private Boolean useUpdateLookUp;

        private Boolean replicateShardCollections;

        private BuilderImpl() {
        }

        private BuilderImpl(DocDbSettings model) {
            username(model.username);
            password(model.password);
            serverName(model.serverName);
            port(model.port);
            databaseName(model.databaseName);
            nestingLevel(model.nestingLevel);
            extractDocId(model.extractDocId);
            docsToInvestigate(model.docsToInvestigate);
            kmsKeyId(model.kmsKeyId);
            secretsManagerAccessRoleArn(model.secretsManagerAccessRoleArn);
            secretsManagerSecretId(model.secretsManagerSecretId);
            useUpdateLookUp(model.useUpdateLookUp);
            replicateShardCollections(model.replicateShardCollections);
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final String getServerName() {
            return serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getNestingLevel() {
            return nestingLevel;
        }

        public final void setNestingLevel(String nestingLevel) {
            this.nestingLevel = nestingLevel;
        }

        @Override
        public final Builder nestingLevel(String nestingLevel) {
            this.nestingLevel = nestingLevel;
            return this;
        }

        @Override
        public final Builder nestingLevel(NestingLevelValue nestingLevel) {
            this.nestingLevel(nestingLevel == null ? null : nestingLevel.toString());
            return this;
        }

        public final Boolean getExtractDocId() {
            return extractDocId;
        }

        public final void setExtractDocId(Boolean extractDocId) {
            this.extractDocId = extractDocId;
        }

        @Override
        public final Builder extractDocId(Boolean extractDocId) {
            this.extractDocId = extractDocId;
            return this;
        }

        public final Integer getDocsToInvestigate() {
            return docsToInvestigate;
        }

        public final void setDocsToInvestigate(Integer docsToInvestigate) {
            this.docsToInvestigate = docsToInvestigate;
        }

        @Override
        public final Builder docsToInvestigate(Integer docsToInvestigate) {
            this.docsToInvestigate = docsToInvestigate;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getSecretsManagerAccessRoleArn() {
            return secretsManagerAccessRoleArn;
        }

        public final void setSecretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
        }

        @Override
        public final Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
            return this;
        }

        public final String getSecretsManagerSecretId() {
            return secretsManagerSecretId;
        }

        public final void setSecretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
        }

        @Override
        public final Builder secretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
            return this;
        }

        public final Boolean getUseUpdateLookUp() {
            return useUpdateLookUp;
        }

        public final void setUseUpdateLookUp(Boolean useUpdateLookUp) {
            this.useUpdateLookUp = useUpdateLookUp;
        }

        @Override
        public final Builder useUpdateLookUp(Boolean useUpdateLookUp) {
            this.useUpdateLookUp = useUpdateLookUp;
            return this;
        }

        public final Boolean getReplicateShardCollections() {
            return replicateShardCollections;
        }

        public final void setReplicateShardCollections(Boolean replicateShardCollections) {
            this.replicateShardCollections = replicateShardCollections;
        }

        @Override
        public final Builder replicateShardCollections(Boolean replicateShardCollections) {
            this.replicateShardCollections = replicateShardCollections;
            return this;
        }

        @Override
        public DocDbSettings build() {
            return new DocDbSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
