/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRefreshSchemasStatusResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DescribeRefreshSchemasStatusResponse.Builder, DescribeRefreshSchemasStatusResponse> {
    private static final SdkField<RefreshSchemasStatus> REFRESH_SCHEMAS_STATUS_FIELD = SdkField
            .<RefreshSchemasStatus> builder(MarshallingType.SDK_POJO).memberName("RefreshSchemasStatus")
            .getter(getter(DescribeRefreshSchemasStatusResponse::refreshSchemasStatus))
            .setter(setter(Builder::refreshSchemasStatus)).constructor(RefreshSchemasStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshSchemasStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFRESH_SCHEMAS_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RefreshSchemasStatus refreshSchemasStatus;

    private DescribeRefreshSchemasStatusResponse(BuilderImpl builder) {
        super(builder);
        this.refreshSchemasStatus = builder.refreshSchemasStatus;
    }

    /**
     * <p>
     * The status of the schema.
     * </p>
     * 
     * @return The status of the schema.
     */
    public final RefreshSchemasStatus refreshSchemasStatus() {
        return refreshSchemasStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(refreshSchemasStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRefreshSchemasStatusResponse)) {
            return false;
        }
        DescribeRefreshSchemasStatusResponse other = (DescribeRefreshSchemasStatusResponse) obj;
        return Objects.equals(refreshSchemasStatus(), other.refreshSchemasStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRefreshSchemasStatusResponse").add("RefreshSchemasStatus", refreshSchemasStatus())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RefreshSchemasStatus":
            return Optional.ofNullable(clazz.cast(refreshSchemasStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RefreshSchemasStatus", REFRESH_SCHEMAS_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRefreshSchemasStatusResponse, T> g) {
        return obj -> g.apply((DescribeRefreshSchemasStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeRefreshSchemasStatusResponse> {
        /**
         * <p>
         * The status of the schema.
         * </p>
         * 
         * @param refreshSchemasStatus
         *        The status of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshSchemasStatus(RefreshSchemasStatus refreshSchemasStatus);

        /**
         * <p>
         * The status of the schema.
         * </p>
         * This is a convenience method that creates an instance of the {@link RefreshSchemasStatus.Builder} avoiding
         * the need to create one manually via {@link RefreshSchemasStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RefreshSchemasStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #refreshSchemasStatus(RefreshSchemasStatus)}.
         * 
         * @param refreshSchemasStatus
         *        a consumer that will call methods on {@link RefreshSchemasStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #refreshSchemasStatus(RefreshSchemasStatus)
         */
        default Builder refreshSchemasStatus(Consumer<RefreshSchemasStatus.Builder> refreshSchemasStatus) {
            return refreshSchemasStatus(RefreshSchemasStatus.builder().applyMutation(refreshSchemasStatus).build());
        }
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private RefreshSchemasStatus refreshSchemasStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRefreshSchemasStatusResponse model) {
            super(model);
            refreshSchemasStatus(model.refreshSchemasStatus);
        }

        public final RefreshSchemasStatus.Builder getRefreshSchemasStatus() {
            return refreshSchemasStatus != null ? refreshSchemasStatus.toBuilder() : null;
        }

        public final void setRefreshSchemasStatus(RefreshSchemasStatus.BuilderImpl refreshSchemasStatus) {
            this.refreshSchemasStatus = refreshSchemasStatus != null ? refreshSchemasStatus.build() : null;
        }

        @Override
        public final Builder refreshSchemasStatus(RefreshSchemasStatus refreshSchemasStatus) {
            this.refreshSchemasStatus = refreshSchemasStatus;
            return this;
        }

        @Override
        public DescribeRefreshSchemasStatusResponse build() {
            return new DescribeRefreshSchemasStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
