/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMetadataModelChildrenRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<DescribeMetadataModelChildrenRequest.Builder, DescribeMetadataModelChildrenRequest> {
    private static final SdkField<String> SELECTION_RULES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectionRules").getter(getter(DescribeMetadataModelChildrenRequest::selectionRules))
            .setter(setter(Builder::selectionRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionRules").build()).build();

    private static final SdkField<String> MIGRATION_PROJECT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MigrationProjectIdentifier")
            .getter(getter(DescribeMetadataModelChildrenRequest::migrationProjectIdentifier))
            .setter(setter(Builder::migrationProjectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProjectIdentifier").build())
            .build();

    private static final SdkField<String> ORIGIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Origin")
            .getter(getter(DescribeMetadataModelChildrenRequest::originAsString)).setter(setter(Builder::origin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origin").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeMetadataModelChildrenRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeMetadataModelChildrenRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTION_RULES_FIELD,
            MIGRATION_PROJECT_IDENTIFIER_FIELD, ORIGIN_FIELD, MARKER_FIELD, MAX_RECORDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String selectionRules;

    private final String migrationProjectIdentifier;

    private final String origin;

    private final String marker;

    private final Integer maxRecords;

    private DescribeMetadataModelChildrenRequest(BuilderImpl builder) {
        super(builder);
        this.selectionRules = builder.selectionRules;
        this.migrationProjectIdentifier = builder.migrationProjectIdentifier;
        this.origin = builder.origin;
        this.marker = builder.marker;
        this.maxRecords = builder.maxRecords;
    }

    /**
     * <p>
     * The JSON string that specifies which metadata model's children to retrieve. Only one selection rule with
     * "rule-action": "explicit" can be provided. For more information, see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.SelectionTransformation.Selections.html"
     * >Selection Rules</a> in the DMS User Guide.
     * </p>
     * 
     * @return The JSON string that specifies which metadata model's children to retrieve. Only one selection rule with
     *         "rule-action": "explicit" can be provided. For more information, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.SelectionTransformation.Selections.html"
     *         >Selection Rules</a> in the DMS User Guide.
     */
    public final String selectionRules() {
        return selectionRules;
    }

    /**
     * <p>
     * The migration project name or Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The migration project name or Amazon Resource Name (ARN).
     */
    public final String migrationProjectIdentifier() {
        return migrationProjectIdentifier;
    }

    /**
     * <p>
     * Specifies whether to retrieve metadata from the source or target tree. Valid values: SOURCE | TARGET
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link OriginTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return Specifies whether to retrieve metadata from the source or target tree. Valid values: SOURCE | TARGET
     * @see OriginTypeValue
     */
    public final OriginTypeValue origin() {
        return OriginTypeValue.fromValue(origin);
    }

    /**
     * <p>
     * Specifies whether to retrieve metadata from the source or target tree. Valid values: SOURCE | TARGET
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link OriginTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return Specifies whether to retrieve metadata from the source or target tree. Valid values: SOURCE | TARGET
     * @see OriginTypeValue
     */
    public final String originAsString() {
        return origin;
    }

    /**
     * <p>
     * Specifies the unique pagination token that indicates where the next page should start. If this parameter is
     * specified, the response includes only records beyond the marker, up to the value specified by MaxRecords.
     * </p>
     * 
     * @return Specifies the unique pagination token that indicates where the next page should start. If this parameter
     *         is specified, the response includes only records beyond the marker, up to the value specified by
     *         MaxRecords.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of metadata model children to include in the response. If more items exist than the specified
     * MaxRecords value, a marker is included in the response so that the remaining results can be retrieved.
     * </p>
     * 
     * @return The maximum number of metadata model children to include in the response. If more items exist than the
     *         specified MaxRecords value, a marker is included in the response so that the remaining results can be
     *         retrieved.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(selectionRules());
        hashCode = 31 * hashCode + Objects.hashCode(migrationProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetadataModelChildrenRequest)) {
            return false;
        }
        DescribeMetadataModelChildrenRequest other = (DescribeMetadataModelChildrenRequest) obj;
        return Objects.equals(selectionRules(), other.selectionRules())
                && Objects.equals(migrationProjectIdentifier(), other.migrationProjectIdentifier())
                && Objects.equals(originAsString(), other.originAsString()) && Objects.equals(marker(), other.marker())
                && Objects.equals(maxRecords(), other.maxRecords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMetadataModelChildrenRequest").add("SelectionRules", selectionRules())
                .add("MigrationProjectIdentifier", migrationProjectIdentifier()).add("Origin", originAsString())
                .add("Marker", marker()).add("MaxRecords", maxRecords()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SelectionRules":
            return Optional.ofNullable(clazz.cast(selectionRules()));
        case "MigrationProjectIdentifier":
            return Optional.ofNullable(clazz.cast(migrationProjectIdentifier()));
        case "Origin":
            return Optional.ofNullable(clazz.cast(originAsString()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SelectionRules", SELECTION_RULES_FIELD);
        map.put("MigrationProjectIdentifier", MIGRATION_PROJECT_IDENTIFIER_FIELD);
        map.put("Origin", ORIGIN_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("MaxRecords", MAX_RECORDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMetadataModelChildrenRequest, T> g) {
        return obj -> g.apply((DescribeMetadataModelChildrenRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMetadataModelChildrenRequest> {
        /**
         * <p>
         * The JSON string that specifies which metadata model's children to retrieve. Only one selection rule with
         * "rule-action": "explicit" can be provided. For more information, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.SelectionTransformation.Selections.html"
         * >Selection Rules</a> in the DMS User Guide.
         * </p>
         * 
         * @param selectionRules
         *        The JSON string that specifies which metadata model's children to retrieve. Only one selection rule
         *        with "rule-action": "explicit" can be provided. For more information, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.SelectionTransformation.Selections.html"
         *        >Selection Rules</a> in the DMS User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectionRules(String selectionRules);

        /**
         * <p>
         * The migration project name or Amazon Resource Name (ARN).
         * </p>
         * 
         * @param migrationProjectIdentifier
         *        The migration project name or Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationProjectIdentifier(String migrationProjectIdentifier);

        /**
         * <p>
         * Specifies whether to retrieve metadata from the source or target tree. Valid values: SOURCE | TARGET
         * </p>
         * 
         * @param origin
         *        Specifies whether to retrieve metadata from the source or target tree. Valid values: SOURCE | TARGET
         * @see OriginTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginTypeValue
         */
        Builder origin(String origin);

        /**
         * <p>
         * Specifies whether to retrieve metadata from the source or target tree. Valid values: SOURCE | TARGET
         * </p>
         * 
         * @param origin
         *        Specifies whether to retrieve metadata from the source or target tree. Valid values: SOURCE | TARGET
         * @see OriginTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginTypeValue
         */
        Builder origin(OriginTypeValue origin);

        /**
         * <p>
         * Specifies the unique pagination token that indicates where the next page should start. If this parameter is
         * specified, the response includes only records beyond the marker, up to the value specified by MaxRecords.
         * </p>
         * 
         * @param marker
         *        Specifies the unique pagination token that indicates where the next page should start. If this
         *        parameter is specified, the response includes only records beyond the marker, up to the value
         *        specified by MaxRecords.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of metadata model children to include in the response. If more items exist than the
         * specified MaxRecords value, a marker is included in the response so that the remaining results can be
         * retrieved.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of metadata model children to include in the response. If more items exist than the
         *        specified MaxRecords value, a marker is included in the response so that the remaining results can be
         *        retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String selectionRules;

        private String migrationProjectIdentifier;

        private String origin;

        private String marker;

        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetadataModelChildrenRequest model) {
            super(model);
            selectionRules(model.selectionRules);
            migrationProjectIdentifier(model.migrationProjectIdentifier);
            origin(model.origin);
            marker(model.marker);
            maxRecords(model.maxRecords);
        }

        public final String getSelectionRules() {
            return selectionRules;
        }

        public final void setSelectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
        }

        @Override
        public final Builder selectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
            return this;
        }

        public final String getMigrationProjectIdentifier() {
            return migrationProjectIdentifier;
        }

        public final void setMigrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
        }

        @Override
        public final Builder migrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
            return this;
        }

        public final String getOrigin() {
            return origin;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(OriginTypeValue origin) {
            this.origin(origin == null ? null : origin.toString());
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeMetadataModelChildrenRequest build() {
            return new DescribeMetadataModelChildrenRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
