/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that defines a data provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataProvider implements SdkPojo, Serializable, ToCopyableBuilder<DataProvider.Builder, DataProvider> {
    private static final SdkField<String> DATA_PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataProviderName").getter(getter(DataProvider::dataProviderName))
            .setter(setter(Builder::dataProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProviderName").build()).build();

    private static final SdkField<String> DATA_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataProviderArn").getter(getter(DataProvider::dataProviderArn)).setter(setter(Builder::dataProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProviderArn").build()).build();

    private static final SdkField<Instant> DATA_PROVIDER_CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("DataProviderCreationTime")
            .getter(getter(DataProvider::dataProviderCreationTime))
            .setter(setter(Builder::dataProviderCreationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProviderCreationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DataProvider::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(DataProvider::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<Boolean> VIRTUAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Virtual").getter(getter(DataProvider::virtual)).setter(setter(Builder::virtual))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Virtual").build()).build();

    private static final SdkField<DataProviderSettings> SETTINGS_FIELD = SdkField
            .<DataProviderSettings> builder(MarshallingType.SDK_POJO).memberName("Settings")
            .getter(getter(DataProvider::settings)).setter(setter(Builder::settings)).constructor(DataProviderSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_PROVIDER_NAME_FIELD,
            DATA_PROVIDER_ARN_FIELD, DATA_PROVIDER_CREATION_TIME_FIELD, DESCRIPTION_FIELD, ENGINE_FIELD, VIRTUAL_FIELD,
            SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataProviderName;

    private final String dataProviderArn;

    private final Instant dataProviderCreationTime;

    private final String description;

    private final String engine;

    private final Boolean virtual;

    private final DataProviderSettings settings;

    private DataProvider(BuilderImpl builder) {
        this.dataProviderName = builder.dataProviderName;
        this.dataProviderArn = builder.dataProviderArn;
        this.dataProviderCreationTime = builder.dataProviderCreationTime;
        this.description = builder.description;
        this.engine = builder.engine;
        this.virtual = builder.virtual;
        this.settings = builder.settings;
    }

    /**
     * <p>
     * The name of the data provider.
     * </p>
     * 
     * @return The name of the data provider.
     */
    public final String dataProviderName() {
        return dataProviderName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) string that uniquely identifies the data provider.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) string that uniquely identifies the data provider.
     */
    public final String dataProviderArn() {
        return dataProviderArn;
    }

    /**
     * <p>
     * The time the data provider was created.
     * </p>
     * 
     * @return The time the data provider was created.
     */
    public final Instant dataProviderCreationTime() {
        return dataProviderCreationTime;
    }

    /**
     * <p>
     * A description of the data provider. Descriptions can have up to 31 characters. A description can contain only
     * ASCII letters, digits, and hyphens ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens,
     * and can only begin with a letter.
     * </p>
     * 
     * @return A description of the data provider. Descriptions can have up to 31 characters. A description can contain
     *         only ASCII letters, digits, and hyphens ('-'). Also, it can't end with a hyphen or contain two
     *         consecutive hyphens, and can only begin with a letter.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of database engine for the data provider. Valid values include <code>"aurora"</code>,
     * <code>"aurora-postgresql"</code>, <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>,
     * <code>"sqlserver"</code>, <code>redshift</code>, <code>mariadb</code>, <code>mongodb</code>, <code>db2</code>,
     * <code>db2-zos</code>, <code>docdb</code>, and <code>sybase</code>. A value of <code>"aurora"</code> represents
     * Amazon Aurora MySQL-Compatible Edition.
     * </p>
     * 
     * @return The type of database engine for the data provider. Valid values include <code>"aurora"</code>,
     *         <code>"aurora-postgresql"</code>, <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>,
     *         <code>"sqlserver"</code>, <code>redshift</code>, <code>mariadb</code>, <code>mongodb</code>,
     *         <code>db2</code>, <code>db2-zos</code>, <code>docdb</code>, and <code>sybase</code>. A value of
     *         <code>"aurora"</code> represents Amazon Aurora MySQL-Compatible Edition.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * Indicates whether the data provider is virtual.
     * </p>
     * 
     * @return Indicates whether the data provider is virtual.
     */
    public final Boolean virtual() {
        return virtual;
    }

    /**
     * <p>
     * The settings in JSON format for a data provider.
     * </p>
     * 
     * @return The settings in JSON format for a data provider.
     */
    public final DataProviderSettings settings() {
        return settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(dataProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataProviderCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(virtual());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProvider)) {
            return false;
        }
        DataProvider other = (DataProvider) obj;
        return Objects.equals(dataProviderName(), other.dataProviderName())
                && Objects.equals(dataProviderArn(), other.dataProviderArn())
                && Objects.equals(dataProviderCreationTime(), other.dataProviderCreationTime())
                && Objects.equals(description(), other.description()) && Objects.equals(engine(), other.engine())
                && Objects.equals(virtual(), other.virtual()) && Objects.equals(settings(), other.settings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataProvider").add("DataProviderName", dataProviderName())
                .add("DataProviderArn", dataProviderArn()).add("DataProviderCreationTime", dataProviderCreationTime())
                .add("Description", description()).add("Engine", engine()).add("Virtual", virtual()).add("Settings", settings())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataProviderName":
            return Optional.ofNullable(clazz.cast(dataProviderName()));
        case "DataProviderArn":
            return Optional.ofNullable(clazz.cast(dataProviderArn()));
        case "DataProviderCreationTime":
            return Optional.ofNullable(clazz.cast(dataProviderCreationTime()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "Virtual":
            return Optional.ofNullable(clazz.cast(virtual()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataProviderName", DATA_PROVIDER_NAME_FIELD);
        map.put("DataProviderArn", DATA_PROVIDER_ARN_FIELD);
        map.put("DataProviderCreationTime", DATA_PROVIDER_CREATION_TIME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("Virtual", VIRTUAL_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataProvider, T> g) {
        return obj -> g.apply((DataProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataProvider> {
        /**
         * <p>
         * The name of the data provider.
         * </p>
         * 
         * @param dataProviderName
         *        The name of the data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProviderName(String dataProviderName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) string that uniquely identifies the data provider.
         * </p>
         * 
         * @param dataProviderArn
         *        The Amazon Resource Name (ARN) string that uniquely identifies the data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProviderArn(String dataProviderArn);

        /**
         * <p>
         * The time the data provider was created.
         * </p>
         * 
         * @param dataProviderCreationTime
         *        The time the data provider was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProviderCreationTime(Instant dataProviderCreationTime);

        /**
         * <p>
         * A description of the data provider. Descriptions can have up to 31 characters. A description can contain only
         * ASCII letters, digits, and hyphens ('-'). Also, it can't end with a hyphen or contain two consecutive
         * hyphens, and can only begin with a letter.
         * </p>
         * 
         * @param description
         *        A description of the data provider. Descriptions can have up to 31 characters. A description can
         *        contain only ASCII letters, digits, and hyphens ('-'). Also, it can't end with a hyphen or contain two
         *        consecutive hyphens, and can only begin with a letter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of database engine for the data provider. Valid values include <code>"aurora"</code>,
         * <code>"aurora-postgresql"</code>, <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>,
         * <code>"sqlserver"</code>, <code>redshift</code>, <code>mariadb</code>, <code>mongodb</code>, <code>db2</code>, <code>db2-zos</code>, <code>docdb</code>, and <code>sybase</code>. A value of <code>"aurora"</code>
         * represents Amazon Aurora MySQL-Compatible Edition.
         * </p>
         * 
         * @param engine
         *        The type of database engine for the data provider. Valid values include <code>"aurora"</code>,
         *        <code>"aurora-postgresql"</code>, <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>
         *        , <code>"sqlserver"</code>, <code>redshift</code>, <code>mariadb</code>, <code>mongodb</code>,
         *        <code>db2</code>, <code>db2-zos</code>, <code>docdb</code>, and <code>sybase</code>. A value of
         *        <code>"aurora"</code> represents Amazon Aurora MySQL-Compatible Edition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * Indicates whether the data provider is virtual.
         * </p>
         * 
         * @param virtual
         *        Indicates whether the data provider is virtual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtual(Boolean virtual);

        /**
         * <p>
         * The settings in JSON format for a data provider.
         * </p>
         * 
         * @param settings
         *        The settings in JSON format for a data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(DataProviderSettings settings);

        /**
         * <p>
         * The settings in JSON format for a data provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataProviderSettings.Builder} avoiding
         * the need to create one manually via {@link DataProviderSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataProviderSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #settings(DataProviderSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link DataProviderSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(DataProviderSettings)
         */
        default Builder settings(Consumer<DataProviderSettings.Builder> settings) {
            return settings(DataProviderSettings.builder().applyMutation(settings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String dataProviderName;

        private String dataProviderArn;

        private Instant dataProviderCreationTime;

        private String description;

        private String engine;

        private Boolean virtual;

        private DataProviderSettings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProvider model) {
            dataProviderName(model.dataProviderName);
            dataProviderArn(model.dataProviderArn);
            dataProviderCreationTime(model.dataProviderCreationTime);
            description(model.description);
            engine(model.engine);
            virtual(model.virtual);
            settings(model.settings);
        }

        public final String getDataProviderName() {
            return dataProviderName;
        }

        public final void setDataProviderName(String dataProviderName) {
            this.dataProviderName = dataProviderName;
        }

        @Override
        public final Builder dataProviderName(String dataProviderName) {
            this.dataProviderName = dataProviderName;
            return this;
        }

        public final String getDataProviderArn() {
            return dataProviderArn;
        }

        public final void setDataProviderArn(String dataProviderArn) {
            this.dataProviderArn = dataProviderArn;
        }

        @Override
        public final Builder dataProviderArn(String dataProviderArn) {
            this.dataProviderArn = dataProviderArn;
            return this;
        }

        public final Instant getDataProviderCreationTime() {
            return dataProviderCreationTime;
        }

        public final void setDataProviderCreationTime(Instant dataProviderCreationTime) {
            this.dataProviderCreationTime = dataProviderCreationTime;
        }

        @Override
        public final Builder dataProviderCreationTime(Instant dataProviderCreationTime) {
            this.dataProviderCreationTime = dataProviderCreationTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final Boolean getVirtual() {
            return virtual;
        }

        public final void setVirtual(Boolean virtual) {
            this.virtual = virtual;
        }

        @Override
        public final Builder virtual(Boolean virtual) {
            this.virtual = virtual;
            return this;
        }

        public final DataProviderSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(DataProviderSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(DataProviderSettings settings) {
            this.settings = settings;
            return this;
        }

        @Override
        public DataProvider build() {
            return new DataProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
