/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMigrationProjectRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<CreateMigrationProjectRequest.Builder, CreateMigrationProjectRequest> {
    private static final SdkField<String> MIGRATION_PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MigrationProjectName").getter(getter(CreateMigrationProjectRequest::migrationProjectName))
            .setter(setter(Builder::migrationProjectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProjectName").build())
            .build();

    private static final SdkField<List<DataProviderDescriptorDefinition>> SOURCE_DATA_PROVIDER_DESCRIPTORS_FIELD = SdkField
            .<List<DataProviderDescriptorDefinition>> builder(MarshallingType.LIST)
            .memberName("SourceDataProviderDescriptors")
            .getter(getter(CreateMigrationProjectRequest::sourceDataProviderDescriptors))
            .setter(setter(Builder::sourceDataProviderDescriptors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDataProviderDescriptors")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataProviderDescriptorDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataProviderDescriptorDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataProviderDescriptorDefinition>> TARGET_DATA_PROVIDER_DESCRIPTORS_FIELD = SdkField
            .<List<DataProviderDescriptorDefinition>> builder(MarshallingType.LIST)
            .memberName("TargetDataProviderDescriptors")
            .getter(getter(CreateMigrationProjectRequest::targetDataProviderDescriptors))
            .setter(setter(Builder::targetDataProviderDescriptors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDataProviderDescriptors")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataProviderDescriptorDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataProviderDescriptorDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INSTANCE_PROFILE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceProfileIdentifier").getter(getter(CreateMigrationProjectRequest::instanceProfileIdentifier))
            .setter(setter(Builder::instanceProfileIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileIdentifier").build())
            .build();

    private static final SdkField<String> TRANSFORMATION_RULES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransformationRules").getter(getter(CreateMigrationProjectRequest::transformationRules))
            .setter(setter(Builder::transformationRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformationRules").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateMigrationProjectRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateMigrationProjectRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SCApplicationAttributes> SCHEMA_CONVERSION_APPLICATION_ATTRIBUTES_FIELD = SdkField
            .<SCApplicationAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("SchemaConversionApplicationAttributes")
            .getter(getter(CreateMigrationProjectRequest::schemaConversionApplicationAttributes))
            .setter(setter(Builder::schemaConversionApplicationAttributes))
            .constructor(SCApplicationAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SchemaConversionApplicationAttributes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIGRATION_PROJECT_NAME_FIELD,
            SOURCE_DATA_PROVIDER_DESCRIPTORS_FIELD, TARGET_DATA_PROVIDER_DESCRIPTORS_FIELD, INSTANCE_PROFILE_IDENTIFIER_FIELD,
            TRANSFORMATION_RULES_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, SCHEMA_CONVERSION_APPLICATION_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String migrationProjectName;

    private final List<DataProviderDescriptorDefinition> sourceDataProviderDescriptors;

    private final List<DataProviderDescriptorDefinition> targetDataProviderDescriptors;

    private final String instanceProfileIdentifier;

    private final String transformationRules;

    private final String description;

    private final List<Tag> tags;

    private final SCApplicationAttributes schemaConversionApplicationAttributes;

    private CreateMigrationProjectRequest(BuilderImpl builder) {
        super(builder);
        this.migrationProjectName = builder.migrationProjectName;
        this.sourceDataProviderDescriptors = builder.sourceDataProviderDescriptors;
        this.targetDataProviderDescriptors = builder.targetDataProviderDescriptors;
        this.instanceProfileIdentifier = builder.instanceProfileIdentifier;
        this.transformationRules = builder.transformationRules;
        this.description = builder.description;
        this.tags = builder.tags;
        this.schemaConversionApplicationAttributes = builder.schemaConversionApplicationAttributes;
    }

    /**
     * <p>
     * A user-friendly name for the migration project.
     * </p>
     * 
     * @return A user-friendly name for the migration project.
     */
    public final String migrationProjectName() {
        return migrationProjectName;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceDataProviderDescriptors property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSourceDataProviderDescriptors() {
        return sourceDataProviderDescriptors != null && !(sourceDataProviderDescriptors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the source data provider, including the name, ARN, and Secrets Manager parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceDataProviderDescriptors} method.
     * </p>
     * 
     * @return Information about the source data provider, including the name, ARN, and Secrets Manager parameters.
     */
    public final List<DataProviderDescriptorDefinition> sourceDataProviderDescriptors() {
        return sourceDataProviderDescriptors;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetDataProviderDescriptors property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTargetDataProviderDescriptors() {
        return targetDataProviderDescriptors != null && !(targetDataProviderDescriptors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the target data provider, including the name, ARN, and Amazon Web Services Secrets Manager
     * parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetDataProviderDescriptors} method.
     * </p>
     * 
     * @return Information about the target data provider, including the name, ARN, and Amazon Web Services Secrets
     *         Manager parameters.
     */
    public final List<DataProviderDescriptorDefinition> targetDataProviderDescriptors() {
        return targetDataProviderDescriptors;
    }

    /**
     * <p>
     * The identifier of the associated instance profile. Identifiers must begin with a letter and must contain only
     * ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
     * </p>
     * 
     * @return The identifier of the associated instance profile. Identifiers must begin with a letter and must contain
     *         only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive
     *         hyphens.
     */
    public final String instanceProfileIdentifier() {
        return instanceProfileIdentifier;
    }

    /**
     * <p>
     * The settings in JSON format for migration rules. Migration rules make it possible for you to change the object
     * names according to the rules that you specify. For example, you can change an object name to lowercase or
     * uppercase, add or remove a prefix or suffix, or rename objects.
     * </p>
     * 
     * @return The settings in JSON format for migration rules. Migration rules make it possible for you to change the
     *         object names according to the rules that you specify. For example, you can change an object name to
     *         lowercase or uppercase, add or remove a prefix or suffix, or rename objects.
     */
    public final String transformationRules() {
        return transformationRules;
    }

    /**
     * <p>
     * A user-friendly description of the migration project.
     * </p>
     * 
     * @return A user-friendly description of the migration project.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more tags to be assigned to the migration project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return One or more tags to be assigned to the migration project.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The schema conversion application attributes, including the Amazon S3 bucket name and Amazon S3 role ARN.
     * </p>
     * 
     * @return The schema conversion application attributes, including the Amazon S3 bucket name and Amazon S3 role ARN.
     */
    public final SCApplicationAttributes schemaConversionApplicationAttributes() {
        return schemaConversionApplicationAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(migrationProjectName());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceDataProviderDescriptors() ? sourceDataProviderDescriptors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetDataProviderDescriptors() ? targetDataProviderDescriptors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceProfileIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(transformationRules());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(schemaConversionApplicationAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMigrationProjectRequest)) {
            return false;
        }
        CreateMigrationProjectRequest other = (CreateMigrationProjectRequest) obj;
        return Objects.equals(migrationProjectName(), other.migrationProjectName())
                && hasSourceDataProviderDescriptors() == other.hasSourceDataProviderDescriptors()
                && Objects.equals(sourceDataProviderDescriptors(), other.sourceDataProviderDescriptors())
                && hasTargetDataProviderDescriptors() == other.hasTargetDataProviderDescriptors()
                && Objects.equals(targetDataProviderDescriptors(), other.targetDataProviderDescriptors())
                && Objects.equals(instanceProfileIdentifier(), other.instanceProfileIdentifier())
                && Objects.equals(transformationRules(), other.transformationRules())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(schemaConversionApplicationAttributes(), other.schemaConversionApplicationAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateMigrationProjectRequest")
                .add("MigrationProjectName", migrationProjectName())
                .add("SourceDataProviderDescriptors", hasSourceDataProviderDescriptors() ? sourceDataProviderDescriptors() : null)
                .add("TargetDataProviderDescriptors", hasTargetDataProviderDescriptors() ? targetDataProviderDescriptors() : null)
                .add("InstanceProfileIdentifier", instanceProfileIdentifier()).add("TransformationRules", transformationRules())
                .add("Description", description()).add("Tags", hasTags() ? tags() : null)
                .add("SchemaConversionApplicationAttributes", schemaConversionApplicationAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MigrationProjectName":
            return Optional.ofNullable(clazz.cast(migrationProjectName()));
        case "SourceDataProviderDescriptors":
            return Optional.ofNullable(clazz.cast(sourceDataProviderDescriptors()));
        case "TargetDataProviderDescriptors":
            return Optional.ofNullable(clazz.cast(targetDataProviderDescriptors()));
        case "InstanceProfileIdentifier":
            return Optional.ofNullable(clazz.cast(instanceProfileIdentifier()));
        case "TransformationRules":
            return Optional.ofNullable(clazz.cast(transformationRules()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SchemaConversionApplicationAttributes":
            return Optional.ofNullable(clazz.cast(schemaConversionApplicationAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MigrationProjectName", MIGRATION_PROJECT_NAME_FIELD);
        map.put("SourceDataProviderDescriptors", SOURCE_DATA_PROVIDER_DESCRIPTORS_FIELD);
        map.put("TargetDataProviderDescriptors", TARGET_DATA_PROVIDER_DESCRIPTORS_FIELD);
        map.put("InstanceProfileIdentifier", INSTANCE_PROFILE_IDENTIFIER_FIELD);
        map.put("TransformationRules", TRANSFORMATION_RULES_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("SchemaConversionApplicationAttributes", SCHEMA_CONVERSION_APPLICATION_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMigrationProjectRequest, T> g) {
        return obj -> g.apply((CreateMigrationProjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMigrationProjectRequest> {
        /**
         * <p>
         * A user-friendly name for the migration project.
         * </p>
         * 
         * @param migrationProjectName
         *        A user-friendly name for the migration project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationProjectName(String migrationProjectName);

        /**
         * <p>
         * Information about the source data provider, including the name, ARN, and Secrets Manager parameters.
         * </p>
         * 
         * @param sourceDataProviderDescriptors
         *        Information about the source data provider, including the name, ARN, and Secrets Manager parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDataProviderDescriptors(Collection<DataProviderDescriptorDefinition> sourceDataProviderDescriptors);

        /**
         * <p>
         * Information about the source data provider, including the name, ARN, and Secrets Manager parameters.
         * </p>
         * 
         * @param sourceDataProviderDescriptors
         *        Information about the source data provider, including the name, ARN, and Secrets Manager parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDataProviderDescriptors(DataProviderDescriptorDefinition... sourceDataProviderDescriptors);

        /**
         * <p>
         * Information about the source data provider, including the name, ARN, and Secrets Manager parameters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptorDefinition.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptorDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptorDefinition.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #sourceDataProviderDescriptors(List<DataProviderDescriptorDefinition>)}.
         * 
         * @param sourceDataProviderDescriptors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptorDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceDataProviderDescriptors(java.util.Collection<DataProviderDescriptorDefinition>)
         */
        Builder sourceDataProviderDescriptors(Consumer<DataProviderDescriptorDefinition.Builder>... sourceDataProviderDescriptors);

        /**
         * <p>
         * Information about the target data provider, including the name, ARN, and Amazon Web Services Secrets Manager
         * parameters.
         * </p>
         * 
         * @param targetDataProviderDescriptors
         *        Information about the target data provider, including the name, ARN, and Amazon Web Services Secrets
         *        Manager parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDataProviderDescriptors(Collection<DataProviderDescriptorDefinition> targetDataProviderDescriptors);

        /**
         * <p>
         * Information about the target data provider, including the name, ARN, and Amazon Web Services Secrets Manager
         * parameters.
         * </p>
         * 
         * @param targetDataProviderDescriptors
         *        Information about the target data provider, including the name, ARN, and Amazon Web Services Secrets
         *        Manager parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDataProviderDescriptors(DataProviderDescriptorDefinition... targetDataProviderDescriptors);

        /**
         * <p>
         * Information about the target data provider, including the name, ARN, and Amazon Web Services Secrets Manager
         * parameters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptorDefinition.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptorDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptorDefinition.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #targetDataProviderDescriptors(List<DataProviderDescriptorDefinition>)}.
         * 
         * @param targetDataProviderDescriptors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptorDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetDataProviderDescriptors(java.util.Collection<DataProviderDescriptorDefinition>)
         */
        Builder targetDataProviderDescriptors(Consumer<DataProviderDescriptorDefinition.Builder>... targetDataProviderDescriptors);

        /**
         * <p>
         * The identifier of the associated instance profile. Identifiers must begin with a letter and must contain only
         * ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two consecutive hyphens.
         * </p>
         * 
         * @param instanceProfileIdentifier
         *        The identifier of the associated instance profile. Identifiers must begin with a letter and must
         *        contain only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two
         *        consecutive hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfileIdentifier(String instanceProfileIdentifier);

        /**
         * <p>
         * The settings in JSON format for migration rules. Migration rules make it possible for you to change the
         * object names according to the rules that you specify. For example, you can change an object name to lowercase
         * or uppercase, add or remove a prefix or suffix, or rename objects.
         * </p>
         * 
         * @param transformationRules
         *        The settings in JSON format for migration rules. Migration rules make it possible for you to change
         *        the object names according to the rules that you specify. For example, you can change an object name
         *        to lowercase or uppercase, add or remove a prefix or suffix, or rename objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformationRules(String transformationRules);

        /**
         * <p>
         * A user-friendly description of the migration project.
         * </p>
         * 
         * @param description
         *        A user-friendly description of the migration project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * One or more tags to be assigned to the migration project.
         * </p>
         * 
         * @param tags
         *        One or more tags to be assigned to the migration project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tags to be assigned to the migration project.
         * </p>
         * 
         * @param tags
         *        One or more tags to be assigned to the migration project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * One or more tags to be assigned to the migration project.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.databasemigration.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The schema conversion application attributes, including the Amazon S3 bucket name and Amazon S3 role ARN.
         * </p>
         * 
         * @param schemaConversionApplicationAttributes
         *        The schema conversion application attributes, including the Amazon S3 bucket name and Amazon S3 role
         *        ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaConversionApplicationAttributes(SCApplicationAttributes schemaConversionApplicationAttributes);

        /**
         * <p>
         * The schema conversion application attributes, including the Amazon S3 bucket name and Amazon S3 role ARN.
         * </p>
         * This is a convenience method that creates an instance of the {@link SCApplicationAttributes.Builder} avoiding
         * the need to create one manually via {@link SCApplicationAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SCApplicationAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #schemaConversionApplicationAttributes(SCApplicationAttributes)}.
         * 
         * @param schemaConversionApplicationAttributes
         *        a consumer that will call methods on {@link SCApplicationAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaConversionApplicationAttributes(SCApplicationAttributes)
         */
        default Builder schemaConversionApplicationAttributes(
                Consumer<SCApplicationAttributes.Builder> schemaConversionApplicationAttributes) {
            return schemaConversionApplicationAttributes(SCApplicationAttributes.builder()
                    .applyMutation(schemaConversionApplicationAttributes).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String migrationProjectName;

        private List<DataProviderDescriptorDefinition> sourceDataProviderDescriptors = DefaultSdkAutoConstructList.getInstance();

        private List<DataProviderDescriptorDefinition> targetDataProviderDescriptors = DefaultSdkAutoConstructList.getInstance();

        private String instanceProfileIdentifier;

        private String transformationRules;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private SCApplicationAttributes schemaConversionApplicationAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMigrationProjectRequest model) {
            super(model);
            migrationProjectName(model.migrationProjectName);
            sourceDataProviderDescriptors(model.sourceDataProviderDescriptors);
            targetDataProviderDescriptors(model.targetDataProviderDescriptors);
            instanceProfileIdentifier(model.instanceProfileIdentifier);
            transformationRules(model.transformationRules);
            description(model.description);
            tags(model.tags);
            schemaConversionApplicationAttributes(model.schemaConversionApplicationAttributes);
        }

        public final String getMigrationProjectName() {
            return migrationProjectName;
        }

        public final void setMigrationProjectName(String migrationProjectName) {
            this.migrationProjectName = migrationProjectName;
        }

        @Override
        public final Builder migrationProjectName(String migrationProjectName) {
            this.migrationProjectName = migrationProjectName;
            return this;
        }

        public final List<DataProviderDescriptorDefinition.Builder> getSourceDataProviderDescriptors() {
            List<DataProviderDescriptorDefinition.Builder> result = DataProviderDescriptorDefinitionListCopier
                    .copyToBuilder(this.sourceDataProviderDescriptors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceDataProviderDescriptors(
                Collection<DataProviderDescriptorDefinition.BuilderImpl> sourceDataProviderDescriptors) {
            this.sourceDataProviderDescriptors = DataProviderDescriptorDefinitionListCopier
                    .copyFromBuilder(sourceDataProviderDescriptors);
        }

        @Override
        public final Builder sourceDataProviderDescriptors(
                Collection<DataProviderDescriptorDefinition> sourceDataProviderDescriptors) {
            this.sourceDataProviderDescriptors = DataProviderDescriptorDefinitionListCopier.copy(sourceDataProviderDescriptors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDataProviderDescriptors(DataProviderDescriptorDefinition... sourceDataProviderDescriptors) {
            sourceDataProviderDescriptors(Arrays.asList(sourceDataProviderDescriptors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDataProviderDescriptors(
                Consumer<DataProviderDescriptorDefinition.Builder>... sourceDataProviderDescriptors) {
            sourceDataProviderDescriptors(Stream.of(sourceDataProviderDescriptors)
                    .map(c -> DataProviderDescriptorDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataProviderDescriptorDefinition.Builder> getTargetDataProviderDescriptors() {
            List<DataProviderDescriptorDefinition.Builder> result = DataProviderDescriptorDefinitionListCopier
                    .copyToBuilder(this.targetDataProviderDescriptors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetDataProviderDescriptors(
                Collection<DataProviderDescriptorDefinition.BuilderImpl> targetDataProviderDescriptors) {
            this.targetDataProviderDescriptors = DataProviderDescriptorDefinitionListCopier
                    .copyFromBuilder(targetDataProviderDescriptors);
        }

        @Override
        public final Builder targetDataProviderDescriptors(
                Collection<DataProviderDescriptorDefinition> targetDataProviderDescriptors) {
            this.targetDataProviderDescriptors = DataProviderDescriptorDefinitionListCopier.copy(targetDataProviderDescriptors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetDataProviderDescriptors(DataProviderDescriptorDefinition... targetDataProviderDescriptors) {
            targetDataProviderDescriptors(Arrays.asList(targetDataProviderDescriptors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetDataProviderDescriptors(
                Consumer<DataProviderDescriptorDefinition.Builder>... targetDataProviderDescriptors) {
            targetDataProviderDescriptors(Stream.of(targetDataProviderDescriptors)
                    .map(c -> DataProviderDescriptorDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInstanceProfileIdentifier() {
            return instanceProfileIdentifier;
        }

        public final void setInstanceProfileIdentifier(String instanceProfileIdentifier) {
            this.instanceProfileIdentifier = instanceProfileIdentifier;
        }

        @Override
        public final Builder instanceProfileIdentifier(String instanceProfileIdentifier) {
            this.instanceProfileIdentifier = instanceProfileIdentifier;
            return this;
        }

        public final String getTransformationRules() {
            return transformationRules;
        }

        public final void setTransformationRules(String transformationRules) {
            this.transformationRules = transformationRules;
        }

        @Override
        public final Builder transformationRules(String transformationRules) {
            this.transformationRules = transformationRules;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final SCApplicationAttributes.Builder getSchemaConversionApplicationAttributes() {
            return schemaConversionApplicationAttributes != null ? schemaConversionApplicationAttributes.toBuilder() : null;
        }

        public final void setSchemaConversionApplicationAttributes(
                SCApplicationAttributes.BuilderImpl schemaConversionApplicationAttributes) {
            this.schemaConversionApplicationAttributes = schemaConversionApplicationAttributes != null ? schemaConversionApplicationAttributes
                    .build() : null;
        }

        @Override
        public final Builder schemaConversionApplicationAttributes(SCApplicationAttributes schemaConversionApplicationAttributes) {
            this.schemaConversionApplicationAttributes = schemaConversionApplicationAttributes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMigrationProjectRequest build() {
            return new CreateMigrationProjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
