/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelMetadataModelCreationResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<CancelMetadataModelCreationResponse.Builder, CancelMetadataModelCreationResponse> {
    private static final SdkField<SchemaConversionRequest> REQUEST_FIELD = SdkField
            .<SchemaConversionRequest> builder(MarshallingType.SDK_POJO).memberName("Request")
            .getter(getter(CancelMetadataModelCreationResponse::request)).setter(setter(Builder::request))
            .constructor(SchemaConversionRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Request").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SchemaConversionRequest request;

    private CancelMetadataModelCreationResponse(BuilderImpl builder) {
        super(builder);
        this.request = builder.request;
    }

    /**
     * Returns the value of the Request property for this object.
     * 
     * @return The value of the Request property for this object.
     */
    public final SchemaConversionRequest request() {
        return request;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(request());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelMetadataModelCreationResponse)) {
            return false;
        }
        CancelMetadataModelCreationResponse other = (CancelMetadataModelCreationResponse) obj;
        return Objects.equals(request(), other.request());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelMetadataModelCreationResponse").add("Request", request()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Request":
            return Optional.ofNullable(clazz.cast(request()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Request", REQUEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelMetadataModelCreationResponse, T> g) {
        return obj -> g.apply((CancelMetadataModelCreationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CancelMetadataModelCreationResponse> {
        /**
         * Sets the value of the Request property for this object.
         *
         * @param request
         *        The new value for the Request property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder request(SchemaConversionRequest request);

        /**
         * Sets the value of the Request property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SchemaConversionRequest.Builder} avoiding
         * the need to create one manually via {@link SchemaConversionRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaConversionRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #request(SchemaConversionRequest)}.
         * 
         * @param request
         *        a consumer that will call methods on {@link SchemaConversionRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #request(SchemaConversionRequest)
         */
        default Builder request(Consumer<SchemaConversionRequest.Builder> request) {
            return request(SchemaConversionRequest.builder().applyMutation(request).build());
        }
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private SchemaConversionRequest request;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelMetadataModelCreationResponse model) {
            super(model);
            request(model.request);
        }

        public final SchemaConversionRequest.Builder getRequest() {
            return request != null ? request.toBuilder() : null;
        }

        public final void setRequest(SchemaConversionRequest.BuilderImpl request) {
            this.request = request != null ? request.build() : null;
        }

        @Override
        public final Builder request(SchemaConversionRequest request) {
            this.request = request;
            return this;
        }

        @Override
        public CancelMetadataModelCreationResponse build() {
            return new CancelMetadataModelCreationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
