/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.CollectorResponse;
import software.amazon.awssdk.services.databasemigration.model.CollectorResponsesCopier;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFleetAdvisorCollectorsResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeFleetAdvisorCollectorsResponse> {
    private static final SdkField<List<CollectorResponse>> COLLECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Collectors").getter(DescribeFleetAdvisorCollectorsResponse.getter(DescribeFleetAdvisorCollectorsResponse::collectors)).setter(DescribeFleetAdvisorCollectorsResponse.setter(Builder::collectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Collectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CollectorResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeFleetAdvisorCollectorsResponse.getter(DescribeFleetAdvisorCollectorsResponse::nextToken)).setter(DescribeFleetAdvisorCollectorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTORS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeFleetAdvisorCollectorsResponse.memberNameToFieldInitializer();
    private final List<CollectorResponse> collectors;
    private final String nextToken;

    private DescribeFleetAdvisorCollectorsResponse(BuilderImpl builder) {
        super(builder);
        this.collectors = builder.collectors;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCollectors() {
        return this.collectors != null && !(this.collectors instanceof SdkAutoConstructList);
    }

    public final List<CollectorResponse> collectors() {
        return this.collectors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollectors() ? this.collectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetAdvisorCollectorsResponse)) {
            return false;
        }
        DescribeFleetAdvisorCollectorsResponse other = (DescribeFleetAdvisorCollectorsResponse)((Object)obj);
        return this.hasCollectors() == other.hasCollectors() && Objects.equals(this.collectors(), other.collectors()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFleetAdvisorCollectorsResponse").add("Collectors", this.hasCollectors() ? this.collectors() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Collectors": {
                return Optional.ofNullable(clazz.cast(this.collectors()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Collectors", COLLECTORS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetAdvisorCollectorsResponse, T> g) {
        return obj -> g.apply((DescribeFleetAdvisorCollectorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private List<CollectorResponse> collectors = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetAdvisorCollectorsResponse model) {
            super(model);
            this.collectors(model.collectors);
            this.nextToken(model.nextToken);
        }

        public final List<CollectorResponse.Builder> getCollectors() {
            List<CollectorResponse.Builder> result = CollectorResponsesCopier.copyToBuilder(this.collectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollectors(Collection<CollectorResponse.BuilderImpl> collectors) {
            this.collectors = CollectorResponsesCopier.copyFromBuilder(collectors);
        }

        @Override
        public final Builder collectors(Collection<CollectorResponse> collectors) {
            this.collectors = CollectorResponsesCopier.copy(collectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectors(CollectorResponse ... collectors) {
            this.collectors(Arrays.asList(collectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectors(Consumer<CollectorResponse.Builder> ... collectors) {
            this.collectors(Stream.of(collectors).map(c -> (CollectorResponse)((CollectorResponse.Builder)CollectorResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeFleetAdvisorCollectorsResponse build() {
            return new DescribeFleetAdvisorCollectorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFleetAdvisorCollectorsResponse> {
        public Builder collectors(Collection<CollectorResponse> var1);

        public Builder collectors(CollectorResponse ... var1);

        public Builder collectors(Consumer<CollectorResponse.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

