/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationTaskAssessmentResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationTaskAssessmentResult> {
    private static final SdkField<String> REPLICATION_TASK_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationTaskIdentifier").getter(ReplicationTaskAssessmentResult.getter(ReplicationTaskAssessmentResult::replicationTaskIdentifier)).setter(ReplicationTaskAssessmentResult.setter(Builder::replicationTaskIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskIdentifier").build()}).build();
    private static final SdkField<String> REPLICATION_TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationTaskArn").getter(ReplicationTaskAssessmentResult.getter(ReplicationTaskAssessmentResult::replicationTaskArn)).setter(ReplicationTaskAssessmentResult.setter(Builder::replicationTaskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskArn").build()}).build();
    private static final SdkField<Instant> REPLICATION_TASK_LAST_ASSESSMENT_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReplicationTaskLastAssessmentDate").getter(ReplicationTaskAssessmentResult.getter(ReplicationTaskAssessmentResult::replicationTaskLastAssessmentDate)).setter(ReplicationTaskAssessmentResult.setter(Builder::replicationTaskLastAssessmentDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskLastAssessmentDate").build()}).build();
    private static final SdkField<String> ASSESSMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssessmentStatus").getter(ReplicationTaskAssessmentResult.getter(ReplicationTaskAssessmentResult::assessmentStatus)).setter(ReplicationTaskAssessmentResult.setter(Builder::assessmentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentStatus").build()}).build();
    private static final SdkField<String> ASSESSMENT_RESULTS_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssessmentResultsFile").getter(ReplicationTaskAssessmentResult.getter(ReplicationTaskAssessmentResult::assessmentResultsFile)).setter(ReplicationTaskAssessmentResult.setter(Builder::assessmentResultsFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentResultsFile").build()}).build();
    private static final SdkField<String> ASSESSMENT_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssessmentResults").getter(ReplicationTaskAssessmentResult.getter(ReplicationTaskAssessmentResult::assessmentResults)).setter(ReplicationTaskAssessmentResult.setter(Builder::assessmentResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentResults").build()}).build();
    private static final SdkField<String> S3_OBJECT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3ObjectUrl").getter(ReplicationTaskAssessmentResult.getter(ReplicationTaskAssessmentResult::s3ObjectUrl)).setter(ReplicationTaskAssessmentResult.setter(Builder::s3ObjectUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ObjectUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_TASK_IDENTIFIER_FIELD, REPLICATION_TASK_ARN_FIELD, REPLICATION_TASK_LAST_ASSESSMENT_DATE_FIELD, ASSESSMENT_STATUS_FIELD, ASSESSMENT_RESULTS_FILE_FIELD, ASSESSMENT_RESULTS_FIELD, S3_OBJECT_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReplicationTaskAssessmentResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String replicationTaskIdentifier;
    private final String replicationTaskArn;
    private final Instant replicationTaskLastAssessmentDate;
    private final String assessmentStatus;
    private final String assessmentResultsFile;
    private final String assessmentResults;
    private final String s3ObjectUrl;

    private ReplicationTaskAssessmentResult(BuilderImpl builder) {
        this.replicationTaskIdentifier = builder.replicationTaskIdentifier;
        this.replicationTaskArn = builder.replicationTaskArn;
        this.replicationTaskLastAssessmentDate = builder.replicationTaskLastAssessmentDate;
        this.assessmentStatus = builder.assessmentStatus;
        this.assessmentResultsFile = builder.assessmentResultsFile;
        this.assessmentResults = builder.assessmentResults;
        this.s3ObjectUrl = builder.s3ObjectUrl;
    }

    public final String replicationTaskIdentifier() {
        return this.replicationTaskIdentifier;
    }

    public final String replicationTaskArn() {
        return this.replicationTaskArn;
    }

    public final Instant replicationTaskLastAssessmentDate() {
        return this.replicationTaskLastAssessmentDate;
    }

    public final String assessmentStatus() {
        return this.assessmentStatus;
    }

    public final String assessmentResultsFile() {
        return this.assessmentResultsFile;
    }

    public final String assessmentResults() {
        return this.assessmentResults;
    }

    public final String s3ObjectUrl() {
        return this.s3ObjectUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskLastAssessmentDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentResultsFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ObjectUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationTaskAssessmentResult)) {
            return false;
        }
        ReplicationTaskAssessmentResult other = (ReplicationTaskAssessmentResult)obj;
        return Objects.equals(this.replicationTaskIdentifier(), other.replicationTaskIdentifier()) && Objects.equals(this.replicationTaskArn(), other.replicationTaskArn()) && Objects.equals(this.replicationTaskLastAssessmentDate(), other.replicationTaskLastAssessmentDate()) && Objects.equals(this.assessmentStatus(), other.assessmentStatus()) && Objects.equals(this.assessmentResultsFile(), other.assessmentResultsFile()) && Objects.equals(this.assessmentResults(), other.assessmentResults()) && Objects.equals(this.s3ObjectUrl(), other.s3ObjectUrl());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicationTaskAssessmentResult").add("ReplicationTaskIdentifier", (Object)this.replicationTaskIdentifier()).add("ReplicationTaskArn", (Object)this.replicationTaskArn()).add("ReplicationTaskLastAssessmentDate", (Object)this.replicationTaskLastAssessmentDate()).add("AssessmentStatus", (Object)this.assessmentStatus()).add("AssessmentResultsFile", (Object)this.assessmentResultsFile()).add("AssessmentResults", (Object)this.assessmentResults()).add("S3ObjectUrl", (Object)(this.s3ObjectUrl() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationTaskIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskIdentifier()));
            }
            case "ReplicationTaskArn": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskArn()));
            }
            case "ReplicationTaskLastAssessmentDate": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskLastAssessmentDate()));
            }
            case "AssessmentStatus": {
                return Optional.ofNullable(clazz.cast(this.assessmentStatus()));
            }
            case "AssessmentResultsFile": {
                return Optional.ofNullable(clazz.cast(this.assessmentResultsFile()));
            }
            case "AssessmentResults": {
                return Optional.ofNullable(clazz.cast(this.assessmentResults()));
            }
            case "S3ObjectUrl": {
                return Optional.ofNullable(clazz.cast(this.s3ObjectUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReplicationTaskIdentifier", REPLICATION_TASK_IDENTIFIER_FIELD);
        map.put("ReplicationTaskArn", REPLICATION_TASK_ARN_FIELD);
        map.put("ReplicationTaskLastAssessmentDate", REPLICATION_TASK_LAST_ASSESSMENT_DATE_FIELD);
        map.put("AssessmentStatus", ASSESSMENT_STATUS_FIELD);
        map.put("AssessmentResultsFile", ASSESSMENT_RESULTS_FILE_FIELD);
        map.put("AssessmentResults", ASSESSMENT_RESULTS_FIELD);
        map.put("S3ObjectUrl", S3_OBJECT_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicationTaskAssessmentResult, T> g) {
        return obj -> g.apply((ReplicationTaskAssessmentResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationTaskIdentifier;
        private String replicationTaskArn;
        private Instant replicationTaskLastAssessmentDate;
        private String assessmentStatus;
        private String assessmentResultsFile;
        private String assessmentResults;
        private String s3ObjectUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationTaskAssessmentResult model) {
            this.replicationTaskIdentifier(model.replicationTaskIdentifier);
            this.replicationTaskArn(model.replicationTaskArn);
            this.replicationTaskLastAssessmentDate(model.replicationTaskLastAssessmentDate);
            this.assessmentStatus(model.assessmentStatus);
            this.assessmentResultsFile(model.assessmentResultsFile);
            this.assessmentResults(model.assessmentResults);
            this.s3ObjectUrl(model.s3ObjectUrl);
        }

        public final String getReplicationTaskIdentifier() {
            return this.replicationTaskIdentifier;
        }

        public final void setReplicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
        }

        @Override
        public final Builder replicationTaskIdentifier(String replicationTaskIdentifier) {
            this.replicationTaskIdentifier = replicationTaskIdentifier;
            return this;
        }

        public final String getReplicationTaskArn() {
            return this.replicationTaskArn;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        @Override
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final Instant getReplicationTaskLastAssessmentDate() {
            return this.replicationTaskLastAssessmentDate;
        }

        public final void setReplicationTaskLastAssessmentDate(Instant replicationTaskLastAssessmentDate) {
            this.replicationTaskLastAssessmentDate = replicationTaskLastAssessmentDate;
        }

        @Override
        public final Builder replicationTaskLastAssessmentDate(Instant replicationTaskLastAssessmentDate) {
            this.replicationTaskLastAssessmentDate = replicationTaskLastAssessmentDate;
            return this;
        }

        public final String getAssessmentStatus() {
            return this.assessmentStatus;
        }

        public final void setAssessmentStatus(String assessmentStatus) {
            this.assessmentStatus = assessmentStatus;
        }

        @Override
        public final Builder assessmentStatus(String assessmentStatus) {
            this.assessmentStatus = assessmentStatus;
            return this;
        }

        public final String getAssessmentResultsFile() {
            return this.assessmentResultsFile;
        }

        public final void setAssessmentResultsFile(String assessmentResultsFile) {
            this.assessmentResultsFile = assessmentResultsFile;
        }

        @Override
        public final Builder assessmentResultsFile(String assessmentResultsFile) {
            this.assessmentResultsFile = assessmentResultsFile;
            return this;
        }

        public final String getAssessmentResults() {
            return this.assessmentResults;
        }

        public final void setAssessmentResults(String assessmentResults) {
            this.assessmentResults = assessmentResults;
        }

        @Override
        public final Builder assessmentResults(String assessmentResults) {
            this.assessmentResults = assessmentResults;
            return this;
        }

        public final String getS3ObjectUrl() {
            return this.s3ObjectUrl;
        }

        public final void setS3ObjectUrl(String s3ObjectUrl) {
            this.s3ObjectUrl = s3ObjectUrl;
        }

        @Override
        public final Builder s3ObjectUrl(String s3ObjectUrl) {
            this.s3ObjectUrl = s3ObjectUrl;
            return this;
        }

        public ReplicationTaskAssessmentResult build() {
            return new ReplicationTaskAssessmentResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationTaskAssessmentResult> {
        public Builder replicationTaskIdentifier(String var1);

        public Builder replicationTaskArn(String var1);

        public Builder replicationTaskLastAssessmentDate(Instant var1);

        public Builder assessmentStatus(String var1);

        public Builder assessmentResultsFile(String var1);

        public Builder assessmentResults(String var1);

        public Builder s3ObjectUrl(String var1);
    }
}

