/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceDataSetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceDataSetting> {
    private static final SdkField<String> CDC_START_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CDCStartPosition").getter(SourceDataSetting.getter(SourceDataSetting::cdcStartPosition)).setter(SourceDataSetting.setter(Builder::cdcStartPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CDCStartPosition").build()}).build();
    private static final SdkField<Instant> CDC_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CDCStartTime").getter(SourceDataSetting.getter(SourceDataSetting::cdcStartTime)).setter(SourceDataSetting.setter(Builder::cdcStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CDCStartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CDC_STOP_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CDCStopTime").getter(SourceDataSetting.getter(SourceDataSetting::cdcStopTime)).setter(SourceDataSetting.setter(Builder::cdcStopTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CDCStopTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> SLOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SlotName").getter(SourceDataSetting.getter(SourceDataSetting::slotName)).setter(SourceDataSetting.setter(Builder::slotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlotName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CDC_START_POSITION_FIELD, CDC_START_TIME_FIELD, CDC_STOP_TIME_FIELD, SLOT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SourceDataSetting.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String cdcStartPosition;
    private final Instant cdcStartTime;
    private final Instant cdcStopTime;
    private final String slotName;

    private SourceDataSetting(BuilderImpl builder) {
        this.cdcStartPosition = builder.cdcStartPosition;
        this.cdcStartTime = builder.cdcStartTime;
        this.cdcStopTime = builder.cdcStopTime;
        this.slotName = builder.slotName;
    }

    public final String cdcStartPosition() {
        return this.cdcStartPosition;
    }

    public final Instant cdcStartTime() {
        return this.cdcStartTime;
    }

    public final Instant cdcStopTime() {
        return this.cdcStopTime;
    }

    public final String slotName() {
        return this.slotName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStartPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStopTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceDataSetting)) {
            return false;
        }
        SourceDataSetting other = (SourceDataSetting)obj;
        return Objects.equals(this.cdcStartPosition(), other.cdcStartPosition()) && Objects.equals(this.cdcStartTime(), other.cdcStartTime()) && Objects.equals(this.cdcStopTime(), other.cdcStopTime()) && Objects.equals(this.slotName(), other.slotName());
    }

    public final String toString() {
        return ToString.builder((String)"SourceDataSetting").add("CDCStartPosition", (Object)this.cdcStartPosition()).add("CDCStartTime", (Object)this.cdcStartTime()).add("CDCStopTime", (Object)this.cdcStopTime()).add("SlotName", (Object)this.slotName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CDCStartPosition": {
                return Optional.ofNullable(clazz.cast(this.cdcStartPosition()));
            }
            case "CDCStartTime": {
                return Optional.ofNullable(clazz.cast(this.cdcStartTime()));
            }
            case "CDCStopTime": {
                return Optional.ofNullable(clazz.cast(this.cdcStopTime()));
            }
            case "SlotName": {
                return Optional.ofNullable(clazz.cast(this.slotName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CDCStartPosition", CDC_START_POSITION_FIELD);
        map.put("CDCStartTime", CDC_START_TIME_FIELD);
        map.put("CDCStopTime", CDC_STOP_TIME_FIELD);
        map.put("SlotName", SLOT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceDataSetting, T> g) {
        return obj -> g.apply((SourceDataSetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cdcStartPosition;
        private Instant cdcStartTime;
        private Instant cdcStopTime;
        private String slotName;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceDataSetting model) {
            this.cdcStartPosition(model.cdcStartPosition);
            this.cdcStartTime(model.cdcStartTime);
            this.cdcStopTime(model.cdcStopTime);
            this.slotName(model.slotName);
        }

        public final String getCdcStartPosition() {
            return this.cdcStartPosition;
        }

        public final void setCdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
        }

        @Override
        public final Builder cdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
            return this;
        }

        public final Instant getCdcStartTime() {
            return this.cdcStartTime;
        }

        public final void setCdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
        }

        @Override
        public final Builder cdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
            return this;
        }

        public final Instant getCdcStopTime() {
            return this.cdcStopTime;
        }

        public final void setCdcStopTime(Instant cdcStopTime) {
            this.cdcStopTime = cdcStopTime;
        }

        @Override
        public final Builder cdcStopTime(Instant cdcStopTime) {
            this.cdcStopTime = cdcStopTime;
            return this;
        }

        public final String getSlotName() {
            return this.slotName;
        }

        public final void setSlotName(String slotName) {
            this.slotName = slotName;
        }

        @Override
        public final Builder slotName(String slotName) {
            this.slotName = slotName;
            return this;
        }

        public SourceDataSetting build() {
            return new SourceDataSetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceDataSetting> {
        public Builder cdcStartPosition(String var1);

        public Builder cdcStartTime(Instant var1);

        public Builder cdcStopTime(Instant var1);

        public Builder slotName(String var1);
    }
}

