/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.TargetDbType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MySQLSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MySQLSettings> {
    private static final SdkField<String> AFTER_CONNECT_SCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AfterConnectScript").getter(MySQLSettings.getter(MySQLSettings::afterConnectScript)).setter(MySQLSettings.setter(Builder::afterConnectScript)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AfterConnectScript").build()}).build();
    private static final SdkField<Boolean> CLEAN_SOURCE_METADATA_ON_MISMATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CleanSourceMetadataOnMismatch").getter(MySQLSettings.getter(MySQLSettings::cleanSourceMetadataOnMismatch)).setter(MySQLSettings.setter(Builder::cleanSourceMetadataOnMismatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CleanSourceMetadataOnMismatch").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(MySQLSettings.getter(MySQLSettings::databaseName)).setter(MySQLSettings.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<Integer> EVENTS_POLL_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EventsPollInterval").getter(MySQLSettings.getter(MySQLSettings::eventsPollInterval)).setter(MySQLSettings.setter(Builder::eventsPollInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventsPollInterval").build()}).build();
    private static final SdkField<String> TARGET_DB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetDbType").getter(MySQLSettings.getter(MySQLSettings::targetDbTypeAsString)).setter(MySQLSettings.setter(Builder::targetDbType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDbType").build()}).build();
    private static final SdkField<Integer> MAX_FILE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxFileSize").getter(MySQLSettings.getter(MySQLSettings::maxFileSize)).setter(MySQLSettings.setter(Builder::maxFileSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFileSize").build()}).build();
    private static final SdkField<Integer> PARALLEL_LOAD_THREADS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParallelLoadThreads").getter(MySQLSettings.getter(MySQLSettings::parallelLoadThreads)).setter(MySQLSettings.setter(Builder::parallelLoadThreads)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelLoadThreads").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(MySQLSettings.getter(MySQLSettings::password)).setter(MySQLSettings.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(MySQLSettings.getter(MySQLSettings::port)).setter(MySQLSettings.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(MySQLSettings.getter(MySQLSettings::serverName)).setter(MySQLSettings.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<String> SERVER_TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerTimezone").getter(MySQLSettings.getter(MySQLSettings::serverTimezone)).setter(MySQLSettings.setter(Builder::serverTimezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerTimezone").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(MySQLSettings.getter(MySQLSettings::username)).setter(MySQLSettings.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerAccessRoleArn").getter(MySQLSettings.getter(MySQLSettings::secretsManagerAccessRoleArn)).setter(MySQLSettings.setter(Builder::secretsManagerAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerAccessRoleArn").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_SECRET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerSecretId").getter(MySQLSettings.getter(MySQLSettings::secretsManagerSecretId)).setter(MySQLSettings.setter(Builder::secretsManagerSecretId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerSecretId").build()}).build();
    private static final SdkField<Integer> EXECUTE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExecuteTimeout").getter(MySQLSettings.getter(MySQLSettings::executeTimeout)).setter(MySQLSettings.setter(Builder::executeTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecuteTimeout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFTER_CONNECT_SCRIPT_FIELD, CLEAN_SOURCE_METADATA_ON_MISMATCH_FIELD, DATABASE_NAME_FIELD, EVENTS_POLL_INTERVAL_FIELD, TARGET_DB_TYPE_FIELD, MAX_FILE_SIZE_FIELD, PARALLEL_LOAD_THREADS_FIELD, PASSWORD_FIELD, PORT_FIELD, SERVER_NAME_FIELD, SERVER_TIMEZONE_FIELD, USERNAME_FIELD, SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD, SECRETS_MANAGER_SECRET_ID_FIELD, EXECUTE_TIMEOUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MySQLSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String afterConnectScript;
    private final Boolean cleanSourceMetadataOnMismatch;
    private final String databaseName;
    private final Integer eventsPollInterval;
    private final String targetDbType;
    private final Integer maxFileSize;
    private final Integer parallelLoadThreads;
    private final String password;
    private final Integer port;
    private final String serverName;
    private final String serverTimezone;
    private final String username;
    private final String secretsManagerAccessRoleArn;
    private final String secretsManagerSecretId;
    private final Integer executeTimeout;

    private MySQLSettings(BuilderImpl builder) {
        this.afterConnectScript = builder.afterConnectScript;
        this.cleanSourceMetadataOnMismatch = builder.cleanSourceMetadataOnMismatch;
        this.databaseName = builder.databaseName;
        this.eventsPollInterval = builder.eventsPollInterval;
        this.targetDbType = builder.targetDbType;
        this.maxFileSize = builder.maxFileSize;
        this.parallelLoadThreads = builder.parallelLoadThreads;
        this.password = builder.password;
        this.port = builder.port;
        this.serverName = builder.serverName;
        this.serverTimezone = builder.serverTimezone;
        this.username = builder.username;
        this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
        this.secretsManagerSecretId = builder.secretsManagerSecretId;
        this.executeTimeout = builder.executeTimeout;
    }

    public final String afterConnectScript() {
        return this.afterConnectScript;
    }

    public final Boolean cleanSourceMetadataOnMismatch() {
        return this.cleanSourceMetadataOnMismatch;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final Integer eventsPollInterval() {
        return this.eventsPollInterval;
    }

    public final TargetDbType targetDbType() {
        return TargetDbType.fromValue(this.targetDbType);
    }

    public final String targetDbTypeAsString() {
        return this.targetDbType;
    }

    public final Integer maxFileSize() {
        return this.maxFileSize;
    }

    public final Integer parallelLoadThreads() {
        return this.parallelLoadThreads;
    }

    public final String password() {
        return this.password;
    }

    public final Integer port() {
        return this.port;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final String serverTimezone() {
        return this.serverTimezone;
    }

    public final String username() {
        return this.username;
    }

    public final String secretsManagerAccessRoleArn() {
        return this.secretsManagerAccessRoleArn;
    }

    public final String secretsManagerSecretId() {
        return this.secretsManagerSecretId;
    }

    public final Integer executeTimeout() {
        return this.executeTimeout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.afterConnectScript());
        hashCode = 31 * hashCode + Objects.hashCode(this.cleanSourceMetadataOnMismatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventsPollInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDbTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFileSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelLoadThreads());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerSecretId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executeTimeout());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MySQLSettings)) {
            return false;
        }
        MySQLSettings other = (MySQLSettings)obj;
        return Objects.equals(this.afterConnectScript(), other.afterConnectScript()) && Objects.equals(this.cleanSourceMetadataOnMismatch(), other.cleanSourceMetadataOnMismatch()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.eventsPollInterval(), other.eventsPollInterval()) && Objects.equals(this.targetDbTypeAsString(), other.targetDbTypeAsString()) && Objects.equals(this.maxFileSize(), other.maxFileSize()) && Objects.equals(this.parallelLoadThreads(), other.parallelLoadThreads()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.serverTimezone(), other.serverTimezone()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.secretsManagerAccessRoleArn(), other.secretsManagerAccessRoleArn()) && Objects.equals(this.secretsManagerSecretId(), other.secretsManagerSecretId()) && Objects.equals(this.executeTimeout(), other.executeTimeout());
    }

    public final String toString() {
        return ToString.builder((String)"MySQLSettings").add("AfterConnectScript", (Object)this.afterConnectScript()).add("CleanSourceMetadataOnMismatch", (Object)this.cleanSourceMetadataOnMismatch()).add("DatabaseName", (Object)this.databaseName()).add("EventsPollInterval", (Object)this.eventsPollInterval()).add("TargetDbType", (Object)this.targetDbTypeAsString()).add("MaxFileSize", (Object)this.maxFileSize()).add("ParallelLoadThreads", (Object)this.parallelLoadThreads()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("Port", (Object)this.port()).add("ServerName", (Object)this.serverName()).add("ServerTimezone", (Object)this.serverTimezone()).add("Username", (Object)this.username()).add("SecretsManagerAccessRoleArn", (Object)this.secretsManagerAccessRoleArn()).add("SecretsManagerSecretId", (Object)this.secretsManagerSecretId()).add("ExecuteTimeout", (Object)this.executeTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AfterConnectScript": {
                return Optional.ofNullable(clazz.cast(this.afterConnectScript()));
            }
            case "CleanSourceMetadataOnMismatch": {
                return Optional.ofNullable(clazz.cast(this.cleanSourceMetadataOnMismatch()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "EventsPollInterval": {
                return Optional.ofNullable(clazz.cast(this.eventsPollInterval()));
            }
            case "TargetDbType": {
                return Optional.ofNullable(clazz.cast(this.targetDbTypeAsString()));
            }
            case "MaxFileSize": {
                return Optional.ofNullable(clazz.cast(this.maxFileSize()));
            }
            case "ParallelLoadThreads": {
                return Optional.ofNullable(clazz.cast(this.parallelLoadThreads()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "ServerTimezone": {
                return Optional.ofNullable(clazz.cast(this.serverTimezone()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "SecretsManagerAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerAccessRoleArn()));
            }
            case "SecretsManagerSecretId": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerSecretId()));
            }
            case "ExecuteTimeout": {
                return Optional.ofNullable(clazz.cast(this.executeTimeout()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AfterConnectScript", AFTER_CONNECT_SCRIPT_FIELD);
        map.put("CleanSourceMetadataOnMismatch", CLEAN_SOURCE_METADATA_ON_MISMATCH_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("EventsPollInterval", EVENTS_POLL_INTERVAL_FIELD);
        map.put("TargetDbType", TARGET_DB_TYPE_FIELD);
        map.put("MaxFileSize", MAX_FILE_SIZE_FIELD);
        map.put("ParallelLoadThreads", PARALLEL_LOAD_THREADS_FIELD);
        map.put("Password", PASSWORD_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("ServerName", SERVER_NAME_FIELD);
        map.put("ServerTimezone", SERVER_TIMEZONE_FIELD);
        map.put("Username", USERNAME_FIELD);
        map.put("SecretsManagerAccessRoleArn", SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD);
        map.put("SecretsManagerSecretId", SECRETS_MANAGER_SECRET_ID_FIELD);
        map.put("ExecuteTimeout", EXECUTE_TIMEOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MySQLSettings, T> g) {
        return obj -> g.apply((MySQLSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String afterConnectScript;
        private Boolean cleanSourceMetadataOnMismatch;
        private String databaseName;
        private Integer eventsPollInterval;
        private String targetDbType;
        private Integer maxFileSize;
        private Integer parallelLoadThreads;
        private String password;
        private Integer port;
        private String serverName;
        private String serverTimezone;
        private String username;
        private String secretsManagerAccessRoleArn;
        private String secretsManagerSecretId;
        private Integer executeTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(MySQLSettings model) {
            this.afterConnectScript(model.afterConnectScript);
            this.cleanSourceMetadataOnMismatch(model.cleanSourceMetadataOnMismatch);
            this.databaseName(model.databaseName);
            this.eventsPollInterval(model.eventsPollInterval);
            this.targetDbType(model.targetDbType);
            this.maxFileSize(model.maxFileSize);
            this.parallelLoadThreads(model.parallelLoadThreads);
            this.password(model.password);
            this.port(model.port);
            this.serverName(model.serverName);
            this.serverTimezone(model.serverTimezone);
            this.username(model.username);
            this.secretsManagerAccessRoleArn(model.secretsManagerAccessRoleArn);
            this.secretsManagerSecretId(model.secretsManagerSecretId);
            this.executeTimeout(model.executeTimeout);
        }

        public final String getAfterConnectScript() {
            return this.afterConnectScript;
        }

        public final void setAfterConnectScript(String afterConnectScript) {
            this.afterConnectScript = afterConnectScript;
        }

        @Override
        public final Builder afterConnectScript(String afterConnectScript) {
            this.afterConnectScript = afterConnectScript;
            return this;
        }

        public final Boolean getCleanSourceMetadataOnMismatch() {
            return this.cleanSourceMetadataOnMismatch;
        }

        public final void setCleanSourceMetadataOnMismatch(Boolean cleanSourceMetadataOnMismatch) {
            this.cleanSourceMetadataOnMismatch = cleanSourceMetadataOnMismatch;
        }

        @Override
        public final Builder cleanSourceMetadataOnMismatch(Boolean cleanSourceMetadataOnMismatch) {
            this.cleanSourceMetadataOnMismatch = cleanSourceMetadataOnMismatch;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final Integer getEventsPollInterval() {
            return this.eventsPollInterval;
        }

        public final void setEventsPollInterval(Integer eventsPollInterval) {
            this.eventsPollInterval = eventsPollInterval;
        }

        @Override
        public final Builder eventsPollInterval(Integer eventsPollInterval) {
            this.eventsPollInterval = eventsPollInterval;
            return this;
        }

        public final String getTargetDbType() {
            return this.targetDbType;
        }

        public final void setTargetDbType(String targetDbType) {
            this.targetDbType = targetDbType;
        }

        @Override
        public final Builder targetDbType(String targetDbType) {
            this.targetDbType = targetDbType;
            return this;
        }

        @Override
        public final Builder targetDbType(TargetDbType targetDbType) {
            this.targetDbType(targetDbType == null ? null : targetDbType.toString());
            return this;
        }

        public final Integer getMaxFileSize() {
            return this.maxFileSize;
        }

        public final void setMaxFileSize(Integer maxFileSize) {
            this.maxFileSize = maxFileSize;
        }

        @Override
        public final Builder maxFileSize(Integer maxFileSize) {
            this.maxFileSize = maxFileSize;
            return this;
        }

        public final Integer getParallelLoadThreads() {
            return this.parallelLoadThreads;
        }

        public final void setParallelLoadThreads(Integer parallelLoadThreads) {
            this.parallelLoadThreads = parallelLoadThreads;
        }

        @Override
        public final Builder parallelLoadThreads(Integer parallelLoadThreads) {
            this.parallelLoadThreads = parallelLoadThreads;
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getServerName() {
            return this.serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final String getServerTimezone() {
            return this.serverTimezone;
        }

        public final void setServerTimezone(String serverTimezone) {
            this.serverTimezone = serverTimezone;
        }

        @Override
        public final Builder serverTimezone(String serverTimezone) {
            this.serverTimezone = serverTimezone;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getSecretsManagerAccessRoleArn() {
            return this.secretsManagerAccessRoleArn;
        }

        public final void setSecretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
        }

        @Override
        public final Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
            return this;
        }

        public final String getSecretsManagerSecretId() {
            return this.secretsManagerSecretId;
        }

        public final void setSecretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
        }

        @Override
        public final Builder secretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
            return this;
        }

        public final Integer getExecuteTimeout() {
            return this.executeTimeout;
        }

        public final void setExecuteTimeout(Integer executeTimeout) {
            this.executeTimeout = executeTimeout;
        }

        @Override
        public final Builder executeTimeout(Integer executeTimeout) {
            this.executeTimeout = executeTimeout;
            return this;
        }

        public MySQLSettings build() {
            return new MySQLSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MySQLSettings> {
        public Builder afterConnectScript(String var1);

        public Builder cleanSourceMetadataOnMismatch(Boolean var1);

        public Builder databaseName(String var1);

        public Builder eventsPollInterval(Integer var1);

        public Builder targetDbType(String var1);

        public Builder targetDbType(TargetDbType var1);

        public Builder maxFileSize(Integer var1);

        public Builder parallelLoadThreads(Integer var1);

        public Builder password(String var1);

        public Builder port(Integer var1);

        public Builder serverName(String var1);

        public Builder serverTimezone(String var1);

        public Builder username(String var1);

        public Builder secretsManagerAccessRoleArn(String var1);

        public Builder secretsManagerSecretId(String var1);

        public Builder executeTimeout(Integer var1);
    }
}

