/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsResponse;

public class DescribeMetadataModelImportsPublisher
implements SdkPublisher<DescribeMetadataModelImportsResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeMetadataModelImportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMetadataModelImportsPublisher(DatabaseMigrationAsyncClient client, DescribeMetadataModelImportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMetadataModelImportsPublisher(DatabaseMigrationAsyncClient client, DescribeMetadataModelImportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMetadataModelImportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMetadataModelImportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeMetadataModelImportsResponseFetcher
    implements AsyncPageFetcher<DescribeMetadataModelImportsResponse> {
        private DescribeMetadataModelImportsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMetadataModelImportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeMetadataModelImportsResponse> nextPage(DescribeMetadataModelImportsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMetadataModelImportsPublisher.this.client.describeMetadataModelImports(DescribeMetadataModelImportsPublisher.this.firstRequest);
            }
            return DescribeMetadataModelImportsPublisher.this.client.describeMetadataModelImports((DescribeMetadataModelImportsRequest)((Object)DescribeMetadataModelImportsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

