/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.SafeguardPolicy;
import software.amazon.awssdk.services.databasemigration.model.SqlServerAuthenticationMethod;
import software.amazon.awssdk.services.databasemigration.model.TlogAccessMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MicrosoftSQLServerSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MicrosoftSQLServerSettings> {
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(MicrosoftSQLServerSettings.getter(MicrosoftSQLServerSettings::port)).setter(MicrosoftSQLServerSettings.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<Integer> BCP_PACKET_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BcpPacketSize").getter(MicrosoftSQLServerSettings.getter(MicrosoftSQLServerSettings::bcpPacketSize)).setter(MicrosoftSQLServerSettings.setter(Builder::bcpPacketSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BcpPacketSize").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(MicrosoftSQLServerSettings.getter(MicrosoftSQLServerSettings::databaseName)).setter(MicrosoftSQLServerSettings.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> CONTROL_TABLES_FILE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControlTablesFileGroup").getter(MicrosoftSQLServerSettings.getter(MicrosoftSQLServerSettings::controlTablesFileGroup)).setter(MicrosoftSQLServerSettings.setter(Builder::controlTablesFileGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlTablesFileGroup").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(MicrosoftSQLServerSettings.getter(MicrosoftSQLServerSettings::password)).setter(MicrosoftSQLServerSettings.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<Boolean> QUERY_SINGLE_ALWAYS_ON_NODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("QuerySingleAlwaysOnNode").getter(MicrosoftSQLServerSettings.getter(MicrosoftSQLServerSettings::querySingleAlwaysOnNode)).setter(MicrosoftSQLServerSettings.setter(Builder::querySingleAlwaysOnNode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuerySingleAlwaysOnNode").build()}).build();
    private static final SdkField<Boolean> READ_BACKUP_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReadBackupOnly").getter(MicrosoftSQLServerSettings.getter(MicrosoftSQLServerSettings::readBackupOnly)).setter(MicrosoftSQLServerSettings.setter(Builder::readBackupOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadBackupOnly").build()}).build();
    private static final SdkField<String> SAFEGUARD_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SafeguardPolicy").getter(MicrosoftSQLServerSettings.getter(MicrosoftSQLServerSettings::safeguardPolicyAsString)).setter(MicrosoftSQLServerSettings.setter(Builder::safeguardPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SafeguardPolicy").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(MicrosoftSQLServerSettings.getter(MicrosoftSQLServerSettings::serverName)).setter(MicrosoftSQLServerSettings.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(MicrosoftSQLServerSettings.getter(MicrosoftSQLServerSettings::username)).setter(MicrosoftSQLServerSettings.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<Boolean> USE_BCP_FULL_LOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseBcpFullLoad").getter(MicrosoftSQLServerSettings.getter(MicrosoftSQLServerSettings::useBcpFullLoad)).setter(MicrosoftSQLServerSettings.setter(Builder::useBcpFullLoad)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseBcpFullLoad").build()}).build();
    private static final SdkField<Boolean> USE_THIRD_PARTY_BACKUP_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseThirdPartyBackupDevice").getter(MicrosoftSQLServerSettings.getter(MicrosoftSQLServerSettings::useThirdPartyBackupDevice)).setter(MicrosoftSQLServerSettings.setter(Builder::useThirdPartyBackupDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseThirdPartyBackupDevice").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerAccessRoleArn").getter(MicrosoftSQLServerSettings.getter(MicrosoftSQLServerSettings::secretsManagerAccessRoleArn)).setter(MicrosoftSQLServerSettings.setter(Builder::secretsManagerAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerAccessRoleArn").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_SECRET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerSecretId").getter(MicrosoftSQLServerSettings.getter(MicrosoftSQLServerSettings::secretsManagerSecretId)).setter(MicrosoftSQLServerSettings.setter(Builder::secretsManagerSecretId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerSecretId").build()}).build();
    private static final SdkField<Boolean> TRIM_SPACE_IN_CHAR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TrimSpaceInChar").getter(MicrosoftSQLServerSettings.getter(MicrosoftSQLServerSettings::trimSpaceInChar)).setter(MicrosoftSQLServerSettings.setter(Builder::trimSpaceInChar)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrimSpaceInChar").build()}).build();
    private static final SdkField<String> TLOG_ACCESS_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TlogAccessMode").getter(MicrosoftSQLServerSettings.getter(MicrosoftSQLServerSettings::tlogAccessModeAsString)).setter(MicrosoftSQLServerSettings.setter(Builder::tlogAccessMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlogAccessMode").build()}).build();
    private static final SdkField<Boolean> FORCE_LOB_LOOKUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ForceLobLookup").getter(MicrosoftSQLServerSettings.getter(MicrosoftSQLServerSettings::forceLobLookup)).setter(MicrosoftSQLServerSettings.setter(Builder::forceLobLookup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceLobLookup").build()}).build();
    private static final SdkField<String> AUTHENTICATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationMethod").getter(MicrosoftSQLServerSettings.getter(MicrosoftSQLServerSettings::authenticationMethodAsString)).setter(MicrosoftSQLServerSettings.setter(Builder::authenticationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMethod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_FIELD, BCP_PACKET_SIZE_FIELD, DATABASE_NAME_FIELD, CONTROL_TABLES_FILE_GROUP_FIELD, PASSWORD_FIELD, QUERY_SINGLE_ALWAYS_ON_NODE_FIELD, READ_BACKUP_ONLY_FIELD, SAFEGUARD_POLICY_FIELD, SERVER_NAME_FIELD, USERNAME_FIELD, USE_BCP_FULL_LOAD_FIELD, USE_THIRD_PARTY_BACKUP_DEVICE_FIELD, SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD, SECRETS_MANAGER_SECRET_ID_FIELD, TRIM_SPACE_IN_CHAR_FIELD, TLOG_ACCESS_MODE_FIELD, FORCE_LOB_LOOKUP_FIELD, AUTHENTICATION_METHOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MicrosoftSQLServerSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer port;
    private final Integer bcpPacketSize;
    private final String databaseName;
    private final String controlTablesFileGroup;
    private final String password;
    private final Boolean querySingleAlwaysOnNode;
    private final Boolean readBackupOnly;
    private final String safeguardPolicy;
    private final String serverName;
    private final String username;
    private final Boolean useBcpFullLoad;
    private final Boolean useThirdPartyBackupDevice;
    private final String secretsManagerAccessRoleArn;
    private final String secretsManagerSecretId;
    private final Boolean trimSpaceInChar;
    private final String tlogAccessMode;
    private final Boolean forceLobLookup;
    private final String authenticationMethod;

    private MicrosoftSQLServerSettings(BuilderImpl builder) {
        this.port = builder.port;
        this.bcpPacketSize = builder.bcpPacketSize;
        this.databaseName = builder.databaseName;
        this.controlTablesFileGroup = builder.controlTablesFileGroup;
        this.password = builder.password;
        this.querySingleAlwaysOnNode = builder.querySingleAlwaysOnNode;
        this.readBackupOnly = builder.readBackupOnly;
        this.safeguardPolicy = builder.safeguardPolicy;
        this.serverName = builder.serverName;
        this.username = builder.username;
        this.useBcpFullLoad = builder.useBcpFullLoad;
        this.useThirdPartyBackupDevice = builder.useThirdPartyBackupDevice;
        this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
        this.secretsManagerSecretId = builder.secretsManagerSecretId;
        this.trimSpaceInChar = builder.trimSpaceInChar;
        this.tlogAccessMode = builder.tlogAccessMode;
        this.forceLobLookup = builder.forceLobLookup;
        this.authenticationMethod = builder.authenticationMethod;
    }

    public final Integer port() {
        return this.port;
    }

    public final Integer bcpPacketSize() {
        return this.bcpPacketSize;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String controlTablesFileGroup() {
        return this.controlTablesFileGroup;
    }

    public final String password() {
        return this.password;
    }

    public final Boolean querySingleAlwaysOnNode() {
        return this.querySingleAlwaysOnNode;
    }

    public final Boolean readBackupOnly() {
        return this.readBackupOnly;
    }

    public final SafeguardPolicy safeguardPolicy() {
        return SafeguardPolicy.fromValue(this.safeguardPolicy);
    }

    public final String safeguardPolicyAsString() {
        return this.safeguardPolicy;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final String username() {
        return this.username;
    }

    public final Boolean useBcpFullLoad() {
        return this.useBcpFullLoad;
    }

    public final Boolean useThirdPartyBackupDevice() {
        return this.useThirdPartyBackupDevice;
    }

    public final String secretsManagerAccessRoleArn() {
        return this.secretsManagerAccessRoleArn;
    }

    public final String secretsManagerSecretId() {
        return this.secretsManagerSecretId;
    }

    public final Boolean trimSpaceInChar() {
        return this.trimSpaceInChar;
    }

    public final TlogAccessMode tlogAccessMode() {
        return TlogAccessMode.fromValue(this.tlogAccessMode);
    }

    public final String tlogAccessModeAsString() {
        return this.tlogAccessMode;
    }

    public final Boolean forceLobLookup() {
        return this.forceLobLookup;
    }

    public final SqlServerAuthenticationMethod authenticationMethod() {
        return SqlServerAuthenticationMethod.fromValue(this.authenticationMethod);
    }

    public final String authenticationMethodAsString() {
        return this.authenticationMethod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.bcpPacketSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlTablesFileGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.querySingleAlwaysOnNode());
        hashCode = 31 * hashCode + Objects.hashCode(this.readBackupOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.safeguardPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.useBcpFullLoad());
        hashCode = 31 * hashCode + Objects.hashCode(this.useThirdPartyBackupDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerSecretId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trimSpaceInChar());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlogAccessModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceLobLookup());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationMethodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MicrosoftSQLServerSettings)) {
            return false;
        }
        MicrosoftSQLServerSettings other = (MicrosoftSQLServerSettings)obj;
        return Objects.equals(this.port(), other.port()) && Objects.equals(this.bcpPacketSize(), other.bcpPacketSize()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.controlTablesFileGroup(), other.controlTablesFileGroup()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.querySingleAlwaysOnNode(), other.querySingleAlwaysOnNode()) && Objects.equals(this.readBackupOnly(), other.readBackupOnly()) && Objects.equals(this.safeguardPolicyAsString(), other.safeguardPolicyAsString()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.useBcpFullLoad(), other.useBcpFullLoad()) && Objects.equals(this.useThirdPartyBackupDevice(), other.useThirdPartyBackupDevice()) && Objects.equals(this.secretsManagerAccessRoleArn(), other.secretsManagerAccessRoleArn()) && Objects.equals(this.secretsManagerSecretId(), other.secretsManagerSecretId()) && Objects.equals(this.trimSpaceInChar(), other.trimSpaceInChar()) && Objects.equals(this.tlogAccessModeAsString(), other.tlogAccessModeAsString()) && Objects.equals(this.forceLobLookup(), other.forceLobLookup()) && Objects.equals(this.authenticationMethodAsString(), other.authenticationMethodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MicrosoftSQLServerSettings").add("Port", (Object)this.port()).add("BcpPacketSize", (Object)this.bcpPacketSize()).add("DatabaseName", (Object)this.databaseName()).add("ControlTablesFileGroup", (Object)this.controlTablesFileGroup()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("QuerySingleAlwaysOnNode", (Object)this.querySingleAlwaysOnNode()).add("ReadBackupOnly", (Object)this.readBackupOnly()).add("SafeguardPolicy", (Object)this.safeguardPolicyAsString()).add("ServerName", (Object)this.serverName()).add("Username", (Object)this.username()).add("UseBcpFullLoad", (Object)this.useBcpFullLoad()).add("UseThirdPartyBackupDevice", (Object)this.useThirdPartyBackupDevice()).add("SecretsManagerAccessRoleArn", (Object)this.secretsManagerAccessRoleArn()).add("SecretsManagerSecretId", (Object)this.secretsManagerSecretId()).add("TrimSpaceInChar", (Object)this.trimSpaceInChar()).add("TlogAccessMode", (Object)this.tlogAccessModeAsString()).add("ForceLobLookup", (Object)this.forceLobLookup()).add("AuthenticationMethod", (Object)this.authenticationMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "BcpPacketSize": {
                return Optional.ofNullable(clazz.cast(this.bcpPacketSize()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "ControlTablesFileGroup": {
                return Optional.ofNullable(clazz.cast(this.controlTablesFileGroup()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "QuerySingleAlwaysOnNode": {
                return Optional.ofNullable(clazz.cast(this.querySingleAlwaysOnNode()));
            }
            case "ReadBackupOnly": {
                return Optional.ofNullable(clazz.cast(this.readBackupOnly()));
            }
            case "SafeguardPolicy": {
                return Optional.ofNullable(clazz.cast(this.safeguardPolicyAsString()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "UseBcpFullLoad": {
                return Optional.ofNullable(clazz.cast(this.useBcpFullLoad()));
            }
            case "UseThirdPartyBackupDevice": {
                return Optional.ofNullable(clazz.cast(this.useThirdPartyBackupDevice()));
            }
            case "SecretsManagerAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerAccessRoleArn()));
            }
            case "SecretsManagerSecretId": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerSecretId()));
            }
            case "TrimSpaceInChar": {
                return Optional.ofNullable(clazz.cast(this.trimSpaceInChar()));
            }
            case "TlogAccessMode": {
                return Optional.ofNullable(clazz.cast(this.tlogAccessModeAsString()));
            }
            case "ForceLobLookup": {
                return Optional.ofNullable(clazz.cast(this.forceLobLookup()));
            }
            case "AuthenticationMethod": {
                return Optional.ofNullable(clazz.cast(this.authenticationMethodAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Port", PORT_FIELD);
        map.put("BcpPacketSize", BCP_PACKET_SIZE_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("ControlTablesFileGroup", CONTROL_TABLES_FILE_GROUP_FIELD);
        map.put("Password", PASSWORD_FIELD);
        map.put("QuerySingleAlwaysOnNode", QUERY_SINGLE_ALWAYS_ON_NODE_FIELD);
        map.put("ReadBackupOnly", READ_BACKUP_ONLY_FIELD);
        map.put("SafeguardPolicy", SAFEGUARD_POLICY_FIELD);
        map.put("ServerName", SERVER_NAME_FIELD);
        map.put("Username", USERNAME_FIELD);
        map.put("UseBcpFullLoad", USE_BCP_FULL_LOAD_FIELD);
        map.put("UseThirdPartyBackupDevice", USE_THIRD_PARTY_BACKUP_DEVICE_FIELD);
        map.put("SecretsManagerAccessRoleArn", SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD);
        map.put("SecretsManagerSecretId", SECRETS_MANAGER_SECRET_ID_FIELD);
        map.put("TrimSpaceInChar", TRIM_SPACE_IN_CHAR_FIELD);
        map.put("TlogAccessMode", TLOG_ACCESS_MODE_FIELD);
        map.put("ForceLobLookup", FORCE_LOB_LOOKUP_FIELD);
        map.put("AuthenticationMethod", AUTHENTICATION_METHOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MicrosoftSQLServerSettings, T> g) {
        return obj -> g.apply((MicrosoftSQLServerSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer port;
        private Integer bcpPacketSize;
        private String databaseName;
        private String controlTablesFileGroup;
        private String password;
        private Boolean querySingleAlwaysOnNode;
        private Boolean readBackupOnly;
        private String safeguardPolicy;
        private String serverName;
        private String username;
        private Boolean useBcpFullLoad;
        private Boolean useThirdPartyBackupDevice;
        private String secretsManagerAccessRoleArn;
        private String secretsManagerSecretId;
        private Boolean trimSpaceInChar;
        private String tlogAccessMode;
        private Boolean forceLobLookup;
        private String authenticationMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(MicrosoftSQLServerSettings model) {
            this.port(model.port);
            this.bcpPacketSize(model.bcpPacketSize);
            this.databaseName(model.databaseName);
            this.controlTablesFileGroup(model.controlTablesFileGroup);
            this.password(model.password);
            this.querySingleAlwaysOnNode(model.querySingleAlwaysOnNode);
            this.readBackupOnly(model.readBackupOnly);
            this.safeguardPolicy(model.safeguardPolicy);
            this.serverName(model.serverName);
            this.username(model.username);
            this.useBcpFullLoad(model.useBcpFullLoad);
            this.useThirdPartyBackupDevice(model.useThirdPartyBackupDevice);
            this.secretsManagerAccessRoleArn(model.secretsManagerAccessRoleArn);
            this.secretsManagerSecretId(model.secretsManagerSecretId);
            this.trimSpaceInChar(model.trimSpaceInChar);
            this.tlogAccessMode(model.tlogAccessMode);
            this.forceLobLookup(model.forceLobLookup);
            this.authenticationMethod(model.authenticationMethod);
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final Integer getBcpPacketSize() {
            return this.bcpPacketSize;
        }

        public final void setBcpPacketSize(Integer bcpPacketSize) {
            this.bcpPacketSize = bcpPacketSize;
        }

        @Override
        public final Builder bcpPacketSize(Integer bcpPacketSize) {
            this.bcpPacketSize = bcpPacketSize;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getControlTablesFileGroup() {
            return this.controlTablesFileGroup;
        }

        public final void setControlTablesFileGroup(String controlTablesFileGroup) {
            this.controlTablesFileGroup = controlTablesFileGroup;
        }

        @Override
        public final Builder controlTablesFileGroup(String controlTablesFileGroup) {
            this.controlTablesFileGroup = controlTablesFileGroup;
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final Boolean getQuerySingleAlwaysOnNode() {
            return this.querySingleAlwaysOnNode;
        }

        public final void setQuerySingleAlwaysOnNode(Boolean querySingleAlwaysOnNode) {
            this.querySingleAlwaysOnNode = querySingleAlwaysOnNode;
        }

        @Override
        public final Builder querySingleAlwaysOnNode(Boolean querySingleAlwaysOnNode) {
            this.querySingleAlwaysOnNode = querySingleAlwaysOnNode;
            return this;
        }

        public final Boolean getReadBackupOnly() {
            return this.readBackupOnly;
        }

        public final void setReadBackupOnly(Boolean readBackupOnly) {
            this.readBackupOnly = readBackupOnly;
        }

        @Override
        public final Builder readBackupOnly(Boolean readBackupOnly) {
            this.readBackupOnly = readBackupOnly;
            return this;
        }

        public final String getSafeguardPolicy() {
            return this.safeguardPolicy;
        }

        public final void setSafeguardPolicy(String safeguardPolicy) {
            this.safeguardPolicy = safeguardPolicy;
        }

        @Override
        public final Builder safeguardPolicy(String safeguardPolicy) {
            this.safeguardPolicy = safeguardPolicy;
            return this;
        }

        @Override
        public final Builder safeguardPolicy(SafeguardPolicy safeguardPolicy) {
            this.safeguardPolicy(safeguardPolicy == null ? null : safeguardPolicy.toString());
            return this;
        }

        public final String getServerName() {
            return this.serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final Boolean getUseBcpFullLoad() {
            return this.useBcpFullLoad;
        }

        public final void setUseBcpFullLoad(Boolean useBcpFullLoad) {
            this.useBcpFullLoad = useBcpFullLoad;
        }

        @Override
        public final Builder useBcpFullLoad(Boolean useBcpFullLoad) {
            this.useBcpFullLoad = useBcpFullLoad;
            return this;
        }

        public final Boolean getUseThirdPartyBackupDevice() {
            return this.useThirdPartyBackupDevice;
        }

        public final void setUseThirdPartyBackupDevice(Boolean useThirdPartyBackupDevice) {
            this.useThirdPartyBackupDevice = useThirdPartyBackupDevice;
        }

        @Override
        public final Builder useThirdPartyBackupDevice(Boolean useThirdPartyBackupDevice) {
            this.useThirdPartyBackupDevice = useThirdPartyBackupDevice;
            return this;
        }

        public final String getSecretsManagerAccessRoleArn() {
            return this.secretsManagerAccessRoleArn;
        }

        public final void setSecretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
        }

        @Override
        public final Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
            return this;
        }

        public final String getSecretsManagerSecretId() {
            return this.secretsManagerSecretId;
        }

        public final void setSecretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
        }

        @Override
        public final Builder secretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
            return this;
        }

        public final Boolean getTrimSpaceInChar() {
            return this.trimSpaceInChar;
        }

        public final void setTrimSpaceInChar(Boolean trimSpaceInChar) {
            this.trimSpaceInChar = trimSpaceInChar;
        }

        @Override
        public final Builder trimSpaceInChar(Boolean trimSpaceInChar) {
            this.trimSpaceInChar = trimSpaceInChar;
            return this;
        }

        public final String getTlogAccessMode() {
            return this.tlogAccessMode;
        }

        public final void setTlogAccessMode(String tlogAccessMode) {
            this.tlogAccessMode = tlogAccessMode;
        }

        @Override
        public final Builder tlogAccessMode(String tlogAccessMode) {
            this.tlogAccessMode = tlogAccessMode;
            return this;
        }

        @Override
        public final Builder tlogAccessMode(TlogAccessMode tlogAccessMode) {
            this.tlogAccessMode(tlogAccessMode == null ? null : tlogAccessMode.toString());
            return this;
        }

        public final Boolean getForceLobLookup() {
            return this.forceLobLookup;
        }

        public final void setForceLobLookup(Boolean forceLobLookup) {
            this.forceLobLookup = forceLobLookup;
        }

        @Override
        public final Builder forceLobLookup(Boolean forceLobLookup) {
            this.forceLobLookup = forceLobLookup;
            return this;
        }

        public final String getAuthenticationMethod() {
            return this.authenticationMethod;
        }

        public final void setAuthenticationMethod(String authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
        }

        @Override
        public final Builder authenticationMethod(String authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            return this;
        }

        @Override
        public final Builder authenticationMethod(SqlServerAuthenticationMethod authenticationMethod) {
            this.authenticationMethod(authenticationMethod == null ? null : authenticationMethod.toString());
            return this;
        }

        public MicrosoftSQLServerSettings build() {
            return new MicrosoftSQLServerSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MicrosoftSQLServerSettings> {
        public Builder port(Integer var1);

        public Builder bcpPacketSize(Integer var1);

        public Builder databaseName(String var1);

        public Builder controlTablesFileGroup(String var1);

        public Builder password(String var1);

        public Builder querySingleAlwaysOnNode(Boolean var1);

        public Builder readBackupOnly(Boolean var1);

        public Builder safeguardPolicy(String var1);

        public Builder safeguardPolicy(SafeguardPolicy var1);

        public Builder serverName(String var1);

        public Builder username(String var1);

        public Builder useBcpFullLoad(Boolean var1);

        public Builder useThirdPartyBackupDevice(Boolean var1);

        public Builder secretsManagerAccessRoleArn(String var1);

        public Builder secretsManagerSecretId(String var1);

        public Builder trimSpaceInChar(Boolean var1);

        public Builder tlogAccessMode(String var1);

        public Builder tlogAccessMode(TlogAccessMode var1);

        public Builder forceLobLookup(Boolean var1);

        public Builder authenticationMethod(String var1);

        public Builder authenticationMethod(SqlServerAuthenticationMethod var1);
    }
}

