/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptorDefinition;
import software.amazon.awssdk.services.databasemigration.model.DataProviderDescriptorDefinitionListCopier;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.SCApplicationAttributes;
import software.amazon.awssdk.services.databasemigration.model.Tag;
import software.amazon.awssdk.services.databasemigration.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMigrationProjectRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, CreateMigrationProjectRequest> {
    private static final SdkField<String> MIGRATION_PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MigrationProjectName").getter(CreateMigrationProjectRequest.getter(CreateMigrationProjectRequest::migrationProjectName)).setter(CreateMigrationProjectRequest.setter(Builder::migrationProjectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProjectName").build()}).build();
    private static final SdkField<List<DataProviderDescriptorDefinition>> SOURCE_DATA_PROVIDER_DESCRIPTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceDataProviderDescriptors").getter(CreateMigrationProjectRequest.getter(CreateMigrationProjectRequest::sourceDataProviderDescriptors)).setter(CreateMigrationProjectRequest.setter(Builder::sourceDataProviderDescriptors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDataProviderDescriptors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataProviderDescriptorDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataProviderDescriptorDefinition>> TARGET_DATA_PROVIDER_DESCRIPTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetDataProviderDescriptors").getter(CreateMigrationProjectRequest.getter(CreateMigrationProjectRequest::targetDataProviderDescriptors)).setter(CreateMigrationProjectRequest.setter(Builder::targetDataProviderDescriptors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDataProviderDescriptors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataProviderDescriptorDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_PROFILE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceProfileIdentifier").getter(CreateMigrationProjectRequest.getter(CreateMigrationProjectRequest::instanceProfileIdentifier)).setter(CreateMigrationProjectRequest.setter(Builder::instanceProfileIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileIdentifier").build()}).build();
    private static final SdkField<String> TRANSFORMATION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransformationRules").getter(CreateMigrationProjectRequest.getter(CreateMigrationProjectRequest::transformationRules)).setter(CreateMigrationProjectRequest.setter(Builder::transformationRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformationRules").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateMigrationProjectRequest.getter(CreateMigrationProjectRequest::description)).setter(CreateMigrationProjectRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateMigrationProjectRequest.getter(CreateMigrationProjectRequest::tags)).setter(CreateMigrationProjectRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SCApplicationAttributes> SCHEMA_CONVERSION_APPLICATION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaConversionApplicationAttributes").getter(CreateMigrationProjectRequest.getter(CreateMigrationProjectRequest::schemaConversionApplicationAttributes)).setter(CreateMigrationProjectRequest.setter(Builder::schemaConversionApplicationAttributes)).constructor(SCApplicationAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaConversionApplicationAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIGRATION_PROJECT_NAME_FIELD, SOURCE_DATA_PROVIDER_DESCRIPTORS_FIELD, TARGET_DATA_PROVIDER_DESCRIPTORS_FIELD, INSTANCE_PROFILE_IDENTIFIER_FIELD, TRANSFORMATION_RULES_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, SCHEMA_CONVERSION_APPLICATION_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMigrationProjectRequest.memberNameToFieldInitializer();
    private final String migrationProjectName;
    private final List<DataProviderDescriptorDefinition> sourceDataProviderDescriptors;
    private final List<DataProviderDescriptorDefinition> targetDataProviderDescriptors;
    private final String instanceProfileIdentifier;
    private final String transformationRules;
    private final String description;
    private final List<Tag> tags;
    private final SCApplicationAttributes schemaConversionApplicationAttributes;

    private CreateMigrationProjectRequest(BuilderImpl builder) {
        super(builder);
        this.migrationProjectName = builder.migrationProjectName;
        this.sourceDataProviderDescriptors = builder.sourceDataProviderDescriptors;
        this.targetDataProviderDescriptors = builder.targetDataProviderDescriptors;
        this.instanceProfileIdentifier = builder.instanceProfileIdentifier;
        this.transformationRules = builder.transformationRules;
        this.description = builder.description;
        this.tags = builder.tags;
        this.schemaConversionApplicationAttributes = builder.schemaConversionApplicationAttributes;
    }

    public final String migrationProjectName() {
        return this.migrationProjectName;
    }

    public final boolean hasSourceDataProviderDescriptors() {
        return this.sourceDataProviderDescriptors != null && !(this.sourceDataProviderDescriptors instanceof SdkAutoConstructList);
    }

    public final List<DataProviderDescriptorDefinition> sourceDataProviderDescriptors() {
        return this.sourceDataProviderDescriptors;
    }

    public final boolean hasTargetDataProviderDescriptors() {
        return this.targetDataProviderDescriptors != null && !(this.targetDataProviderDescriptors instanceof SdkAutoConstructList);
    }

    public final List<DataProviderDescriptorDefinition> targetDataProviderDescriptors() {
        return this.targetDataProviderDescriptors;
    }

    public final String instanceProfileIdentifier() {
        return this.instanceProfileIdentifier;
    }

    public final String transformationRules() {
        return this.transformationRules;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final SCApplicationAttributes schemaConversionApplicationAttributes() {
        return this.schemaConversionApplicationAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationProjectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceDataProviderDescriptors() ? this.sourceDataProviderDescriptors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetDataProviderDescriptors() ? this.targetDataProviderDescriptors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformationRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaConversionApplicationAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMigrationProjectRequest)) {
            return false;
        }
        CreateMigrationProjectRequest other = (CreateMigrationProjectRequest)((Object)obj);
        return Objects.equals(this.migrationProjectName(), other.migrationProjectName()) && this.hasSourceDataProviderDescriptors() == other.hasSourceDataProviderDescriptors() && Objects.equals(this.sourceDataProviderDescriptors(), other.sourceDataProviderDescriptors()) && this.hasTargetDataProviderDescriptors() == other.hasTargetDataProviderDescriptors() && Objects.equals(this.targetDataProviderDescriptors(), other.targetDataProviderDescriptors()) && Objects.equals(this.instanceProfileIdentifier(), other.instanceProfileIdentifier()) && Objects.equals(this.transformationRules(), other.transformationRules()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.schemaConversionApplicationAttributes(), other.schemaConversionApplicationAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMigrationProjectRequest").add("MigrationProjectName", (Object)this.migrationProjectName()).add("SourceDataProviderDescriptors", this.hasSourceDataProviderDescriptors() ? this.sourceDataProviderDescriptors() : null).add("TargetDataProviderDescriptors", this.hasTargetDataProviderDescriptors() ? this.targetDataProviderDescriptors() : null).add("InstanceProfileIdentifier", (Object)this.instanceProfileIdentifier()).add("TransformationRules", (Object)this.transformationRules()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("SchemaConversionApplicationAttributes", (Object)this.schemaConversionApplicationAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MigrationProjectName": {
                return Optional.ofNullable(clazz.cast(this.migrationProjectName()));
            }
            case "SourceDataProviderDescriptors": {
                return Optional.ofNullable(clazz.cast(this.sourceDataProviderDescriptors()));
            }
            case "TargetDataProviderDescriptors": {
                return Optional.ofNullable(clazz.cast(this.targetDataProviderDescriptors()));
            }
            case "InstanceProfileIdentifier": {
                return Optional.ofNullable(clazz.cast(this.instanceProfileIdentifier()));
            }
            case "TransformationRules": {
                return Optional.ofNullable(clazz.cast(this.transformationRules()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SchemaConversionApplicationAttributes": {
                return Optional.ofNullable(clazz.cast(this.schemaConversionApplicationAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MigrationProjectName", MIGRATION_PROJECT_NAME_FIELD);
        map.put("SourceDataProviderDescriptors", SOURCE_DATA_PROVIDER_DESCRIPTORS_FIELD);
        map.put("TargetDataProviderDescriptors", TARGET_DATA_PROVIDER_DESCRIPTORS_FIELD);
        map.put("InstanceProfileIdentifier", INSTANCE_PROFILE_IDENTIFIER_FIELD);
        map.put("TransformationRules", TRANSFORMATION_RULES_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("SchemaConversionApplicationAttributes", SCHEMA_CONVERSION_APPLICATION_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMigrationProjectRequest, T> g) {
        return obj -> g.apply((CreateMigrationProjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String migrationProjectName;
        private List<DataProviderDescriptorDefinition> sourceDataProviderDescriptors = DefaultSdkAutoConstructList.getInstance();
        private List<DataProviderDescriptorDefinition> targetDataProviderDescriptors = DefaultSdkAutoConstructList.getInstance();
        private String instanceProfileIdentifier;
        private String transformationRules;
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private SCApplicationAttributes schemaConversionApplicationAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMigrationProjectRequest model) {
            super(model);
            this.migrationProjectName(model.migrationProjectName);
            this.sourceDataProviderDescriptors(model.sourceDataProviderDescriptors);
            this.targetDataProviderDescriptors(model.targetDataProviderDescriptors);
            this.instanceProfileIdentifier(model.instanceProfileIdentifier);
            this.transformationRules(model.transformationRules);
            this.description(model.description);
            this.tags(model.tags);
            this.schemaConversionApplicationAttributes(model.schemaConversionApplicationAttributes);
        }

        public final String getMigrationProjectName() {
            return this.migrationProjectName;
        }

        public final void setMigrationProjectName(String migrationProjectName) {
            this.migrationProjectName = migrationProjectName;
        }

        @Override
        public final Builder migrationProjectName(String migrationProjectName) {
            this.migrationProjectName = migrationProjectName;
            return this;
        }

        public final List<DataProviderDescriptorDefinition.Builder> getSourceDataProviderDescriptors() {
            List<DataProviderDescriptorDefinition.Builder> result = DataProviderDescriptorDefinitionListCopier.copyToBuilder(this.sourceDataProviderDescriptors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceDataProviderDescriptors(Collection<DataProviderDescriptorDefinition.BuilderImpl> sourceDataProviderDescriptors) {
            this.sourceDataProviderDescriptors = DataProviderDescriptorDefinitionListCopier.copyFromBuilder(sourceDataProviderDescriptors);
        }

        @Override
        public final Builder sourceDataProviderDescriptors(Collection<DataProviderDescriptorDefinition> sourceDataProviderDescriptors) {
            this.sourceDataProviderDescriptors = DataProviderDescriptorDefinitionListCopier.copy(sourceDataProviderDescriptors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDataProviderDescriptors(DataProviderDescriptorDefinition ... sourceDataProviderDescriptors) {
            this.sourceDataProviderDescriptors(Arrays.asList(sourceDataProviderDescriptors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDataProviderDescriptors(Consumer<DataProviderDescriptorDefinition.Builder> ... sourceDataProviderDescriptors) {
            this.sourceDataProviderDescriptors(Stream.of(sourceDataProviderDescriptors).map(c -> (DataProviderDescriptorDefinition)((DataProviderDescriptorDefinition.Builder)DataProviderDescriptorDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataProviderDescriptorDefinition.Builder> getTargetDataProviderDescriptors() {
            List<DataProviderDescriptorDefinition.Builder> result = DataProviderDescriptorDefinitionListCopier.copyToBuilder(this.targetDataProviderDescriptors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetDataProviderDescriptors(Collection<DataProviderDescriptorDefinition.BuilderImpl> targetDataProviderDescriptors) {
            this.targetDataProviderDescriptors = DataProviderDescriptorDefinitionListCopier.copyFromBuilder(targetDataProviderDescriptors);
        }

        @Override
        public final Builder targetDataProviderDescriptors(Collection<DataProviderDescriptorDefinition> targetDataProviderDescriptors) {
            this.targetDataProviderDescriptors = DataProviderDescriptorDefinitionListCopier.copy(targetDataProviderDescriptors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetDataProviderDescriptors(DataProviderDescriptorDefinition ... targetDataProviderDescriptors) {
            this.targetDataProviderDescriptors(Arrays.asList(targetDataProviderDescriptors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetDataProviderDescriptors(Consumer<DataProviderDescriptorDefinition.Builder> ... targetDataProviderDescriptors) {
            this.targetDataProviderDescriptors(Stream.of(targetDataProviderDescriptors).map(c -> (DataProviderDescriptorDefinition)((DataProviderDescriptorDefinition.Builder)DataProviderDescriptorDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInstanceProfileIdentifier() {
            return this.instanceProfileIdentifier;
        }

        public final void setInstanceProfileIdentifier(String instanceProfileIdentifier) {
            this.instanceProfileIdentifier = instanceProfileIdentifier;
        }

        @Override
        public final Builder instanceProfileIdentifier(String instanceProfileIdentifier) {
            this.instanceProfileIdentifier = instanceProfileIdentifier;
            return this;
        }

        public final String getTransformationRules() {
            return this.transformationRules;
        }

        public final void setTransformationRules(String transformationRules) {
            this.transformationRules = transformationRules;
        }

        @Override
        public final Builder transformationRules(String transformationRules) {
            this.transformationRules = transformationRules;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SCApplicationAttributes.Builder getSchemaConversionApplicationAttributes() {
            return this.schemaConversionApplicationAttributes != null ? this.schemaConversionApplicationAttributes.toBuilder() : null;
        }

        public final void setSchemaConversionApplicationAttributes(SCApplicationAttributes.BuilderImpl schemaConversionApplicationAttributes) {
            this.schemaConversionApplicationAttributes = schemaConversionApplicationAttributes != null ? schemaConversionApplicationAttributes.build() : null;
        }

        @Override
        public final Builder schemaConversionApplicationAttributes(SCApplicationAttributes schemaConversionApplicationAttributes) {
            this.schemaConversionApplicationAttributes = schemaConversionApplicationAttributes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMigrationProjectRequest build() {
            return new CreateMigrationProjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMigrationProjectRequest> {
        public Builder migrationProjectName(String var1);

        public Builder sourceDataProviderDescriptors(Collection<DataProviderDescriptorDefinition> var1);

        public Builder sourceDataProviderDescriptors(DataProviderDescriptorDefinition ... var1);

        public Builder sourceDataProviderDescriptors(Consumer<DataProviderDescriptorDefinition.Builder> ... var1);

        public Builder targetDataProviderDescriptors(Collection<DataProviderDescriptorDefinition> var1);

        public Builder targetDataProviderDescriptors(DataProviderDescriptorDefinition ... var1);

        public Builder targetDataProviderDescriptors(Consumer<DataProviderDescriptorDefinition.Builder> ... var1);

        public Builder instanceProfileIdentifier(String var1);

        public Builder transformationRules(String var1);

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder schemaConversionApplicationAttributes(SCApplicationAttributes var1);

        default public Builder schemaConversionApplicationAttributes(Consumer<SCApplicationAttributes.Builder> schemaConversionApplicationAttributes) {
            return this.schemaConversionApplicationAttributes((SCApplicationAttributes)((SCApplicationAttributes.Builder)SCApplicationAttributes.builder().applyMutation(schemaConversionApplicationAttributes)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

