/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.ComputeConfig;
import software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationConfig> {
    private static final SdkField<String> REPLICATION_CONFIG_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationConfigIdentifier").getter(ReplicationConfig.getter(ReplicationConfig::replicationConfigIdentifier)).setter(ReplicationConfig.setter(Builder::replicationConfigIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigIdentifier").build()}).build();
    private static final SdkField<String> REPLICATION_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationConfigArn").getter(ReplicationConfig.getter(ReplicationConfig::replicationConfigArn)).setter(ReplicationConfig.setter(Builder::replicationConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigArn").build()}).build();
    private static final SdkField<String> SOURCE_ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceEndpointArn").getter(ReplicationConfig.getter(ReplicationConfig::sourceEndpointArn)).setter(ReplicationConfig.setter(Builder::sourceEndpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEndpointArn").build()}).build();
    private static final SdkField<String> TARGET_ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetEndpointArn").getter(ReplicationConfig.getter(ReplicationConfig::targetEndpointArn)).setter(ReplicationConfig.setter(Builder::targetEndpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEndpointArn").build()}).build();
    private static final SdkField<String> REPLICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationType").getter(ReplicationConfig.getter(ReplicationConfig::replicationTypeAsString)).setter(ReplicationConfig.setter(Builder::replicationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationType").build()}).build();
    private static final SdkField<ComputeConfig> COMPUTE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComputeConfig").getter(ReplicationConfig.getter(ReplicationConfig::computeConfig)).setter(ReplicationConfig.setter(Builder::computeConfig)).constructor(ComputeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeConfig").build()}).build();
    private static final SdkField<String> REPLICATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationSettings").getter(ReplicationConfig.getter(ReplicationConfig::replicationSettings)).setter(ReplicationConfig.setter(Builder::replicationSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSettings").build()}).build();
    private static final SdkField<String> SUPPLEMENTAL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupplementalSettings").getter(ReplicationConfig.getter(ReplicationConfig::supplementalSettings)).setter(ReplicationConfig.setter(Builder::supplementalSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplementalSettings").build()}).build();
    private static final SdkField<String> TABLE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableMappings").getter(ReplicationConfig.getter(ReplicationConfig::tableMappings)).setter(ReplicationConfig.setter(Builder::tableMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMappings").build()}).build();
    private static final SdkField<Instant> REPLICATION_CONFIG_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReplicationConfigCreateTime").getter(ReplicationConfig.getter(ReplicationConfig::replicationConfigCreateTime)).setter(ReplicationConfig.setter(Builder::replicationConfigCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigCreateTime").build()}).build();
    private static final SdkField<Instant> REPLICATION_CONFIG_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReplicationConfigUpdateTime").getter(ReplicationConfig.getter(ReplicationConfig::replicationConfigUpdateTime)).setter(ReplicationConfig.setter(Builder::replicationConfigUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_CONFIG_IDENTIFIER_FIELD, REPLICATION_CONFIG_ARN_FIELD, SOURCE_ENDPOINT_ARN_FIELD, TARGET_ENDPOINT_ARN_FIELD, REPLICATION_TYPE_FIELD, COMPUTE_CONFIG_FIELD, REPLICATION_SETTINGS_FIELD, SUPPLEMENTAL_SETTINGS_FIELD, TABLE_MAPPINGS_FIELD, REPLICATION_CONFIG_CREATE_TIME_FIELD, REPLICATION_CONFIG_UPDATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ReplicationConfigIdentifier", REPLICATION_CONFIG_IDENTIFIER_FIELD);
            this.put("ReplicationConfigArn", REPLICATION_CONFIG_ARN_FIELD);
            this.put("SourceEndpointArn", SOURCE_ENDPOINT_ARN_FIELD);
            this.put("TargetEndpointArn", TARGET_ENDPOINT_ARN_FIELD);
            this.put("ReplicationType", REPLICATION_TYPE_FIELD);
            this.put("ComputeConfig", COMPUTE_CONFIG_FIELD);
            this.put("ReplicationSettings", REPLICATION_SETTINGS_FIELD);
            this.put("SupplementalSettings", SUPPLEMENTAL_SETTINGS_FIELD);
            this.put("TableMappings", TABLE_MAPPINGS_FIELD);
            this.put("ReplicationConfigCreateTime", REPLICATION_CONFIG_CREATE_TIME_FIELD);
            this.put("ReplicationConfigUpdateTime", REPLICATION_CONFIG_UPDATE_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String replicationConfigIdentifier;
    private final String replicationConfigArn;
    private final String sourceEndpointArn;
    private final String targetEndpointArn;
    private final String replicationType;
    private final ComputeConfig computeConfig;
    private final String replicationSettings;
    private final String supplementalSettings;
    private final String tableMappings;
    private final Instant replicationConfigCreateTime;
    private final Instant replicationConfigUpdateTime;

    private ReplicationConfig(BuilderImpl builder) {
        this.replicationConfigIdentifier = builder.replicationConfigIdentifier;
        this.replicationConfigArn = builder.replicationConfigArn;
        this.sourceEndpointArn = builder.sourceEndpointArn;
        this.targetEndpointArn = builder.targetEndpointArn;
        this.replicationType = builder.replicationType;
        this.computeConfig = builder.computeConfig;
        this.replicationSettings = builder.replicationSettings;
        this.supplementalSettings = builder.supplementalSettings;
        this.tableMappings = builder.tableMappings;
        this.replicationConfigCreateTime = builder.replicationConfigCreateTime;
        this.replicationConfigUpdateTime = builder.replicationConfigUpdateTime;
    }

    public final String replicationConfigIdentifier() {
        return this.replicationConfigIdentifier;
    }

    public final String replicationConfigArn() {
        return this.replicationConfigArn;
    }

    public final String sourceEndpointArn() {
        return this.sourceEndpointArn;
    }

    public final String targetEndpointArn() {
        return this.targetEndpointArn;
    }

    public final MigrationTypeValue replicationType() {
        return MigrationTypeValue.fromValue(this.replicationType);
    }

    public final String replicationTypeAsString() {
        return this.replicationType;
    }

    public final ComputeConfig computeConfig() {
        return this.computeConfig;
    }

    public final String replicationSettings() {
        return this.replicationSettings;
    }

    public final String supplementalSettings() {
        return this.supplementalSettings;
    }

    public final String tableMappings() {
        return this.tableMappings;
    }

    public final Instant replicationConfigCreateTime() {
        return this.replicationConfigCreateTime;
    }

    public final Instant replicationConfigUpdateTime() {
        return this.replicationConfigUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationConfigIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.supplementalSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationConfigCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationConfigUpdateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationConfig)) {
            return false;
        }
        ReplicationConfig other = (ReplicationConfig)obj;
        return Objects.equals(this.replicationConfigIdentifier(), other.replicationConfigIdentifier()) && Objects.equals(this.replicationConfigArn(), other.replicationConfigArn()) && Objects.equals(this.sourceEndpointArn(), other.sourceEndpointArn()) && Objects.equals(this.targetEndpointArn(), other.targetEndpointArn()) && Objects.equals(this.replicationTypeAsString(), other.replicationTypeAsString()) && Objects.equals(this.computeConfig(), other.computeConfig()) && Objects.equals(this.replicationSettings(), other.replicationSettings()) && Objects.equals(this.supplementalSettings(), other.supplementalSettings()) && Objects.equals(this.tableMappings(), other.tableMappings()) && Objects.equals(this.replicationConfigCreateTime(), other.replicationConfigCreateTime()) && Objects.equals(this.replicationConfigUpdateTime(), other.replicationConfigUpdateTime());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicationConfig").add("ReplicationConfigIdentifier", (Object)this.replicationConfigIdentifier()).add("ReplicationConfigArn", (Object)this.replicationConfigArn()).add("SourceEndpointArn", (Object)this.sourceEndpointArn()).add("TargetEndpointArn", (Object)this.targetEndpointArn()).add("ReplicationType", (Object)this.replicationTypeAsString()).add("ComputeConfig", (Object)this.computeConfig()).add("ReplicationSettings", (Object)this.replicationSettings()).add("SupplementalSettings", (Object)this.supplementalSettings()).add("TableMappings", (Object)this.tableMappings()).add("ReplicationConfigCreateTime", (Object)this.replicationConfigCreateTime()).add("ReplicationConfigUpdateTime", (Object)this.replicationConfigUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationConfigIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationConfigIdentifier()));
            }
            case "ReplicationConfigArn": {
                return Optional.ofNullable(clazz.cast(this.replicationConfigArn()));
            }
            case "SourceEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.sourceEndpointArn()));
            }
            case "TargetEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.targetEndpointArn()));
            }
            case "ReplicationType": {
                return Optional.ofNullable(clazz.cast(this.replicationTypeAsString()));
            }
            case "ComputeConfig": {
                return Optional.ofNullable(clazz.cast(this.computeConfig()));
            }
            case "ReplicationSettings": {
                return Optional.ofNullable(clazz.cast(this.replicationSettings()));
            }
            case "SupplementalSettings": {
                return Optional.ofNullable(clazz.cast(this.supplementalSettings()));
            }
            case "TableMappings": {
                return Optional.ofNullable(clazz.cast(this.tableMappings()));
            }
            case "ReplicationConfigCreateTime": {
                return Optional.ofNullable(clazz.cast(this.replicationConfigCreateTime()));
            }
            case "ReplicationConfigUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.replicationConfigUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationConfig, T> g) {
        return obj -> g.apply((ReplicationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationConfigIdentifier;
        private String replicationConfigArn;
        private String sourceEndpointArn;
        private String targetEndpointArn;
        private String replicationType;
        private ComputeConfig computeConfig;
        private String replicationSettings;
        private String supplementalSettings;
        private String tableMappings;
        private Instant replicationConfigCreateTime;
        private Instant replicationConfigUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationConfig model) {
            this.replicationConfigIdentifier(model.replicationConfigIdentifier);
            this.replicationConfigArn(model.replicationConfigArn);
            this.sourceEndpointArn(model.sourceEndpointArn);
            this.targetEndpointArn(model.targetEndpointArn);
            this.replicationType(model.replicationType);
            this.computeConfig(model.computeConfig);
            this.replicationSettings(model.replicationSettings);
            this.supplementalSettings(model.supplementalSettings);
            this.tableMappings(model.tableMappings);
            this.replicationConfigCreateTime(model.replicationConfigCreateTime);
            this.replicationConfigUpdateTime(model.replicationConfigUpdateTime);
        }

        public final String getReplicationConfigIdentifier() {
            return this.replicationConfigIdentifier;
        }

        public final void setReplicationConfigIdentifier(String replicationConfigIdentifier) {
            this.replicationConfigIdentifier = replicationConfigIdentifier;
        }

        @Override
        public final Builder replicationConfigIdentifier(String replicationConfigIdentifier) {
            this.replicationConfigIdentifier = replicationConfigIdentifier;
            return this;
        }

        public final String getReplicationConfigArn() {
            return this.replicationConfigArn;
        }

        public final void setReplicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
        }

        @Override
        public final Builder replicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
            return this;
        }

        public final String getSourceEndpointArn() {
            return this.sourceEndpointArn;
        }

        public final void setSourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
        }

        @Override
        public final Builder sourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
            return this;
        }

        public final String getTargetEndpointArn() {
            return this.targetEndpointArn;
        }

        public final void setTargetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
        }

        @Override
        public final Builder targetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
            return this;
        }

        public final String getReplicationType() {
            return this.replicationType;
        }

        public final void setReplicationType(String replicationType) {
            this.replicationType = replicationType;
        }

        @Override
        public final Builder replicationType(String replicationType) {
            this.replicationType = replicationType;
            return this;
        }

        @Override
        public final Builder replicationType(MigrationTypeValue replicationType) {
            this.replicationType(replicationType == null ? null : replicationType.toString());
            return this;
        }

        public final ComputeConfig.Builder getComputeConfig() {
            return this.computeConfig != null ? this.computeConfig.toBuilder() : null;
        }

        public final void setComputeConfig(ComputeConfig.BuilderImpl computeConfig) {
            this.computeConfig = computeConfig != null ? computeConfig.build() : null;
        }

        @Override
        public final Builder computeConfig(ComputeConfig computeConfig) {
            this.computeConfig = computeConfig;
            return this;
        }

        public final String getReplicationSettings() {
            return this.replicationSettings;
        }

        public final void setReplicationSettings(String replicationSettings) {
            this.replicationSettings = replicationSettings;
        }

        @Override
        public final Builder replicationSettings(String replicationSettings) {
            this.replicationSettings = replicationSettings;
            return this;
        }

        public final String getSupplementalSettings() {
            return this.supplementalSettings;
        }

        public final void setSupplementalSettings(String supplementalSettings) {
            this.supplementalSettings = supplementalSettings;
        }

        @Override
        public final Builder supplementalSettings(String supplementalSettings) {
            this.supplementalSettings = supplementalSettings;
            return this;
        }

        public final String getTableMappings() {
            return this.tableMappings;
        }

        public final void setTableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
        }

        @Override
        public final Builder tableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
            return this;
        }

        public final Instant getReplicationConfigCreateTime() {
            return this.replicationConfigCreateTime;
        }

        public final void setReplicationConfigCreateTime(Instant replicationConfigCreateTime) {
            this.replicationConfigCreateTime = replicationConfigCreateTime;
        }

        @Override
        public final Builder replicationConfigCreateTime(Instant replicationConfigCreateTime) {
            this.replicationConfigCreateTime = replicationConfigCreateTime;
            return this;
        }

        public final Instant getReplicationConfigUpdateTime() {
            return this.replicationConfigUpdateTime;
        }

        public final void setReplicationConfigUpdateTime(Instant replicationConfigUpdateTime) {
            this.replicationConfigUpdateTime = replicationConfigUpdateTime;
        }

        @Override
        public final Builder replicationConfigUpdateTime(Instant replicationConfigUpdateTime) {
            this.replicationConfigUpdateTime = replicationConfigUpdateTime;
            return this;
        }

        public ReplicationConfig build() {
            return new ReplicationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationConfig> {
        public Builder replicationConfigIdentifier(String var1);

        public Builder replicationConfigArn(String var1);

        public Builder sourceEndpointArn(String var1);

        public Builder targetEndpointArn(String var1);

        public Builder replicationType(String var1);

        public Builder replicationType(MigrationTypeValue var1);

        public Builder computeConfig(ComputeConfig var1);

        default public Builder computeConfig(Consumer<ComputeConfig.Builder> computeConfig) {
            return this.computeConfig((ComputeConfig)((ComputeConfig.Builder)ComputeConfig.builder().applyMutation(computeConfig)).build());
        }

        public Builder replicationSettings(String var1);

        public Builder supplementalSettings(String var1);

        public Builder tableMappings(String var1);

        public Builder replicationConfigCreateTime(Instant var1);

        public Builder replicationConfigUpdateTime(Instant var1);
    }
}

