/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.DataProviderSettings;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyDataProviderRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, ModifyDataProviderRequest> {
    private static final SdkField<String> DATA_PROVIDER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataProviderIdentifier").getter(ModifyDataProviderRequest.getter(ModifyDataProviderRequest::dataProviderIdentifier)).setter(ModifyDataProviderRequest.setter(Builder::dataProviderIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProviderIdentifier").build()}).build();
    private static final SdkField<String> DATA_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataProviderName").getter(ModifyDataProviderRequest.getter(ModifyDataProviderRequest::dataProviderName)).setter(ModifyDataProviderRequest.setter(Builder::dataProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProviderName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ModifyDataProviderRequest.getter(ModifyDataProviderRequest::description)).setter(ModifyDataProviderRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(ModifyDataProviderRequest.getter(ModifyDataProviderRequest::engine)).setter(ModifyDataProviderRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<Boolean> EXACT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExactSettings").getter(ModifyDataProviderRequest.getter(ModifyDataProviderRequest::exactSettings)).setter(ModifyDataProviderRequest.setter(Builder::exactSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExactSettings").build()}).build();
    private static final SdkField<DataProviderSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(ModifyDataProviderRequest.getter(ModifyDataProviderRequest::settings)).setter(ModifyDataProviderRequest.setter(Builder::settings)).constructor(DataProviderSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_PROVIDER_IDENTIFIER_FIELD, DATA_PROVIDER_NAME_FIELD, DESCRIPTION_FIELD, ENGINE_FIELD, EXACT_SETTINGS_FIELD, SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DataProviderIdentifier", DATA_PROVIDER_IDENTIFIER_FIELD);
            this.put("DataProviderName", DATA_PROVIDER_NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Engine", ENGINE_FIELD);
            this.put("ExactSettings", EXACT_SETTINGS_FIELD);
            this.put("Settings", SETTINGS_FIELD);
        }
    });
    private final String dataProviderIdentifier;
    private final String dataProviderName;
    private final String description;
    private final String engine;
    private final Boolean exactSettings;
    private final DataProviderSettings settings;

    private ModifyDataProviderRequest(BuilderImpl builder) {
        super(builder);
        this.dataProviderIdentifier = builder.dataProviderIdentifier;
        this.dataProviderName = builder.dataProviderName;
        this.description = builder.description;
        this.engine = builder.engine;
        this.exactSettings = builder.exactSettings;
        this.settings = builder.settings;
    }

    public final String dataProviderIdentifier() {
        return this.dataProviderIdentifier;
    }

    public final String dataProviderName() {
        return this.dataProviderName;
    }

    public final String description() {
        return this.description;
    }

    public final String engine() {
        return this.engine;
    }

    public final Boolean exactSettings() {
        return this.exactSettings;
    }

    public final DataProviderSettings settings() {
        return this.settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProviderIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.exactSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDataProviderRequest)) {
            return false;
        }
        ModifyDataProviderRequest other = (ModifyDataProviderRequest)((Object)obj);
        return Objects.equals(this.dataProviderIdentifier(), other.dataProviderIdentifier()) && Objects.equals(this.dataProviderName(), other.dataProviderName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.exactSettings(), other.exactSettings()) && Objects.equals(this.settings(), other.settings());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyDataProviderRequest").add("DataProviderIdentifier", (Object)this.dataProviderIdentifier()).add("DataProviderName", (Object)this.dataProviderName()).add("Description", (Object)this.description()).add("Engine", (Object)this.engine()).add("ExactSettings", (Object)this.exactSettings()).add("Settings", (Object)this.settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataProviderIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dataProviderIdentifier()));
            }
            case "DataProviderName": {
                return Optional.ofNullable(clazz.cast(this.dataProviderName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "ExactSettings": {
                return Optional.ofNullable(clazz.cast(this.exactSettings()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDataProviderRequest, T> g) {
        return obj -> g.apply((ModifyDataProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String dataProviderIdentifier;
        private String dataProviderName;
        private String description;
        private String engine;
        private Boolean exactSettings;
        private DataProviderSettings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDataProviderRequest model) {
            super(model);
            this.dataProviderIdentifier(model.dataProviderIdentifier);
            this.dataProviderName(model.dataProviderName);
            this.description(model.description);
            this.engine(model.engine);
            this.exactSettings(model.exactSettings);
            this.settings(model.settings);
        }

        public final String getDataProviderIdentifier() {
            return this.dataProviderIdentifier;
        }

        public final void setDataProviderIdentifier(String dataProviderIdentifier) {
            this.dataProviderIdentifier = dataProviderIdentifier;
        }

        @Override
        public final Builder dataProviderIdentifier(String dataProviderIdentifier) {
            this.dataProviderIdentifier = dataProviderIdentifier;
            return this;
        }

        public final String getDataProviderName() {
            return this.dataProviderName;
        }

        public final void setDataProviderName(String dataProviderName) {
            this.dataProviderName = dataProviderName;
        }

        @Override
        public final Builder dataProviderName(String dataProviderName) {
            this.dataProviderName = dataProviderName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final Boolean getExactSettings() {
            return this.exactSettings;
        }

        public final void setExactSettings(Boolean exactSettings) {
            this.exactSettings = exactSettings;
        }

        @Override
        public final Builder exactSettings(Boolean exactSettings) {
            this.exactSettings = exactSettings;
            return this;
        }

        public final DataProviderSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        public final void setSettings(DataProviderSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(DataProviderSettings settings) {
            this.settings = settings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDataProviderRequest build() {
            return new ModifyDataProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyDataProviderRequest> {
        public Builder dataProviderIdentifier(String var1);

        public Builder dataProviderName(String var1);

        public Builder description(String var1);

        public Builder engine(String var1);

        public Builder exactSettings(Boolean var1);

        public Builder settings(DataProviderSettings var1);

        default public Builder settings(Consumer<DataProviderSettings.Builder> settings) {
            return this.settings((DataProviderSettings)((DataProviderSettings.Builder)DataProviderSettings.builder().applyMutation(settings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

