/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.ExcludeTestListCopier;
import software.amazon.awssdk.services.databasemigration.model.IncludeTestListCopier;
import software.amazon.awssdk.services.databasemigration.model.Tag;
import software.amazon.awssdk.services.databasemigration.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartReplicationTaskAssessmentRunRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, StartReplicationTaskAssessmentRunRequest> {
    private static final SdkField<String> REPLICATION_TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationTaskArn").getter(StartReplicationTaskAssessmentRunRequest.getter(StartReplicationTaskAssessmentRunRequest::replicationTaskArn)).setter(StartReplicationTaskAssessmentRunRequest.setter(Builder::replicationTaskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskArn").build()}).build();
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceAccessRoleArn").getter(StartReplicationTaskAssessmentRunRequest.getter(StartReplicationTaskAssessmentRunRequest::serviceAccessRoleArn)).setter(StartReplicationTaskAssessmentRunRequest.setter(Builder::serviceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build()}).build();
    private static final SdkField<String> RESULT_LOCATION_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultLocationBucket").getter(StartReplicationTaskAssessmentRunRequest.getter(StartReplicationTaskAssessmentRunRequest::resultLocationBucket)).setter(StartReplicationTaskAssessmentRunRequest.setter(Builder::resultLocationBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultLocationBucket").build()}).build();
    private static final SdkField<String> RESULT_LOCATION_FOLDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultLocationFolder").getter(StartReplicationTaskAssessmentRunRequest.getter(StartReplicationTaskAssessmentRunRequest::resultLocationFolder)).setter(StartReplicationTaskAssessmentRunRequest.setter(Builder::resultLocationFolder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultLocationFolder").build()}).build();
    private static final SdkField<String> RESULT_ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultEncryptionMode").getter(StartReplicationTaskAssessmentRunRequest.getter(StartReplicationTaskAssessmentRunRequest::resultEncryptionMode)).setter(StartReplicationTaskAssessmentRunRequest.setter(Builder::resultEncryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultEncryptionMode").build()}).build();
    private static final SdkField<String> RESULT_KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultKmsKeyArn").getter(StartReplicationTaskAssessmentRunRequest.getter(StartReplicationTaskAssessmentRunRequest::resultKmsKeyArn)).setter(StartReplicationTaskAssessmentRunRequest.setter(Builder::resultKmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultKmsKeyArn").build()}).build();
    private static final SdkField<String> ASSESSMENT_RUN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssessmentRunName").getter(StartReplicationTaskAssessmentRunRequest.getter(StartReplicationTaskAssessmentRunRequest::assessmentRunName)).setter(StartReplicationTaskAssessmentRunRequest.setter(Builder::assessmentRunName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentRunName").build()}).build();
    private static final SdkField<List<String>> INCLUDE_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludeOnly").getter(StartReplicationTaskAssessmentRunRequest.getter(StartReplicationTaskAssessmentRunRequest::includeOnly)).setter(StartReplicationTaskAssessmentRunRequest.setter(Builder::includeOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeOnly").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Exclude").getter(StartReplicationTaskAssessmentRunRequest.getter(StartReplicationTaskAssessmentRunRequest::exclude)).setter(StartReplicationTaskAssessmentRunRequest.setter(Builder::exclude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclude").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(StartReplicationTaskAssessmentRunRequest.getter(StartReplicationTaskAssessmentRunRequest::tags)).setter(StartReplicationTaskAssessmentRunRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_TASK_ARN_FIELD, SERVICE_ACCESS_ROLE_ARN_FIELD, RESULT_LOCATION_BUCKET_FIELD, RESULT_LOCATION_FOLDER_FIELD, RESULT_ENCRYPTION_MODE_FIELD, RESULT_KMS_KEY_ARN_FIELD, ASSESSMENT_RUN_NAME_FIELD, INCLUDE_ONLY_FIELD, EXCLUDE_FIELD, TAGS_FIELD));
    private final String replicationTaskArn;
    private final String serviceAccessRoleArn;
    private final String resultLocationBucket;
    private final String resultLocationFolder;
    private final String resultEncryptionMode;
    private final String resultKmsKeyArn;
    private final String assessmentRunName;
    private final List<String> includeOnly;
    private final List<String> exclude;
    private final List<Tag> tags;

    private StartReplicationTaskAssessmentRunRequest(BuilderImpl builder) {
        super(builder);
        this.replicationTaskArn = builder.replicationTaskArn;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.resultLocationBucket = builder.resultLocationBucket;
        this.resultLocationFolder = builder.resultLocationFolder;
        this.resultEncryptionMode = builder.resultEncryptionMode;
        this.resultKmsKeyArn = builder.resultKmsKeyArn;
        this.assessmentRunName = builder.assessmentRunName;
        this.includeOnly = builder.includeOnly;
        this.exclude = builder.exclude;
        this.tags = builder.tags;
    }

    public final String replicationTaskArn() {
        return this.replicationTaskArn;
    }

    public final String serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    public final String resultLocationBucket() {
        return this.resultLocationBucket;
    }

    public final String resultLocationFolder() {
        return this.resultLocationFolder;
    }

    public final String resultEncryptionMode() {
        return this.resultEncryptionMode;
    }

    public final String resultKmsKeyArn() {
        return this.resultKmsKeyArn;
    }

    public final String assessmentRunName() {
        return this.assessmentRunName;
    }

    public final boolean hasIncludeOnly() {
        return this.includeOnly != null && !(this.includeOnly instanceof SdkAutoConstructList);
    }

    public final List<String> includeOnly() {
        return this.includeOnly;
    }

    public final boolean hasExclude() {
        return this.exclude != null && !(this.exclude instanceof SdkAutoConstructList);
    }

    public final List<String> exclude() {
        return this.exclude;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultLocationBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultLocationFolder());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultEncryptionMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultKmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentRunName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeOnly() ? this.includeOnly() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclude() ? this.exclude() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartReplicationTaskAssessmentRunRequest)) {
            return false;
        }
        StartReplicationTaskAssessmentRunRequest other = (StartReplicationTaskAssessmentRunRequest)((Object)obj);
        return Objects.equals(this.replicationTaskArn(), other.replicationTaskArn()) && Objects.equals(this.serviceAccessRoleArn(), other.serviceAccessRoleArn()) && Objects.equals(this.resultLocationBucket(), other.resultLocationBucket()) && Objects.equals(this.resultLocationFolder(), other.resultLocationFolder()) && Objects.equals(this.resultEncryptionMode(), other.resultEncryptionMode()) && Objects.equals(this.resultKmsKeyArn(), other.resultKmsKeyArn()) && Objects.equals(this.assessmentRunName(), other.assessmentRunName()) && this.hasIncludeOnly() == other.hasIncludeOnly() && Objects.equals(this.includeOnly(), other.includeOnly()) && this.hasExclude() == other.hasExclude() && Objects.equals(this.exclude(), other.exclude()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StartReplicationTaskAssessmentRunRequest").add("ReplicationTaskArn", (Object)this.replicationTaskArn()).add("ServiceAccessRoleArn", (Object)this.serviceAccessRoleArn()).add("ResultLocationBucket", (Object)this.resultLocationBucket()).add("ResultLocationFolder", (Object)this.resultLocationFolder()).add("ResultEncryptionMode", (Object)this.resultEncryptionMode()).add("ResultKmsKeyArn", (Object)this.resultKmsKeyArn()).add("AssessmentRunName", (Object)this.assessmentRunName()).add("IncludeOnly", this.hasIncludeOnly() ? this.includeOnly() : null).add("Exclude", this.hasExclude() ? this.exclude() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationTaskArn": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskArn()));
            }
            case "ServiceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessRoleArn()));
            }
            case "ResultLocationBucket": {
                return Optional.ofNullable(clazz.cast(this.resultLocationBucket()));
            }
            case "ResultLocationFolder": {
                return Optional.ofNullable(clazz.cast(this.resultLocationFolder()));
            }
            case "ResultEncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.resultEncryptionMode()));
            }
            case "ResultKmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.resultKmsKeyArn()));
            }
            case "AssessmentRunName": {
                return Optional.ofNullable(clazz.cast(this.assessmentRunName()));
            }
            case "IncludeOnly": {
                return Optional.ofNullable(clazz.cast(this.includeOnly()));
            }
            case "Exclude": {
                return Optional.ofNullable(clazz.cast(this.exclude()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartReplicationTaskAssessmentRunRequest, T> g) {
        return obj -> g.apply((StartReplicationTaskAssessmentRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String replicationTaskArn;
        private String serviceAccessRoleArn;
        private String resultLocationBucket;
        private String resultLocationFolder;
        private String resultEncryptionMode;
        private String resultKmsKeyArn;
        private String assessmentRunName;
        private List<String> includeOnly = DefaultSdkAutoConstructList.getInstance();
        private List<String> exclude = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartReplicationTaskAssessmentRunRequest model) {
            super(model);
            this.replicationTaskArn(model.replicationTaskArn);
            this.serviceAccessRoleArn(model.serviceAccessRoleArn);
            this.resultLocationBucket(model.resultLocationBucket);
            this.resultLocationFolder(model.resultLocationFolder);
            this.resultEncryptionMode(model.resultEncryptionMode);
            this.resultKmsKeyArn(model.resultKmsKeyArn);
            this.assessmentRunName(model.assessmentRunName);
            this.includeOnly(model.includeOnly);
            this.exclude(model.exclude);
            this.tags(model.tags);
        }

        public final String getReplicationTaskArn() {
            return this.replicationTaskArn;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        @Override
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final String getServiceAccessRoleArn() {
            return this.serviceAccessRoleArn;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final String getResultLocationBucket() {
            return this.resultLocationBucket;
        }

        public final void setResultLocationBucket(String resultLocationBucket) {
            this.resultLocationBucket = resultLocationBucket;
        }

        @Override
        public final Builder resultLocationBucket(String resultLocationBucket) {
            this.resultLocationBucket = resultLocationBucket;
            return this;
        }

        public final String getResultLocationFolder() {
            return this.resultLocationFolder;
        }

        public final void setResultLocationFolder(String resultLocationFolder) {
            this.resultLocationFolder = resultLocationFolder;
        }

        @Override
        public final Builder resultLocationFolder(String resultLocationFolder) {
            this.resultLocationFolder = resultLocationFolder;
            return this;
        }

        public final String getResultEncryptionMode() {
            return this.resultEncryptionMode;
        }

        public final void setResultEncryptionMode(String resultEncryptionMode) {
            this.resultEncryptionMode = resultEncryptionMode;
        }

        @Override
        public final Builder resultEncryptionMode(String resultEncryptionMode) {
            this.resultEncryptionMode = resultEncryptionMode;
            return this;
        }

        public final String getResultKmsKeyArn() {
            return this.resultKmsKeyArn;
        }

        public final void setResultKmsKeyArn(String resultKmsKeyArn) {
            this.resultKmsKeyArn = resultKmsKeyArn;
        }

        @Override
        public final Builder resultKmsKeyArn(String resultKmsKeyArn) {
            this.resultKmsKeyArn = resultKmsKeyArn;
            return this;
        }

        public final String getAssessmentRunName() {
            return this.assessmentRunName;
        }

        public final void setAssessmentRunName(String assessmentRunName) {
            this.assessmentRunName = assessmentRunName;
        }

        @Override
        public final Builder assessmentRunName(String assessmentRunName) {
            this.assessmentRunName = assessmentRunName;
            return this;
        }

        public final Collection<String> getIncludeOnly() {
            if (this.includeOnly instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includeOnly;
        }

        public final void setIncludeOnly(Collection<String> includeOnly) {
            this.includeOnly = IncludeTestListCopier.copy(includeOnly);
        }

        @Override
        public final Builder includeOnly(Collection<String> includeOnly) {
            this.includeOnly = IncludeTestListCopier.copy(includeOnly);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeOnly(String ... includeOnly) {
            this.includeOnly(Arrays.asList(includeOnly));
            return this;
        }

        public final Collection<String> getExclude() {
            if (this.exclude instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclude;
        }

        public final void setExclude(Collection<String> exclude) {
            this.exclude = ExcludeTestListCopier.copy(exclude);
        }

        @Override
        public final Builder exclude(Collection<String> exclude) {
            this.exclude = ExcludeTestListCopier.copy(exclude);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclude(String ... exclude) {
            this.exclude(Arrays.asList(exclude));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartReplicationTaskAssessmentRunRequest build() {
            return new StartReplicationTaskAssessmentRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartReplicationTaskAssessmentRunRequest> {
        public Builder replicationTaskArn(String var1);

        public Builder serviceAccessRoleArn(String var1);

        public Builder resultLocationBucket(String var1);

        public Builder resultLocationFolder(String var1);

        public Builder resultEncryptionMode(String var1);

        public Builder resultKmsKeyArn(String var1);

        public Builder assessmentRunName(String var1);

        public Builder includeOnly(Collection<String> var1);

        public Builder includeOnly(String ... var1);

        public Builder exclude(Collection<String> var1);

        public Builder exclude(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

