/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DataMigrationSettings;
import software.amazon.awssdk.services.databasemigration.model.DataMigrationStatistics;
import software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue;
import software.amazon.awssdk.services.databasemigration.model.PublicIpAddressListCopier;
import software.amazon.awssdk.services.databasemigration.model.SourceDataSetting;
import software.amazon.awssdk.services.databasemigration.model.SourceDataSettingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataMigration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataMigration> {
    private static final SdkField<String> DATA_MIGRATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataMigrationName").getter(DataMigration.getter(DataMigration::dataMigrationName)).setter(DataMigration.setter(Builder::dataMigrationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationName").build()}).build();
    private static final SdkField<String> DATA_MIGRATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataMigrationArn").getter(DataMigration.getter(DataMigration::dataMigrationArn)).setter(DataMigration.setter(Builder::dataMigrationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationArn").build()}).build();
    private static final SdkField<Instant> DATA_MIGRATION_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DataMigrationCreateTime").getter(DataMigration.getter(DataMigration::dataMigrationCreateTime)).setter(DataMigration.setter(Builder::dataMigrationCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationCreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> DATA_MIGRATION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DataMigrationStartTime").getter(DataMigration.getter(DataMigration::dataMigrationStartTime)).setter(DataMigration.setter(Builder::dataMigrationStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationStartTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> DATA_MIGRATION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DataMigrationEndTime").getter(DataMigration.getter(DataMigration::dataMigrationEndTime)).setter(DataMigration.setter(Builder::dataMigrationEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationEndTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceAccessRoleArn").getter(DataMigration.getter(DataMigration::serviceAccessRoleArn)).setter(DataMigration.setter(Builder::serviceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build()}).build();
    private static final SdkField<String> MIGRATION_PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MigrationProjectArn").getter(DataMigration.getter(DataMigration::migrationProjectArn)).setter(DataMigration.setter(Builder::migrationProjectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProjectArn").build()}).build();
    private static final SdkField<String> DATA_MIGRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataMigrationType").getter(DataMigration.getter(DataMigration::dataMigrationTypeAsString)).setter(DataMigration.setter(Builder::dataMigrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationType").build()}).build();
    private static final SdkField<DataMigrationSettings> DATA_MIGRATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataMigrationSettings").getter(DataMigration.getter(DataMigration::dataMigrationSettings)).setter(DataMigration.setter(Builder::dataMigrationSettings)).constructor(DataMigrationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationSettings").build()}).build();
    private static final SdkField<List<SourceDataSetting>> SOURCE_DATA_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceDataSettings").getter(DataMigration.getter(DataMigration::sourceDataSettings)).setter(DataMigration.setter(Builder::sourceDataSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDataSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceDataSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataMigrationStatistics> DATA_MIGRATION_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataMigrationStatistics").getter(DataMigration.getter(DataMigration::dataMigrationStatistics)).setter(DataMigration.setter(Builder::dataMigrationStatistics)).constructor(DataMigrationStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationStatistics").build()}).build();
    private static final SdkField<String> DATA_MIGRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataMigrationStatus").getter(DataMigration.getter(DataMigration::dataMigrationStatus)).setter(DataMigration.setter(Builder::dataMigrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationStatus").build()}).build();
    private static final SdkField<List<String>> PUBLIC_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PublicIpAddresses").getter(DataMigration.getter(DataMigration::publicIpAddresses)).setter(DataMigration.setter(Builder::publicIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAST_FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastFailureMessage").getter(DataMigration.getter(DataMigration::lastFailureMessage)).setter(DataMigration.setter(Builder::lastFailureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailureMessage").build()}).build();
    private static final SdkField<String> STOP_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StopReason").getter(DataMigration.getter(DataMigration::stopReason)).setter(DataMigration.setter(Builder::stopReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_MIGRATION_NAME_FIELD, DATA_MIGRATION_ARN_FIELD, DATA_MIGRATION_CREATE_TIME_FIELD, DATA_MIGRATION_START_TIME_FIELD, DATA_MIGRATION_END_TIME_FIELD, SERVICE_ACCESS_ROLE_ARN_FIELD, MIGRATION_PROJECT_ARN_FIELD, DATA_MIGRATION_TYPE_FIELD, DATA_MIGRATION_SETTINGS_FIELD, SOURCE_DATA_SETTINGS_FIELD, DATA_MIGRATION_STATISTICS_FIELD, DATA_MIGRATION_STATUS_FIELD, PUBLIC_IP_ADDRESSES_FIELD, LAST_FAILURE_MESSAGE_FIELD, STOP_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataMigrationName;
    private final String dataMigrationArn;
    private final Instant dataMigrationCreateTime;
    private final Instant dataMigrationStartTime;
    private final Instant dataMigrationEndTime;
    private final String serviceAccessRoleArn;
    private final String migrationProjectArn;
    private final String dataMigrationType;
    private final DataMigrationSettings dataMigrationSettings;
    private final List<SourceDataSetting> sourceDataSettings;
    private final DataMigrationStatistics dataMigrationStatistics;
    private final String dataMigrationStatus;
    private final List<String> publicIpAddresses;
    private final String lastFailureMessage;
    private final String stopReason;

    private DataMigration(BuilderImpl builder) {
        this.dataMigrationName = builder.dataMigrationName;
        this.dataMigrationArn = builder.dataMigrationArn;
        this.dataMigrationCreateTime = builder.dataMigrationCreateTime;
        this.dataMigrationStartTime = builder.dataMigrationStartTime;
        this.dataMigrationEndTime = builder.dataMigrationEndTime;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.migrationProjectArn = builder.migrationProjectArn;
        this.dataMigrationType = builder.dataMigrationType;
        this.dataMigrationSettings = builder.dataMigrationSettings;
        this.sourceDataSettings = builder.sourceDataSettings;
        this.dataMigrationStatistics = builder.dataMigrationStatistics;
        this.dataMigrationStatus = builder.dataMigrationStatus;
        this.publicIpAddresses = builder.publicIpAddresses;
        this.lastFailureMessage = builder.lastFailureMessage;
        this.stopReason = builder.stopReason;
    }

    public final String dataMigrationName() {
        return this.dataMigrationName;
    }

    public final String dataMigrationArn() {
        return this.dataMigrationArn;
    }

    public final Instant dataMigrationCreateTime() {
        return this.dataMigrationCreateTime;
    }

    public final Instant dataMigrationStartTime() {
        return this.dataMigrationStartTime;
    }

    public final Instant dataMigrationEndTime() {
        return this.dataMigrationEndTime;
    }

    public final String serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    public final String migrationProjectArn() {
        return this.migrationProjectArn;
    }

    public final MigrationTypeValue dataMigrationType() {
        return MigrationTypeValue.fromValue(this.dataMigrationType);
    }

    public final String dataMigrationTypeAsString() {
        return this.dataMigrationType;
    }

    public final DataMigrationSettings dataMigrationSettings() {
        return this.dataMigrationSettings;
    }

    public final boolean hasSourceDataSettings() {
        return this.sourceDataSettings != null && !(this.sourceDataSettings instanceof SdkAutoConstructList);
    }

    public final List<SourceDataSetting> sourceDataSettings() {
        return this.sourceDataSettings;
    }

    public final DataMigrationStatistics dataMigrationStatistics() {
        return this.dataMigrationStatistics;
    }

    public final String dataMigrationStatus() {
        return this.dataMigrationStatus;
    }

    public final boolean hasPublicIpAddresses() {
        return this.publicIpAddresses != null && !(this.publicIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> publicIpAddresses() {
        return this.publicIpAddresses;
    }

    public final String lastFailureMessage() {
        return this.lastFailureMessage;
    }

    public final String stopReason() {
        return this.stopReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataMigrationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataMigrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataMigrationCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataMigrationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataMigrationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationProjectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataMigrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataMigrationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceDataSettings() ? this.sourceDataSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataMigrationStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataMigrationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPublicIpAddresses() ? this.publicIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastFailureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataMigration)) {
            return false;
        }
        DataMigration other = (DataMigration)obj;
        return Objects.equals(this.dataMigrationName(), other.dataMigrationName()) && Objects.equals(this.dataMigrationArn(), other.dataMigrationArn()) && Objects.equals(this.dataMigrationCreateTime(), other.dataMigrationCreateTime()) && Objects.equals(this.dataMigrationStartTime(), other.dataMigrationStartTime()) && Objects.equals(this.dataMigrationEndTime(), other.dataMigrationEndTime()) && Objects.equals(this.serviceAccessRoleArn(), other.serviceAccessRoleArn()) && Objects.equals(this.migrationProjectArn(), other.migrationProjectArn()) && Objects.equals(this.dataMigrationTypeAsString(), other.dataMigrationTypeAsString()) && Objects.equals(this.dataMigrationSettings(), other.dataMigrationSettings()) && this.hasSourceDataSettings() == other.hasSourceDataSettings() && Objects.equals(this.sourceDataSettings(), other.sourceDataSettings()) && Objects.equals(this.dataMigrationStatistics(), other.dataMigrationStatistics()) && Objects.equals(this.dataMigrationStatus(), other.dataMigrationStatus()) && this.hasPublicIpAddresses() == other.hasPublicIpAddresses() && Objects.equals(this.publicIpAddresses(), other.publicIpAddresses()) && Objects.equals(this.lastFailureMessage(), other.lastFailureMessage()) && Objects.equals(this.stopReason(), other.stopReason());
    }

    public final String toString() {
        return ToString.builder((String)"DataMigration").add("DataMigrationName", (Object)this.dataMigrationName()).add("DataMigrationArn", (Object)this.dataMigrationArn()).add("DataMigrationCreateTime", (Object)this.dataMigrationCreateTime()).add("DataMigrationStartTime", (Object)this.dataMigrationStartTime()).add("DataMigrationEndTime", (Object)this.dataMigrationEndTime()).add("ServiceAccessRoleArn", (Object)this.serviceAccessRoleArn()).add("MigrationProjectArn", (Object)this.migrationProjectArn()).add("DataMigrationType", (Object)this.dataMigrationTypeAsString()).add("DataMigrationSettings", (Object)this.dataMigrationSettings()).add("SourceDataSettings", this.hasSourceDataSettings() ? this.sourceDataSettings() : null).add("DataMigrationStatistics", (Object)this.dataMigrationStatistics()).add("DataMigrationStatus", (Object)this.dataMigrationStatus()).add("PublicIpAddresses", (Object)(this.publicIpAddresses() == null ? null : "*** Sensitive Data Redacted ***")).add("LastFailureMessage", (Object)this.lastFailureMessage()).add("StopReason", (Object)this.stopReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataMigrationName": {
                return Optional.ofNullable(clazz.cast(this.dataMigrationName()));
            }
            case "DataMigrationArn": {
                return Optional.ofNullable(clazz.cast(this.dataMigrationArn()));
            }
            case "DataMigrationCreateTime": {
                return Optional.ofNullable(clazz.cast(this.dataMigrationCreateTime()));
            }
            case "DataMigrationStartTime": {
                return Optional.ofNullable(clazz.cast(this.dataMigrationStartTime()));
            }
            case "DataMigrationEndTime": {
                return Optional.ofNullable(clazz.cast(this.dataMigrationEndTime()));
            }
            case "ServiceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessRoleArn()));
            }
            case "MigrationProjectArn": {
                return Optional.ofNullable(clazz.cast(this.migrationProjectArn()));
            }
            case "DataMigrationType": {
                return Optional.ofNullable(clazz.cast(this.dataMigrationTypeAsString()));
            }
            case "DataMigrationSettings": {
                return Optional.ofNullable(clazz.cast(this.dataMigrationSettings()));
            }
            case "SourceDataSettings": {
                return Optional.ofNullable(clazz.cast(this.sourceDataSettings()));
            }
            case "DataMigrationStatistics": {
                return Optional.ofNullable(clazz.cast(this.dataMigrationStatistics()));
            }
            case "DataMigrationStatus": {
                return Optional.ofNullable(clazz.cast(this.dataMigrationStatus()));
            }
            case "PublicIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.publicIpAddresses()));
            }
            case "LastFailureMessage": {
                return Optional.ofNullable(clazz.cast(this.lastFailureMessage()));
            }
            case "StopReason": {
                return Optional.ofNullable(clazz.cast(this.stopReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataMigration, T> g) {
        return obj -> g.apply((DataMigration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataMigrationName;
        private String dataMigrationArn;
        private Instant dataMigrationCreateTime;
        private Instant dataMigrationStartTime;
        private Instant dataMigrationEndTime;
        private String serviceAccessRoleArn;
        private String migrationProjectArn;
        private String dataMigrationType;
        private DataMigrationSettings dataMigrationSettings;
        private List<SourceDataSetting> sourceDataSettings = DefaultSdkAutoConstructList.getInstance();
        private DataMigrationStatistics dataMigrationStatistics;
        private String dataMigrationStatus;
        private List<String> publicIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private String lastFailureMessage;
        private String stopReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DataMigration model) {
            this.dataMigrationName(model.dataMigrationName);
            this.dataMigrationArn(model.dataMigrationArn);
            this.dataMigrationCreateTime(model.dataMigrationCreateTime);
            this.dataMigrationStartTime(model.dataMigrationStartTime);
            this.dataMigrationEndTime(model.dataMigrationEndTime);
            this.serviceAccessRoleArn(model.serviceAccessRoleArn);
            this.migrationProjectArn(model.migrationProjectArn);
            this.dataMigrationType(model.dataMigrationType);
            this.dataMigrationSettings(model.dataMigrationSettings);
            this.sourceDataSettings(model.sourceDataSettings);
            this.dataMigrationStatistics(model.dataMigrationStatistics);
            this.dataMigrationStatus(model.dataMigrationStatus);
            this.publicIpAddresses(model.publicIpAddresses);
            this.lastFailureMessage(model.lastFailureMessage);
            this.stopReason(model.stopReason);
        }

        public final String getDataMigrationName() {
            return this.dataMigrationName;
        }

        public final void setDataMigrationName(String dataMigrationName) {
            this.dataMigrationName = dataMigrationName;
        }

        @Override
        public final Builder dataMigrationName(String dataMigrationName) {
            this.dataMigrationName = dataMigrationName;
            return this;
        }

        public final String getDataMigrationArn() {
            return this.dataMigrationArn;
        }

        public final void setDataMigrationArn(String dataMigrationArn) {
            this.dataMigrationArn = dataMigrationArn;
        }

        @Override
        public final Builder dataMigrationArn(String dataMigrationArn) {
            this.dataMigrationArn = dataMigrationArn;
            return this;
        }

        public final Instant getDataMigrationCreateTime() {
            return this.dataMigrationCreateTime;
        }

        public final void setDataMigrationCreateTime(Instant dataMigrationCreateTime) {
            this.dataMigrationCreateTime = dataMigrationCreateTime;
        }

        @Override
        public final Builder dataMigrationCreateTime(Instant dataMigrationCreateTime) {
            this.dataMigrationCreateTime = dataMigrationCreateTime;
            return this;
        }

        public final Instant getDataMigrationStartTime() {
            return this.dataMigrationStartTime;
        }

        public final void setDataMigrationStartTime(Instant dataMigrationStartTime) {
            this.dataMigrationStartTime = dataMigrationStartTime;
        }

        @Override
        public final Builder dataMigrationStartTime(Instant dataMigrationStartTime) {
            this.dataMigrationStartTime = dataMigrationStartTime;
            return this;
        }

        public final Instant getDataMigrationEndTime() {
            return this.dataMigrationEndTime;
        }

        public final void setDataMigrationEndTime(Instant dataMigrationEndTime) {
            this.dataMigrationEndTime = dataMigrationEndTime;
        }

        @Override
        public final Builder dataMigrationEndTime(Instant dataMigrationEndTime) {
            this.dataMigrationEndTime = dataMigrationEndTime;
            return this;
        }

        public final String getServiceAccessRoleArn() {
            return this.serviceAccessRoleArn;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final String getMigrationProjectArn() {
            return this.migrationProjectArn;
        }

        public final void setMigrationProjectArn(String migrationProjectArn) {
            this.migrationProjectArn = migrationProjectArn;
        }

        @Override
        public final Builder migrationProjectArn(String migrationProjectArn) {
            this.migrationProjectArn = migrationProjectArn;
            return this;
        }

        public final String getDataMigrationType() {
            return this.dataMigrationType;
        }

        public final void setDataMigrationType(String dataMigrationType) {
            this.dataMigrationType = dataMigrationType;
        }

        @Override
        public final Builder dataMigrationType(String dataMigrationType) {
            this.dataMigrationType = dataMigrationType;
            return this;
        }

        @Override
        public final Builder dataMigrationType(MigrationTypeValue dataMigrationType) {
            this.dataMigrationType(dataMigrationType == null ? null : dataMigrationType.toString());
            return this;
        }

        public final DataMigrationSettings.Builder getDataMigrationSettings() {
            return this.dataMigrationSettings != null ? this.dataMigrationSettings.toBuilder() : null;
        }

        public final void setDataMigrationSettings(DataMigrationSettings.BuilderImpl dataMigrationSettings) {
            this.dataMigrationSettings = dataMigrationSettings != null ? dataMigrationSettings.build() : null;
        }

        @Override
        public final Builder dataMigrationSettings(DataMigrationSettings dataMigrationSettings) {
            this.dataMigrationSettings = dataMigrationSettings;
            return this;
        }

        public final List<SourceDataSetting.Builder> getSourceDataSettings() {
            List<SourceDataSetting.Builder> result = SourceDataSettingsCopier.copyToBuilder(this.sourceDataSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceDataSettings(Collection<SourceDataSetting.BuilderImpl> sourceDataSettings) {
            this.sourceDataSettings = SourceDataSettingsCopier.copyFromBuilder(sourceDataSettings);
        }

        @Override
        public final Builder sourceDataSettings(Collection<SourceDataSetting> sourceDataSettings) {
            this.sourceDataSettings = SourceDataSettingsCopier.copy(sourceDataSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDataSettings(SourceDataSetting ... sourceDataSettings) {
            this.sourceDataSettings(Arrays.asList(sourceDataSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDataSettings(Consumer<SourceDataSetting.Builder> ... sourceDataSettings) {
            this.sourceDataSettings(Stream.of(sourceDataSettings).map(c -> (SourceDataSetting)((SourceDataSetting.Builder)SourceDataSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataMigrationStatistics.Builder getDataMigrationStatistics() {
            return this.dataMigrationStatistics != null ? this.dataMigrationStatistics.toBuilder() : null;
        }

        public final void setDataMigrationStatistics(DataMigrationStatistics.BuilderImpl dataMigrationStatistics) {
            this.dataMigrationStatistics = dataMigrationStatistics != null ? dataMigrationStatistics.build() : null;
        }

        @Override
        public final Builder dataMigrationStatistics(DataMigrationStatistics dataMigrationStatistics) {
            this.dataMigrationStatistics = dataMigrationStatistics;
            return this;
        }

        public final String getDataMigrationStatus() {
            return this.dataMigrationStatus;
        }

        public final void setDataMigrationStatus(String dataMigrationStatus) {
            this.dataMigrationStatus = dataMigrationStatus;
        }

        @Override
        public final Builder dataMigrationStatus(String dataMigrationStatus) {
            this.dataMigrationStatus = dataMigrationStatus;
            return this;
        }

        public final Collection<String> getPublicIpAddresses() {
            if (this.publicIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.publicIpAddresses;
        }

        public final void setPublicIpAddresses(Collection<String> publicIpAddresses) {
            this.publicIpAddresses = PublicIpAddressListCopier.copy(publicIpAddresses);
        }

        @Override
        public final Builder publicIpAddresses(Collection<String> publicIpAddresses) {
            this.publicIpAddresses = PublicIpAddressListCopier.copy(publicIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicIpAddresses(String ... publicIpAddresses) {
            this.publicIpAddresses(Arrays.asList(publicIpAddresses));
            return this;
        }

        public final String getLastFailureMessage() {
            return this.lastFailureMessage;
        }

        public final void setLastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
        }

        @Override
        public final Builder lastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
            return this;
        }

        public final String getStopReason() {
            return this.stopReason;
        }

        public final void setStopReason(String stopReason) {
            this.stopReason = stopReason;
        }

        @Override
        public final Builder stopReason(String stopReason) {
            this.stopReason = stopReason;
            return this;
        }

        public DataMigration build() {
            return new DataMigration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataMigration> {
        public Builder dataMigrationName(String var1);

        public Builder dataMigrationArn(String var1);

        public Builder dataMigrationCreateTime(Instant var1);

        public Builder dataMigrationStartTime(Instant var1);

        public Builder dataMigrationEndTime(Instant var1);

        public Builder serviceAccessRoleArn(String var1);

        public Builder migrationProjectArn(String var1);

        public Builder dataMigrationType(String var1);

        public Builder dataMigrationType(MigrationTypeValue var1);

        public Builder dataMigrationSettings(DataMigrationSettings var1);

        default public Builder dataMigrationSettings(Consumer<DataMigrationSettings.Builder> dataMigrationSettings) {
            return this.dataMigrationSettings((DataMigrationSettings)((DataMigrationSettings.Builder)DataMigrationSettings.builder().applyMutation(dataMigrationSettings)).build());
        }

        public Builder sourceDataSettings(Collection<SourceDataSetting> var1);

        public Builder sourceDataSettings(SourceDataSetting ... var1);

        public Builder sourceDataSettings(Consumer<SourceDataSetting.Builder> ... var1);

        public Builder dataMigrationStatistics(DataMigrationStatistics var1);

        default public Builder dataMigrationStatistics(Consumer<DataMigrationStatistics.Builder> dataMigrationStatistics) {
            return this.dataMigrationStatistics((DataMigrationStatistics)((DataMigrationStatistics.Builder)DataMigrationStatistics.builder().applyMutation(dataMigrationStatistics)).build());
        }

        public Builder dataMigrationStatus(String var1);

        public Builder publicIpAddresses(Collection<String> var1);

        public Builder publicIpAddresses(String ... var1);

        public Builder lastFailureMessage(String var1);

        public Builder stopReason(String var1);
    }
}

