/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class FleetAdvisorSchemaListCopier {
    static List<SchemaResponse> copy(Collection<? extends SchemaResponse> fleetAdvisorSchemaListParam) {
        List<SchemaResponse> list;
        if (fleetAdvisorSchemaListParam == null || fleetAdvisorSchemaListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SchemaResponse> modifiableList = new ArrayList<>();
            fleetAdvisorSchemaListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SchemaResponse> copyFromBuilder(Collection<? extends SchemaResponse.Builder> fleetAdvisorSchemaListParam) {
        List<SchemaResponse> list;
        if (fleetAdvisorSchemaListParam == null || fleetAdvisorSchemaListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SchemaResponse> modifiableList = new ArrayList<>();
            fleetAdvisorSchemaListParam.forEach(entry -> {
                SchemaResponse member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SchemaResponse.Builder> copyToBuilder(Collection<? extends SchemaResponse> fleetAdvisorSchemaListParam) {
        List<SchemaResponse.Builder> list;
        if (fleetAdvisorSchemaListParam == null || fleetAdvisorSchemaListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SchemaResponse.Builder> modifiableList = new ArrayList<>();
            fleetAdvisorSchemaListParam.forEach(entry -> {
                SchemaResponse.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
