/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse;

public class DescribeCertificatesPublisher
implements SdkPublisher<DescribeCertificatesResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeCertificatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCertificatesPublisher(DatabaseMigrationAsyncClient client, DescribeCertificatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCertificatesPublisher(DatabaseMigrationAsyncClient client, DescribeCertificatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCertificatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCertificatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeCertificatesResponseFetcher
    implements AsyncPageFetcher<DescribeCertificatesResponse> {
        private DescribeCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCertificatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeCertificatesResponse> nextPage(DescribeCertificatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeCertificatesPublisher.this.client.describeCertificates(DescribeCertificatesPublisher.this.firstRequest);
            }
            return DescribeCertificatesPublisher.this.client.describeCertificates((DescribeCertificatesRequest)((Object)DescribeCertificatesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

