/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClientBuilder;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationServiceClientConfiguration;
import software.amazon.awssdk.services.databasemigration.DefaultDatabaseMigrationBaseClientBuilder;
import software.amazon.awssdk.services.databasemigration.DefaultDatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.endpoints.DatabaseMigrationEndpointProvider;

@SdkInternalApi
final class DefaultDatabaseMigrationClientBuilder
extends DefaultDatabaseMigrationBaseClientBuilder<DatabaseMigrationClientBuilder, DatabaseMigrationClient>
implements DatabaseMigrationClientBuilder {
    DefaultDatabaseMigrationClientBuilder() {
    }

    @Override
    public DefaultDatabaseMigrationClientBuilder endpointProvider(DatabaseMigrationEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DatabaseMigrationClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDatabaseMigrationClientBuilder.validateClientOptions(clientConfiguration);
        DatabaseMigrationServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDatabaseMigrationClient client = new DefaultDatabaseMigrationClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DatabaseMigrationServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DatabaseMigrationServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

