/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetAdvisorLsaAnalysisResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DescribeFleetAdvisorLsaAnalysisResponse.Builder, DescribeFleetAdvisorLsaAnalysisResponse> {
    private static final SdkField<List<FleetAdvisorLsaAnalysisResponse>> ANALYSIS_FIELD = SdkField
            .<List<FleetAdvisorLsaAnalysisResponse>> builder(MarshallingType.LIST)
            .memberName("Analysis")
            .getter(getter(DescribeFleetAdvisorLsaAnalysisResponse::analysis))
            .setter(setter(Builder::analysis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Analysis").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FleetAdvisorLsaAnalysisResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(FleetAdvisorLsaAnalysisResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeFleetAdvisorLsaAnalysisResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<FleetAdvisorLsaAnalysisResponse> analysis;

    private final String nextToken;

    private DescribeFleetAdvisorLsaAnalysisResponse(BuilderImpl builder) {
        super(builder);
        this.analysis = builder.analysis;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Analysis property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAnalysis() {
        return analysis != null && !(analysis instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>FleetAdvisorLsaAnalysisResponse</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalysis} method.
     * </p>
     * 
     * @return A list of <code>FleetAdvisorLsaAnalysisResponse</code> objects.
     */
    public final List<FleetAdvisorLsaAnalysisResponse> analysis() {
        return analysis;
    }

    /**
     * <p>
     * If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged.
     * </p>
     * 
     * @return If <code>NextToken</code> is returned, there are more results available. The value of
     *         <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page. Keep all other arguments unchanged.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAnalysis() ? analysis() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetAdvisorLsaAnalysisResponse)) {
            return false;
        }
        DescribeFleetAdvisorLsaAnalysisResponse other = (DescribeFleetAdvisorLsaAnalysisResponse) obj;
        return hasAnalysis() == other.hasAnalysis() && Objects.equals(analysis(), other.analysis())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFleetAdvisorLsaAnalysisResponse").add("Analysis", hasAnalysis() ? analysis() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Analysis":
            return Optional.ofNullable(clazz.cast(analysis()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetAdvisorLsaAnalysisResponse, T> g) {
        return obj -> g.apply((DescribeFleetAdvisorLsaAnalysisResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFleetAdvisorLsaAnalysisResponse> {
        /**
         * <p>
         * A list of <code>FleetAdvisorLsaAnalysisResponse</code> objects.
         * </p>
         * 
         * @param analysis
         *        A list of <code>FleetAdvisorLsaAnalysisResponse</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysis(Collection<FleetAdvisorLsaAnalysisResponse> analysis);

        /**
         * <p>
         * A list of <code>FleetAdvisorLsaAnalysisResponse</code> objects.
         * </p>
         * 
         * @param analysis
         *        A list of <code>FleetAdvisorLsaAnalysisResponse</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysis(FleetAdvisorLsaAnalysisResponse... analysis);

        /**
         * <p>
         * A list of <code>FleetAdvisorLsaAnalysisResponse</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.FleetAdvisorLsaAnalysisResponse.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.databasemigration.model.FleetAdvisorLsaAnalysisResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.FleetAdvisorLsaAnalysisResponse.Builder#build()}
         * is called immediately and its result is passed to {@link #analysis(List<FleetAdvisorLsaAnalysisResponse>)}.
         * 
         * @param analysis
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.FleetAdvisorLsaAnalysisResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysis(java.util.Collection<FleetAdvisorLsaAnalysisResponse>)
         */
        Builder analysis(Consumer<FleetAdvisorLsaAnalysisResponse.Builder>... analysis);

        /**
         * <p>
         * If <code>NextToken</code> is returned, there are more results available. The value of <code>NextToken</code>
         * is a unique pagination token for each page. Make the call again using the returned token to retrieve the next
         * page. Keep all other arguments unchanged.
         * </p>
         * 
         * @param nextToken
         *        If <code>NextToken</code> is returned, there are more results available. The value of
         *        <code>NextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page. Keep all other arguments unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private List<FleetAdvisorLsaAnalysisResponse> analysis = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetAdvisorLsaAnalysisResponse model) {
            super(model);
            analysis(model.analysis);
            nextToken(model.nextToken);
        }

        public final List<FleetAdvisorLsaAnalysisResponse.Builder> getAnalysis() {
            List<FleetAdvisorLsaAnalysisResponse.Builder> result = FleetAdvisorLsaAnalysisResponseListCopier
                    .copyToBuilder(this.analysis);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalysis(Collection<FleetAdvisorLsaAnalysisResponse.BuilderImpl> analysis) {
            this.analysis = FleetAdvisorLsaAnalysisResponseListCopier.copyFromBuilder(analysis);
        }

        @Override
        public final Builder analysis(Collection<FleetAdvisorLsaAnalysisResponse> analysis) {
            this.analysis = FleetAdvisorLsaAnalysisResponseListCopier.copy(analysis);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysis(FleetAdvisorLsaAnalysisResponse... analysis) {
            analysis(Arrays.asList(analysis));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysis(Consumer<FleetAdvisorLsaAnalysisResponse.Builder>... analysis) {
            analysis(Stream.of(analysis).map(c -> FleetAdvisorLsaAnalysisResponse.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeFleetAdvisorLsaAnalysisResponse build() {
            return new DescribeFleetAdvisorLsaAnalysisResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
