/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EndpointSettingTypeValue {
    STRING("string"),
    BOOLEAN("boolean"),
    INTEGER("integer"),
    ENUM("enum"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EndpointSettingTypeValue> VALUE_MAP;
    private final String value;

    private EndpointSettingTypeValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EndpointSettingTypeValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EndpointSettingTypeValue> knownValues() {
        EnumSet<EndpointSettingTypeValue> knownValues = EnumSet.allOf(EndpointSettingTypeValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EndpointSettingTypeValue.class, EndpointSettingTypeValue::toString);
    }
}

