/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.IndividualAssessmentNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeApplicableIndividualAssessmentsResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeApplicableIndividualAssessmentsResponse> {
    private static final SdkField<List<String>> INDIVIDUAL_ASSESSMENT_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IndividualAssessmentNames").getter(DescribeApplicableIndividualAssessmentsResponse.getter(DescribeApplicableIndividualAssessmentsResponse::individualAssessmentNames)).setter(DescribeApplicableIndividualAssessmentsResponse.setter(Builder::individualAssessmentNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndividualAssessmentNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeApplicableIndividualAssessmentsResponse.getter(DescribeApplicableIndividualAssessmentsResponse::marker)).setter(DescribeApplicableIndividualAssessmentsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDIVIDUAL_ASSESSMENT_NAMES_FIELD, MARKER_FIELD));
    private final List<String> individualAssessmentNames;
    private final String marker;

    private DescribeApplicableIndividualAssessmentsResponse(BuilderImpl builder) {
        super(builder);
        this.individualAssessmentNames = builder.individualAssessmentNames;
        this.marker = builder.marker;
    }

    public final boolean hasIndividualAssessmentNames() {
        return this.individualAssessmentNames != null && !(this.individualAssessmentNames instanceof SdkAutoConstructList);
    }

    public final List<String> individualAssessmentNames() {
        return this.individualAssessmentNames;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIndividualAssessmentNames() ? this.individualAssessmentNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicableIndividualAssessmentsResponse)) {
            return false;
        }
        DescribeApplicableIndividualAssessmentsResponse other = (DescribeApplicableIndividualAssessmentsResponse)((Object)obj);
        return this.hasIndividualAssessmentNames() == other.hasIndividualAssessmentNames() && Objects.equals(this.individualAssessmentNames(), other.individualAssessmentNames()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeApplicableIndividualAssessmentsResponse").add("IndividualAssessmentNames", this.hasIndividualAssessmentNames() ? this.individualAssessmentNames() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndividualAssessmentNames": {
                return Optional.ofNullable(clazz.cast(this.individualAssessmentNames()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicableIndividualAssessmentsResponse, T> g) {
        return obj -> g.apply((DescribeApplicableIndividualAssessmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private List<String> individualAssessmentNames = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicableIndividualAssessmentsResponse model) {
            super(model);
            this.individualAssessmentNames(model.individualAssessmentNames);
            this.marker(model.marker);
        }

        public final Collection<String> getIndividualAssessmentNames() {
            if (this.individualAssessmentNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.individualAssessmentNames;
        }

        public final void setIndividualAssessmentNames(Collection<String> individualAssessmentNames) {
            this.individualAssessmentNames = IndividualAssessmentNameListCopier.copy(individualAssessmentNames);
        }

        @Override
        public final Builder individualAssessmentNames(Collection<String> individualAssessmentNames) {
            this.individualAssessmentNames = IndividualAssessmentNameListCopier.copy(individualAssessmentNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder individualAssessmentNames(String ... individualAssessmentNames) {
            this.individualAssessmentNames(Arrays.asList(individualAssessmentNames));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeApplicableIndividualAssessmentsResponse build() {
            return new DescribeApplicableIndividualAssessmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeApplicableIndividualAssessmentsResponse> {
        public Builder individualAssessmentNames(Collection<String> var1);

        public Builder individualAssessmentNames(String ... var1);

        public Builder marker(String var1);
    }
}

