/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MigrationTypeValue {
    FULL_LOAD("full-load"),
    CDC("cdc"),
    FULL_LOAD_AND_CDC("full-load-and-cdc"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MigrationTypeValue> VALUE_MAP;
    private final String value;

    private MigrationTypeValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MigrationTypeValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MigrationTypeValue> knownValues() {
        EnumSet<MigrationTypeValue> knownValues = EnumSet.allOf(MigrationTypeValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MigrationTypeValue.class, MigrationTypeValue::toString);
    }
}

