/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a collection of table statistics in response to a request by the <code>DescribeTableStatistics</code>
 * operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableStatistics implements SdkPojo, Serializable, ToCopyableBuilder<TableStatistics.Builder, TableStatistics> {
    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaName").getter(getter(TableStatistics::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(TableStatistics::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<Long> INSERTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Inserts")
            .getter(getter(TableStatistics::inserts)).setter(setter(Builder::inserts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inserts").build()).build();

    private static final SdkField<Long> DELETES_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Deletes")
            .getter(getter(TableStatistics::deletes)).setter(setter(Builder::deletes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deletes").build()).build();

    private static final SdkField<Long> UPDATES_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Updates")
            .getter(getter(TableStatistics::updates)).setter(setter(Builder::updates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build()).build();

    private static final SdkField<Long> DDLS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Ddls")
            .getter(getter(TableStatistics::ddls)).setter(setter(Builder::ddls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ddls").build()).build();

    private static final SdkField<Long> FULL_LOAD_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FullLoadRows").getter(getter(TableStatistics::fullLoadRows)).setter(setter(Builder::fullLoadRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadRows").build()).build();

    private static final SdkField<Long> FULL_LOAD_CONDTNL_CHK_FAILED_ROWS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("FullLoadCondtnlChkFailedRows")
            .getter(getter(TableStatistics::fullLoadCondtnlChkFailedRows))
            .setter(setter(Builder::fullLoadCondtnlChkFailedRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadCondtnlChkFailedRows")
                    .build()).build();

    private static final SdkField<Long> FULL_LOAD_ERROR_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FullLoadErrorRows").getter(getter(TableStatistics::fullLoadErrorRows))
            .setter(setter(Builder::fullLoadErrorRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadErrorRows").build()).build();

    private static final SdkField<Instant> FULL_LOAD_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FullLoadStartTime").getter(getter(TableStatistics::fullLoadStartTime))
            .setter(setter(Builder::fullLoadStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadStartTime").build()).build();

    private static final SdkField<Instant> FULL_LOAD_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FullLoadEndTime").getter(getter(TableStatistics::fullLoadEndTime))
            .setter(setter(Builder::fullLoadEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadEndTime").build()).build();

    private static final SdkField<Boolean> FULL_LOAD_RELOADED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FullLoadReloaded").getter(getter(TableStatistics::fullLoadReloaded))
            .setter(setter(Builder::fullLoadReloaded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadReloaded").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdateTime").getter(getter(TableStatistics::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final SdkField<String> TABLE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableState").getter(getter(TableStatistics::tableState)).setter(setter(Builder::tableState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableState").build()).build();

    private static final SdkField<Long> VALIDATION_PENDING_RECORDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ValidationPendingRecords").getter(getter(TableStatistics::validationPendingRecords))
            .setter(setter(Builder::validationPendingRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationPendingRecords").build())
            .build();

    private static final SdkField<Long> VALIDATION_FAILED_RECORDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ValidationFailedRecords").getter(getter(TableStatistics::validationFailedRecords))
            .setter(setter(Builder::validationFailedRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationFailedRecords").build())
            .build();

    private static final SdkField<Long> VALIDATION_SUSPENDED_RECORDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ValidationSuspendedRecords")
            .getter(getter(TableStatistics::validationSuspendedRecords))
            .setter(setter(Builder::validationSuspendedRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationSuspendedRecords").build())
            .build();

    private static final SdkField<String> VALIDATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationState").getter(getter(TableStatistics::validationState))
            .setter(setter(Builder::validationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationState").build()).build();

    private static final SdkField<String> VALIDATION_STATE_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValidationStateDetails").getter(getter(TableStatistics::validationStateDetails))
            .setter(setter(Builder::validationStateDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStateDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_NAME_FIELD,
            TABLE_NAME_FIELD, INSERTS_FIELD, DELETES_FIELD, UPDATES_FIELD, DDLS_FIELD, FULL_LOAD_ROWS_FIELD,
            FULL_LOAD_CONDTNL_CHK_FAILED_ROWS_FIELD, FULL_LOAD_ERROR_ROWS_FIELD, FULL_LOAD_START_TIME_FIELD,
            FULL_LOAD_END_TIME_FIELD, FULL_LOAD_RELOADED_FIELD, LAST_UPDATE_TIME_FIELD, TABLE_STATE_FIELD,
            VALIDATION_PENDING_RECORDS_FIELD, VALIDATION_FAILED_RECORDS_FIELD, VALIDATION_SUSPENDED_RECORDS_FIELD,
            VALIDATION_STATE_FIELD, VALIDATION_STATE_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String schemaName;

    private final String tableName;

    private final Long inserts;

    private final Long deletes;

    private final Long updates;

    private final Long ddls;

    private final Long fullLoadRows;

    private final Long fullLoadCondtnlChkFailedRows;

    private final Long fullLoadErrorRows;

    private final Instant fullLoadStartTime;

    private final Instant fullLoadEndTime;

    private final Boolean fullLoadReloaded;

    private final Instant lastUpdateTime;

    private final String tableState;

    private final Long validationPendingRecords;

    private final Long validationFailedRecords;

    private final Long validationSuspendedRecords;

    private final String validationState;

    private final String validationStateDetails;

    private TableStatistics(BuilderImpl builder) {
        this.schemaName = builder.schemaName;
        this.tableName = builder.tableName;
        this.inserts = builder.inserts;
        this.deletes = builder.deletes;
        this.updates = builder.updates;
        this.ddls = builder.ddls;
        this.fullLoadRows = builder.fullLoadRows;
        this.fullLoadCondtnlChkFailedRows = builder.fullLoadCondtnlChkFailedRows;
        this.fullLoadErrorRows = builder.fullLoadErrorRows;
        this.fullLoadStartTime = builder.fullLoadStartTime;
        this.fullLoadEndTime = builder.fullLoadEndTime;
        this.fullLoadReloaded = builder.fullLoadReloaded;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.tableState = builder.tableState;
        this.validationPendingRecords = builder.validationPendingRecords;
        this.validationFailedRecords = builder.validationFailedRecords;
        this.validationSuspendedRecords = builder.validationSuspendedRecords;
        this.validationState = builder.validationState;
        this.validationStateDetails = builder.validationStateDetails;
    }

    /**
     * <p>
     * The schema name.
     * </p>
     * 
     * @return The schema name.
     */
    public final String schemaName() {
        return schemaName;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The number of insert actions performed on a table.
     * </p>
     * 
     * @return The number of insert actions performed on a table.
     */
    public final Long inserts() {
        return inserts;
    }

    /**
     * <p>
     * The number of delete actions performed on a table.
     * </p>
     * 
     * @return The number of delete actions performed on a table.
     */
    public final Long deletes() {
        return deletes;
    }

    /**
     * <p>
     * The number of update actions performed on a table.
     * </p>
     * 
     * @return The number of update actions performed on a table.
     */
    public final Long updates() {
        return updates;
    }

    /**
     * <p>
     * The data definition language (DDL) used to build and modify the structure of your tables.
     * </p>
     * 
     * @return The data definition language (DDL) used to build and modify the structure of your tables.
     */
    public final Long ddls() {
        return ddls;
    }

    /**
     * <p>
     * The number of rows added during the full load operation.
     * </p>
     * 
     * @return The number of rows added during the full load operation.
     */
    public final Long fullLoadRows() {
        return fullLoadRows;
    }

    /**
     * <p>
     * The number of rows that failed conditional checks during the full load operation (valid only for migrations where
     * DynamoDB is the target).
     * </p>
     * 
     * @return The number of rows that failed conditional checks during the full load operation (valid only for
     *         migrations where DynamoDB is the target).
     */
    public final Long fullLoadCondtnlChkFailedRows() {
        return fullLoadCondtnlChkFailedRows;
    }

    /**
     * <p>
     * The number of rows that failed to load during the full load operation (valid only for migrations where DynamoDB
     * is the target).
     * </p>
     * 
     * @return The number of rows that failed to load during the full load operation (valid only for migrations where
     *         DynamoDB is the target).
     */
    public final Long fullLoadErrorRows() {
        return fullLoadErrorRows;
    }

    /**
     * <p>
     * The time when the full load operation started.
     * </p>
     * 
     * @return The time when the full load operation started.
     */
    public final Instant fullLoadStartTime() {
        return fullLoadStartTime;
    }

    /**
     * <p>
     * The time when the full load operation completed.
     * </p>
     * 
     * @return The time when the full load operation completed.
     */
    public final Instant fullLoadEndTime() {
        return fullLoadEndTime;
    }

    /**
     * <p>
     * A value that indicates if the table was reloaded (<code>true</code>) or loaded as part of a new full load
     * operation (<code>false</code>).
     * </p>
     * 
     * @return A value that indicates if the table was reloaded (<code>true</code>) or loaded as part of a new full load
     *         operation (<code>false</code>).
     */
    public final Boolean fullLoadReloaded() {
        return fullLoadReloaded;
    }

    /**
     * <p>
     * The last time a table was updated.
     * </p>
     * 
     * @return The last time a table was updated.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The state of the tables described.
     * </p>
     * <p>
     * Valid states: Table does not exist | Before load | Full load | Table completed | Table cancelled | Table error |
     * Table all | Table updates | Table is being reloaded
     * </p>
     * 
     * @return The state of the tables described.</p>
     *         <p>
     *         Valid states: Table does not exist | Before load | Full load | Table completed | Table cancelled | Table
     *         error | Table all | Table updates | Table is being reloaded
     */
    public final String tableState() {
        return tableState;
    }

    /**
     * <p>
     * The number of records that have yet to be validated.
     * </p>
     * 
     * @return The number of records that have yet to be validated.
     */
    public final Long validationPendingRecords() {
        return validationPendingRecords;
    }

    /**
     * <p>
     * The number of records that failed validation.
     * </p>
     * 
     * @return The number of records that failed validation.
     */
    public final Long validationFailedRecords() {
        return validationFailedRecords;
    }

    /**
     * <p>
     * The number of records that couldn't be validated.
     * </p>
     * 
     * @return The number of records that couldn't be validated.
     */
    public final Long validationSuspendedRecords() {
        return validationSuspendedRecords;
    }

    /**
     * <p>
     * The validation state of the table.
     * </p>
     * <p>
     * This parameter can have the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Not enabled – Validation isn't enabled for the table in the migration task.
     * </p>
     * </li>
     * <li>
     * <p>
     * Pending records – Some records in the table are waiting for validation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Mismatched records – Some records in the table don't match between the source and target.
     * </p>
     * </li>
     * <li>
     * <p>
     * Suspended records – Some records in the table couldn't be validated.
     * </p>
     * </li>
     * <li>
     * <p>
     * No primary key –The table couldn't be validated because it has no primary key.
     * </p>
     * </li>
     * <li>
     * <p>
     * Table error – The table wasn't validated because it's in an error state and some data wasn't migrated.
     * </p>
     * </li>
     * <li>
     * <p>
     * Validated – All rows in the table are validated. If the table is updated, the status can change from Validated.
     * </p>
     * </li>
     * <li>
     * <p>
     * Error – The table couldn't be validated because of an unexpected error.
     * </p>
     * </li>
     * <li>
     * <p>
     * Pending validation – The table is waiting validation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Preparing table – Preparing the table enabled in the migration task for validation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Pending revalidation – All rows in the table are pending validation after the table was updated.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The validation state of the table.</p>
     *         <p>
     *         This parameter can have the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Not enabled – Validation isn't enabled for the table in the migration task.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Pending records – Some records in the table are waiting for validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Mismatched records – Some records in the table don't match between the source and target.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Suspended records – Some records in the table couldn't be validated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         No primary key –The table couldn't be validated because it has no primary key.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Table error – The table wasn't validated because it's in an error state and some data wasn't migrated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Validated – All rows in the table are validated. If the table is updated, the status can change from
     *         Validated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Error – The table couldn't be validated because of an unexpected error.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Pending validation – The table is waiting validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Preparing table – Preparing the table enabled in the migration task for validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Pending revalidation – All rows in the table are pending validation after the table was updated.
     *         </p>
     *         </li>
     */
    public final String validationState() {
        return validationState;
    }

    /**
     * <p>
     * Additional details about the state of validation.
     * </p>
     * 
     * @return Additional details about the state of validation.
     */
    public final String validationStateDetails() {
        return validationStateDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(inserts());
        hashCode = 31 * hashCode + Objects.hashCode(deletes());
        hashCode = 31 * hashCode + Objects.hashCode(updates());
        hashCode = 31 * hashCode + Objects.hashCode(ddls());
        hashCode = 31 * hashCode + Objects.hashCode(fullLoadRows());
        hashCode = 31 * hashCode + Objects.hashCode(fullLoadCondtnlChkFailedRows());
        hashCode = 31 * hashCode + Objects.hashCode(fullLoadErrorRows());
        hashCode = 31 * hashCode + Objects.hashCode(fullLoadStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(fullLoadEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(fullLoadReloaded());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(tableState());
        hashCode = 31 * hashCode + Objects.hashCode(validationPendingRecords());
        hashCode = 31 * hashCode + Objects.hashCode(validationFailedRecords());
        hashCode = 31 * hashCode + Objects.hashCode(validationSuspendedRecords());
        hashCode = 31 * hashCode + Objects.hashCode(validationState());
        hashCode = 31 * hashCode + Objects.hashCode(validationStateDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableStatistics)) {
            return false;
        }
        TableStatistics other = (TableStatistics) obj;
        return Objects.equals(schemaName(), other.schemaName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(inserts(), other.inserts()) && Objects.equals(deletes(), other.deletes())
                && Objects.equals(updates(), other.updates()) && Objects.equals(ddls(), other.ddls())
                && Objects.equals(fullLoadRows(), other.fullLoadRows())
                && Objects.equals(fullLoadCondtnlChkFailedRows(), other.fullLoadCondtnlChkFailedRows())
                && Objects.equals(fullLoadErrorRows(), other.fullLoadErrorRows())
                && Objects.equals(fullLoadStartTime(), other.fullLoadStartTime())
                && Objects.equals(fullLoadEndTime(), other.fullLoadEndTime())
                && Objects.equals(fullLoadReloaded(), other.fullLoadReloaded())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(tableState(), other.tableState())
                && Objects.equals(validationPendingRecords(), other.validationPendingRecords())
                && Objects.equals(validationFailedRecords(), other.validationFailedRecords())
                && Objects.equals(validationSuspendedRecords(), other.validationSuspendedRecords())
                && Objects.equals(validationState(), other.validationState())
                && Objects.equals(validationStateDetails(), other.validationStateDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableStatistics").add("SchemaName", schemaName()).add("TableName", tableName())
                .add("Inserts", inserts()).add("Deletes", deletes()).add("Updates", updates()).add("Ddls", ddls())
                .add("FullLoadRows", fullLoadRows()).add("FullLoadCondtnlChkFailedRows", fullLoadCondtnlChkFailedRows())
                .add("FullLoadErrorRows", fullLoadErrorRows()).add("FullLoadStartTime", fullLoadStartTime())
                .add("FullLoadEndTime", fullLoadEndTime()).add("FullLoadReloaded", fullLoadReloaded())
                .add("LastUpdateTime", lastUpdateTime()).add("TableState", tableState())
                .add("ValidationPendingRecords", validationPendingRecords())
                .add("ValidationFailedRecords", validationFailedRecords())
                .add("ValidationSuspendedRecords", validationSuspendedRecords()).add("ValidationState", validationState())
                .add("ValidationStateDetails", validationStateDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "Inserts":
            return Optional.ofNullable(clazz.cast(inserts()));
        case "Deletes":
            return Optional.ofNullable(clazz.cast(deletes()));
        case "Updates":
            return Optional.ofNullable(clazz.cast(updates()));
        case "Ddls":
            return Optional.ofNullable(clazz.cast(ddls()));
        case "FullLoadRows":
            return Optional.ofNullable(clazz.cast(fullLoadRows()));
        case "FullLoadCondtnlChkFailedRows":
            return Optional.ofNullable(clazz.cast(fullLoadCondtnlChkFailedRows()));
        case "FullLoadErrorRows":
            return Optional.ofNullable(clazz.cast(fullLoadErrorRows()));
        case "FullLoadStartTime":
            return Optional.ofNullable(clazz.cast(fullLoadStartTime()));
        case "FullLoadEndTime":
            return Optional.ofNullable(clazz.cast(fullLoadEndTime()));
        case "FullLoadReloaded":
            return Optional.ofNullable(clazz.cast(fullLoadReloaded()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "TableState":
            return Optional.ofNullable(clazz.cast(tableState()));
        case "ValidationPendingRecords":
            return Optional.ofNullable(clazz.cast(validationPendingRecords()));
        case "ValidationFailedRecords":
            return Optional.ofNullable(clazz.cast(validationFailedRecords()));
        case "ValidationSuspendedRecords":
            return Optional.ofNullable(clazz.cast(validationSuspendedRecords()));
        case "ValidationState":
            return Optional.ofNullable(clazz.cast(validationState()));
        case "ValidationStateDetails":
            return Optional.ofNullable(clazz.cast(validationStateDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableStatistics, T> g) {
        return obj -> g.apply((TableStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableStatistics> {
        /**
         * <p>
         * The schema name.
         * </p>
         * 
         * @param schemaName
         *        The schema name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param tableName
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The number of insert actions performed on a table.
         * </p>
         * 
         * @param inserts
         *        The number of insert actions performed on a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inserts(Long inserts);

        /**
         * <p>
         * The number of delete actions performed on a table.
         * </p>
         * 
         * @param deletes
         *        The number of delete actions performed on a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletes(Long deletes);

        /**
         * <p>
         * The number of update actions performed on a table.
         * </p>
         * 
         * @param updates
         *        The number of update actions performed on a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(Long updates);

        /**
         * <p>
         * The data definition language (DDL) used to build and modify the structure of your tables.
         * </p>
         * 
         * @param ddls
         *        The data definition language (DDL) used to build and modify the structure of your tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ddls(Long ddls);

        /**
         * <p>
         * The number of rows added during the full load operation.
         * </p>
         * 
         * @param fullLoadRows
         *        The number of rows added during the full load operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullLoadRows(Long fullLoadRows);

        /**
         * <p>
         * The number of rows that failed conditional checks during the full load operation (valid only for migrations
         * where DynamoDB is the target).
         * </p>
         * 
         * @param fullLoadCondtnlChkFailedRows
         *        The number of rows that failed conditional checks during the full load operation (valid only for
         *        migrations where DynamoDB is the target).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullLoadCondtnlChkFailedRows(Long fullLoadCondtnlChkFailedRows);

        /**
         * <p>
         * The number of rows that failed to load during the full load operation (valid only for migrations where
         * DynamoDB is the target).
         * </p>
         * 
         * @param fullLoadErrorRows
         *        The number of rows that failed to load during the full load operation (valid only for migrations where
         *        DynamoDB is the target).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullLoadErrorRows(Long fullLoadErrorRows);

        /**
         * <p>
         * The time when the full load operation started.
         * </p>
         * 
         * @param fullLoadStartTime
         *        The time when the full load operation started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullLoadStartTime(Instant fullLoadStartTime);

        /**
         * <p>
         * The time when the full load operation completed.
         * </p>
         * 
         * @param fullLoadEndTime
         *        The time when the full load operation completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullLoadEndTime(Instant fullLoadEndTime);

        /**
         * <p>
         * A value that indicates if the table was reloaded (<code>true</code>) or loaded as part of a new full load
         * operation (<code>false</code>).
         * </p>
         * 
         * @param fullLoadReloaded
         *        A value that indicates if the table was reloaded (<code>true</code>) or loaded as part of a new full
         *        load operation (<code>false</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullLoadReloaded(Boolean fullLoadReloaded);

        /**
         * <p>
         * The last time a table was updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The last time a table was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The state of the tables described.
         * </p>
         * <p>
         * Valid states: Table does not exist | Before load | Full load | Table completed | Table cancelled | Table
         * error | Table all | Table updates | Table is being reloaded
         * </p>
         * 
         * @param tableState
         *        The state of the tables described.</p>
         *        <p>
         *        Valid states: Table does not exist | Before load | Full load | Table completed | Table cancelled |
         *        Table error | Table all | Table updates | Table is being reloaded
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableState(String tableState);

        /**
         * <p>
         * The number of records that have yet to be validated.
         * </p>
         * 
         * @param validationPendingRecords
         *        The number of records that have yet to be validated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationPendingRecords(Long validationPendingRecords);

        /**
         * <p>
         * The number of records that failed validation.
         * </p>
         * 
         * @param validationFailedRecords
         *        The number of records that failed validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationFailedRecords(Long validationFailedRecords);

        /**
         * <p>
         * The number of records that couldn't be validated.
         * </p>
         * 
         * @param validationSuspendedRecords
         *        The number of records that couldn't be validated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationSuspendedRecords(Long validationSuspendedRecords);

        /**
         * <p>
         * The validation state of the table.
         * </p>
         * <p>
         * This parameter can have the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Not enabled – Validation isn't enabled for the table in the migration task.
         * </p>
         * </li>
         * <li>
         * <p>
         * Pending records – Some records in the table are waiting for validation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Mismatched records – Some records in the table don't match between the source and target.
         * </p>
         * </li>
         * <li>
         * <p>
         * Suspended records – Some records in the table couldn't be validated.
         * </p>
         * </li>
         * <li>
         * <p>
         * No primary key –The table couldn't be validated because it has no primary key.
         * </p>
         * </li>
         * <li>
         * <p>
         * Table error – The table wasn't validated because it's in an error state and some data wasn't migrated.
         * </p>
         * </li>
         * <li>
         * <p>
         * Validated – All rows in the table are validated. If the table is updated, the status can change from
         * Validated.
         * </p>
         * </li>
         * <li>
         * <p>
         * Error – The table couldn't be validated because of an unexpected error.
         * </p>
         * </li>
         * <li>
         * <p>
         * Pending validation – The table is waiting validation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Preparing table – Preparing the table enabled in the migration task for validation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Pending revalidation – All rows in the table are pending validation after the table was updated.
         * </p>
         * </li>
         * </ul>
         * 
         * @param validationState
         *        The validation state of the table.</p>
         *        <p>
         *        This parameter can have the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Not enabled – Validation isn't enabled for the table in the migration task.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Pending records – Some records in the table are waiting for validation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Mismatched records – Some records in the table don't match between the source and target.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Suspended records – Some records in the table couldn't be validated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        No primary key –The table couldn't be validated because it has no primary key.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Table error – The table wasn't validated because it's in an error state and some data wasn't migrated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Validated – All rows in the table are validated. If the table is updated, the status can change from
         *        Validated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Error – The table couldn't be validated because of an unexpected error.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Pending validation – The table is waiting validation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Preparing table – Preparing the table enabled in the migration task for validation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Pending revalidation – All rows in the table are pending validation after the table was updated.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationState(String validationState);

        /**
         * <p>
         * Additional details about the state of validation.
         * </p>
         * 
         * @param validationStateDetails
         *        Additional details about the state of validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationStateDetails(String validationStateDetails);
    }

    static final class BuilderImpl implements Builder {
        private String schemaName;

        private String tableName;

        private Long inserts;

        private Long deletes;

        private Long updates;

        private Long ddls;

        private Long fullLoadRows;

        private Long fullLoadCondtnlChkFailedRows;

        private Long fullLoadErrorRows;

        private Instant fullLoadStartTime;

        private Instant fullLoadEndTime;

        private Boolean fullLoadReloaded;

        private Instant lastUpdateTime;

        private String tableState;

        private Long validationPendingRecords;

        private Long validationFailedRecords;

        private Long validationSuspendedRecords;

        private String validationState;

        private String validationStateDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(TableStatistics model) {
            schemaName(model.schemaName);
            tableName(model.tableName);
            inserts(model.inserts);
            deletes(model.deletes);
            updates(model.updates);
            ddls(model.ddls);
            fullLoadRows(model.fullLoadRows);
            fullLoadCondtnlChkFailedRows(model.fullLoadCondtnlChkFailedRows);
            fullLoadErrorRows(model.fullLoadErrorRows);
            fullLoadStartTime(model.fullLoadStartTime);
            fullLoadEndTime(model.fullLoadEndTime);
            fullLoadReloaded(model.fullLoadReloaded);
            lastUpdateTime(model.lastUpdateTime);
            tableState(model.tableState);
            validationPendingRecords(model.validationPendingRecords);
            validationFailedRecords(model.validationFailedRecords);
            validationSuspendedRecords(model.validationSuspendedRecords);
            validationState(model.validationState);
            validationStateDetails(model.validationStateDetails);
        }

        public final String getSchemaName() {
            return schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Long getInserts() {
            return inserts;
        }

        @Override
        public final Builder inserts(Long inserts) {
            this.inserts = inserts;
            return this;
        }

        public final void setInserts(Long inserts) {
            this.inserts = inserts;
        }

        public final Long getDeletes() {
            return deletes;
        }

        @Override
        public final Builder deletes(Long deletes) {
            this.deletes = deletes;
            return this;
        }

        public final void setDeletes(Long deletes) {
            this.deletes = deletes;
        }

        public final Long getUpdates() {
            return updates;
        }

        @Override
        public final Builder updates(Long updates) {
            this.updates = updates;
            return this;
        }

        public final void setUpdates(Long updates) {
            this.updates = updates;
        }

        public final Long getDdls() {
            return ddls;
        }

        @Override
        public final Builder ddls(Long ddls) {
            this.ddls = ddls;
            return this;
        }

        public final void setDdls(Long ddls) {
            this.ddls = ddls;
        }

        public final Long getFullLoadRows() {
            return fullLoadRows;
        }

        @Override
        public final Builder fullLoadRows(Long fullLoadRows) {
            this.fullLoadRows = fullLoadRows;
            return this;
        }

        public final void setFullLoadRows(Long fullLoadRows) {
            this.fullLoadRows = fullLoadRows;
        }

        public final Long getFullLoadCondtnlChkFailedRows() {
            return fullLoadCondtnlChkFailedRows;
        }

        @Override
        public final Builder fullLoadCondtnlChkFailedRows(Long fullLoadCondtnlChkFailedRows) {
            this.fullLoadCondtnlChkFailedRows = fullLoadCondtnlChkFailedRows;
            return this;
        }

        public final void setFullLoadCondtnlChkFailedRows(Long fullLoadCondtnlChkFailedRows) {
            this.fullLoadCondtnlChkFailedRows = fullLoadCondtnlChkFailedRows;
        }

        public final Long getFullLoadErrorRows() {
            return fullLoadErrorRows;
        }

        @Override
        public final Builder fullLoadErrorRows(Long fullLoadErrorRows) {
            this.fullLoadErrorRows = fullLoadErrorRows;
            return this;
        }

        public final void setFullLoadErrorRows(Long fullLoadErrorRows) {
            this.fullLoadErrorRows = fullLoadErrorRows;
        }

        public final Instant getFullLoadStartTime() {
            return fullLoadStartTime;
        }

        @Override
        public final Builder fullLoadStartTime(Instant fullLoadStartTime) {
            this.fullLoadStartTime = fullLoadStartTime;
            return this;
        }

        public final void setFullLoadStartTime(Instant fullLoadStartTime) {
            this.fullLoadStartTime = fullLoadStartTime;
        }

        public final Instant getFullLoadEndTime() {
            return fullLoadEndTime;
        }

        @Override
        public final Builder fullLoadEndTime(Instant fullLoadEndTime) {
            this.fullLoadEndTime = fullLoadEndTime;
            return this;
        }

        public final void setFullLoadEndTime(Instant fullLoadEndTime) {
            this.fullLoadEndTime = fullLoadEndTime;
        }

        public final Boolean getFullLoadReloaded() {
            return fullLoadReloaded;
        }

        @Override
        public final Builder fullLoadReloaded(Boolean fullLoadReloaded) {
            this.fullLoadReloaded = fullLoadReloaded;
            return this;
        }

        public final void setFullLoadReloaded(Boolean fullLoadReloaded) {
            this.fullLoadReloaded = fullLoadReloaded;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public final String getTableState() {
            return tableState;
        }

        @Override
        public final Builder tableState(String tableState) {
            this.tableState = tableState;
            return this;
        }

        public final void setTableState(String tableState) {
            this.tableState = tableState;
        }

        public final Long getValidationPendingRecords() {
            return validationPendingRecords;
        }

        @Override
        public final Builder validationPendingRecords(Long validationPendingRecords) {
            this.validationPendingRecords = validationPendingRecords;
            return this;
        }

        public final void setValidationPendingRecords(Long validationPendingRecords) {
            this.validationPendingRecords = validationPendingRecords;
        }

        public final Long getValidationFailedRecords() {
            return validationFailedRecords;
        }

        @Override
        public final Builder validationFailedRecords(Long validationFailedRecords) {
            this.validationFailedRecords = validationFailedRecords;
            return this;
        }

        public final void setValidationFailedRecords(Long validationFailedRecords) {
            this.validationFailedRecords = validationFailedRecords;
        }

        public final Long getValidationSuspendedRecords() {
            return validationSuspendedRecords;
        }

        @Override
        public final Builder validationSuspendedRecords(Long validationSuspendedRecords) {
            this.validationSuspendedRecords = validationSuspendedRecords;
            return this;
        }

        public final void setValidationSuspendedRecords(Long validationSuspendedRecords) {
            this.validationSuspendedRecords = validationSuspendedRecords;
        }

        public final String getValidationState() {
            return validationState;
        }

        @Override
        public final Builder validationState(String validationState) {
            this.validationState = validationState;
            return this;
        }

        public final void setValidationState(String validationState) {
            this.validationState = validationState;
        }

        public final String getValidationStateDetails() {
            return validationStateDetails;
        }

        @Override
        public final Builder validationStateDetails(String validationStateDetails) {
            this.validationStateDetails = validationStateDetails;
            return this;
        }

        public final void setValidationStateDetails(String validationStateDetails) {
            this.validationStateDetails = validationStateDetails;
        }

        @Override
        public TableStatistics build() {
            return new TableStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
