/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that defines a Microsoft SQL Server endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MicrosoftSQLServerSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MicrosoftSQLServerSettings.Builder, MicrosoftSQLServerSettings> {
    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(MicrosoftSQLServerSettings::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<Integer> BCP_PACKET_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BcpPacketSize").getter(getter(MicrosoftSQLServerSettings::bcpPacketSize))
            .setter(setter(Builder::bcpPacketSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BcpPacketSize").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(MicrosoftSQLServerSettings::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> CONTROL_TABLES_FILE_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ControlTablesFileGroup").getter(getter(MicrosoftSQLServerSettings::controlTablesFileGroup))
            .setter(setter(Builder::controlTablesFileGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlTablesFileGroup").build())
            .build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(MicrosoftSQLServerSettings::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<Boolean> READ_BACKUP_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReadBackupOnly").getter(getter(MicrosoftSQLServerSettings::readBackupOnly))
            .setter(setter(Builder::readBackupOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadBackupOnly").build()).build();

    private static final SdkField<String> SAFEGUARD_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SafeguardPolicy").getter(getter(MicrosoftSQLServerSettings::safeguardPolicyAsString))
            .setter(setter(Builder::safeguardPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SafeguardPolicy").build()).build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(MicrosoftSQLServerSettings::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(MicrosoftSQLServerSettings::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<Boolean> USE_BCP_FULL_LOAD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UseBcpFullLoad").getter(getter(MicrosoftSQLServerSettings::useBcpFullLoad))
            .setter(setter(Builder::useBcpFullLoad))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseBcpFullLoad").build()).build();

    private static final SdkField<String> SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecretsManagerAccessRoleArn")
            .getter(getter(MicrosoftSQLServerSettings::secretsManagerAccessRoleArn))
            .setter(setter(Builder::secretsManagerAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerAccessRoleArn")
                    .build()).build();

    private static final SdkField<String> SECRETS_MANAGER_SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretsManagerSecretId").getter(getter(MicrosoftSQLServerSettings::secretsManagerSecretId))
            .setter(setter(Builder::secretsManagerSecretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerSecretId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_FIELD,
            BCP_PACKET_SIZE_FIELD, DATABASE_NAME_FIELD, CONTROL_TABLES_FILE_GROUP_FIELD, PASSWORD_FIELD, READ_BACKUP_ONLY_FIELD,
            SAFEGUARD_POLICY_FIELD, SERVER_NAME_FIELD, USERNAME_FIELD, USE_BCP_FULL_LOAD_FIELD,
            SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD, SECRETS_MANAGER_SECRET_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer port;

    private final Integer bcpPacketSize;

    private final String databaseName;

    private final String controlTablesFileGroup;

    private final String password;

    private final Boolean readBackupOnly;

    private final String safeguardPolicy;

    private final String serverName;

    private final String username;

    private final Boolean useBcpFullLoad;

    private final String secretsManagerAccessRoleArn;

    private final String secretsManagerSecretId;

    private MicrosoftSQLServerSettings(BuilderImpl builder) {
        this.port = builder.port;
        this.bcpPacketSize = builder.bcpPacketSize;
        this.databaseName = builder.databaseName;
        this.controlTablesFileGroup = builder.controlTablesFileGroup;
        this.password = builder.password;
        this.readBackupOnly = builder.readBackupOnly;
        this.safeguardPolicy = builder.safeguardPolicy;
        this.serverName = builder.serverName;
        this.username = builder.username;
        this.useBcpFullLoad = builder.useBcpFullLoad;
        this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
        this.secretsManagerSecretId = builder.secretsManagerSecretId;
    }

    /**
     * <p>
     * Endpoint TCP port.
     * </p>
     * 
     * @return Endpoint TCP port.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The maximum size of the packets (in bytes) used to transfer data using BCP.
     * </p>
     * 
     * @return The maximum size of the packets (in bytes) used to transfer data using BCP.
     */
    public final Integer bcpPacketSize() {
        return bcpPacketSize;
    }

    /**
     * <p>
     * Database name for the endpoint.
     * </p>
     * 
     * @return Database name for the endpoint.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * Specifies a file group for the AWS DMS internal tables. When the replication task starts, all the internal AWS
     * DMS control tables (awsdms_ apply_exception, awsdms_apply, awsdms_changes) are created for the specified file
     * group.
     * </p>
     * 
     * @return Specifies a file group for the AWS DMS internal tables. When the replication task starts, all the
     *         internal AWS DMS control tables (awsdms_ apply_exception, awsdms_apply, awsdms_changes) are created for
     *         the specified file group.
     */
    public final String controlTablesFileGroup() {
        return controlTablesFileGroup;
    }

    /**
     * <p>
     * Endpoint connection password.
     * </p>
     * 
     * @return Endpoint connection password.
     */
    public final String password() {
        return password;
    }

    /**
     * <p>
     * When this attribute is set to <code>Y</code>, AWS DMS only reads changes from transaction log backups and doesn't
     * read from the active transaction log file during ongoing replication. Setting this parameter to <code>Y</code>
     * enables you to control active transaction log file growth during full load and ongoing replication tasks.
     * However, it can add some source latency to ongoing replication.
     * </p>
     * 
     * @return When this attribute is set to <code>Y</code>, AWS DMS only reads changes from transaction log backups and
     *         doesn't read from the active transaction log file during ongoing replication. Setting this parameter to
     *         <code>Y</code> enables you to control active transaction log file growth during full load and ongoing
     *         replication tasks. However, it can add some source latency to ongoing replication.
     */
    public final Boolean readBackupOnly() {
        return readBackupOnly;
    }

    /**
     * <p>
     * Use this attribute to minimize the need to access the backup log and enable AWS DMS to prevent truncation using
     * one of the following two methods.
     * </p>
     * <p>
     * <i>Start transactions in the database:</i> This is the default method. When this method is used, AWS DMS prevents
     * TLOG truncation by mimicking a transaction in the database. As long as such a transaction is open, changes that
     * appear after the transaction started aren't truncated. If you need Microsoft Replication to be enabled in your
     * database, then you must choose this method.
     * </p>
     * <p>
     * <i>Exclusively use sp_repldone within a single task</i>: When this method is used, AWS DMS reads the changes and
     * then uses sp_repldone to mark the TLOG transactions as ready for truncation. Although this method doesn't involve
     * any transactional activities, it can only be used when Microsoft Replication isn't running. Also, when using this
     * method, only one AWS DMS task can access the database at any given time. Therefore, if you need to run parallel
     * AWS DMS tasks against the same database, use the default method.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #safeguardPolicy}
     * will return {@link SafeguardPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #safeguardPolicyAsString}.
     * </p>
     * 
     * @return Use this attribute to minimize the need to access the backup log and enable AWS DMS to prevent truncation
     *         using one of the following two methods.</p>
     *         <p>
     *         <i>Start transactions in the database:</i> This is the default method. When this method is used, AWS DMS
     *         prevents TLOG truncation by mimicking a transaction in the database. As long as such a transaction is
     *         open, changes that appear after the transaction started aren't truncated. If you need Microsoft
     *         Replication to be enabled in your database, then you must choose this method.
     *         </p>
     *         <p>
     *         <i>Exclusively use sp_repldone within a single task</i>: When this method is used, AWS DMS reads the
     *         changes and then uses sp_repldone to mark the TLOG transactions as ready for truncation. Although this
     *         method doesn't involve any transactional activities, it can only be used when Microsoft Replication isn't
     *         running. Also, when using this method, only one AWS DMS task can access the database at any given time.
     *         Therefore, if you need to run parallel AWS DMS tasks against the same database, use the default method.
     * @see SafeguardPolicy
     */
    public final SafeguardPolicy safeguardPolicy() {
        return SafeguardPolicy.fromValue(safeguardPolicy);
    }

    /**
     * <p>
     * Use this attribute to minimize the need to access the backup log and enable AWS DMS to prevent truncation using
     * one of the following two methods.
     * </p>
     * <p>
     * <i>Start transactions in the database:</i> This is the default method. When this method is used, AWS DMS prevents
     * TLOG truncation by mimicking a transaction in the database. As long as such a transaction is open, changes that
     * appear after the transaction started aren't truncated. If you need Microsoft Replication to be enabled in your
     * database, then you must choose this method.
     * </p>
     * <p>
     * <i>Exclusively use sp_repldone within a single task</i>: When this method is used, AWS DMS reads the changes and
     * then uses sp_repldone to mark the TLOG transactions as ready for truncation. Although this method doesn't involve
     * any transactional activities, it can only be used when Microsoft Replication isn't running. Also, when using this
     * method, only one AWS DMS task can access the database at any given time. Therefore, if you need to run parallel
     * AWS DMS tasks against the same database, use the default method.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #safeguardPolicy}
     * will return {@link SafeguardPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #safeguardPolicyAsString}.
     * </p>
     * 
     * @return Use this attribute to minimize the need to access the backup log and enable AWS DMS to prevent truncation
     *         using one of the following two methods.</p>
     *         <p>
     *         <i>Start transactions in the database:</i> This is the default method. When this method is used, AWS DMS
     *         prevents TLOG truncation by mimicking a transaction in the database. As long as such a transaction is
     *         open, changes that appear after the transaction started aren't truncated. If you need Microsoft
     *         Replication to be enabled in your database, then you must choose this method.
     *         </p>
     *         <p>
     *         <i>Exclusively use sp_repldone within a single task</i>: When this method is used, AWS DMS reads the
     *         changes and then uses sp_repldone to mark the TLOG transactions as ready for truncation. Although this
     *         method doesn't involve any transactional activities, it can only be used when Microsoft Replication isn't
     *         running. Also, when using this method, only one AWS DMS task can access the database at any given time.
     *         Therefore, if you need to run parallel AWS DMS tasks against the same database, use the default method.
     * @see SafeguardPolicy
     */
    public final String safeguardPolicyAsString() {
        return safeguardPolicy;
    }

    /**
     * <p>
     * Fully qualified domain name of the endpoint.
     * </p>
     * 
     * @return Fully qualified domain name of the endpoint.
     */
    public final String serverName() {
        return serverName;
    }

    /**
     * <p>
     * Endpoint connection user name.
     * </p>
     * 
     * @return Endpoint connection user name.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * Use this to attribute to transfer data for full-load operations using BCP. When the target table contains an
     * identity column that does not exist in the source table, you must disable the use BCP for loading table option.
     * </p>
     * 
     * @return Use this to attribute to transfer data for full-load operations using BCP. When the target table contains
     *         an identity column that does not exist in the source table, you must disable the use BCP for loading
     *         table option.
     */
    public final Boolean useBcpFullLoad() {
        return useBcpFullLoad;
    }

    /**
     * <p>
     * The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants the
     * required permissions to access the value in <code>SecretsManagerSecret</code>. <code>SecretsManagerSecret</code>
     * has the value of the AWS Secrets Manager secret that allows access to the SQL Server endpoint.
     * </p>
     * <note>
     * <p>
     * You can specify one of two sets of values for these permissions. You can specify the values for this setting and
     * <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for <code>UserName</code>,
     * <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
     * information on creating this <code>SecretsManagerSecret</code> and the <code>SecretsManagerAccessRoleArn</code>
     * and <code>SecretsManagerSecretId</code> required to access it, see <a href=
     * "https://docs.aws.amazon.com/https:/docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager"
     * >Using secrets to access AWS Database Migration Service resources</a> in the <i>AWS Database Migration Service
     * User Guide</i>.
     * </p>
     * </note>
     * 
     * @return The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and
     *         grants the required permissions to access the value in <code>SecretsManagerSecret</code>.
     *         <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access to
     *         the SQL Server endpoint.</p> <note>
     *         <p>
     *         You can specify one of two sets of values for these permissions. You can specify the values for this
     *         setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for
     *         <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can't
     *         specify both. For more information on creating this <code>SecretsManagerSecret</code> and the
     *         <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it,
     *         see <a href=
     *         "https://docs.aws.amazon.com/https:/docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager"
     *         >Using secrets to access AWS Database Migration Service resources</a> in the <i>AWS Database Migration
     *         Service User Guide</i>.
     *         </p>
     */
    public final String secretsManagerAccessRoleArn() {
        return secretsManagerAccessRoleArn;
    }

    /**
     * <p>
     * The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the SQL Server
     * endpoint connection details.
     * </p>
     * 
     * @return The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the
     *         SQL Server endpoint connection details.
     */
    public final String secretsManagerSecretId() {
        return secretsManagerSecretId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(bcpPacketSize());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(controlTablesFileGroup());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(readBackupOnly());
        hashCode = 31 * hashCode + Objects.hashCode(safeguardPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(useBcpFullLoad());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerSecretId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MicrosoftSQLServerSettings)) {
            return false;
        }
        MicrosoftSQLServerSettings other = (MicrosoftSQLServerSettings) obj;
        return Objects.equals(port(), other.port()) && Objects.equals(bcpPacketSize(), other.bcpPacketSize())
                && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(controlTablesFileGroup(), other.controlTablesFileGroup())
                && Objects.equals(password(), other.password()) && Objects.equals(readBackupOnly(), other.readBackupOnly())
                && Objects.equals(safeguardPolicyAsString(), other.safeguardPolicyAsString())
                && Objects.equals(serverName(), other.serverName()) && Objects.equals(username(), other.username())
                && Objects.equals(useBcpFullLoad(), other.useBcpFullLoad())
                && Objects.equals(secretsManagerAccessRoleArn(), other.secretsManagerAccessRoleArn())
                && Objects.equals(secretsManagerSecretId(), other.secretsManagerSecretId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MicrosoftSQLServerSettings").add("Port", port()).add("BcpPacketSize", bcpPacketSize())
                .add("DatabaseName", databaseName()).add("ControlTablesFileGroup", controlTablesFileGroup())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ReadBackupOnly", readBackupOnly()).add("SafeguardPolicy", safeguardPolicyAsString())
                .add("ServerName", serverName()).add("Username", username()).add("UseBcpFullLoad", useBcpFullLoad())
                .add("SecretsManagerAccessRoleArn", secretsManagerAccessRoleArn())
                .add("SecretsManagerSecretId", secretsManagerSecretId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "BcpPacketSize":
            return Optional.ofNullable(clazz.cast(bcpPacketSize()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "ControlTablesFileGroup":
            return Optional.ofNullable(clazz.cast(controlTablesFileGroup()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "ReadBackupOnly":
            return Optional.ofNullable(clazz.cast(readBackupOnly()));
        case "SafeguardPolicy":
            return Optional.ofNullable(clazz.cast(safeguardPolicyAsString()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "UseBcpFullLoad":
            return Optional.ofNullable(clazz.cast(useBcpFullLoad()));
        case "SecretsManagerAccessRoleArn":
            return Optional.ofNullable(clazz.cast(secretsManagerAccessRoleArn()));
        case "SecretsManagerSecretId":
            return Optional.ofNullable(clazz.cast(secretsManagerSecretId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MicrosoftSQLServerSettings, T> g) {
        return obj -> g.apply((MicrosoftSQLServerSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MicrosoftSQLServerSettings> {
        /**
         * <p>
         * Endpoint TCP port.
         * </p>
         * 
         * @param port
         *        Endpoint TCP port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The maximum size of the packets (in bytes) used to transfer data using BCP.
         * </p>
         * 
         * @param bcpPacketSize
         *        The maximum size of the packets (in bytes) used to transfer data using BCP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bcpPacketSize(Integer bcpPacketSize);

        /**
         * <p>
         * Database name for the endpoint.
         * </p>
         * 
         * @param databaseName
         *        Database name for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * Specifies a file group for the AWS DMS internal tables. When the replication task starts, all the internal
         * AWS DMS control tables (awsdms_ apply_exception, awsdms_apply, awsdms_changes) are created for the specified
         * file group.
         * </p>
         * 
         * @param controlTablesFileGroup
         *        Specifies a file group for the AWS DMS internal tables. When the replication task starts, all the
         *        internal AWS DMS control tables (awsdms_ apply_exception, awsdms_apply, awsdms_changes) are created
         *        for the specified file group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlTablesFileGroup(String controlTablesFileGroup);

        /**
         * <p>
         * Endpoint connection password.
         * </p>
         * 
         * @param password
         *        Endpoint connection password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * When this attribute is set to <code>Y</code>, AWS DMS only reads changes from transaction log backups and
         * doesn't read from the active transaction log file during ongoing replication. Setting this parameter to
         * <code>Y</code> enables you to control active transaction log file growth during full load and ongoing
         * replication tasks. However, it can add some source latency to ongoing replication.
         * </p>
         * 
         * @param readBackupOnly
         *        When this attribute is set to <code>Y</code>, AWS DMS only reads changes from transaction log backups
         *        and doesn't read from the active transaction log file during ongoing replication. Setting this
         *        parameter to <code>Y</code> enables you to control active transaction log file growth during full load
         *        and ongoing replication tasks. However, it can add some source latency to ongoing replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readBackupOnly(Boolean readBackupOnly);

        /**
         * <p>
         * Use this attribute to minimize the need to access the backup log and enable AWS DMS to prevent truncation
         * using one of the following two methods.
         * </p>
         * <p>
         * <i>Start transactions in the database:</i> This is the default method. When this method is used, AWS DMS
         * prevents TLOG truncation by mimicking a transaction in the database. As long as such a transaction is open,
         * changes that appear after the transaction started aren't truncated. If you need Microsoft Replication to be
         * enabled in your database, then you must choose this method.
         * </p>
         * <p>
         * <i>Exclusively use sp_repldone within a single task</i>: When this method is used, AWS DMS reads the changes
         * and then uses sp_repldone to mark the TLOG transactions as ready for truncation. Although this method doesn't
         * involve any transactional activities, it can only be used when Microsoft Replication isn't running. Also,
         * when using this method, only one AWS DMS task can access the database at any given time. Therefore, if you
         * need to run parallel AWS DMS tasks against the same database, use the default method.
         * </p>
         * 
         * @param safeguardPolicy
         *        Use this attribute to minimize the need to access the backup log and enable AWS DMS to prevent
         *        truncation using one of the following two methods.</p>
         *        <p>
         *        <i>Start transactions in the database:</i> This is the default method. When this method is used, AWS
         *        DMS prevents TLOG truncation by mimicking a transaction in the database. As long as such a transaction
         *        is open, changes that appear after the transaction started aren't truncated. If you need Microsoft
         *        Replication to be enabled in your database, then you must choose this method.
         *        </p>
         *        <p>
         *        <i>Exclusively use sp_repldone within a single task</i>: When this method is used, AWS DMS reads the
         *        changes and then uses sp_repldone to mark the TLOG transactions as ready for truncation. Although this
         *        method doesn't involve any transactional activities, it can only be used when Microsoft Replication
         *        isn't running. Also, when using this method, only one AWS DMS task can access the database at any
         *        given time. Therefore, if you need to run parallel AWS DMS tasks against the same database, use the
         *        default method.
         * @see SafeguardPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SafeguardPolicy
         */
        Builder safeguardPolicy(String safeguardPolicy);

        /**
         * <p>
         * Use this attribute to minimize the need to access the backup log and enable AWS DMS to prevent truncation
         * using one of the following two methods.
         * </p>
         * <p>
         * <i>Start transactions in the database:</i> This is the default method. When this method is used, AWS DMS
         * prevents TLOG truncation by mimicking a transaction in the database. As long as such a transaction is open,
         * changes that appear after the transaction started aren't truncated. If you need Microsoft Replication to be
         * enabled in your database, then you must choose this method.
         * </p>
         * <p>
         * <i>Exclusively use sp_repldone within a single task</i>: When this method is used, AWS DMS reads the changes
         * and then uses sp_repldone to mark the TLOG transactions as ready for truncation. Although this method doesn't
         * involve any transactional activities, it can only be used when Microsoft Replication isn't running. Also,
         * when using this method, only one AWS DMS task can access the database at any given time. Therefore, if you
         * need to run parallel AWS DMS tasks against the same database, use the default method.
         * </p>
         * 
         * @param safeguardPolicy
         *        Use this attribute to minimize the need to access the backup log and enable AWS DMS to prevent
         *        truncation using one of the following two methods.</p>
         *        <p>
         *        <i>Start transactions in the database:</i> This is the default method. When this method is used, AWS
         *        DMS prevents TLOG truncation by mimicking a transaction in the database. As long as such a transaction
         *        is open, changes that appear after the transaction started aren't truncated. If you need Microsoft
         *        Replication to be enabled in your database, then you must choose this method.
         *        </p>
         *        <p>
         *        <i>Exclusively use sp_repldone within a single task</i>: When this method is used, AWS DMS reads the
         *        changes and then uses sp_repldone to mark the TLOG transactions as ready for truncation. Although this
         *        method doesn't involve any transactional activities, it can only be used when Microsoft Replication
         *        isn't running. Also, when using this method, only one AWS DMS task can access the database at any
         *        given time. Therefore, if you need to run parallel AWS DMS tasks against the same database, use the
         *        default method.
         * @see SafeguardPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SafeguardPolicy
         */
        Builder safeguardPolicy(SafeguardPolicy safeguardPolicy);

        /**
         * <p>
         * Fully qualified domain name of the endpoint.
         * </p>
         * 
         * @param serverName
         *        Fully qualified domain name of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * Endpoint connection user name.
         * </p>
         * 
         * @param username
         *        Endpoint connection user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * Use this to attribute to transfer data for full-load operations using BCP. When the target table contains an
         * identity column that does not exist in the source table, you must disable the use BCP for loading table
         * option.
         * </p>
         * 
         * @param useBcpFullLoad
         *        Use this to attribute to transfer data for full-load operations using BCP. When the target table
         *        contains an identity column that does not exist in the source table, you must disable the use BCP for
         *        loading table option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useBcpFullLoad(Boolean useBcpFullLoad);

        /**
         * <p>
         * The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and grants
         * the required permissions to access the value in <code>SecretsManagerSecret</code>.
         * <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access to the
         * SQL Server endpoint.
         * </p>
         * <note>
         * <p>
         * You can specify one of two sets of values for these permissions. You can specify the values for this setting
         * and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for <code>UserName</code>,
         * <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
         * information on creating this <code>SecretsManagerSecret</code> and the
         * <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access it, see
         * <a href=
         * "https://docs.aws.amazon.com/https:/docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager"
         * >Using secrets to access AWS Database Migration Service resources</a> in the <i>AWS Database Migration
         * Service User Guide</i>.
         * </p>
         * </note>
         * 
         * @param secretsManagerAccessRoleArn
         *        The full Amazon Resource Name (ARN) of the IAM role that specifies AWS DMS as the trusted entity and
         *        grants the required permissions to access the value in <code>SecretsManagerSecret</code>.
         *        <code>SecretsManagerSecret</code> has the value of the AWS Secrets Manager secret that allows access
         *        to the SQL Server endpoint.</p> <note>
         *        <p>
         *        You can specify one of two sets of values for these permissions. You can specify the values for this
         *        setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text values for
         *        <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>. You
         *        can't specify both. For more information on creating this <code>SecretsManagerSecret</code> and the
         *        <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to access
         *        it, see <a href=
         *        "https://docs.aws.amazon.com/https:/docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager"
         *        >Using secrets to access AWS Database Migration Service resources</a> in the <i>AWS Database Migration
         *        Service User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn);

        /**
         * <p>
         * The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the SQL
         * Server endpoint connection details.
         * </p>
         * 
         * @param secretsManagerSecretId
         *        The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the
         *        SQL Server endpoint connection details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerSecretId(String secretsManagerSecretId);
    }

    static final class BuilderImpl implements Builder {
        private Integer port;

        private Integer bcpPacketSize;

        private String databaseName;

        private String controlTablesFileGroup;

        private String password;

        private Boolean readBackupOnly;

        private String safeguardPolicy;

        private String serverName;

        private String username;

        private Boolean useBcpFullLoad;

        private String secretsManagerAccessRoleArn;

        private String secretsManagerSecretId;

        private BuilderImpl() {
        }

        private BuilderImpl(MicrosoftSQLServerSettings model) {
            port(model.port);
            bcpPacketSize(model.bcpPacketSize);
            databaseName(model.databaseName);
            controlTablesFileGroup(model.controlTablesFileGroup);
            password(model.password);
            readBackupOnly(model.readBackupOnly);
            safeguardPolicy(model.safeguardPolicy);
            serverName(model.serverName);
            username(model.username);
            useBcpFullLoad(model.useBcpFullLoad);
            secretsManagerAccessRoleArn(model.secretsManagerAccessRoleArn);
            secretsManagerSecretId(model.secretsManagerSecretId);
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final Integer getBcpPacketSize() {
            return bcpPacketSize;
        }

        @Override
        public final Builder bcpPacketSize(Integer bcpPacketSize) {
            this.bcpPacketSize = bcpPacketSize;
            return this;
        }

        public final void setBcpPacketSize(Integer bcpPacketSize) {
            this.bcpPacketSize = bcpPacketSize;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getControlTablesFileGroup() {
            return controlTablesFileGroup;
        }

        @Override
        public final Builder controlTablesFileGroup(String controlTablesFileGroup) {
            this.controlTablesFileGroup = controlTablesFileGroup;
            return this;
        }

        public final void setControlTablesFileGroup(String controlTablesFileGroup) {
            this.controlTablesFileGroup = controlTablesFileGroup;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final Boolean getReadBackupOnly() {
            return readBackupOnly;
        }

        @Override
        public final Builder readBackupOnly(Boolean readBackupOnly) {
            this.readBackupOnly = readBackupOnly;
            return this;
        }

        public final void setReadBackupOnly(Boolean readBackupOnly) {
            this.readBackupOnly = readBackupOnly;
        }

        public final String getSafeguardPolicy() {
            return safeguardPolicy;
        }

        @Override
        public final Builder safeguardPolicy(String safeguardPolicy) {
            this.safeguardPolicy = safeguardPolicy;
            return this;
        }

        @Override
        public final Builder safeguardPolicy(SafeguardPolicy safeguardPolicy) {
            this.safeguardPolicy(safeguardPolicy == null ? null : safeguardPolicy.toString());
            return this;
        }

        public final void setSafeguardPolicy(String safeguardPolicy) {
            this.safeguardPolicy = safeguardPolicy;
        }

        public final String getServerName() {
            return serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final Boolean getUseBcpFullLoad() {
            return useBcpFullLoad;
        }

        @Override
        public final Builder useBcpFullLoad(Boolean useBcpFullLoad) {
            this.useBcpFullLoad = useBcpFullLoad;
            return this;
        }

        public final void setUseBcpFullLoad(Boolean useBcpFullLoad) {
            this.useBcpFullLoad = useBcpFullLoad;
        }

        public final String getSecretsManagerAccessRoleArn() {
            return secretsManagerAccessRoleArn;
        }

        @Override
        public final Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
            return this;
        }

        public final void setSecretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
        }

        public final String getSecretsManagerSecretId() {
            return secretsManagerSecretId;
        }

        @Override
        public final Builder secretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
            return this;
        }

        public final void setSecretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
        }

        @Override
        public MicrosoftSQLServerSettings build() {
            return new MicrosoftSQLServerSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
