/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that defines an Elasticsearch endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ElasticsearchSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ElasticsearchSettings.Builder, ElasticsearchSettings> {
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceAccessRoleArn").getter(getter(ElasticsearchSettings::serviceAccessRoleArn))
            .setter(setter(Builder::serviceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build())
            .build();

    private static final SdkField<String> ENDPOINT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointUri").getter(getter(ElasticsearchSettings::endpointUri)).setter(setter(Builder::endpointUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointUri").build()).build();

    private static final SdkField<Integer> FULL_LOAD_ERROR_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FullLoadErrorPercentage").getter(getter(ElasticsearchSettings::fullLoadErrorPercentage))
            .setter(setter(Builder::fullLoadErrorPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadErrorPercentage").build())
            .build();

    private static final SdkField<Integer> ERROR_RETRY_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ErrorRetryDuration").getter(getter(ElasticsearchSettings::errorRetryDuration))
            .setter(setter(Builder::errorRetryDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorRetryDuration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACCESS_ROLE_ARN_FIELD,
            ENDPOINT_URI_FIELD, FULL_LOAD_ERROR_PERCENTAGE_FIELD, ERROR_RETRY_DURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceAccessRoleArn;

    private final String endpointUri;

    private final Integer fullLoadErrorPercentage;

    private final Integer errorRetryDuration;

    private ElasticsearchSettings(BuilderImpl builder) {
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.endpointUri = builder.endpointUri;
        this.fullLoadErrorPercentage = builder.fullLoadErrorPercentage;
        this.errorRetryDuration = builder.errorRetryDuration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) used by service to access the IAM role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) used by service to access the IAM role.
     */
    public final String serviceAccessRoleArn() {
        return serviceAccessRoleArn;
    }

    /**
     * <p>
     * The endpoint for the Elasticsearch cluster. AWS DMS uses HTTPS if a transport protocol (http/https) is not
     * specified.
     * </p>
     * 
     * @return The endpoint for the Elasticsearch cluster. AWS DMS uses HTTPS if a transport protocol (http/https) is
     *         not specified.
     */
    public final String endpointUri() {
        return endpointUri;
    }

    /**
     * <p>
     * The maximum percentage of records that can fail to be written before a full load operation stops.
     * </p>
     * <p>
     * To avoid early failure, this counter is only effective after 1000 records are transferred. Elasticsearch also has
     * the concept of error monitoring during the last 10 minutes of an Observation Window. If transfer of all records
     * fail in the last 10 minutes, the full load operation stops.
     * </p>
     * 
     * @return The maximum percentage of records that can fail to be written before a full load operation stops.</p>
     *         <p>
     *         To avoid early failure, this counter is only effective after 1000 records are transferred. Elasticsearch
     *         also has the concept of error monitoring during the last 10 minutes of an Observation Window. If transfer
     *         of all records fail in the last 10 minutes, the full load operation stops.
     */
    public final Integer fullLoadErrorPercentage() {
        return fullLoadErrorPercentage;
    }

    /**
     * <p>
     * The maximum number of seconds for which DMS retries failed API requests to the Elasticsearch cluster.
     * </p>
     * 
     * @return The maximum number of seconds for which DMS retries failed API requests to the Elasticsearch cluster.
     */
    public final Integer errorRetryDuration() {
        return errorRetryDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointUri());
        hashCode = 31 * hashCode + Objects.hashCode(fullLoadErrorPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(errorRetryDuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchSettings)) {
            return false;
        }
        ElasticsearchSettings other = (ElasticsearchSettings) obj;
        return Objects.equals(serviceAccessRoleArn(), other.serviceAccessRoleArn())
                && Objects.equals(endpointUri(), other.endpointUri())
                && Objects.equals(fullLoadErrorPercentage(), other.fullLoadErrorPercentage())
                && Objects.equals(errorRetryDuration(), other.errorRetryDuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ElasticsearchSettings").add("ServiceAccessRoleArn", serviceAccessRoleArn())
                .add("EndpointUri", endpointUri()).add("FullLoadErrorPercentage", fullLoadErrorPercentage())
                .add("ErrorRetryDuration", errorRetryDuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(serviceAccessRoleArn()));
        case "EndpointUri":
            return Optional.ofNullable(clazz.cast(endpointUri()));
        case "FullLoadErrorPercentage":
            return Optional.ofNullable(clazz.cast(fullLoadErrorPercentage()));
        case "ErrorRetryDuration":
            return Optional.ofNullable(clazz.cast(errorRetryDuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticsearchSettings, T> g) {
        return obj -> g.apply((ElasticsearchSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ElasticsearchSettings> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) used by service to access the IAM role.
         * </p>
         * 
         * @param serviceAccessRoleArn
         *        The Amazon Resource Name (ARN) used by service to access the IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccessRoleArn(String serviceAccessRoleArn);

        /**
         * <p>
         * The endpoint for the Elasticsearch cluster. AWS DMS uses HTTPS if a transport protocol (http/https) is not
         * specified.
         * </p>
         * 
         * @param endpointUri
         *        The endpoint for the Elasticsearch cluster. AWS DMS uses HTTPS if a transport protocol (http/https) is
         *        not specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointUri(String endpointUri);

        /**
         * <p>
         * The maximum percentage of records that can fail to be written before a full load operation stops.
         * </p>
         * <p>
         * To avoid early failure, this counter is only effective after 1000 records are transferred. Elasticsearch also
         * has the concept of error monitoring during the last 10 minutes of an Observation Window. If transfer of all
         * records fail in the last 10 minutes, the full load operation stops.
         * </p>
         * 
         * @param fullLoadErrorPercentage
         *        The maximum percentage of records that can fail to be written before a full load operation stops.</p>
         *        <p>
         *        To avoid early failure, this counter is only effective after 1000 records are transferred.
         *        Elasticsearch also has the concept of error monitoring during the last 10 minutes of an Observation
         *        Window. If transfer of all records fail in the last 10 minutes, the full load operation stops.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullLoadErrorPercentage(Integer fullLoadErrorPercentage);

        /**
         * <p>
         * The maximum number of seconds for which DMS retries failed API requests to the Elasticsearch cluster.
         * </p>
         * 
         * @param errorRetryDuration
         *        The maximum number of seconds for which DMS retries failed API requests to the Elasticsearch cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorRetryDuration(Integer errorRetryDuration);
    }

    static final class BuilderImpl implements Builder {
        private String serviceAccessRoleArn;

        private String endpointUri;

        private Integer fullLoadErrorPercentage;

        private Integer errorRetryDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchSettings model) {
            serviceAccessRoleArn(model.serviceAccessRoleArn);
            endpointUri(model.endpointUri);
            fullLoadErrorPercentage(model.fullLoadErrorPercentage);
            errorRetryDuration(model.errorRetryDuration);
        }

        public final String getServiceAccessRoleArn() {
            return serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        public final String getEndpointUri() {
            return endpointUri;
        }

        @Override
        public final Builder endpointUri(String endpointUri) {
            this.endpointUri = endpointUri;
            return this;
        }

        public final void setEndpointUri(String endpointUri) {
            this.endpointUri = endpointUri;
        }

        public final Integer getFullLoadErrorPercentage() {
            return fullLoadErrorPercentage;
        }

        @Override
        public final Builder fullLoadErrorPercentage(Integer fullLoadErrorPercentage) {
            this.fullLoadErrorPercentage = fullLoadErrorPercentage;
            return this;
        }

        public final void setFullLoadErrorPercentage(Integer fullLoadErrorPercentage) {
            this.fullLoadErrorPercentage = fullLoadErrorPercentage;
        }

        public final Integer getErrorRetryDuration() {
            return errorRetryDuration;
        }

        @Override
        public final Builder errorRetryDuration(Integer errorRetryDuration) {
            this.errorRetryDuration = errorRetryDuration;
            return this;
        }

        public final void setErrorRetryDuration(Integer errorRetryDuration) {
            this.errorRetryDuration = errorRetryDuration;
        }

        @Override
        public ElasticsearchSettings build() {
            return new ElasticsearchSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
