/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEndpointsResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DescribeEndpointsResponse.Builder, DescribeEndpointsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeEndpointsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<Endpoint>> ENDPOINTS_FIELD = SdkField
            .<List<Endpoint>> builder(MarshallingType.LIST)
            .memberName("Endpoints")
            .getter(getter(DescribeEndpointsResponse::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(Endpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(MARKER_FIELD, ENDPOINTS_FIELD));

    private final String marker;

    private final List<Endpoint> endpoints;

    private DescribeEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.endpoints = builder.endpoints;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * Returns true if the Endpoints property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Endpoint description.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEndpoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Endpoint description.
     */
    public final List<Endpoint> endpoints() {
        return endpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpoints() ? endpoints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointsResponse)) {
            return false;
        }
        DescribeEndpointsResponse other = (DescribeEndpointsResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasEndpoints() == other.hasEndpoints()
                && Objects.equals(endpoints(), other.endpoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEndpointsResponse").add("Marker", marker())
                .add("Endpoints", hasEndpoints() ? endpoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "Endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEndpointsResponse, T> g) {
        return obj -> g.apply((DescribeEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEndpointsResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Endpoint description.
         * </p>
         * 
         * @param endpoints
         *        Endpoint description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Collection<Endpoint> endpoints);

        /**
         * <p>
         * Endpoint description.
         * </p>
         * 
         * @param endpoints
         *        Endpoint description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Endpoint... endpoints);

        /**
         * <p>
         * Endpoint description.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Endpoint>.Builder} avoiding the need to
         * create one manually via {@link List<Endpoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Endpoint>.Builder#build()} is called immediately and its
         * result is passed to {@link #endpoints(List<Endpoint>)}.
         * 
         * @param endpoints
         *        a consumer that will call methods on {@link List<Endpoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoints(List<Endpoint>)
         */
        Builder endpoints(Consumer<Endpoint.Builder>... endpoints);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private String marker;

        private List<Endpoint> endpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointsResponse model) {
            super(model);
            marker(model.marker);
            endpoints(model.endpoints);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Endpoint.Builder> getEndpoints() {
            if (endpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return endpoints != null ? endpoints.stream().map(Endpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder endpoints(Collection<Endpoint> endpoints) {
            this.endpoints = EndpointListCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Endpoint... endpoints) {
            endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<Endpoint.Builder>... endpoints) {
            endpoints(Stream.of(endpoints).map(c -> Endpoint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndpoints(Collection<Endpoint.BuilderImpl> endpoints) {
            this.endpoints = EndpointListCopier.copyFromBuilder(endpoints);
        }

        @Override
        public DescribeEndpointsResponse build() {
            return new DescribeEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
