/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SSL certificate that can be used to encrypt connections between the endpoints and the replication instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Certificate implements SdkPojo, Serializable, ToCopyableBuilder<Certificate.Builder, Certificate> {
    private static final SdkField<String> CERTIFICATE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateIdentifier").getter(getter(Certificate::certificateIdentifier))
            .setter(setter(Builder::certificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateIdentifier").build())
            .build();

    private static final SdkField<Instant> CERTIFICATE_CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CertificateCreationDate").getter(getter(Certificate::certificateCreationDate))
            .setter(setter(Builder::certificateCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateCreationDate").build())
            .build();

    private static final SdkField<String> CERTIFICATE_PEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificatePem").getter(getter(Certificate::certificatePem)).setter(setter(Builder::certificatePem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificatePem").build()).build();

    private static final SdkField<SdkBytes> CERTIFICATE_WALLET_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("CertificateWallet").getter(getter(Certificate::certificateWallet))
            .setter(setter(Builder::certificateWallet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateWallet").build()).build();

    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateArn").getter(getter(Certificate::certificateArn)).setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()).build();

    private static final SdkField<String> CERTIFICATE_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateOwner").getter(getter(Certificate::certificateOwner))
            .setter(setter(Builder::certificateOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateOwner").build()).build();

    private static final SdkField<Instant> VALID_FROM_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ValidFromDate").getter(getter(Certificate::validFromDate)).setter(setter(Builder::validFromDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidFromDate").build()).build();

    private static final SdkField<Instant> VALID_TO_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ValidToDate").getter(getter(Certificate::validToDate)).setter(setter(Builder::validToDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidToDate").build()).build();

    private static final SdkField<String> SIGNING_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SigningAlgorithm").getter(getter(Certificate::signingAlgorithm))
            .setter(setter(Builder::signingAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAlgorithm").build()).build();

    private static final SdkField<Integer> KEY_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("KeyLength").getter(getter(Certificate::keyLength)).setter(setter(Builder::keyLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyLength").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_IDENTIFIER_FIELD,
            CERTIFICATE_CREATION_DATE_FIELD, CERTIFICATE_PEM_FIELD, CERTIFICATE_WALLET_FIELD, CERTIFICATE_ARN_FIELD,
            CERTIFICATE_OWNER_FIELD, VALID_FROM_DATE_FIELD, VALID_TO_DATE_FIELD, SIGNING_ALGORITHM_FIELD, KEY_LENGTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String certificateIdentifier;

    private final Instant certificateCreationDate;

    private final String certificatePem;

    private final SdkBytes certificateWallet;

    private final String certificateArn;

    private final String certificateOwner;

    private final Instant validFromDate;

    private final Instant validToDate;

    private final String signingAlgorithm;

    private final Integer keyLength;

    private Certificate(BuilderImpl builder) {
        this.certificateIdentifier = builder.certificateIdentifier;
        this.certificateCreationDate = builder.certificateCreationDate;
        this.certificatePem = builder.certificatePem;
        this.certificateWallet = builder.certificateWallet;
        this.certificateArn = builder.certificateArn;
        this.certificateOwner = builder.certificateOwner;
        this.validFromDate = builder.validFromDate;
        this.validToDate = builder.validToDate;
        this.signingAlgorithm = builder.signingAlgorithm;
        this.keyLength = builder.keyLength;
    }

    /**
     * <p>
     * A customer-assigned name for the certificate. Identifiers must begin with a letter and must contain only ASCII
     * letters, digits, and hyphens. They can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * 
     * @return A customer-assigned name for the certificate. Identifiers must begin with a letter and must contain only
     *         ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two consecutive hyphens.
     */
    public final String certificateIdentifier() {
        return certificateIdentifier;
    }

    /**
     * <p>
     * The date that the certificate was created.
     * </p>
     * 
     * @return The date that the certificate was created.
     */
    public final Instant certificateCreationDate() {
        return certificateCreationDate;
    }

    /**
     * <p>
     * The contents of a <code>.pem</code> file, which contains an X.509 certificate.
     * </p>
     * 
     * @return The contents of a <code>.pem</code> file, which contains an X.509 certificate.
     */
    public final String certificatePem() {
        return certificatePem;
    }

    /**
     * <p>
     * The location of an imported Oracle Wallet certificate for use with SSL.
     * </p>
     * 
     * @return The location of an imported Oracle Wallet certificate for use with SSL.
     */
    public final SdkBytes certificateWallet() {
        return certificateWallet;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the certificate.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the certificate.
     */
    public final String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The owner of the certificate.
     * </p>
     * 
     * @return The owner of the certificate.
     */
    public final String certificateOwner() {
        return certificateOwner;
    }

    /**
     * <p>
     * The beginning date that the certificate is valid.
     * </p>
     * 
     * @return The beginning date that the certificate is valid.
     */
    public final Instant validFromDate() {
        return validFromDate;
    }

    /**
     * <p>
     * The final date that the certificate is valid.
     * </p>
     * 
     * @return The final date that the certificate is valid.
     */
    public final Instant validToDate() {
        return validToDate;
    }

    /**
     * <p>
     * The signing algorithm for the certificate.
     * </p>
     * 
     * @return The signing algorithm for the certificate.
     */
    public final String signingAlgorithm() {
        return signingAlgorithm;
    }

    /**
     * <p>
     * The key length of the cryptographic algorithm being used.
     * </p>
     * 
     * @return The key length of the cryptographic algorithm being used.
     */
    public final Integer keyLength() {
        return keyLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(certificateCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(certificateWallet());
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateOwner());
        hashCode = 31 * hashCode + Objects.hashCode(validFromDate());
        hashCode = 31 * hashCode + Objects.hashCode(validToDate());
        hashCode = 31 * hashCode + Objects.hashCode(signingAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(keyLength());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate) obj;
        return Objects.equals(certificateIdentifier(), other.certificateIdentifier())
                && Objects.equals(certificateCreationDate(), other.certificateCreationDate())
                && Objects.equals(certificatePem(), other.certificatePem())
                && Objects.equals(certificateWallet(), other.certificateWallet())
                && Objects.equals(certificateArn(), other.certificateArn())
                && Objects.equals(certificateOwner(), other.certificateOwner())
                && Objects.equals(validFromDate(), other.validFromDate()) && Objects.equals(validToDate(), other.validToDate())
                && Objects.equals(signingAlgorithm(), other.signingAlgorithm()) && Objects.equals(keyLength(), other.keyLength());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Certificate").add("CertificateIdentifier", certificateIdentifier())
                .add("CertificateCreationDate", certificateCreationDate()).add("CertificatePem", certificatePem())
                .add("CertificateWallet", certificateWallet()).add("CertificateArn", certificateArn())
                .add("CertificateOwner", certificateOwner()).add("ValidFromDate", validFromDate())
                .add("ValidToDate", validToDate()).add("SigningAlgorithm", signingAlgorithm()).add("KeyLength", keyLength())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateIdentifier":
            return Optional.ofNullable(clazz.cast(certificateIdentifier()));
        case "CertificateCreationDate":
            return Optional.ofNullable(clazz.cast(certificateCreationDate()));
        case "CertificatePem":
            return Optional.ofNullable(clazz.cast(certificatePem()));
        case "CertificateWallet":
            return Optional.ofNullable(clazz.cast(certificateWallet()));
        case "CertificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "CertificateOwner":
            return Optional.ofNullable(clazz.cast(certificateOwner()));
        case "ValidFromDate":
            return Optional.ofNullable(clazz.cast(validFromDate()));
        case "ValidToDate":
            return Optional.ofNullable(clazz.cast(validToDate()));
        case "SigningAlgorithm":
            return Optional.ofNullable(clazz.cast(signingAlgorithm()));
        case "KeyLength":
            return Optional.ofNullable(clazz.cast(keyLength()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Certificate, T> g) {
        return obj -> g.apply((Certificate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Certificate> {
        /**
         * <p>
         * A customer-assigned name for the certificate. Identifiers must begin with a letter and must contain only
         * ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two consecutive hyphens.
         * </p>
         * 
         * @param certificateIdentifier
         *        A customer-assigned name for the certificate. Identifiers must begin with a letter and must contain
         *        only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two consecutive
         *        hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateIdentifier(String certificateIdentifier);

        /**
         * <p>
         * The date that the certificate was created.
         * </p>
         * 
         * @param certificateCreationDate
         *        The date that the certificate was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateCreationDate(Instant certificateCreationDate);

        /**
         * <p>
         * The contents of a <code>.pem</code> file, which contains an X.509 certificate.
         * </p>
         * 
         * @param certificatePem
         *        The contents of a <code>.pem</code> file, which contains an X.509 certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePem(String certificatePem);

        /**
         * <p>
         * The location of an imported Oracle Wallet certificate for use with SSL.
         * </p>
         * 
         * @param certificateWallet
         *        The location of an imported Oracle Wallet certificate for use with SSL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateWallet(SdkBytes certificateWallet);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the certificate.
         * </p>
         * 
         * @param certificateArn
         *        The Amazon Resource Name (ARN) for the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The owner of the certificate.
         * </p>
         * 
         * @param certificateOwner
         *        The owner of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateOwner(String certificateOwner);

        /**
         * <p>
         * The beginning date that the certificate is valid.
         * </p>
         * 
         * @param validFromDate
         *        The beginning date that the certificate is valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validFromDate(Instant validFromDate);

        /**
         * <p>
         * The final date that the certificate is valid.
         * </p>
         * 
         * @param validToDate
         *        The final date that the certificate is valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validToDate(Instant validToDate);

        /**
         * <p>
         * The signing algorithm for the certificate.
         * </p>
         * 
         * @param signingAlgorithm
         *        The signing algorithm for the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingAlgorithm(String signingAlgorithm);

        /**
         * <p>
         * The key length of the cryptographic algorithm being used.
         * </p>
         * 
         * @param keyLength
         *        The key length of the cryptographic algorithm being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyLength(Integer keyLength);
    }

    static final class BuilderImpl implements Builder {
        private String certificateIdentifier;

        private Instant certificateCreationDate;

        private String certificatePem;

        private SdkBytes certificateWallet;

        private String certificateArn;

        private String certificateOwner;

        private Instant validFromDate;

        private Instant validToDate;

        private String signingAlgorithm;

        private Integer keyLength;

        private BuilderImpl() {
        }

        private BuilderImpl(Certificate model) {
            certificateIdentifier(model.certificateIdentifier);
            certificateCreationDate(model.certificateCreationDate);
            certificatePem(model.certificatePem);
            certificateWallet(model.certificateWallet);
            certificateArn(model.certificateArn);
            certificateOwner(model.certificateOwner);
            validFromDate(model.validFromDate);
            validToDate(model.validToDate);
            signingAlgorithm(model.signingAlgorithm);
            keyLength(model.keyLength);
        }

        public final String getCertificateIdentifier() {
            return certificateIdentifier;
        }

        @Override
        public final Builder certificateIdentifier(String certificateIdentifier) {
            this.certificateIdentifier = certificateIdentifier;
            return this;
        }

        public final void setCertificateIdentifier(String certificateIdentifier) {
            this.certificateIdentifier = certificateIdentifier;
        }

        public final Instant getCertificateCreationDate() {
            return certificateCreationDate;
        }

        @Override
        public final Builder certificateCreationDate(Instant certificateCreationDate) {
            this.certificateCreationDate = certificateCreationDate;
            return this;
        }

        public final void setCertificateCreationDate(Instant certificateCreationDate) {
            this.certificateCreationDate = certificateCreationDate;
        }

        public final String getCertificatePem() {
            return certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final ByteBuffer getCertificateWallet() {
            return certificateWallet == null ? null : certificateWallet.asByteBuffer();
        }

        @Override
        public final Builder certificateWallet(SdkBytes certificateWallet) {
            this.certificateWallet = StandardMemberCopier.copy(certificateWallet);
            return this;
        }

        public final void setCertificateWallet(ByteBuffer certificateWallet) {
            certificateWallet(certificateWallet == null ? null : SdkBytes.fromByteBuffer(certificateWallet));
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateOwner() {
            return certificateOwner;
        }

        @Override
        public final Builder certificateOwner(String certificateOwner) {
            this.certificateOwner = certificateOwner;
            return this;
        }

        public final void setCertificateOwner(String certificateOwner) {
            this.certificateOwner = certificateOwner;
        }

        public final Instant getValidFromDate() {
            return validFromDate;
        }

        @Override
        public final Builder validFromDate(Instant validFromDate) {
            this.validFromDate = validFromDate;
            return this;
        }

        public final void setValidFromDate(Instant validFromDate) {
            this.validFromDate = validFromDate;
        }

        public final Instant getValidToDate() {
            return validToDate;
        }

        @Override
        public final Builder validToDate(Instant validToDate) {
            this.validToDate = validToDate;
            return this;
        }

        public final void setValidToDate(Instant validToDate) {
            this.validToDate = validToDate;
        }

        public final String getSigningAlgorithm() {
            return signingAlgorithm;
        }

        @Override
        public final Builder signingAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        public final void setSigningAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
        }

        public final Integer getKeyLength() {
            return keyLength;
        }

        @Override
        public final Builder keyLength(Integer keyLength) {
            this.keyLength = keyLength;
            return this;
        }

        public final void setKeyLength(Integer keyLength) {
            this.keyLength = keyLength;
        }

        @Override
        public Certificate build() {
            return new Certificate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
