/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.EndpointSetting;
import software.amazon.awssdk.services.databasemigration.model.EndpointSettingsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEndpointSettingsResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeEndpointSettingsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeEndpointSettingsResponse.getter(DescribeEndpointSettingsResponse::marker)).setter(DescribeEndpointSettingsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<EndpointSetting>> ENDPOINT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndpointSettings").getter(DescribeEndpointSettingsResponse.getter(DescribeEndpointSettingsResponse::endpointSettings)).setter(DescribeEndpointSettingsResponse.setter(Builder::endpointSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EndpointSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, ENDPOINT_SETTINGS_FIELD));
    private final String marker;
    private final List<EndpointSetting> endpointSettings;

    private DescribeEndpointSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.endpointSettings = builder.endpointSettings;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasEndpointSettings() {
        return this.endpointSettings != null && !(this.endpointSettings instanceof SdkAutoConstructList);
    }

    public final List<EndpointSetting> endpointSettings() {
        return this.endpointSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpointSettings() ? this.endpointSettings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointSettingsResponse)) {
            return false;
        }
        DescribeEndpointSettingsResponse other = (DescribeEndpointSettingsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasEndpointSettings() == other.hasEndpointSettings() && Objects.equals(this.endpointSettings(), other.endpointSettings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEndpointSettingsResponse").add("Marker", (Object)this.marker()).add("EndpointSettings", this.hasEndpointSettings() ? this.endpointSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "EndpointSettings": {
                return Optional.ofNullable(clazz.cast(this.endpointSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEndpointSettingsResponse, T> g) {
        return obj -> g.apply((DescribeEndpointSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<EndpointSetting> endpointSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointSettingsResponse model) {
            super(model);
            this.marker(model.marker);
            this.endpointSettings(model.endpointSettings);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final List<EndpointSetting.Builder> getEndpointSettings() {
            List<EndpointSetting.Builder> result = EndpointSettingsListCopier.copyToBuilder(this.endpointSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder endpointSettings(Collection<EndpointSetting> endpointSettings) {
            this.endpointSettings = EndpointSettingsListCopier.copy(endpointSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointSettings(EndpointSetting ... endpointSettings) {
            this.endpointSettings(Arrays.asList(endpointSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointSettings(Consumer<EndpointSetting.Builder> ... endpointSettings) {
            this.endpointSettings(Stream.of(endpointSettings).map(c -> (EndpointSetting)((EndpointSetting.Builder)EndpointSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEndpointSettings(Collection<EndpointSetting.BuilderImpl> endpointSettings) {
            this.endpointSettings = EndpointSettingsListCopier.copyFromBuilder(endpointSettings);
        }

        @Override
        public DescribeEndpointSettingsResponse build() {
            return new DescribeEndpointSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEndpointSettingsResponse> {
        public Builder marker(String var1);

        public Builder endpointSettings(Collection<EndpointSetting> var1);

        public Builder endpointSettings(EndpointSetting ... var1);

        public Builder endpointSettings(Consumer<EndpointSetting.Builder> ... var1);
    }
}

