/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IBMDb2Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IBMDb2Settings> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(IBMDb2Settings.getter(IBMDb2Settings::databaseName)).setter(IBMDb2Settings.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(IBMDb2Settings.getter(IBMDb2Settings::password)).setter(IBMDb2Settings.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(IBMDb2Settings.getter(IBMDb2Settings::port)).setter(IBMDb2Settings.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(IBMDb2Settings.getter(IBMDb2Settings::serverName)).setter(IBMDb2Settings.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<Boolean> SET_DATA_CAPTURE_CHANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SetDataCaptureChanges").getter(IBMDb2Settings.getter(IBMDb2Settings::setDataCaptureChanges)).setter(IBMDb2Settings.setter(Builder::setDataCaptureChanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SetDataCaptureChanges").build()}).build();
    private static final SdkField<String> CURRENT_LSN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentLsn").getter(IBMDb2Settings.getter(IBMDb2Settings::currentLsn)).setter(IBMDb2Settings.setter(Builder::currentLsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentLsn").build()}).build();
    private static final SdkField<Integer> MAX_K_BYTES_PER_READ_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxKBytesPerRead").getter(IBMDb2Settings.getter(IBMDb2Settings::maxKBytesPerRead)).setter(IBMDb2Settings.setter(Builder::maxKBytesPerRead)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxKBytesPerRead").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(IBMDb2Settings.getter(IBMDb2Settings::username)).setter(IBMDb2Settings.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD, PASSWORD_FIELD, PORT_FIELD, SERVER_NAME_FIELD, SET_DATA_CAPTURE_CHANGES_FIELD, CURRENT_LSN_FIELD, MAX_K_BYTES_PER_READ_FIELD, USERNAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final String password;
    private final Integer port;
    private final String serverName;
    private final Boolean setDataCaptureChanges;
    private final String currentLsn;
    private final Integer maxKBytesPerRead;
    private final String username;

    private IBMDb2Settings(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.password = builder.password;
        this.port = builder.port;
        this.serverName = builder.serverName;
        this.setDataCaptureChanges = builder.setDataCaptureChanges;
        this.currentLsn = builder.currentLsn;
        this.maxKBytesPerRead = builder.maxKBytesPerRead;
        this.username = builder.username;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String password() {
        return this.password;
    }

    public Integer port() {
        return this.port;
    }

    public String serverName() {
        return this.serverName;
    }

    public Boolean setDataCaptureChanges() {
        return this.setDataCaptureChanges;
    }

    public String currentLsn() {
        return this.currentLsn;
    }

    public Integer maxKBytesPerRead() {
        return this.maxKBytesPerRead;
    }

    public String username() {
        return this.username;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.setDataCaptureChanges());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentLsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxKBytesPerRead());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IBMDb2Settings)) {
            return false;
        }
        IBMDb2Settings other = (IBMDb2Settings)obj;
        return Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.setDataCaptureChanges(), other.setDataCaptureChanges()) && Objects.equals(this.currentLsn(), other.currentLsn()) && Objects.equals(this.maxKBytesPerRead(), other.maxKBytesPerRead()) && Objects.equals(this.username(), other.username());
    }

    public String toString() {
        return ToString.builder((String)"IBMDb2Settings").add("DatabaseName", (Object)this.databaseName()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("Port", (Object)this.port()).add("ServerName", (Object)this.serverName()).add("SetDataCaptureChanges", (Object)this.setDataCaptureChanges()).add("CurrentLsn", (Object)this.currentLsn()).add("MaxKBytesPerRead", (Object)this.maxKBytesPerRead()).add("Username", (Object)this.username()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "SetDataCaptureChanges": {
                return Optional.ofNullable(clazz.cast(this.setDataCaptureChanges()));
            }
            case "CurrentLsn": {
                return Optional.ofNullable(clazz.cast(this.currentLsn()));
            }
            case "MaxKBytesPerRead": {
                return Optional.ofNullable(clazz.cast(this.maxKBytesPerRead()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IBMDb2Settings, T> g) {
        return obj -> g.apply((IBMDb2Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseName;
        private String password;
        private Integer port;
        private String serverName;
        private Boolean setDataCaptureChanges;
        private String currentLsn;
        private Integer maxKBytesPerRead;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(IBMDb2Settings model) {
            this.databaseName(model.databaseName);
            this.password(model.password);
            this.port(model.port);
            this.serverName(model.serverName);
            this.setDataCaptureChanges(model.setDataCaptureChanges);
            this.currentLsn(model.currentLsn);
            this.maxKBytesPerRead(model.maxKBytesPerRead);
            this.username(model.username);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final Boolean getSetDataCaptureChanges() {
            return this.setDataCaptureChanges;
        }

        @Override
        public final Builder setDataCaptureChanges(Boolean setDataCaptureChanges) {
            this.setDataCaptureChanges = setDataCaptureChanges;
            return this;
        }

        public final void setSetDataCaptureChanges(Boolean setDataCaptureChanges) {
            this.setDataCaptureChanges = setDataCaptureChanges;
        }

        public final String getCurrentLsn() {
            return this.currentLsn;
        }

        @Override
        public final Builder currentLsn(String currentLsn) {
            this.currentLsn = currentLsn;
            return this;
        }

        public final void setCurrentLsn(String currentLsn) {
            this.currentLsn = currentLsn;
        }

        public final Integer getMaxKBytesPerRead() {
            return this.maxKBytesPerRead;
        }

        @Override
        public final Builder maxKBytesPerRead(Integer maxKBytesPerRead) {
            this.maxKBytesPerRead = maxKBytesPerRead;
            return this;
        }

        public final void setMaxKBytesPerRead(Integer maxKBytesPerRead) {
            this.maxKBytesPerRead = maxKBytesPerRead;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public IBMDb2Settings build() {
            return new IBMDb2Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IBMDb2Settings> {
        public Builder databaseName(String var1);

        public Builder password(String var1);

        public Builder port(Integer var1);

        public Builder serverName(String var1);

        public Builder setDataCaptureChanges(Boolean var1);

        public Builder currentLsn(String var1);

        public Builder maxKBytesPerRead(Integer var1);

        public Builder username(String var1);
    }
}

