/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.Tag;
import software.amazon.awssdk.services.databasemigration.model.TagListCopier;
import software.amazon.awssdk.services.databasemigration.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReplicationInstanceRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, CreateReplicationInstanceRequest> {
    private static final SdkField<String> REPLICATION_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationInstanceIdentifier").getter(CreateReplicationInstanceRequest.getter(CreateReplicationInstanceRequest::replicationInstanceIdentifier)).setter(CreateReplicationInstanceRequest.setter(Builder::replicationInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceIdentifier").build()}).build();
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedStorage").getter(CreateReplicationInstanceRequest.getter(CreateReplicationInstanceRequest::allocatedStorage)).setter(CreateReplicationInstanceRequest.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()}).build();
    private static final SdkField<String> REPLICATION_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationInstanceClass").getter(CreateReplicationInstanceRequest.getter(CreateReplicationInstanceRequest::replicationInstanceClass)).setter(CreateReplicationInstanceRequest.setter(Builder::replicationInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceClass").build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroupIds").getter(CreateReplicationInstanceRequest.getter(CreateReplicationInstanceRequest::vpcSecurityGroupIds)).setter(CreateReplicationInstanceRequest.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(CreateReplicationInstanceRequest.getter(CreateReplicationInstanceRequest::availabilityZone)).setter(CreateReplicationInstanceRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> REPLICATION_SUBNET_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationSubnetGroupIdentifier").getter(CreateReplicationInstanceRequest.getter(CreateReplicationInstanceRequest::replicationSubnetGroupIdentifier)).setter(CreateReplicationInstanceRequest.setter(Builder::replicationSubnetGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSubnetGroupIdentifier").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(CreateReplicationInstanceRequest.getter(CreateReplicationInstanceRequest::preferredMaintenanceWindow)).setter(CreateReplicationInstanceRequest.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiAZ").getter(CreateReplicationInstanceRequest.getter(CreateReplicationInstanceRequest::multiAZ)).setter(CreateReplicationInstanceRequest.setter(Builder::multiAZ)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(CreateReplicationInstanceRequest.getter(CreateReplicationInstanceRequest::engineVersion)).setter(CreateReplicationInstanceRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(CreateReplicationInstanceRequest.getter(CreateReplicationInstanceRequest::autoMinorVersionUpgrade)).setter(CreateReplicationInstanceRequest.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateReplicationInstanceRequest.getter(CreateReplicationInstanceRequest::tags)).setter(CreateReplicationInstanceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateReplicationInstanceRequest.getter(CreateReplicationInstanceRequest::kmsKeyId)).setter(CreateReplicationInstanceRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAccessible").getter(CreateReplicationInstanceRequest.getter(CreateReplicationInstanceRequest::publiclyAccessible)).setter(CreateReplicationInstanceRequest.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build()}).build();
    private static final SdkField<String> DNS_NAME_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsNameServers").getter(CreateReplicationInstanceRequest.getter(CreateReplicationInstanceRequest::dnsNameServers)).setter(CreateReplicationInstanceRequest.setter(Builder::dnsNameServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsNameServers").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_INSTANCE_IDENTIFIER_FIELD, ALLOCATED_STORAGE_FIELD, REPLICATION_INSTANCE_CLASS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, AVAILABILITY_ZONE_FIELD, REPLICATION_SUBNET_GROUP_IDENTIFIER_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, MULTI_AZ_FIELD, ENGINE_VERSION_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, TAGS_FIELD, KMS_KEY_ID_FIELD, PUBLICLY_ACCESSIBLE_FIELD, DNS_NAME_SERVERS_FIELD));
    private final String replicationInstanceIdentifier;
    private final Integer allocatedStorage;
    private final String replicationInstanceClass;
    private final List<String> vpcSecurityGroupIds;
    private final String availabilityZone;
    private final String replicationSubnetGroupIdentifier;
    private final String preferredMaintenanceWindow;
    private final Boolean multiAZ;
    private final String engineVersion;
    private final Boolean autoMinorVersionUpgrade;
    private final List<Tag> tags;
    private final String kmsKeyId;
    private final Boolean publiclyAccessible;
    private final String dnsNameServers;

    private CreateReplicationInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.replicationInstanceIdentifier = builder.replicationInstanceIdentifier;
        this.allocatedStorage = builder.allocatedStorage;
        this.replicationInstanceClass = builder.replicationInstanceClass;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.availabilityZone = builder.availabilityZone;
        this.replicationSubnetGroupIdentifier = builder.replicationSubnetGroupIdentifier;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.dnsNameServers = builder.dnsNameServers;
    }

    public String replicationInstanceIdentifier() {
        return this.replicationInstanceIdentifier;
    }

    public Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public String replicationInstanceClass() {
        return this.replicationInstanceClass;
    }

    public boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String replicationSubnetGroupIdentifier() {
        return this.replicationSubnetGroupIdentifier;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public Boolean multiAZ() {
        return this.multiAZ;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public String dnsNameServers() {
        return this.dnsNameServers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationSubnetGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsNameServers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationInstanceRequest)) {
            return false;
        }
        CreateReplicationInstanceRequest other = (CreateReplicationInstanceRequest)((Object)obj);
        return Objects.equals(this.replicationInstanceIdentifier(), other.replicationInstanceIdentifier()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.replicationInstanceClass(), other.replicationInstanceClass()) && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.replicationSubnetGroupIdentifier(), other.replicationSubnetGroupIdentifier()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.dnsNameServers(), other.dnsNameServers());
    }

    public String toString() {
        return ToString.builder((String)"CreateReplicationInstanceRequest").add("ReplicationInstanceIdentifier", (Object)this.replicationInstanceIdentifier()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("ReplicationInstanceClass", (Object)this.replicationInstanceClass()).add("VpcSecurityGroupIds", this.vpcSecurityGroupIds()).add("AvailabilityZone", (Object)this.availabilityZone()).add("ReplicationSubnetGroupIdentifier", (Object)this.replicationSubnetGroupIdentifier()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("MultiAZ", (Object)this.multiAZ()).add("EngineVersion", (Object)this.engineVersion()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("Tags", this.tags()).add("KmsKeyId", (Object)this.kmsKeyId()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("DnsNameServers", (Object)this.dnsNameServers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceIdentifier()));
            }
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "ReplicationInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceClass()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "ReplicationSubnetGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationSubnetGroupIdentifier()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "MultiAZ": {
                return Optional.ofNullable(clazz.cast(this.multiAZ()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "DnsNameServers": {
                return Optional.ofNullable(clazz.cast(this.dnsNameServers()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicationInstanceRequest, T> g) {
        return obj -> g.apply((CreateReplicationInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String replicationInstanceIdentifier;
        private Integer allocatedStorage;
        private String replicationInstanceClass;
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String availabilityZone;
        private String replicationSubnetGroupIdentifier;
        private String preferredMaintenanceWindow;
        private Boolean multiAZ;
        private String engineVersion;
        private Boolean autoMinorVersionUpgrade;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String kmsKeyId;
        private Boolean publiclyAccessible;
        private String dnsNameServers;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationInstanceRequest model) {
            super(model);
            this.replicationInstanceIdentifier(model.replicationInstanceIdentifier);
            this.allocatedStorage(model.allocatedStorage);
            this.replicationInstanceClass(model.replicationInstanceClass);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.availabilityZone(model.availabilityZone);
            this.replicationSubnetGroupIdentifier(model.replicationSubnetGroupIdentifier);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.multiAZ(model.multiAZ);
            this.engineVersion(model.engineVersion);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.tags(model.tags);
            this.kmsKeyId(model.kmsKeyId);
            this.publiclyAccessible(model.publiclyAccessible);
            this.dnsNameServers(model.dnsNameServers);
        }

        public final String getReplicationInstanceIdentifier() {
            return this.replicationInstanceIdentifier;
        }

        @Override
        public final Builder replicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
            return this;
        }

        public final void setReplicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final String getReplicationInstanceClass() {
            return this.replicationInstanceClass;
        }

        @Override
        public final Builder replicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
            return this;
        }

        public final void setReplicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getReplicationSubnetGroupIdentifier() {
            return this.replicationSubnetGroupIdentifier;
        }

        @Override
        public final Builder replicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier) {
            this.replicationSubnetGroupIdentifier = replicationSubnetGroupIdentifier;
            return this;
        }

        public final void setReplicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier) {
            this.replicationSubnetGroupIdentifier = replicationSubnetGroupIdentifier;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final String getDnsNameServers() {
            return this.dnsNameServers;
        }

        @Override
        public final Builder dnsNameServers(String dnsNameServers) {
            this.dnsNameServers = dnsNameServers;
            return this;
        }

        public final void setDnsNameServers(String dnsNameServers) {
            this.dnsNameServers = dnsNameServers;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicationInstanceRequest build() {
            return new CreateReplicationInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateReplicationInstanceRequest> {
        public Builder replicationInstanceIdentifier(String var1);

        public Builder allocatedStorage(Integer var1);

        public Builder replicationInstanceClass(String var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder availabilityZone(String var1);

        public Builder replicationSubnetGroupIdentifier(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder multiAZ(Boolean var1);

        public Builder engineVersion(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder kmsKeyId(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder dnsNameServers(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

