/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a subnet group in response to a request by the <code>DescribeReplicationSubnetGroup</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationSubnetGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationSubnetGroup.Builder, ReplicationSubnetGroup> {
    private static final SdkField<String> REPLICATION_SUBNET_GROUP_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationSubnetGroup::replicationSubnetGroupIdentifier))
            .setter(setter(Builder::replicationSubnetGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSubnetGroupIdentifier")
                    .build()).build();

    private static final SdkField<String> REPLICATION_SUBNET_GROUP_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationSubnetGroup::replicationSubnetGroupDescription))
            .setter(setter(Builder::replicationSubnetGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSubnetGroupDescription")
                    .build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationSubnetGroup::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> SUBNET_GROUP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationSubnetGroup::subnetGroupStatus)).setter(setter(Builder::subnetGroupStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroupStatus").build()).build();

    private static final SdkField<List<Subnet>> SUBNETS_FIELD = SdkField
            .<List<Subnet>> builder(MarshallingType.LIST)
            .getter(getter(ReplicationSubnetGroup::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Subnet> builder(MarshallingType.SDK_POJO)
                                            .constructor(Subnet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLICATION_SUBNET_GROUP_IDENTIFIER_FIELD, REPLICATION_SUBNET_GROUP_DESCRIPTION_FIELD, VPC_ID_FIELD,
            SUBNET_GROUP_STATUS_FIELD, SUBNETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String replicationSubnetGroupIdentifier;

    private final String replicationSubnetGroupDescription;

    private final String vpcId;

    private final String subnetGroupStatus;

    private final List<Subnet> subnets;

    private ReplicationSubnetGroup(BuilderImpl builder) {
        this.replicationSubnetGroupIdentifier = builder.replicationSubnetGroupIdentifier;
        this.replicationSubnetGroupDescription = builder.replicationSubnetGroupDescription;
        this.vpcId = builder.vpcId;
        this.subnetGroupStatus = builder.subnetGroupStatus;
        this.subnets = builder.subnets;
    }

    /**
     * <p>
     * The identifier of the replication instance subnet group.
     * </p>
     * 
     * @return The identifier of the replication instance subnet group.
     */
    public String replicationSubnetGroupIdentifier() {
        return replicationSubnetGroupIdentifier;
    }

    /**
     * <p>
     * A description for the replication subnet group.
     * </p>
     * 
     * @return A description for the replication subnet group.
     */
    public String replicationSubnetGroupDescription() {
        return replicationSubnetGroupDescription;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The status of the subnet group.
     * </p>
     * 
     * @return The status of the subnet group.
     */
    public String subnetGroupStatus() {
        return subnetGroupStatus;
    }

    /**
     * Returns true if the Subnets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subnets that are in the subnet group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The subnets that are in the subnet group.
     */
    public List<Subnet> subnets() {
        return subnets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicationSubnetGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(replicationSubnetGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetGroupStatus());
        hashCode = 31 * hashCode + Objects.hashCode(subnets());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationSubnetGroup)) {
            return false;
        }
        ReplicationSubnetGroup other = (ReplicationSubnetGroup) obj;
        return Objects.equals(replicationSubnetGroupIdentifier(), other.replicationSubnetGroupIdentifier())
                && Objects.equals(replicationSubnetGroupDescription(), other.replicationSubnetGroupDescription())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(subnetGroupStatus(), other.subnetGroupStatus())
                && Objects.equals(subnets(), other.subnets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReplicationSubnetGroup")
                .add("ReplicationSubnetGroupIdentifier", replicationSubnetGroupIdentifier())
                .add("ReplicationSubnetGroupDescription", replicationSubnetGroupDescription()).add("VpcId", vpcId())
                .add("SubnetGroupStatus", subnetGroupStatus()).add("Subnets", subnets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationSubnetGroupIdentifier":
            return Optional.ofNullable(clazz.cast(replicationSubnetGroupIdentifier()));
        case "ReplicationSubnetGroupDescription":
            return Optional.ofNullable(clazz.cast(replicationSubnetGroupDescription()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SubnetGroupStatus":
            return Optional.ofNullable(clazz.cast(subnetGroupStatus()));
        case "Subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationSubnetGroup, T> g) {
        return obj -> g.apply((ReplicationSubnetGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationSubnetGroup> {
        /**
         * <p>
         * The identifier of the replication instance subnet group.
         * </p>
         * 
         * @param replicationSubnetGroupIdentifier
         *        The identifier of the replication instance subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier);

        /**
         * <p>
         * A description for the replication subnet group.
         * </p>
         * 
         * @param replicationSubnetGroupDescription
         *        A description for the replication subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSubnetGroupDescription(String replicationSubnetGroupDescription);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The status of the subnet group.
         * </p>
         * 
         * @param subnetGroupStatus
         *        The status of the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetGroupStatus(String subnetGroupStatus);

        /**
         * <p>
         * The subnets that are in the subnet group.
         * </p>
         * 
         * @param subnets
         *        The subnets that are in the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<Subnet> subnets);

        /**
         * <p>
         * The subnets that are in the subnet group.
         * </p>
         * 
         * @param subnets
         *        The subnets that are in the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Subnet... subnets);

        /**
         * <p>
         * The subnets that are in the subnet group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Subnet>.Builder} avoiding the need to
         * create one manually via {@link List<Subnet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Subnet>.Builder#build()} is called immediately and its
         * result is passed to {@link #subnets(List<Subnet>)}.
         * 
         * @param subnets
         *        a consumer that will call methods on {@link List<Subnet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnets(List<Subnet>)
         */
        Builder subnets(Consumer<Subnet.Builder>... subnets);
    }

    static final class BuilderImpl implements Builder {
        private String replicationSubnetGroupIdentifier;

        private String replicationSubnetGroupDescription;

        private String vpcId;

        private String subnetGroupStatus;

        private List<Subnet> subnets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationSubnetGroup model) {
            replicationSubnetGroupIdentifier(model.replicationSubnetGroupIdentifier);
            replicationSubnetGroupDescription(model.replicationSubnetGroupDescription);
            vpcId(model.vpcId);
            subnetGroupStatus(model.subnetGroupStatus);
            subnets(model.subnets);
        }

        public final String getReplicationSubnetGroupIdentifier() {
            return replicationSubnetGroupIdentifier;
        }

        @Override
        public final Builder replicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier) {
            this.replicationSubnetGroupIdentifier = replicationSubnetGroupIdentifier;
            return this;
        }

        public final void setReplicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier) {
            this.replicationSubnetGroupIdentifier = replicationSubnetGroupIdentifier;
        }

        public final String getReplicationSubnetGroupDescription() {
            return replicationSubnetGroupDescription;
        }

        @Override
        public final Builder replicationSubnetGroupDescription(String replicationSubnetGroupDescription) {
            this.replicationSubnetGroupDescription = replicationSubnetGroupDescription;
            return this;
        }

        public final void setReplicationSubnetGroupDescription(String replicationSubnetGroupDescription) {
            this.replicationSubnetGroupDescription = replicationSubnetGroupDescription;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getSubnetGroupStatus() {
            return subnetGroupStatus;
        }

        @Override
        public final Builder subnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
            return this;
        }

        public final void setSubnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
        }

        public final Collection<Subnet.Builder> getSubnets() {
            return subnets != null ? subnets.stream().map(Subnet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Subnet... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Consumer<Subnet.Builder>... subnets) {
            subnets(Stream.of(subnets).map(c -> Subnet.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubnets(Collection<Subnet.BuilderImpl> subnets) {
            this.subnets = SubnetListCopier.copyFromBuilder(subnets);
        }

        @Override
        public ReplicationSubnetGroup build() {
            return new ReplicationSubnetGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
