/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the values of pending modifications to a replication instance. This data type is an object
 * of the <code>ReplicationInstance</code> user-defined data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationPendingModifiedValues implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationPendingModifiedValues.Builder, ReplicationPendingModifiedValues> {
    private static final SdkField<String> REPLICATION_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationPendingModifiedValues::replicationInstanceClass))
            .setter(setter(Builder::replicationInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceClass").build())
            .build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ReplicationPendingModifiedValues::allocatedStorage)).setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ReplicationPendingModifiedValues::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReplicationPendingModifiedValues::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLICATION_INSTANCE_CLASS_FIELD, ALLOCATED_STORAGE_FIELD, MULTI_AZ_FIELD, ENGINE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String replicationInstanceClass;

    private final Integer allocatedStorage;

    private final Boolean multiAZ;

    private final String engineVersion;

    private ReplicationPendingModifiedValues(BuilderImpl builder) {
        this.replicationInstanceClass = builder.replicationInstanceClass;
        this.allocatedStorage = builder.allocatedStorage;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
    }

    /**
     * <p>
     * The compute and memory capacity of the replication instance.
     * </p>
     * <p>
     * Valid Values:
     * <code>dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge </code>
     * </p>
     * 
     * @return The compute and memory capacity of the replication instance.</p>
     *         <p>
     *         Valid Values:
     *         <code>dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge </code>
     */
    public String replicationInstanceClass() {
        return replicationInstanceClass;
    }

    /**
     * <p>
     * The amount of storage (in gigabytes) that is allocated for the replication instance.
     * </p>
     * 
     * @return The amount of storage (in gigabytes) that is allocated for the replication instance.
     */
    public Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
     * <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>.
     * </p>
     * 
     * @return Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
     *         <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>.
     */
    public Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * <p>
     * The engine version number of the replication instance.
     * </p>
     * 
     * @return The engine version number of the replication instance.
     */
    public String engineVersion() {
        return engineVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationPendingModifiedValues)) {
            return false;
        }
        ReplicationPendingModifiedValues other = (ReplicationPendingModifiedValues) obj;
        return Objects.equals(replicationInstanceClass(), other.replicationInstanceClass())
                && Objects.equals(allocatedStorage(), other.allocatedStorage()) && Objects.equals(multiAZ(), other.multiAZ())
                && Objects.equals(engineVersion(), other.engineVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReplicationPendingModifiedValues").add("ReplicationInstanceClass", replicationInstanceClass())
                .add("AllocatedStorage", allocatedStorage()).add("MultiAZ", multiAZ()).add("EngineVersion", engineVersion())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationInstanceClass":
            return Optional.ofNullable(clazz.cast(replicationInstanceClass()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationPendingModifiedValues, T> g) {
        return obj -> g.apply((ReplicationPendingModifiedValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationPendingModifiedValues> {
        /**
         * <p>
         * The compute and memory capacity of the replication instance.
         * </p>
         * <p>
         * Valid Values:
         * <code>dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge </code>
         * </p>
         * 
         * @param replicationInstanceClass
         *        The compute and memory capacity of the replication instance.</p>
         *        <p>
         *        Valid Values:
         *        <code>dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceClass(String replicationInstanceClass);

        /**
         * <p>
         * The amount of storage (in gigabytes) that is allocated for the replication instance.
         * </p>
         * 
         * @param allocatedStorage
         *        The amount of storage (in gigabytes) that is allocated for the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
         * <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>.
         * </p>
         * 
         * @param multiAZ
         *        Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
         *        <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * The engine version number of the replication instance.
         * </p>
         * 
         * @param engineVersion
         *        The engine version number of the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);
    }

    static final class BuilderImpl implements Builder {
        private String replicationInstanceClass;

        private Integer allocatedStorage;

        private Boolean multiAZ;

        private String engineVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationPendingModifiedValues model) {
            replicationInstanceClass(model.replicationInstanceClass);
            allocatedStorage(model.allocatedStorage);
            multiAZ(model.multiAZ);
            engineVersion(model.engineVersion);
        }

        public final String getReplicationInstanceClass() {
            return replicationInstanceClass;
        }

        @Override
        public final Builder replicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
            return this;
        }

        public final void setReplicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public ReplicationPendingModifiedValues build() {
            return new ReplicationPendingModifiedValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
