/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that defines an Amazon Neptune endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NeptuneSettings implements SdkPojo, Serializable, ToCopyableBuilder<NeptuneSettings.Builder, NeptuneSettings> {
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NeptuneSettings::serviceAccessRoleArn)).setter(setter(Builder::serviceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build())
            .build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NeptuneSettings::s3BucketName)).setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<String> S3_BUCKET_FOLDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NeptuneSettings::s3BucketFolder)).setter(setter(Builder::s3BucketFolder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketFolder").build()).build();

    private static final SdkField<Integer> ERROR_RETRY_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(NeptuneSettings::errorRetryDuration)).setter(setter(Builder::errorRetryDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorRetryDuration").build())
            .build();

    private static final SdkField<Integer> MAX_FILE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(NeptuneSettings::maxFileSize)).setter(setter(Builder::maxFileSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFileSize").build()).build();

    private static final SdkField<Integer> MAX_RETRY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(NeptuneSettings::maxRetryCount)).setter(setter(Builder::maxRetryCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetryCount").build()).build();

    private static final SdkField<Boolean> IAM_AUTH_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(NeptuneSettings::iamAuthEnabled)).setter(setter(Builder::iamAuthEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamAuthEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACCESS_ROLE_ARN_FIELD,
            S3_BUCKET_NAME_FIELD, S3_BUCKET_FOLDER_FIELD, ERROR_RETRY_DURATION_FIELD, MAX_FILE_SIZE_FIELD, MAX_RETRY_COUNT_FIELD,
            IAM_AUTH_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceAccessRoleArn;

    private final String s3BucketName;

    private final String s3BucketFolder;

    private final Integer errorRetryDuration;

    private final Integer maxFileSize;

    private final Integer maxRetryCount;

    private final Boolean iamAuthEnabled;

    private NeptuneSettings(BuilderImpl builder) {
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.s3BucketName = builder.s3BucketName;
        this.s3BucketFolder = builder.s3BucketFolder;
        this.errorRetryDuration = builder.errorRetryDuration;
        this.maxFileSize = builder.maxFileSize;
        this.maxRetryCount = builder.maxRetryCount;
        this.iamAuthEnabled = builder.iamAuthEnabled;
    }

    /**
     * <p>
     * The ARN of the service role you have created for the Neptune target endpoint. For more information, see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.ServiceRole"
     * >https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.ServiceRole</a> in
     * the <i>AWS Database Migration Service User Guide.</i>
     * </p>
     * 
     * @return The ARN of the service role you have created for the Neptune target endpoint. For more information, see
     *         <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.ServiceRole"
     *         >https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.
     *         ServiceRole</a> in the <i>AWS Database Migration Service User Guide.</i>
     */
    public String serviceAccessRoleArn() {
        return serviceAccessRoleArn;
    }

    /**
     * <p>
     * The name of the S3 bucket for AWS DMS to temporarily store migrated graph data in CSV files before bulk-loading
     * it to the Neptune target database. AWS DMS maps the SQL source data to graph data before storing it in these CSV
     * files.
     * </p>
     * 
     * @return The name of the S3 bucket for AWS DMS to temporarily store migrated graph data in CSV files before
     *         bulk-loading it to the Neptune target database. AWS DMS maps the SQL source data to graph data before
     *         storing it in these CSV files.
     */
    public String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * A folder path where you where you want AWS DMS to store migrated graph data in the S3 bucket specified by
     * <code>S3BucketName</code>
     * </p>
     * 
     * @return A folder path where you where you want AWS DMS to store migrated graph data in the S3 bucket specified by
     *         <code>S3BucketName</code>
     */
    public String s3BucketFolder() {
        return s3BucketFolder;
    }

    /**
     * <p>
     * The number of milliseconds for AWS DMS to wait to retry a bulk-load of migrated graph data to the Neptune target
     * database before raising an error. The default is 250.
     * </p>
     * 
     * @return The number of milliseconds for AWS DMS to wait to retry a bulk-load of migrated graph data to the Neptune
     *         target database before raising an error. The default is 250.
     */
    public Integer errorRetryDuration() {
        return errorRetryDuration;
    }

    /**
     * <p>
     * The maximum size in KB of migrated graph data stored in a CSV file before AWS DMS bulk-loads the data to the
     * Neptune target database. The default is 1048576 KB. If successful, AWS DMS clears the bucket, ready to store the
     * next batch of migrated graph data.
     * </p>
     * 
     * @return The maximum size in KB of migrated graph data stored in a CSV file before AWS DMS bulk-loads the data to
     *         the Neptune target database. The default is 1048576 KB. If successful, AWS DMS clears the bucket, ready
     *         to store the next batch of migrated graph data.
     */
    public Integer maxFileSize() {
        return maxFileSize;
    }

    /**
     * <p>
     * The number of times for AWS DMS to retry a bulk-load of migrated graph data to the Neptune target database before
     * raising an error. The default is 5.
     * </p>
     * 
     * @return The number of times for AWS DMS to retry a bulk-load of migrated graph data to the Neptune target
     *         database before raising an error. The default is 5.
     */
    public Integer maxRetryCount() {
        return maxRetryCount;
    }

    /**
     * <p>
     * If you want IAM authorization enabled for this endpoint, set this parameter to <code>true</code> and attach the
     * appropriate role policy document to your service role specified by <code>ServiceAccessRoleArn</code>. The default
     * is <code>false</code>.
     * </p>
     * 
     * @return If you want IAM authorization enabled for this endpoint, set this parameter to <code>true</code> and
     *         attach the appropriate role policy document to your service role specified by
     *         <code>ServiceAccessRoleArn</code>. The default is <code>false</code>.
     */
    public Boolean iamAuthEnabled() {
        return iamAuthEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketFolder());
        hashCode = 31 * hashCode + Objects.hashCode(errorRetryDuration());
        hashCode = 31 * hashCode + Objects.hashCode(maxFileSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxRetryCount());
        hashCode = 31 * hashCode + Objects.hashCode(iamAuthEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NeptuneSettings)) {
            return false;
        }
        NeptuneSettings other = (NeptuneSettings) obj;
        return Objects.equals(serviceAccessRoleArn(), other.serviceAccessRoleArn())
                && Objects.equals(s3BucketName(), other.s3BucketName())
                && Objects.equals(s3BucketFolder(), other.s3BucketFolder())
                && Objects.equals(errorRetryDuration(), other.errorRetryDuration())
                && Objects.equals(maxFileSize(), other.maxFileSize()) && Objects.equals(maxRetryCount(), other.maxRetryCount())
                && Objects.equals(iamAuthEnabled(), other.iamAuthEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NeptuneSettings").add("ServiceAccessRoleArn", serviceAccessRoleArn())
                .add("S3BucketName", s3BucketName()).add("S3BucketFolder", s3BucketFolder())
                .add("ErrorRetryDuration", errorRetryDuration()).add("MaxFileSize", maxFileSize())
                .add("MaxRetryCount", maxRetryCount()).add("IamAuthEnabled", iamAuthEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(serviceAccessRoleArn()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "S3BucketFolder":
            return Optional.ofNullable(clazz.cast(s3BucketFolder()));
        case "ErrorRetryDuration":
            return Optional.ofNullable(clazz.cast(errorRetryDuration()));
        case "MaxFileSize":
            return Optional.ofNullable(clazz.cast(maxFileSize()));
        case "MaxRetryCount":
            return Optional.ofNullable(clazz.cast(maxRetryCount()));
        case "IamAuthEnabled":
            return Optional.ofNullable(clazz.cast(iamAuthEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NeptuneSettings, T> g) {
        return obj -> g.apply((NeptuneSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NeptuneSettings> {
        /**
         * <p>
         * The ARN of the service role you have created for the Neptune target endpoint. For more information, see <a
         * href
         * ="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.ServiceRole"
         * >https
         * ://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.ServiceRole</a> in
         * the <i>AWS Database Migration Service User Guide.</i>
         * </p>
         * 
         * @param serviceAccessRoleArn
         *        The ARN of the service role you have created for the Neptune target endpoint. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.ServiceRole"
         *        >https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.
         *        ServiceRole</a> in the <i>AWS Database Migration Service User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccessRoleArn(String serviceAccessRoleArn);

        /**
         * <p>
         * The name of the S3 bucket for AWS DMS to temporarily store migrated graph data in CSV files before
         * bulk-loading it to the Neptune target database. AWS DMS maps the SQL source data to graph data before storing
         * it in these CSV files.
         * </p>
         * 
         * @param s3BucketName
         *        The name of the S3 bucket for AWS DMS to temporarily store migrated graph data in CSV files before
         *        bulk-loading it to the Neptune target database. AWS DMS maps the SQL source data to graph data before
         *        storing it in these CSV files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * A folder path where you where you want AWS DMS to store migrated graph data in the S3 bucket specified by
         * <code>S3BucketName</code>
         * </p>
         * 
         * @param s3BucketFolder
         *        A folder path where you where you want AWS DMS to store migrated graph data in the S3 bucket specified
         *        by <code>S3BucketName</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketFolder(String s3BucketFolder);

        /**
         * <p>
         * The number of milliseconds for AWS DMS to wait to retry a bulk-load of migrated graph data to the Neptune
         * target database before raising an error. The default is 250.
         * </p>
         * 
         * @param errorRetryDuration
         *        The number of milliseconds for AWS DMS to wait to retry a bulk-load of migrated graph data to the
         *        Neptune target database before raising an error. The default is 250.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorRetryDuration(Integer errorRetryDuration);

        /**
         * <p>
         * The maximum size in KB of migrated graph data stored in a CSV file before AWS DMS bulk-loads the data to the
         * Neptune target database. The default is 1048576 KB. If successful, AWS DMS clears the bucket, ready to store
         * the next batch of migrated graph data.
         * </p>
         * 
         * @param maxFileSize
         *        The maximum size in KB of migrated graph data stored in a CSV file before AWS DMS bulk-loads the data
         *        to the Neptune target database. The default is 1048576 KB. If successful, AWS DMS clears the bucket,
         *        ready to store the next batch of migrated graph data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxFileSize(Integer maxFileSize);

        /**
         * <p>
         * The number of times for AWS DMS to retry a bulk-load of migrated graph data to the Neptune target database
         * before raising an error. The default is 5.
         * </p>
         * 
         * @param maxRetryCount
         *        The number of times for AWS DMS to retry a bulk-load of migrated graph data to the Neptune target
         *        database before raising an error. The default is 5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRetryCount(Integer maxRetryCount);

        /**
         * <p>
         * If you want IAM authorization enabled for this endpoint, set this parameter to <code>true</code> and attach
         * the appropriate role policy document to your service role specified by <code>ServiceAccessRoleArn</code>. The
         * default is <code>false</code>.
         * </p>
         * 
         * @param iamAuthEnabled
         *        If you want IAM authorization enabled for this endpoint, set this parameter to <code>true</code> and
         *        attach the appropriate role policy document to your service role specified by
         *        <code>ServiceAccessRoleArn</code>. The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamAuthEnabled(Boolean iamAuthEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String serviceAccessRoleArn;

        private String s3BucketName;

        private String s3BucketFolder;

        private Integer errorRetryDuration;

        private Integer maxFileSize;

        private Integer maxRetryCount;

        private Boolean iamAuthEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(NeptuneSettings model) {
            serviceAccessRoleArn(model.serviceAccessRoleArn);
            s3BucketName(model.s3BucketName);
            s3BucketFolder(model.s3BucketFolder);
            errorRetryDuration(model.errorRetryDuration);
            maxFileSize(model.maxFileSize);
            maxRetryCount(model.maxRetryCount);
            iamAuthEnabled(model.iamAuthEnabled);
        }

        public final String getServiceAccessRoleArn() {
            return serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getS3BucketFolder() {
            return s3BucketFolder;
        }

        @Override
        public final Builder s3BucketFolder(String s3BucketFolder) {
            this.s3BucketFolder = s3BucketFolder;
            return this;
        }

        public final void setS3BucketFolder(String s3BucketFolder) {
            this.s3BucketFolder = s3BucketFolder;
        }

        public final Integer getErrorRetryDuration() {
            return errorRetryDuration;
        }

        @Override
        public final Builder errorRetryDuration(Integer errorRetryDuration) {
            this.errorRetryDuration = errorRetryDuration;
            return this;
        }

        public final void setErrorRetryDuration(Integer errorRetryDuration) {
            this.errorRetryDuration = errorRetryDuration;
        }

        public final Integer getMaxFileSize() {
            return maxFileSize;
        }

        @Override
        public final Builder maxFileSize(Integer maxFileSize) {
            this.maxFileSize = maxFileSize;
            return this;
        }

        public final void setMaxFileSize(Integer maxFileSize) {
            this.maxFileSize = maxFileSize;
        }

        public final Integer getMaxRetryCount() {
            return maxRetryCount;
        }

        @Override
        public final Builder maxRetryCount(Integer maxRetryCount) {
            this.maxRetryCount = maxRetryCount;
            return this;
        }

        public final void setMaxRetryCount(Integer maxRetryCount) {
            this.maxRetryCount = maxRetryCount;
        }

        public final Boolean getIamAuthEnabled() {
            return iamAuthEnabled;
        }

        @Override
        public final Builder iamAuthEnabled(Boolean iamAuthEnabled) {
            this.iamAuthEnabled = iamAuthEnabled;
            return this;
        }

        public final void setIamAuthEnabled(Boolean iamAuthEnabled) {
            this.iamAuthEnabled = iamAuthEnabled;
        }

        @Override
        public NeptuneSettings build() {
            return new NeptuneSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
