/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyReplicationInstanceRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<ModifyReplicationInstanceRequest.Builder, ModifyReplicationInstanceRequest> {
    private static final SdkField<String> REPLICATION_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationInstanceRequest::replicationInstanceArn))
            .setter(setter(Builder::replicationInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceArn").build())
            .build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ModifyReplicationInstanceRequest::allocatedStorage)).setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyReplicationInstanceRequest::applyImmediately)).setter(setter(Builder::applyImmediately))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()).build();

    private static final SdkField<String> REPLICATION_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationInstanceRequest::replicationInstanceClass))
            .setter(setter(Builder::replicationInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceClass").build())
            .build();

    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ModifyReplicationInstanceRequest::vpcSecurityGroupIds))
            .setter(setter(Builder::vpcSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationInstanceRequest::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyReplicationInstanceRequest::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationInstanceRequest::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> ALLOW_MAJOR_VERSION_UPGRADE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyReplicationInstanceRequest::allowMajorVersionUpgrade))
            .setter(setter(Builder::allowMajorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowMajorVersionUpgrade").build())
            .build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ModifyReplicationInstanceRequest::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<String> REPLICATION_INSTANCE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyReplicationInstanceRequest::replicationInstanceIdentifier))
            .setter(setter(Builder::replicationInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLICATION_INSTANCE_ARN_FIELD, ALLOCATED_STORAGE_FIELD, APPLY_IMMEDIATELY_FIELD, REPLICATION_INSTANCE_CLASS_FIELD,
            VPC_SECURITY_GROUP_IDS_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, MULTI_AZ_FIELD, ENGINE_VERSION_FIELD,
            ALLOW_MAJOR_VERSION_UPGRADE_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, REPLICATION_INSTANCE_IDENTIFIER_FIELD));

    private final String replicationInstanceArn;

    private final Integer allocatedStorage;

    private final Boolean applyImmediately;

    private final String replicationInstanceClass;

    private final List<String> vpcSecurityGroupIds;

    private final String preferredMaintenanceWindow;

    private final Boolean multiAZ;

    private final String engineVersion;

    private final Boolean allowMajorVersionUpgrade;

    private final Boolean autoMinorVersionUpgrade;

    private final String replicationInstanceIdentifier;

    private ModifyReplicationInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.allocatedStorage = builder.allocatedStorage;
        this.applyImmediately = builder.applyImmediately;
        this.replicationInstanceClass = builder.replicationInstanceClass;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.allowMajorVersionUpgrade = builder.allowMajorVersionUpgrade;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.replicationInstanceIdentifier = builder.replicationInstanceIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replication instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replication instance.
     */
    public String replicationInstanceArn() {
        return replicationInstanceArn;
    }

    /**
     * <p>
     * The amount of storage (in gigabytes) to be allocated for the replication instance.
     * </p>
     * 
     * @return The amount of storage (in gigabytes) to be allocated for the replication instance.
     */
    public Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * Indicates whether the changes should be applied immediately or during the next maintenance window.
     * </p>
     * 
     * @return Indicates whether the changes should be applied immediately or during the next maintenance window.
     */
    public Boolean applyImmediately() {
        return applyImmediately;
    }

    /**
     * <p>
     * The compute and memory capacity of the replication instance.
     * </p>
     * <p>
     * Valid Values:
     * <code>dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge </code>
     * </p>
     * 
     * @return The compute and memory capacity of the replication instance.</p>
     *         <p>
     *         Valid Values:
     *         <code>dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge </code>
     */
    public String replicationInstanceClass() {
        return replicationInstanceClass;
    }

    /**
     * Returns true if the VpcSecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasVpcSecurityGroupIds() {
        return vpcSecurityGroupIds != null && !(vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the VPC security group to be used with the replication instance. The VPC security group must work with
     * the VPC containing the replication instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVpcSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the VPC security group to be used with the replication instance. The VPC security group must
     *         work with the VPC containing the replication instance.
     */
    public List<String> vpcSecurityGroupIds() {
        return vpcSecurityGroupIds;
    }

    /**
     * <p>
     * The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage.
     * Changing this parameter does not result in an outage, except in the following situation, and the change is
     * asynchronously applied as soon as possible. If moving this window to the current time, there must be at least 30
     * minutes between the current time and end of the window to ensure pending changes are applied.
     * </p>
     * <p>
     * Default: Uses existing setting
     * </p>
     * <p>
     * Format: ddd:hh24:mi-ddd:hh24:mi
     * </p>
     * <p>
     * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     * </p>
     * <p>
     * Constraints: Must be at least 30 minutes
     * </p>
     * 
     * @return The weekly time range (in UTC) during which system maintenance can occur, which might result in an
     *         outage. Changing this parameter does not result in an outage, except in the following situation, and the
     *         change is asynchronously applied as soon as possible. If moving this window to the current time, there
     *         must be at least 30 minutes between the current time and end of the window to ensure pending changes are
     *         applied.</p>
     *         <p>
     *         Default: Uses existing setting
     *         </p>
     *         <p>
     *         Format: ddd:hh24:mi-ddd:hh24:mi
     *         </p>
     *         <p>
     *         Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
     *         </p>
     *         <p>
     *         Constraints: Must be at least 30 minutes
     */
    public String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
     * <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>.
     * </p>
     * 
     * @return Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
     *         <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>.
     */
    public Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * <p>
     * The engine version number of the replication instance.
     * </p>
     * 
     * @return The engine version number of the replication instance.
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * Indicates that major version upgrades are allowed. Changing this parameter does not result in an outage, and the
     * change is asynchronously applied as soon as possible.
     * </p>
     * <p>
     * This parameter must be set to <code>true</code> when specifying a value for the <code>EngineVersion</code>
     * parameter that is a different major version than the replication instance's current version.
     * </p>
     * 
     * @return Indicates that major version upgrades are allowed. Changing this parameter does not result in an outage,
     *         and the change is asynchronously applied as soon as possible.</p>
     *         <p>
     *         This parameter must be set to <code>true</code> when specifying a value for the
     *         <code>EngineVersion</code> parameter that is a different major version than the replication instance's
     *         current version.
     */
    public Boolean allowMajorVersionUpgrade() {
        return allowMajorVersionUpgrade;
    }

    /**
     * <p>
     * A value that indicates that minor version upgrades are applied automatically to the replication instance during
     * the maintenance window. Changing this parameter doesn't result in an outage, except in the case dsecribed
     * following. The change is asynchronously applied as soon as possible.
     * </p>
     * <p>
     * An outage does result if these factors apply:
     * </p>
     * <ul>
     * <li>
     * <p>
     * This parameter is set to <code>true</code> during the maintenance window.
     * </p>
     * </li>
     * <li>
     * <p>
     * A newer minor version is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS DMS has enabled automatic patching for the given engine version.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A value that indicates that minor version upgrades are applied automatically to the replication instance
     *         during the maintenance window. Changing this parameter doesn't result in an outage, except in the case
     *         dsecribed following. The change is asynchronously applied as soon as possible. </p>
     *         <p>
     *         An outage does result if these factors apply:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         This parameter is set to <code>true</code> during the maintenance window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A newer minor version is available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AWS DMS has enabled automatic patching for the given engine version.
     *         </p>
     *         </li>
     */
    public Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * The replication instance identifier. This parameter is stored as a lowercase string.
     * </p>
     * 
     * @return The replication instance identifier. This parameter is stored as a lowercase string.
     */
    public String replicationInstanceIdentifier() {
        return replicationInstanceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(vpcSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(allowMajorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceIdentifier());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReplicationInstanceRequest)) {
            return false;
        }
        ModifyReplicationInstanceRequest other = (ModifyReplicationInstanceRequest) obj;
        return Objects.equals(replicationInstanceArn(), other.replicationInstanceArn())
                && Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(applyImmediately(), other.applyImmediately())
                && Objects.equals(replicationInstanceClass(), other.replicationInstanceClass())
                && Objects.equals(vpcSecurityGroupIds(), other.vpcSecurityGroupIds())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(multiAZ(), other.multiAZ()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(allowMajorVersionUpgrade(), other.allowMajorVersionUpgrade())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(replicationInstanceIdentifier(), other.replicationInstanceIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyReplicationInstanceRequest").add("ReplicationInstanceArn", replicationInstanceArn())
                .add("AllocatedStorage", allocatedStorage()).add("ApplyImmediately", applyImmediately())
                .add("ReplicationInstanceClass", replicationInstanceClass()).add("VpcSecurityGroupIds", vpcSecurityGroupIds())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow()).add("MultiAZ", multiAZ())
                .add("EngineVersion", engineVersion()).add("AllowMajorVersionUpgrade", allowMajorVersionUpgrade())
                .add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("ReplicationInstanceIdentifier", replicationInstanceIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationInstanceArn":
            return Optional.ofNullable(clazz.cast(replicationInstanceArn()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "ApplyImmediately":
            return Optional.ofNullable(clazz.cast(applyImmediately()));
        case "ReplicationInstanceClass":
            return Optional.ofNullable(clazz.cast(replicationInstanceClass()));
        case "VpcSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupIds()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "AllowMajorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(allowMajorVersionUpgrade()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "ReplicationInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(replicationInstanceIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyReplicationInstanceRequest, T> g) {
        return obj -> g.apply((ModifyReplicationInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyReplicationInstanceRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replication instance.
         * </p>
         * 
         * @param replicationInstanceArn
         *        The Amazon Resource Name (ARN) of the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceArn(String replicationInstanceArn);

        /**
         * <p>
         * The amount of storage (in gigabytes) to be allocated for the replication instance.
         * </p>
         * 
         * @param allocatedStorage
         *        The amount of storage (in gigabytes) to be allocated for the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * Indicates whether the changes should be applied immediately or during the next maintenance window.
         * </p>
         * 
         * @param applyImmediately
         *        Indicates whether the changes should be applied immediately or during the next maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyImmediately(Boolean applyImmediately);

        /**
         * <p>
         * The compute and memory capacity of the replication instance.
         * </p>
         * <p>
         * Valid Values:
         * <code>dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge </code>
         * </p>
         * 
         * @param replicationInstanceClass
         *        The compute and memory capacity of the replication instance.</p>
         *        <p>
         *        Valid Values:
         *        <code>dms.t2.micro | dms.t2.small | dms.t2.medium | dms.t2.large | dms.c4.large | dms.c4.xlarge | dms.c4.2xlarge | dms.c4.4xlarge </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceClass(String replicationInstanceClass);

        /**
         * <p>
         * Specifies the VPC security group to be used with the replication instance. The VPC security group must work
         * with the VPC containing the replication instance.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        Specifies the VPC security group to be used with the replication instance. The VPC security group must
         *        work with the VPC containing the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds);

        /**
         * <p>
         * Specifies the VPC security group to be used with the replication instance. The VPC security group must work
         * with the VPC containing the replication instance.
         * </p>
         * 
         * @param vpcSecurityGroupIds
         *        Specifies the VPC security group to be used with the replication instance. The VPC security group must
         *        work with the VPC containing the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds);

        /**
         * <p>
         * The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage.
         * Changing this parameter does not result in an outage, except in the following situation, and the change is
         * asynchronously applied as soon as possible. If moving this window to the current time, there must be at least
         * 30 minutes between the current time and end of the window to ensure pending changes are applied.
         * </p>
         * <p>
         * Default: Uses existing setting
         * </p>
         * <p>
         * Format: ddd:hh24:mi-ddd:hh24:mi
         * </p>
         * <p>
         * Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         * </p>
         * <p>
         * Constraints: Must be at least 30 minutes
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range (in UTC) during which system maintenance can occur, which might result in an
         *        outage. Changing this parameter does not result in an outage, except in the following situation, and
         *        the change is asynchronously applied as soon as possible. If moving this window to the current time,
         *        there must be at least 30 minutes between the current time and end of the window to ensure pending
         *        changes are applied.</p>
         *        <p>
         *        Default: Uses existing setting
         *        </p>
         *        <p>
         *        Format: ddd:hh24:mi-ddd:hh24:mi
         *        </p>
         *        <p>
         *        Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
         *        </p>
         *        <p>
         *        Constraints: Must be at least 30 minutes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
         * <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>.
         * </p>
         * 
         * @param multiAZ
         *        Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
         *        <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * The engine version number of the replication instance.
         * </p>
         * 
         * @param engineVersion
         *        The engine version number of the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * Indicates that major version upgrades are allowed. Changing this parameter does not result in an outage, and
         * the change is asynchronously applied as soon as possible.
         * </p>
         * <p>
         * This parameter must be set to <code>true</code> when specifying a value for the <code>EngineVersion</code>
         * parameter that is a different major version than the replication instance's current version.
         * </p>
         * 
         * @param allowMajorVersionUpgrade
         *        Indicates that major version upgrades are allowed. Changing this parameter does not result in an
         *        outage, and the change is asynchronously applied as soon as possible.</p>
         *        <p>
         *        This parameter must be set to <code>true</code> when specifying a value for the
         *        <code>EngineVersion</code> parameter that is a different major version than the replication instance's
         *        current version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade);

        /**
         * <p>
         * A value that indicates that minor version upgrades are applied automatically to the replication instance
         * during the maintenance window. Changing this parameter doesn't result in an outage, except in the case
         * dsecribed following. The change is asynchronously applied as soon as possible.
         * </p>
         * <p>
         * An outage does result if these factors apply:
         * </p>
         * <ul>
         * <li>
         * <p>
         * This parameter is set to <code>true</code> during the maintenance window.
         * </p>
         * </li>
         * <li>
         * <p>
         * A newer minor version is available.
         * </p>
         * </li>
         * <li>
         * <p>
         * AWS DMS has enabled automatic patching for the given engine version.
         * </p>
         * </li>
         * </ul>
         * 
         * @param autoMinorVersionUpgrade
         *        A value that indicates that minor version upgrades are applied automatically to the replication
         *        instance during the maintenance window. Changing this parameter doesn't result in an outage, except in
         *        the case dsecribed following. The change is asynchronously applied as soon as possible. </p>
         *        <p>
         *        An outage does result if these factors apply:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        This parameter is set to <code>true</code> during the maintenance window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A newer minor version is available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AWS DMS has enabled automatic patching for the given engine version.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * The replication instance identifier. This parameter is stored as a lowercase string.
         * </p>
         * 
         * @param replicationInstanceIdentifier
         *        The replication instance identifier. This parameter is stored as a lowercase string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceIdentifier(String replicationInstanceIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String replicationInstanceArn;

        private Integer allocatedStorage;

        private Boolean applyImmediately;

        private String replicationInstanceClass;

        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String preferredMaintenanceWindow;

        private Boolean multiAZ;

        private String engineVersion;

        private Boolean allowMajorVersionUpgrade;

        private Boolean autoMinorVersionUpgrade;

        private String replicationInstanceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReplicationInstanceRequest model) {
            super(model);
            replicationInstanceArn(model.replicationInstanceArn);
            allocatedStorage(model.allocatedStorage);
            applyImmediately(model.applyImmediately);
            replicationInstanceClass(model.replicationInstanceClass);
            vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            multiAZ(model.multiAZ);
            engineVersion(model.engineVersion);
            allowMajorVersionUpgrade(model.allowMajorVersionUpgrade);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            replicationInstanceIdentifier(model.replicationInstanceIdentifier);
        }

        public final String getReplicationInstanceArn() {
            return replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final Boolean getApplyImmediately() {
            return applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        public final String getReplicationInstanceClass() {
            return replicationInstanceClass;
        }

        @Override
        public final Builder replicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
            return this;
        }

        public final void setReplicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String... vpcSecurityGroupIds) {
            vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getAllowMajorVersionUpgrade() {
            return allowMajorVersionUpgrade;
        }

        @Override
        public final Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
            return this;
        }

        public final void setAllowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final String getReplicationInstanceIdentifier() {
            return replicationInstanceIdentifier;
        }

        @Override
        public final Builder replicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
            return this;
        }

        public final void setReplicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyReplicationInstanceRequest build() {
            return new ModifyReplicationInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
