/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyEndpointRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<ModifyEndpointRequest.Builder, ModifyEndpointRequest> {
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyEndpointRequest::endpointArn)).setter(setter(Builder::endpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()).build();

    private static final SdkField<String> ENDPOINT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyEndpointRequest::endpointIdentifier)).setter(setter(Builder::endpointIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointIdentifier").build())
            .build();

    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyEndpointRequest::endpointTypeAsString)).setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()).build();

    private static final SdkField<String> ENGINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyEndpointRequest::engineName)).setter(setter(Builder::engineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineName").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyEndpointRequest::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyEndpointRequest::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyEndpointRequest::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ModifyEndpointRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyEndpointRequest::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> EXTRA_CONNECTION_ATTRIBUTES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyEndpointRequest::extraConnectionAttributes)).setter(setter(Builder::extraConnectionAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraConnectionAttributes").build())
            .build();

    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyEndpointRequest::certificateArn)).setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()).build();

    private static final SdkField<String> SSL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyEndpointRequest::sslModeAsString)).setter(setter(Builder::sslMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslMode").build()).build();

    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyEndpointRequest::serviceAccessRoleArn)).setter(setter(Builder::serviceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build())
            .build();

    private static final SdkField<String> EXTERNAL_TABLE_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModifyEndpointRequest::externalTableDefinition)).setter(setter(Builder::externalTableDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalTableDefinition").build())
            .build();

    private static final SdkField<DynamoDbSettings> DYNAMO_DB_SETTINGS_FIELD = SdkField
            .<DynamoDbSettings> builder(MarshallingType.SDK_POJO).getter(getter(ModifyEndpointRequest::dynamoDbSettings))
            .setter(setter(Builder::dynamoDbSettings)).constructor(DynamoDbSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamoDbSettings").build()).build();

    private static final SdkField<S3Settings> S3_SETTINGS_FIELD = SdkField.<S3Settings> builder(MarshallingType.SDK_POJO)
            .getter(getter(ModifyEndpointRequest::s3Settings)).setter(setter(Builder::s3Settings))
            .constructor(S3Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Settings").build()).build();

    private static final SdkField<DmsTransferSettings> DMS_TRANSFER_SETTINGS_FIELD = SdkField
            .<DmsTransferSettings> builder(MarshallingType.SDK_POJO).getter(getter(ModifyEndpointRequest::dmsTransferSettings))
            .setter(setter(Builder::dmsTransferSettings)).constructor(DmsTransferSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DmsTransferSettings").build())
            .build();

    private static final SdkField<MongoDbSettings> MONGO_DB_SETTINGS_FIELD = SdkField
            .<MongoDbSettings> builder(MarshallingType.SDK_POJO).getter(getter(ModifyEndpointRequest::mongoDbSettings))
            .setter(setter(Builder::mongoDbSettings)).constructor(MongoDbSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MongoDbSettings").build()).build();

    private static final SdkField<KinesisSettings> KINESIS_SETTINGS_FIELD = SdkField
            .<KinesisSettings> builder(MarshallingType.SDK_POJO).getter(getter(ModifyEndpointRequest::kinesisSettings))
            .setter(setter(Builder::kinesisSettings)).constructor(KinesisSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisSettings").build()).build();

    private static final SdkField<KafkaSettings> KAFKA_SETTINGS_FIELD = SdkField
            .<KafkaSettings> builder(MarshallingType.SDK_POJO).getter(getter(ModifyEndpointRequest::kafkaSettings))
            .setter(setter(Builder::kafkaSettings)).constructor(KafkaSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KafkaSettings").build()).build();

    private static final SdkField<ElasticsearchSettings> ELASTICSEARCH_SETTINGS_FIELD = SdkField
            .<ElasticsearchSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(ModifyEndpointRequest::elasticsearchSettings)).setter(setter(Builder::elasticsearchSettings))
            .constructor(ElasticsearchSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchSettings").build())
            .build();

    private static final SdkField<NeptuneSettings> NEPTUNE_SETTINGS_FIELD = SdkField
            .<NeptuneSettings> builder(MarshallingType.SDK_POJO).getter(getter(ModifyEndpointRequest::neptuneSettings))
            .setter(setter(Builder::neptuneSettings)).constructor(NeptuneSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NeptuneSettings").build()).build();

    private static final SdkField<RedshiftSettings> REDSHIFT_SETTINGS_FIELD = SdkField
            .<RedshiftSettings> builder(MarshallingType.SDK_POJO).getter(getter(ModifyEndpointRequest::redshiftSettings))
            .setter(setter(Builder::redshiftSettings)).constructor(RedshiftSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ARN_FIELD,
            ENDPOINT_IDENTIFIER_FIELD, ENDPOINT_TYPE_FIELD, ENGINE_NAME_FIELD, USERNAME_FIELD, PASSWORD_FIELD, SERVER_NAME_FIELD,
            PORT_FIELD, DATABASE_NAME_FIELD, EXTRA_CONNECTION_ATTRIBUTES_FIELD, CERTIFICATE_ARN_FIELD, SSL_MODE_FIELD,
            SERVICE_ACCESS_ROLE_ARN_FIELD, EXTERNAL_TABLE_DEFINITION_FIELD, DYNAMO_DB_SETTINGS_FIELD, S3_SETTINGS_FIELD,
            DMS_TRANSFER_SETTINGS_FIELD, MONGO_DB_SETTINGS_FIELD, KINESIS_SETTINGS_FIELD, KAFKA_SETTINGS_FIELD,
            ELASTICSEARCH_SETTINGS_FIELD, NEPTUNE_SETTINGS_FIELD, REDSHIFT_SETTINGS_FIELD));

    private final String endpointArn;

    private final String endpointIdentifier;

    private final String endpointType;

    private final String engineName;

    private final String username;

    private final String password;

    private final String serverName;

    private final Integer port;

    private final String databaseName;

    private final String extraConnectionAttributes;

    private final String certificateArn;

    private final String sslMode;

    private final String serviceAccessRoleArn;

    private final String externalTableDefinition;

    private final DynamoDbSettings dynamoDbSettings;

    private final S3Settings s3Settings;

    private final DmsTransferSettings dmsTransferSettings;

    private final MongoDbSettings mongoDbSettings;

    private final KinesisSettings kinesisSettings;

    private final KafkaSettings kafkaSettings;

    private final ElasticsearchSettings elasticsearchSettings;

    private final NeptuneSettings neptuneSettings;

    private final RedshiftSettings redshiftSettings;

    private ModifyEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointArn = builder.endpointArn;
        this.endpointIdentifier = builder.endpointIdentifier;
        this.endpointType = builder.endpointType;
        this.engineName = builder.engineName;
        this.username = builder.username;
        this.password = builder.password;
        this.serverName = builder.serverName;
        this.port = builder.port;
        this.databaseName = builder.databaseName;
        this.extraConnectionAttributes = builder.extraConnectionAttributes;
        this.certificateArn = builder.certificateArn;
        this.sslMode = builder.sslMode;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.externalTableDefinition = builder.externalTableDefinition;
        this.dynamoDbSettings = builder.dynamoDbSettings;
        this.s3Settings = builder.s3Settings;
        this.dmsTransferSettings = builder.dmsTransferSettings;
        this.mongoDbSettings = builder.mongoDbSettings;
        this.kinesisSettings = builder.kinesisSettings;
        this.kafkaSettings = builder.kafkaSettings;
        this.elasticsearchSettings = builder.elasticsearchSettings;
        this.neptuneSettings = builder.neptuneSettings;
        this.redshiftSettings = builder.redshiftSettings;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
     */
    public String endpointArn() {
        return endpointArn;
    }

    /**
     * <p>
     * The database endpoint identifier. Identifiers must begin with a letter and must contain only ASCII letters,
     * digits, and hyphens. They can't end with a hyphen or contain two consecutive hyphens.
     * </p>
     * 
     * @return The database endpoint identifier. Identifiers must begin with a letter and must contain only ASCII
     *         letters, digits, and hyphens. They can't end with a hyphen or contain two consecutive hyphens.
     */
    public String endpointIdentifier() {
        return endpointIdentifier;
    }

    /**
     * <p>
     * The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link ReplicationEndpointTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
     * @see ReplicationEndpointTypeValue
     */
    public ReplicationEndpointTypeValue endpointType() {
        return ReplicationEndpointTypeValue.fromValue(endpointType);
    }

    /**
     * <p>
     * The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link ReplicationEndpointTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
     * @see ReplicationEndpointTypeValue
     */
    public String endpointTypeAsString() {
        return endpointType;
    }

    /**
     * <p>
     * The type of engine for the endpoint. Valid values, depending on the EndpointType, include <code>"mysql"</code>,
     * <code>"oracle"</code>, <code>"postgres"</code>, <code>"mariadb"</code>, <code>"aurora"</code>,
     * <code>"aurora-postgresql"</code>, <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>,
     * <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>,
     * <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>, <code>"documentdb"</code>, and
     * <code>"sqlserver"</code>.
     * </p>
     * 
     * @return The type of engine for the endpoint. Valid values, depending on the EndpointType, include
     *         <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>, <code>"mariadb"</code>,
     *         <code>"aurora"</code>, <code>"aurora-postgresql"</code>, <code>"redshift"</code>, <code>"s3"</code>,
     *         <code>"db2"</code>, <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>,
     *         <code>"mongodb"</code>, <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>,
     *         <code>"documentdb"</code>, and <code>"sqlserver"</code>.
     */
    public String engineName() {
        return engineName;
    }

    /**
     * <p>
     * The user name to be used to login to the endpoint database.
     * </p>
     * 
     * @return The user name to be used to login to the endpoint database.
     */
    public String username() {
        return username;
    }

    /**
     * <p>
     * The password to be used to login to the endpoint database.
     * </p>
     * 
     * @return The password to be used to login to the endpoint database.
     */
    public String password() {
        return password;
    }

    /**
     * <p>
     * The name of the server where the endpoint database resides.
     * </p>
     * 
     * @return The name of the server where the endpoint database resides.
     */
    public String serverName() {
        return serverName;
    }

    /**
     * <p>
     * The port used by the endpoint database.
     * </p>
     * 
     * @return The port used by the endpoint database.
     */
    public Integer port() {
        return port;
    }

    /**
     * <p>
     * The name of the endpoint database.
     * </p>
     * 
     * @return The name of the endpoint database.
     */
    public String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * Additional attributes associated with the connection. To reset this parameter, pass the empty string ("") as an
     * argument.
     * </p>
     * 
     * @return Additional attributes associated with the connection. To reset this parameter, pass the empty string ("")
     *         as an argument.
     */
    public String extraConnectionAttributes() {
        return extraConnectionAttributes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the certificate used for SSL connection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the certificate used for SSL connection.
     */
    public String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The SSL mode used to connect to the endpoint. The default value is <code>none</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sslMode} will
     * return {@link DmsSslModeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sslModeAsString}.
     * </p>
     * 
     * @return The SSL mode used to connect to the endpoint. The default value is <code>none</code>.
     * @see DmsSslModeValue
     */
    public DmsSslModeValue sslMode() {
        return DmsSslModeValue.fromValue(sslMode);
    }

    /**
     * <p>
     * The SSL mode used to connect to the endpoint. The default value is <code>none</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sslMode} will
     * return {@link DmsSslModeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sslModeAsString}.
     * </p>
     * 
     * @return The SSL mode used to connect to the endpoint. The default value is <code>none</code>.
     * @see DmsSslModeValue
     */
    public String sslModeAsString() {
        return sslMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the service access role you want to use to modify the endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the service access role you want to use to modify the endpoint.
     */
    public String serviceAccessRoleArn() {
        return serviceAccessRoleArn;
    }

    /**
     * <p>
     * The external table definition.
     * </p>
     * 
     * @return The external table definition.
     */
    public String externalTableDefinition() {
        return externalTableDefinition;
    }

    /**
     * <p>
     * Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other available settings,
     * see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html">Using Object Mapping to
     * Migrate Data to DynamoDB</a> in the <i>AWS Database Migration Service User Guide.</i>
     * </p>
     * 
     * @return Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other available
     *         settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html">Using
     *         Object Mapping to Migrate Data to DynamoDB</a> in the <i>AWS Database Migration Service User Guide.</i>
     */
    public DynamoDbSettings dynamoDbSettings() {
        return dynamoDbSettings;
    }

    /**
     * <p>
     * Settings in JSON format for the target Amazon S3 endpoint. For more information about the available settings, see
     * <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra
     * Connection Attributes When Using Amazon S3 as a Target for AWS DMS</a> in the <i>AWS Database Migration Service
     * User Guide.</i>
     * </p>
     * 
     * @return Settings in JSON format for the target Amazon S3 endpoint. For more information about the available
     *         settings, see <a
     *         href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring"
     *         >Extra Connection Attributes When Using Amazon S3 as a Target for AWS DMS</a> in the <i>AWS Database
     *         Migration Service User Guide.</i>
     */
    public S3Settings s3Settings() {
        return s3Settings;
    }

    /**
     * <p>
     * The settings in JSON format for the DMS transfer type of source endpoint.
     * </p>
     * <p>
     * Attributes include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * serviceAccessRoleArn - The AWS Identity and Access Management (IAM) role that has permission to access the Amazon
     * S3 bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * BucketName - The name of the S3 bucket to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * compressionType - An optional parameter to use GZIP to compress the target files. Either set this parameter to
     * NONE (the default) or don't use it to leave the files uncompressed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Shorthand syntax for these settings is as follows:
     * <code>ServiceAccessRoleArn=string ,BucketName=string,CompressionType=string</code>
     * </p>
     * <p>
     * JSON syntax for these settings is as follows:
     * <code>{ "ServiceAccessRoleArn": "string", "BucketName": "string", "CompressionType": "none"|"gzip" } </code>
     * </p>
     * 
     * @return The settings in JSON format for the DMS transfer type of source endpoint. </p>
     *         <p>
     *         Attributes include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         serviceAccessRoleArn - The AWS Identity and Access Management (IAM) role that has permission to access
     *         the Amazon S3 bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         BucketName - The name of the S3 bucket to use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         compressionType - An optional parameter to use GZIP to compress the target files. Either set this
     *         parameter to NONE (the default) or don't use it to leave the files uncompressed.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Shorthand syntax for these settings is as follows:
     *         <code>ServiceAccessRoleArn=string ,BucketName=string,CompressionType=string</code>
     *         </p>
     *         <p>
     *         JSON syntax for these settings is as follows:
     *         <code>{ "ServiceAccessRoleArn": "string", "BucketName": "string", "CompressionType": "none"|"gzip" } </code>
     */
    public DmsTransferSettings dmsTransferSettings() {
        return dmsTransferSettings;
    }

    /**
     * <p>
     * Settings in JSON format for the source MongoDB endpoint. For more information about the available settings, see
     * the configuration properties section in <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html"> Using MongoDB as a Target for
     * AWS Database Migration Service</a> in the <i>AWS Database Migration Service User Guide.</i>
     * </p>
     * 
     * @return Settings in JSON format for the source MongoDB endpoint. For more information about the available
     *         settings, see the configuration properties section in <a
     *         href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html"> Using MongoDB as a
     *         Target for AWS Database Migration Service</a> in the <i>AWS Database Migration Service User Guide.</i>
     */
    public MongoDbSettings mongoDbSettings() {
        return mongoDbSettings;
    }

    /**
     * <p>
     * Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For more information about the
     * available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html">Using
     * Amazon Kinesis Data Streams as a Target for AWS Database Migration Service</a> in the <i>AWS Database Migration
     * User Guide.</i>
     * </p>
     * 
     * @return Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For more information
     *         about the available settings, see <a
     *         href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html">Using Amazon Kinesis
     *         Data Streams as a Target for AWS Database Migration Service</a> in the <i>AWS Database Migration User
     *         Guide.</i>
     */
    public KinesisSettings kinesisSettings() {
        return kinesisSettings;
    }

    /**
     * <p>
     * Settings in JSON format for the target Apache Kafka endpoint. For more information about the available settings,
     * see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html">Using Apache Kafka as a
     * Target for AWS Database Migration Service</a> in the <i>AWS Database Migration User Guide.</i>
     * </p>
     * 
     * @return Settings in JSON format for the target Apache Kafka endpoint. For more information about the available
     *         settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html">Using
     *         Apache Kafka as a Target for AWS Database Migration Service</a> in the <i>AWS Database Migration User
     *         Guide.</i>
     */
    public KafkaSettings kafkaSettings() {
        return kafkaSettings;
    }

    /**
     * <p>
     * Settings in JSON format for the target Elasticsearch endpoint. For more information about the available settings,
     * see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration"
     * >Extra Connection Attributes When Using Elasticsearch as a Target for AWS DMS</a> in the <i>AWS Database
     * Migration User Guide.</i>
     * </p>
     * 
     * @return Settings in JSON format for the target Elasticsearch endpoint. For more information about the available
     *         settings, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration"
     *         >Extra Connection Attributes When Using Elasticsearch as a Target for AWS DMS</a> in the <i>AWS Database
     *         Migration User Guide.</i>
     */
    public ElasticsearchSettings elasticsearchSettings() {
        return elasticsearchSettings;
    }

    /**
     * <p>
     * Settings in JSON format for the target Amazon Neptune endpoint. For more information about the available
     * settings, see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings"
     * >https
     * ://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings</a> in
     * the <i>AWS Database Migration Service User Guide.</i>
     * </p>
     * 
     * @return Settings in JSON format for the target Amazon Neptune endpoint. For more information about the available
     *         settings, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings"
     *         >https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.
     *         EndpointSettings</a> in the <i>AWS Database Migration Service User Guide.</i>
     */
    public NeptuneSettings neptuneSettings() {
        return neptuneSettings;
    }

    /**
     * Returns the value of the RedshiftSettings property for this object.
     * 
     * @return The value of the RedshiftSettings property for this object.
     */
    public RedshiftSettings redshiftSettings() {
        return redshiftSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(engineName());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(extraConnectionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(sslModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(externalTableDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(dynamoDbSettings());
        hashCode = 31 * hashCode + Objects.hashCode(s3Settings());
        hashCode = 31 * hashCode + Objects.hashCode(dmsTransferSettings());
        hashCode = 31 * hashCode + Objects.hashCode(mongoDbSettings());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisSettings());
        hashCode = 31 * hashCode + Objects.hashCode(kafkaSettings());
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearchSettings());
        hashCode = 31 * hashCode + Objects.hashCode(neptuneSettings());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftSettings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyEndpointRequest)) {
            return false;
        }
        ModifyEndpointRequest other = (ModifyEndpointRequest) obj;
        return Objects.equals(endpointArn(), other.endpointArn())
                && Objects.equals(endpointIdentifier(), other.endpointIdentifier())
                && Objects.equals(endpointTypeAsString(), other.endpointTypeAsString())
                && Objects.equals(engineName(), other.engineName()) && Objects.equals(username(), other.username())
                && Objects.equals(password(), other.password()) && Objects.equals(serverName(), other.serverName())
                && Objects.equals(port(), other.port()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(extraConnectionAttributes(), other.extraConnectionAttributes())
                && Objects.equals(certificateArn(), other.certificateArn())
                && Objects.equals(sslModeAsString(), other.sslModeAsString())
                && Objects.equals(serviceAccessRoleArn(), other.serviceAccessRoleArn())
                && Objects.equals(externalTableDefinition(), other.externalTableDefinition())
                && Objects.equals(dynamoDbSettings(), other.dynamoDbSettings())
                && Objects.equals(s3Settings(), other.s3Settings())
                && Objects.equals(dmsTransferSettings(), other.dmsTransferSettings())
                && Objects.equals(mongoDbSettings(), other.mongoDbSettings())
                && Objects.equals(kinesisSettings(), other.kinesisSettings())
                && Objects.equals(kafkaSettings(), other.kafkaSettings())
                && Objects.equals(elasticsearchSettings(), other.elasticsearchSettings())
                && Objects.equals(neptuneSettings(), other.neptuneSettings())
                && Objects.equals(redshiftSettings(), other.redshiftSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyEndpointRequest").add("EndpointArn", endpointArn())
                .add("EndpointIdentifier", endpointIdentifier()).add("EndpointType", endpointTypeAsString())
                .add("EngineName", engineName()).add("Username", username())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***").add("ServerName", serverName())
                .add("Port", port()).add("DatabaseName", databaseName())
                .add("ExtraConnectionAttributes", extraConnectionAttributes()).add("CertificateArn", certificateArn())
                .add("SslMode", sslModeAsString()).add("ServiceAccessRoleArn", serviceAccessRoleArn())
                .add("ExternalTableDefinition", externalTableDefinition()).add("DynamoDbSettings", dynamoDbSettings())
                .add("S3Settings", s3Settings()).add("DmsTransferSettings", dmsTransferSettings())
                .add("MongoDbSettings", mongoDbSettings()).add("KinesisSettings", kinesisSettings())
                .add("KafkaSettings", kafkaSettings()).add("ElasticsearchSettings", elasticsearchSettings())
                .add("NeptuneSettings", neptuneSettings()).add("RedshiftSettings", redshiftSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointArn":
            return Optional.ofNullable(clazz.cast(endpointArn()));
        case "EndpointIdentifier":
            return Optional.ofNullable(clazz.cast(endpointIdentifier()));
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointTypeAsString()));
        case "EngineName":
            return Optional.ofNullable(clazz.cast(engineName()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "ExtraConnectionAttributes":
            return Optional.ofNullable(clazz.cast(extraConnectionAttributes()));
        case "CertificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "SslMode":
            return Optional.ofNullable(clazz.cast(sslModeAsString()));
        case "ServiceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(serviceAccessRoleArn()));
        case "ExternalTableDefinition":
            return Optional.ofNullable(clazz.cast(externalTableDefinition()));
        case "DynamoDbSettings":
            return Optional.ofNullable(clazz.cast(dynamoDbSettings()));
        case "S3Settings":
            return Optional.ofNullable(clazz.cast(s3Settings()));
        case "DmsTransferSettings":
            return Optional.ofNullable(clazz.cast(dmsTransferSettings()));
        case "MongoDbSettings":
            return Optional.ofNullable(clazz.cast(mongoDbSettings()));
        case "KinesisSettings":
            return Optional.ofNullable(clazz.cast(kinesisSettings()));
        case "KafkaSettings":
            return Optional.ofNullable(clazz.cast(kafkaSettings()));
        case "ElasticsearchSettings":
            return Optional.ofNullable(clazz.cast(elasticsearchSettings()));
        case "NeptuneSettings":
            return Optional.ofNullable(clazz.cast(neptuneSettings()));
        case "RedshiftSettings":
            return Optional.ofNullable(clazz.cast(redshiftSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyEndpointRequest, T> g) {
        return obj -> g.apply((ModifyEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyEndpointRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
         * </p>
         * 
         * @param endpointArn
         *        The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointArn(String endpointArn);

        /**
         * <p>
         * The database endpoint identifier. Identifiers must begin with a letter and must contain only ASCII letters,
         * digits, and hyphens. They can't end with a hyphen or contain two consecutive hyphens.
         * </p>
         * 
         * @param endpointIdentifier
         *        The database endpoint identifier. Identifiers must begin with a letter and must contain only ASCII
         *        letters, digits, and hyphens. They can't end with a hyphen or contain two consecutive hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointIdentifier(String endpointIdentifier);

        /**
         * <p>
         * The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
         * </p>
         * 
         * @param endpointType
         *        The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
         * @see ReplicationEndpointTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationEndpointTypeValue
         */
        Builder endpointType(String endpointType);

        /**
         * <p>
         * The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
         * </p>
         * 
         * @param endpointType
         *        The type of endpoint. Valid values are <code>source</code> and <code>target</code>.
         * @see ReplicationEndpointTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationEndpointTypeValue
         */
        Builder endpointType(ReplicationEndpointTypeValue endpointType);

        /**
         * <p>
         * The type of engine for the endpoint. Valid values, depending on the EndpointType, include
         * <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>, <code>"mariadb"</code>,
         * <code>"aurora"</code>, <code>"aurora-postgresql"</code>, <code>"redshift"</code>, <code>"s3"</code>,
         * <code>"db2"</code>, <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>,
         * <code>"mongodb"</code>, <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>,
         * <code>"documentdb"</code>, and <code>"sqlserver"</code>.
         * </p>
         * 
         * @param engineName
         *        The type of engine for the endpoint. Valid values, depending on the EndpointType, include
         *        <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>, <code>"mariadb"</code>,
         *        <code>"aurora"</code>, <code>"aurora-postgresql"</code>, <code>"redshift"</code>, <code>"s3"</code>,
         *        <code>"db2"</code>, <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>,
         *        <code>"mongodb"</code>, <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>,
         *        <code>"documentdb"</code>, and <code>"sqlserver"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineName(String engineName);

        /**
         * <p>
         * The user name to be used to login to the endpoint database.
         * </p>
         * 
         * @param username
         *        The user name to be used to login to the endpoint database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The password to be used to login to the endpoint database.
         * </p>
         * 
         * @param password
         *        The password to be used to login to the endpoint database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The name of the server where the endpoint database resides.
         * </p>
         * 
         * @param serverName
         *        The name of the server where the endpoint database resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * The port used by the endpoint database.
         * </p>
         * 
         * @param port
         *        The port used by the endpoint database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The name of the endpoint database.
         * </p>
         * 
         * @param databaseName
         *        The name of the endpoint database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * Additional attributes associated with the connection. To reset this parameter, pass the empty string ("") as
         * an argument.
         * </p>
         * 
         * @param extraConnectionAttributes
         *        Additional attributes associated with the connection. To reset this parameter, pass the empty string
         *        ("") as an argument.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraConnectionAttributes(String extraConnectionAttributes);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the certificate used for SSL connection.
         * </p>
         * 
         * @param certificateArn
         *        The Amazon Resource Name (ARN) of the certificate used for SSL connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The SSL mode used to connect to the endpoint. The default value is <code>none</code>.
         * </p>
         * 
         * @param sslMode
         *        The SSL mode used to connect to the endpoint. The default value is <code>none</code>.
         * @see DmsSslModeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DmsSslModeValue
         */
        Builder sslMode(String sslMode);

        /**
         * <p>
         * The SSL mode used to connect to the endpoint. The default value is <code>none</code>.
         * </p>
         * 
         * @param sslMode
         *        The SSL mode used to connect to the endpoint. The default value is <code>none</code>.
         * @see DmsSslModeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DmsSslModeValue
         */
        Builder sslMode(DmsSslModeValue sslMode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the service access role you want to use to modify the endpoint.
         * </p>
         * 
         * @param serviceAccessRoleArn
         *        The Amazon Resource Name (ARN) for the service access role you want to use to modify the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccessRoleArn(String serviceAccessRoleArn);

        /**
         * <p>
         * The external table definition.
         * </p>
         * 
         * @param externalTableDefinition
         *        The external table definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalTableDefinition(String externalTableDefinition);

        /**
         * <p>
         * Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other available
         * settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html">Using
         * Object Mapping to Migrate Data to DynamoDB</a> in the <i>AWS Database Migration Service User Guide.</i>
         * </p>
         * 
         * @param dynamoDbSettings
         *        Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other available
         *        settings, see <a
         *        href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html">Using Object Mapping
         *        to Migrate Data to DynamoDB</a> in the <i>AWS Database Migration Service User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamoDbSettings(DynamoDbSettings dynamoDbSettings);

        /**
         * <p>
         * Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other available
         * settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html">Using
         * Object Mapping to Migrate Data to DynamoDB</a> in the <i>AWS Database Migration Service User Guide.</i>
         * </p>
         * This is a convenience that creates an instance of the {@link DynamoDbSettings.Builder} avoiding the need to
         * create one manually via {@link DynamoDbSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link DynamoDbSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #dynamoDbSettings(DynamoDbSettings)}.
         * 
         * @param dynamoDbSettings
         *        a consumer that will call methods on {@link DynamoDbSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamoDbSettings(DynamoDbSettings)
         */
        default Builder dynamoDbSettings(Consumer<DynamoDbSettings.Builder> dynamoDbSettings) {
            return dynamoDbSettings(DynamoDbSettings.builder().applyMutation(dynamoDbSettings).build());
        }

        /**
         * <p>
         * Settings in JSON format for the target Amazon S3 endpoint. For more information about the available settings,
         * see <a
         * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra
         * Connection Attributes When Using Amazon S3 as a Target for AWS DMS</a> in the <i>AWS Database Migration
         * Service User Guide.</i>
         * </p>
         * 
         * @param s3Settings
         *        Settings in JSON format for the target Amazon S3 endpoint. For more information about the available
         *        settings, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring"
         *        >Extra Connection Attributes When Using Amazon S3 as a Target for AWS DMS</a> in the <i>AWS Database
         *        Migration Service User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Settings(S3Settings s3Settings);

        /**
         * <p>
         * Settings in JSON format for the target Amazon S3 endpoint. For more information about the available settings,
         * see <a
         * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra
         * Connection Attributes When Using Amazon S3 as a Target for AWS DMS</a> in the <i>AWS Database Migration
         * Service User Guide.</i>
         * </p>
         * This is a convenience that creates an instance of the {@link S3Settings.Builder} avoiding the need to create
         * one manually via {@link S3Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Settings.Builder#build()} is called immediately and its result
         * is passed to {@link #s3Settings(S3Settings)}.
         * 
         * @param s3Settings
         *        a consumer that will call methods on {@link S3Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Settings(S3Settings)
         */
        default Builder s3Settings(Consumer<S3Settings.Builder> s3Settings) {
            return s3Settings(S3Settings.builder().applyMutation(s3Settings).build());
        }

        /**
         * <p>
         * The settings in JSON format for the DMS transfer type of source endpoint.
         * </p>
         * <p>
         * Attributes include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * serviceAccessRoleArn - The AWS Identity and Access Management (IAM) role that has permission to access the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * BucketName - The name of the S3 bucket to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * compressionType - An optional parameter to use GZIP to compress the target files. Either set this parameter
         * to NONE (the default) or don't use it to leave the files uncompressed.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Shorthand syntax for these settings is as follows:
         * <code>ServiceAccessRoleArn=string ,BucketName=string,CompressionType=string</code>
         * </p>
         * <p>
         * JSON syntax for these settings is as follows:
         * <code>{ "ServiceAccessRoleArn": "string", "BucketName": "string", "CompressionType": "none"|"gzip" } </code>
         * </p>
         * 
         * @param dmsTransferSettings
         *        The settings in JSON format for the DMS transfer type of source endpoint. </p>
         *        <p>
         *        Attributes include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        serviceAccessRoleArn - The AWS Identity and Access Management (IAM) role that has permission to access
         *        the Amazon S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        BucketName - The name of the S3 bucket to use.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        compressionType - An optional parameter to use GZIP to compress the target files. Either set this
         *        parameter to NONE (the default) or don't use it to leave the files uncompressed.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Shorthand syntax for these settings is as follows:
         *        <code>ServiceAccessRoleArn=string ,BucketName=string,CompressionType=string</code>
         *        </p>
         *        <p>
         *        JSON syntax for these settings is as follows:
         *        <code>{ "ServiceAccessRoleArn": "string", "BucketName": "string", "CompressionType": "none"|"gzip" } </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dmsTransferSettings(DmsTransferSettings dmsTransferSettings);

        /**
         * <p>
         * The settings in JSON format for the DMS transfer type of source endpoint.
         * </p>
         * <p>
         * Attributes include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * serviceAccessRoleArn - The AWS Identity and Access Management (IAM) role that has permission to access the
         * Amazon S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * BucketName - The name of the S3 bucket to use.
         * </p>
         * </li>
         * <li>
         * <p>
         * compressionType - An optional parameter to use GZIP to compress the target files. Either set this parameter
         * to NONE (the default) or don't use it to leave the files uncompressed.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Shorthand syntax for these settings is as follows:
         * <code>ServiceAccessRoleArn=string ,BucketName=string,CompressionType=string</code>
         * </p>
         * <p>
         * JSON syntax for these settings is as follows:
         * <code>{ "ServiceAccessRoleArn": "string", "BucketName": "string", "CompressionType": "none"|"gzip" } </code>
         * </p>
         * This is a convenience that creates an instance of the {@link DmsTransferSettings.Builder} avoiding the need
         * to create one manually via {@link DmsTransferSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link DmsTransferSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #dmsTransferSettings(DmsTransferSettings)}.
         * 
         * @param dmsTransferSettings
         *        a consumer that will call methods on {@link DmsTransferSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dmsTransferSettings(DmsTransferSettings)
         */
        default Builder dmsTransferSettings(Consumer<DmsTransferSettings.Builder> dmsTransferSettings) {
            return dmsTransferSettings(DmsTransferSettings.builder().applyMutation(dmsTransferSettings).build());
        }

        /**
         * <p>
         * Settings in JSON format for the source MongoDB endpoint. For more information about the available settings,
         * see the configuration properties section in <a
         * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html"> Using MongoDB as a Target
         * for AWS Database Migration Service</a> in the <i>AWS Database Migration Service User Guide.</i>
         * </p>
         * 
         * @param mongoDbSettings
         *        Settings in JSON format for the source MongoDB endpoint. For more information about the available
         *        settings, see the configuration properties section in <a
         *        href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html"> Using MongoDB as a
         *        Target for AWS Database Migration Service</a> in the <i>AWS Database Migration Service User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mongoDbSettings(MongoDbSettings mongoDbSettings);

        /**
         * <p>
         * Settings in JSON format for the source MongoDB endpoint. For more information about the available settings,
         * see the configuration properties section in <a
         * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html"> Using MongoDB as a Target
         * for AWS Database Migration Service</a> in the <i>AWS Database Migration Service User Guide.</i>
         * </p>
         * This is a convenience that creates an instance of the {@link MongoDbSettings.Builder} avoiding the need to
         * create one manually via {@link MongoDbSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link MongoDbSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #mongoDbSettings(MongoDbSettings)}.
         * 
         * @param mongoDbSettings
         *        a consumer that will call methods on {@link MongoDbSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mongoDbSettings(MongoDbSettings)
         */
        default Builder mongoDbSettings(Consumer<MongoDbSettings.Builder> mongoDbSettings) {
            return mongoDbSettings(MongoDbSettings.builder().applyMutation(mongoDbSettings).build());
        }

        /**
         * <p>
         * Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For more information about
         * the available settings, see <a
         * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html">Using Amazon Kinesis Data
         * Streams as a Target for AWS Database Migration Service</a> in the <i>AWS Database Migration User Guide.</i>
         * </p>
         * 
         * @param kinesisSettings
         *        Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For more information
         *        about the available settings, see <a
         *        href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html">Using Amazon Kinesis
         *        Data Streams as a Target for AWS Database Migration Service</a> in the <i>AWS Database Migration User
         *        Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisSettings(KinesisSettings kinesisSettings);

        /**
         * <p>
         * Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For more information about
         * the available settings, see <a
         * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html">Using Amazon Kinesis Data
         * Streams as a Target for AWS Database Migration Service</a> in the <i>AWS Database Migration User Guide.</i>
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisSettings.Builder} avoiding the need to
         * create one manually via {@link KinesisSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #kinesisSettings(KinesisSettings)}.
         * 
         * @param kinesisSettings
         *        a consumer that will call methods on {@link KinesisSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisSettings(KinesisSettings)
         */
        default Builder kinesisSettings(Consumer<KinesisSettings.Builder> kinesisSettings) {
            return kinesisSettings(KinesisSettings.builder().applyMutation(kinesisSettings).build());
        }

        /**
         * <p>
         * Settings in JSON format for the target Apache Kafka endpoint. For more information about the available
         * settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html">Using Apache
         * Kafka as a Target for AWS Database Migration Service</a> in the <i>AWS Database Migration User Guide.</i>
         * </p>
         * 
         * @param kafkaSettings
         *        Settings in JSON format for the target Apache Kafka endpoint. For more information about the available
         *        settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html">Using
         *        Apache Kafka as a Target for AWS Database Migration Service</a> in the <i>AWS Database Migration User
         *        Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafkaSettings(KafkaSettings kafkaSettings);

        /**
         * <p>
         * Settings in JSON format for the target Apache Kafka endpoint. For more information about the available
         * settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html">Using Apache
         * Kafka as a Target for AWS Database Migration Service</a> in the <i>AWS Database Migration User Guide.</i>
         * </p>
         * This is a convenience that creates an instance of the {@link KafkaSettings.Builder} avoiding the need to
         * create one manually via {@link KafkaSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link KafkaSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #kafkaSettings(KafkaSettings)}.
         * 
         * @param kafkaSettings
         *        a consumer that will call methods on {@link KafkaSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kafkaSettings(KafkaSettings)
         */
        default Builder kafkaSettings(Consumer<KafkaSettings.Builder> kafkaSettings) {
            return kafkaSettings(KafkaSettings.builder().applyMutation(kafkaSettings).build());
        }

        /**
         * <p>
         * Settings in JSON format for the target Elasticsearch endpoint. For more information about the available
         * settings, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration"
         * >Extra Connection Attributes When Using Elasticsearch as a Target for AWS DMS</a> in the <i>AWS Database
         * Migration User Guide.</i>
         * </p>
         * 
         * @param elasticsearchSettings
         *        Settings in JSON format for the target Elasticsearch endpoint. For more information about the
         *        available settings, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration"
         *        >Extra Connection Attributes When Using Elasticsearch as a Target for AWS DMS</a> in the <i>AWS
         *        Database Migration User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchSettings(ElasticsearchSettings elasticsearchSettings);

        /**
         * <p>
         * Settings in JSON format for the target Elasticsearch endpoint. For more information about the available
         * settings, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration"
         * >Extra Connection Attributes When Using Elasticsearch as a Target for AWS DMS</a> in the <i>AWS Database
         * Migration User Guide.</i>
         * </p>
         * This is a convenience that creates an instance of the {@link ElasticsearchSettings.Builder} avoiding the need
         * to create one manually via {@link ElasticsearchSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ElasticsearchSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #elasticsearchSettings(ElasticsearchSettings)}.
         * 
         * @param elasticsearchSettings
         *        a consumer that will call methods on {@link ElasticsearchSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticsearchSettings(ElasticsearchSettings)
         */
        default Builder elasticsearchSettings(Consumer<ElasticsearchSettings.Builder> elasticsearchSettings) {
            return elasticsearchSettings(ElasticsearchSettings.builder().applyMutation(elasticsearchSettings).build());
        }

        /**
         * <p>
         * Settings in JSON format for the target Amazon Neptune endpoint. For more information about the available
         * settings, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings"
         * >https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.
         * EndpointSettings</a> in the <i>AWS Database Migration Service User Guide.</i>
         * </p>
         * 
         * @param neptuneSettings
         *        Settings in JSON format for the target Amazon Neptune endpoint. For more information about the
         *        available settings, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings"
         *        >https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.
         *        EndpointSettings</a> in the <i>AWS Database Migration Service User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neptuneSettings(NeptuneSettings neptuneSettings);

        /**
         * <p>
         * Settings in JSON format for the target Amazon Neptune endpoint. For more information about the available
         * settings, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings"
         * >https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.
         * EndpointSettings</a> in the <i>AWS Database Migration Service User Guide.</i>
         * </p>
         * This is a convenience that creates an instance of the {@link NeptuneSettings.Builder} avoiding the need to
         * create one manually via {@link NeptuneSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link NeptuneSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #neptuneSettings(NeptuneSettings)}.
         * 
         * @param neptuneSettings
         *        a consumer that will call methods on {@link NeptuneSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #neptuneSettings(NeptuneSettings)
         */
        default Builder neptuneSettings(Consumer<NeptuneSettings.Builder> neptuneSettings) {
            return neptuneSettings(NeptuneSettings.builder().applyMutation(neptuneSettings).build());
        }

        /**
         * Sets the value of the RedshiftSettings property for this object.
         *
         * @param redshiftSettings
         *        The new value for the RedshiftSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftSettings(RedshiftSettings redshiftSettings);

        /**
         * Sets the value of the RedshiftSettings property for this object.
         *
         * This is a convenience that creates an instance of the {@link RedshiftSettings.Builder} avoiding the need to
         * create one manually via {@link RedshiftSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link RedshiftSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #redshiftSettings(RedshiftSettings)}.
         * 
         * @param redshiftSettings
         *        a consumer that will call methods on {@link RedshiftSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftSettings(RedshiftSettings)
         */
        default Builder redshiftSettings(Consumer<RedshiftSettings.Builder> redshiftSettings) {
            return redshiftSettings(RedshiftSettings.builder().applyMutation(redshiftSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String endpointArn;

        private String endpointIdentifier;

        private String endpointType;

        private String engineName;

        private String username;

        private String password;

        private String serverName;

        private Integer port;

        private String databaseName;

        private String extraConnectionAttributes;

        private String certificateArn;

        private String sslMode;

        private String serviceAccessRoleArn;

        private String externalTableDefinition;

        private DynamoDbSettings dynamoDbSettings;

        private S3Settings s3Settings;

        private DmsTransferSettings dmsTransferSettings;

        private MongoDbSettings mongoDbSettings;

        private KinesisSettings kinesisSettings;

        private KafkaSettings kafkaSettings;

        private ElasticsearchSettings elasticsearchSettings;

        private NeptuneSettings neptuneSettings;

        private RedshiftSettings redshiftSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyEndpointRequest model) {
            super(model);
            endpointArn(model.endpointArn);
            endpointIdentifier(model.endpointIdentifier);
            endpointType(model.endpointType);
            engineName(model.engineName);
            username(model.username);
            password(model.password);
            serverName(model.serverName);
            port(model.port);
            databaseName(model.databaseName);
            extraConnectionAttributes(model.extraConnectionAttributes);
            certificateArn(model.certificateArn);
            sslMode(model.sslMode);
            serviceAccessRoleArn(model.serviceAccessRoleArn);
            externalTableDefinition(model.externalTableDefinition);
            dynamoDbSettings(model.dynamoDbSettings);
            s3Settings(model.s3Settings);
            dmsTransferSettings(model.dmsTransferSettings);
            mongoDbSettings(model.mongoDbSettings);
            kinesisSettings(model.kinesisSettings);
            kafkaSettings(model.kafkaSettings);
            elasticsearchSettings(model.elasticsearchSettings);
            neptuneSettings(model.neptuneSettings);
            redshiftSettings(model.redshiftSettings);
        }

        public final String getEndpointArn() {
            return endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        public final String getEndpointIdentifier() {
            return endpointIdentifier;
        }

        @Override
        public final Builder endpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
            return this;
        }

        public final void setEndpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
        }

        public final String getEndpointType() {
            return endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(ReplicationEndpointTypeValue endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        public final String getEngineName() {
            return engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getServerName() {
            return serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final Integer getPort() {
            return port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getExtraConnectionAttributes() {
            return extraConnectionAttributes;
        }

        @Override
        public final Builder extraConnectionAttributes(String extraConnectionAttributes) {
            this.extraConnectionAttributes = extraConnectionAttributes;
            return this;
        }

        public final void setExtraConnectionAttributes(String extraConnectionAttributes) {
            this.extraConnectionAttributes = extraConnectionAttributes;
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getSslMode() {
            return sslMode;
        }

        @Override
        public final Builder sslMode(String sslMode) {
            this.sslMode = sslMode;
            return this;
        }

        @Override
        public final Builder sslMode(DmsSslModeValue sslMode) {
            this.sslMode(sslMode == null ? null : sslMode.toString());
            return this;
        }

        public final void setSslMode(String sslMode) {
            this.sslMode = sslMode;
        }

        public final String getServiceAccessRoleArn() {
            return serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        public final String getExternalTableDefinition() {
            return externalTableDefinition;
        }

        @Override
        public final Builder externalTableDefinition(String externalTableDefinition) {
            this.externalTableDefinition = externalTableDefinition;
            return this;
        }

        public final void setExternalTableDefinition(String externalTableDefinition) {
            this.externalTableDefinition = externalTableDefinition;
        }

        public final DynamoDbSettings.Builder getDynamoDbSettings() {
            return dynamoDbSettings != null ? dynamoDbSettings.toBuilder() : null;
        }

        @Override
        public final Builder dynamoDbSettings(DynamoDbSettings dynamoDbSettings) {
            this.dynamoDbSettings = dynamoDbSettings;
            return this;
        }

        public final void setDynamoDbSettings(DynamoDbSettings.BuilderImpl dynamoDbSettings) {
            this.dynamoDbSettings = dynamoDbSettings != null ? dynamoDbSettings.build() : null;
        }

        public final S3Settings.Builder getS3Settings() {
            return s3Settings != null ? s3Settings.toBuilder() : null;
        }

        @Override
        public final Builder s3Settings(S3Settings s3Settings) {
            this.s3Settings = s3Settings;
            return this;
        }

        public final void setS3Settings(S3Settings.BuilderImpl s3Settings) {
            this.s3Settings = s3Settings != null ? s3Settings.build() : null;
        }

        public final DmsTransferSettings.Builder getDmsTransferSettings() {
            return dmsTransferSettings != null ? dmsTransferSettings.toBuilder() : null;
        }

        @Override
        public final Builder dmsTransferSettings(DmsTransferSettings dmsTransferSettings) {
            this.dmsTransferSettings = dmsTransferSettings;
            return this;
        }

        public final void setDmsTransferSettings(DmsTransferSettings.BuilderImpl dmsTransferSettings) {
            this.dmsTransferSettings = dmsTransferSettings != null ? dmsTransferSettings.build() : null;
        }

        public final MongoDbSettings.Builder getMongoDbSettings() {
            return mongoDbSettings != null ? mongoDbSettings.toBuilder() : null;
        }

        @Override
        public final Builder mongoDbSettings(MongoDbSettings mongoDbSettings) {
            this.mongoDbSettings = mongoDbSettings;
            return this;
        }

        public final void setMongoDbSettings(MongoDbSettings.BuilderImpl mongoDbSettings) {
            this.mongoDbSettings = mongoDbSettings != null ? mongoDbSettings.build() : null;
        }

        public final KinesisSettings.Builder getKinesisSettings() {
            return kinesisSettings != null ? kinesisSettings.toBuilder() : null;
        }

        @Override
        public final Builder kinesisSettings(KinesisSettings kinesisSettings) {
            this.kinesisSettings = kinesisSettings;
            return this;
        }

        public final void setKinesisSettings(KinesisSettings.BuilderImpl kinesisSettings) {
            this.kinesisSettings = kinesisSettings != null ? kinesisSettings.build() : null;
        }

        public final KafkaSettings.Builder getKafkaSettings() {
            return kafkaSettings != null ? kafkaSettings.toBuilder() : null;
        }

        @Override
        public final Builder kafkaSettings(KafkaSettings kafkaSettings) {
            this.kafkaSettings = kafkaSettings;
            return this;
        }

        public final void setKafkaSettings(KafkaSettings.BuilderImpl kafkaSettings) {
            this.kafkaSettings = kafkaSettings != null ? kafkaSettings.build() : null;
        }

        public final ElasticsearchSettings.Builder getElasticsearchSettings() {
            return elasticsearchSettings != null ? elasticsearchSettings.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchSettings(ElasticsearchSettings elasticsearchSettings) {
            this.elasticsearchSettings = elasticsearchSettings;
            return this;
        }

        public final void setElasticsearchSettings(ElasticsearchSettings.BuilderImpl elasticsearchSettings) {
            this.elasticsearchSettings = elasticsearchSettings != null ? elasticsearchSettings.build() : null;
        }

        public final NeptuneSettings.Builder getNeptuneSettings() {
            return neptuneSettings != null ? neptuneSettings.toBuilder() : null;
        }

        @Override
        public final Builder neptuneSettings(NeptuneSettings neptuneSettings) {
            this.neptuneSettings = neptuneSettings;
            return this;
        }

        public final void setNeptuneSettings(NeptuneSettings.BuilderImpl neptuneSettings) {
            this.neptuneSettings = neptuneSettings != null ? neptuneSettings.build() : null;
        }

        public final RedshiftSettings.Builder getRedshiftSettings() {
            return redshiftSettings != null ? redshiftSettings.toBuilder() : null;
        }

        @Override
        public final Builder redshiftSettings(RedshiftSettings redshiftSettings) {
            this.redshiftSettings = redshiftSettings;
            return this;
        }

        public final void setRedshiftSettings(RedshiftSettings.BuilderImpl redshiftSettings) {
            this.redshiftSettings = redshiftSettings != null ? redshiftSettings.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyEndpointRequest build() {
            return new ModifyEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
