/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that describes an Amazon Kinesis Data Stream endpoint. This information includes the output
 * format of records applied to the endpoint and details of transaction and control table data information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisSettings implements SdkPojo, Serializable, ToCopyableBuilder<KinesisSettings.Builder, KinesisSettings> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(KinesisSettings::streamArn)).setter(setter(Builder::streamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()).build();

    private static final SdkField<String> MESSAGE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(KinesisSettings::messageFormatAsString)).setter(setter(Builder::messageFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageFormat").build()).build();

    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(KinesisSettings::serviceAccessRoleArn)).setter(setter(Builder::serviceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build())
            .build();

    private static final SdkField<Boolean> INCLUDE_TRANSACTION_DETAILS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).getter(getter(KinesisSettings::includeTransactionDetails))
            .setter(setter(Builder::includeTransactionDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTransactionDetails").build())
            .build();

    private static final SdkField<Boolean> INCLUDE_PARTITION_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(KinesisSettings::includePartitionValue)).setter(setter(Builder::includePartitionValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludePartitionValue").build())
            .build();

    private static final SdkField<Boolean> PARTITION_INCLUDE_SCHEMA_TABLE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(KinesisSettings::partitionIncludeSchemaTable))
            .setter(setter(Builder::partitionIncludeSchemaTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionIncludeSchemaTable")
                    .build()).build();

    private static final SdkField<Boolean> INCLUDE_TABLE_ALTER_OPERATIONS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(KinesisSettings::includeTableAlterOperations))
            .setter(setter(Builder::includeTableAlterOperations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTableAlterOperations")
                    .build()).build();

    private static final SdkField<Boolean> INCLUDE_CONTROL_DETAILS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(KinesisSettings::includeControlDetails)).setter(setter(Builder::includeControlDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeControlDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD,
            MESSAGE_FORMAT_FIELD, SERVICE_ACCESS_ROLE_ARN_FIELD, INCLUDE_TRANSACTION_DETAILS_FIELD,
            INCLUDE_PARTITION_VALUE_FIELD, PARTITION_INCLUDE_SCHEMA_TABLE_FIELD, INCLUDE_TABLE_ALTER_OPERATIONS_FIELD,
            INCLUDE_CONTROL_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String streamArn;

    private final String messageFormat;

    private final String serviceAccessRoleArn;

    private final Boolean includeTransactionDetails;

    private final Boolean includePartitionValue;

    private final Boolean partitionIncludeSchemaTable;

    private final Boolean includeTableAlterOperations;

    private final Boolean includeControlDetails;

    private KinesisSettings(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.messageFormat = builder.messageFormat;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.includeTransactionDetails = builder.includeTransactionDetails;
        this.includePartitionValue = builder.includePartitionValue;
        this.partitionIncludeSchemaTable = builder.partitionIncludeSchemaTable;
        this.includeTableAlterOperations = builder.includeTableAlterOperations;
        this.includeControlDetails = builder.includeControlDetails;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.
     */
    public String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * The output format for the records created on the endpoint. The message format is <code>JSON</code> (default) or
     * <code>JSON_UNFORMATTED</code> (a single line with no tab).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageFormat}
     * will return {@link MessageFormatValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #messageFormatAsString}.
     * </p>
     * 
     * @return The output format for the records created on the endpoint. The message format is <code>JSON</code>
     *         (default) or <code>JSON_UNFORMATTED</code> (a single line with no tab).
     * @see MessageFormatValue
     */
    public MessageFormatValue messageFormat() {
        return MessageFormatValue.fromValue(messageFormat);
    }

    /**
     * <p>
     * The output format for the records created on the endpoint. The message format is <code>JSON</code> (default) or
     * <code>JSON_UNFORMATTED</code> (a single line with no tab).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageFormat}
     * will return {@link MessageFormatValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #messageFormatAsString}.
     * </p>
     * 
     * @return The output format for the records created on the endpoint. The message format is <code>JSON</code>
     *         (default) or <code>JSON_UNFORMATTED</code> (a single line with no tab).
     * @see MessageFormatValue
     */
    public String messageFormatAsString() {
        return messageFormat;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the AWS Identity and Access Management (IAM) role that AWS DMS uses to write
     * to the Kinesis data stream.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the AWS Identity and Access Management (IAM) role that AWS DMS uses to
     *         write to the Kinesis data stream.
     */
    public String serviceAccessRoleArn() {
        return serviceAccessRoleArn;
    }

    /**
     * <p>
     * Provides detailed transaction information from the source database. This information includes a commit timestamp,
     * a log position, and values for <code>transaction_id</code>, previous <code>transaction_id</code>, and
     * <code>transaction_record_id</code> (the record offset within a transaction). The default is <code>False</code>.
     * </p>
     * 
     * @return Provides detailed transaction information from the source database. This information includes a commit
     *         timestamp, a log position, and values for <code>transaction_id</code>, previous
     *         <code>transaction_id</code>, and <code>transaction_record_id</code> (the record offset within a
     *         transaction). The default is <code>False</code>.
     */
    public Boolean includeTransactionDetails() {
        return includeTransactionDetails;
    }

    /**
     * <p>
     * Shows the partition value within the Kinesis message output, unless the partition type is
     * <code>schema-table-type</code>. The default is <code>False</code>.
     * </p>
     * 
     * @return Shows the partition value within the Kinesis message output, unless the partition type is
     *         <code>schema-table-type</code>. The default is <code>False</code>.
     */
    public Boolean includePartitionValue() {
        return includePartitionValue;
    }

    /**
     * <p>
     * Prefixes schema and table names to partition values, when the partition type is <code>primary-key-type</code>.
     * Doing this increases data distribution among Kinesis shards. For example, suppose that a SysBench schema has
     * thousands of tables and each table has only limited range for a primary key. In this case, the same primary key
     * is sent from thousands of tables to the same shard, which causes throttling. The default is <code>False</code>.
     * </p>
     * 
     * @return Prefixes schema and table names to partition values, when the partition type is
     *         <code>primary-key-type</code>. Doing this increases data distribution among Kinesis shards. For example,
     *         suppose that a SysBench schema has thousands of tables and each table has only limited range for a
     *         primary key. In this case, the same primary key is sent from thousands of tables to the same shard, which
     *         causes throttling. The default is <code>False</code>.
     */
    public Boolean partitionIncludeSchemaTable() {
        return partitionIncludeSchemaTable;
    }

    /**
     * <p>
     * Includes any data definition language (DDL) operations that change the table in the control data, such as
     * <code>rename-table</code>, <code>drop-table</code>, <code>add-column</code>, <code>drop-column</code>, and
     * <code>rename-column</code>. The default is <code>False</code>.
     * </p>
     * 
     * @return Includes any data definition language (DDL) operations that change the table in the control data, such as
     *         <code>rename-table</code>, <code>drop-table</code>, <code>add-column</code>, <code>drop-column</code>,
     *         and <code>rename-column</code>. The default is <code>False</code>.
     */
    public Boolean includeTableAlterOperations() {
        return includeTableAlterOperations;
    }

    /**
     * <p>
     * Shows detailed control information for table definition, column definition, and table and column changes in the
     * Kinesis message output. The default is <code>False</code>.
     * </p>
     * 
     * @return Shows detailed control information for table definition, column definition, and table and column changes
     *         in the Kinesis message output. The default is <code>False</code>.
     */
    public Boolean includeControlDetails() {
        return includeControlDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(messageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(includeTransactionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(includePartitionValue());
        hashCode = 31 * hashCode + Objects.hashCode(partitionIncludeSchemaTable());
        hashCode = 31 * hashCode + Objects.hashCode(includeTableAlterOperations());
        hashCode = 31 * hashCode + Objects.hashCode(includeControlDetails());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisSettings)) {
            return false;
        }
        KinesisSettings other = (KinesisSettings) obj;
        return Objects.equals(streamArn(), other.streamArn())
                && Objects.equals(messageFormatAsString(), other.messageFormatAsString())
                && Objects.equals(serviceAccessRoleArn(), other.serviceAccessRoleArn())
                && Objects.equals(includeTransactionDetails(), other.includeTransactionDetails())
                && Objects.equals(includePartitionValue(), other.includePartitionValue())
                && Objects.equals(partitionIncludeSchemaTable(), other.partitionIncludeSchemaTable())
                && Objects.equals(includeTableAlterOperations(), other.includeTableAlterOperations())
                && Objects.equals(includeControlDetails(), other.includeControlDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("KinesisSettings").add("StreamArn", streamArn()).add("MessageFormat", messageFormatAsString())
                .add("ServiceAccessRoleArn", serviceAccessRoleArn())
                .add("IncludeTransactionDetails", includeTransactionDetails())
                .add("IncludePartitionValue", includePartitionValue())
                .add("PartitionIncludeSchemaTable", partitionIncludeSchemaTable())
                .add("IncludeTableAlterOperations", includeTableAlterOperations())
                .add("IncludeControlDetails", includeControlDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        case "MessageFormat":
            return Optional.ofNullable(clazz.cast(messageFormatAsString()));
        case "ServiceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(serviceAccessRoleArn()));
        case "IncludeTransactionDetails":
            return Optional.ofNullable(clazz.cast(includeTransactionDetails()));
        case "IncludePartitionValue":
            return Optional.ofNullable(clazz.cast(includePartitionValue()));
        case "PartitionIncludeSchemaTable":
            return Optional.ofNullable(clazz.cast(partitionIncludeSchemaTable()));
        case "IncludeTableAlterOperations":
            return Optional.ofNullable(clazz.cast(includeTableAlterOperations()));
        case "IncludeControlDetails":
            return Optional.ofNullable(clazz.cast(includeControlDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisSettings, T> g) {
        return obj -> g.apply((KinesisSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisSettings> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.
         * </p>
         * 
         * @param streamArn
         *        The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * The output format for the records created on the endpoint. The message format is <code>JSON</code> (default)
         * or <code>JSON_UNFORMATTED</code> (a single line with no tab).
         * </p>
         * 
         * @param messageFormat
         *        The output format for the records created on the endpoint. The message format is <code>JSON</code>
         *        (default) or <code>JSON_UNFORMATTED</code> (a single line with no tab).
         * @see MessageFormatValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageFormatValue
         */
        Builder messageFormat(String messageFormat);

        /**
         * <p>
         * The output format for the records created on the endpoint. The message format is <code>JSON</code> (default)
         * or <code>JSON_UNFORMATTED</code> (a single line with no tab).
         * </p>
         * 
         * @param messageFormat
         *        The output format for the records created on the endpoint. The message format is <code>JSON</code>
         *        (default) or <code>JSON_UNFORMATTED</code> (a single line with no tab).
         * @see MessageFormatValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageFormatValue
         */
        Builder messageFormat(MessageFormatValue messageFormat);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the AWS Identity and Access Management (IAM) role that AWS DMS uses to
         * write to the Kinesis data stream.
         * </p>
         * 
         * @param serviceAccessRoleArn
         *        The Amazon Resource Name (ARN) for the AWS Identity and Access Management (IAM) role that AWS DMS uses
         *        to write to the Kinesis data stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccessRoleArn(String serviceAccessRoleArn);

        /**
         * <p>
         * Provides detailed transaction information from the source database. This information includes a commit
         * timestamp, a log position, and values for <code>transaction_id</code>, previous <code>transaction_id</code>,
         * and <code>transaction_record_id</code> (the record offset within a transaction). The default is
         * <code>False</code>.
         * </p>
         * 
         * @param includeTransactionDetails
         *        Provides detailed transaction information from the source database. This information includes a commit
         *        timestamp, a log position, and values for <code>transaction_id</code>, previous
         *        <code>transaction_id</code>, and <code>transaction_record_id</code> (the record offset within a
         *        transaction). The default is <code>False</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeTransactionDetails(Boolean includeTransactionDetails);

        /**
         * <p>
         * Shows the partition value within the Kinesis message output, unless the partition type is
         * <code>schema-table-type</code>. The default is <code>False</code>.
         * </p>
         * 
         * @param includePartitionValue
         *        Shows the partition value within the Kinesis message output, unless the partition type is
         *        <code>schema-table-type</code>. The default is <code>False</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includePartitionValue(Boolean includePartitionValue);

        /**
         * <p>
         * Prefixes schema and table names to partition values, when the partition type is <code>primary-key-type</code>
         * . Doing this increases data distribution among Kinesis shards. For example, suppose that a SysBench schema
         * has thousands of tables and each table has only limited range for a primary key. In this case, the same
         * primary key is sent from thousands of tables to the same shard, which causes throttling. The default is
         * <code>False</code>.
         * </p>
         * 
         * @param partitionIncludeSchemaTable
         *        Prefixes schema and table names to partition values, when the partition type is
         *        <code>primary-key-type</code>. Doing this increases data distribution among Kinesis shards. For
         *        example, suppose that a SysBench schema has thousands of tables and each table has only limited range
         *        for a primary key. In this case, the same primary key is sent from thousands of tables to the same
         *        shard, which causes throttling. The default is <code>False</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionIncludeSchemaTable(Boolean partitionIncludeSchemaTable);

        /**
         * <p>
         * Includes any data definition language (DDL) operations that change the table in the control data, such as
         * <code>rename-table</code>, <code>drop-table</code>, <code>add-column</code>, <code>drop-column</code>, and
         * <code>rename-column</code>. The default is <code>False</code>.
         * </p>
         * 
         * @param includeTableAlterOperations
         *        Includes any data definition language (DDL) operations that change the table in the control data, such
         *        as <code>rename-table</code>, <code>drop-table</code>, <code>add-column</code>,
         *        <code>drop-column</code>, and <code>rename-column</code>. The default is <code>False</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeTableAlterOperations(Boolean includeTableAlterOperations);

        /**
         * <p>
         * Shows detailed control information for table definition, column definition, and table and column changes in
         * the Kinesis message output. The default is <code>False</code>.
         * </p>
         * 
         * @param includeControlDetails
         *        Shows detailed control information for table definition, column definition, and table and column
         *        changes in the Kinesis message output. The default is <code>False</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeControlDetails(Boolean includeControlDetails);
    }

    static final class BuilderImpl implements Builder {
        private String streamArn;

        private String messageFormat;

        private String serviceAccessRoleArn;

        private Boolean includeTransactionDetails;

        private Boolean includePartitionValue;

        private Boolean partitionIncludeSchemaTable;

        private Boolean includeTableAlterOperations;

        private Boolean includeControlDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisSettings model) {
            streamArn(model.streamArn);
            messageFormat(model.messageFormat);
            serviceAccessRoleArn(model.serviceAccessRoleArn);
            includeTransactionDetails(model.includeTransactionDetails);
            includePartitionValue(model.includePartitionValue);
            partitionIncludeSchemaTable(model.partitionIncludeSchemaTable);
            includeTableAlterOperations(model.includeTableAlterOperations);
            includeControlDetails(model.includeControlDetails);
        }

        public final String getStreamArn() {
            return streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        public final String getMessageFormat() {
            return messageFormat;
        }

        @Override
        public final Builder messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        @Override
        public final Builder messageFormat(MessageFormatValue messageFormat) {
            this.messageFormat(messageFormat == null ? null : messageFormat.toString());
            return this;
        }

        public final void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        public final String getServiceAccessRoleArn() {
            return serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        public final Boolean getIncludeTransactionDetails() {
            return includeTransactionDetails;
        }

        @Override
        public final Builder includeTransactionDetails(Boolean includeTransactionDetails) {
            this.includeTransactionDetails = includeTransactionDetails;
            return this;
        }

        public final void setIncludeTransactionDetails(Boolean includeTransactionDetails) {
            this.includeTransactionDetails = includeTransactionDetails;
        }

        public final Boolean getIncludePartitionValue() {
            return includePartitionValue;
        }

        @Override
        public final Builder includePartitionValue(Boolean includePartitionValue) {
            this.includePartitionValue = includePartitionValue;
            return this;
        }

        public final void setIncludePartitionValue(Boolean includePartitionValue) {
            this.includePartitionValue = includePartitionValue;
        }

        public final Boolean getPartitionIncludeSchemaTable() {
            return partitionIncludeSchemaTable;
        }

        @Override
        public final Builder partitionIncludeSchemaTable(Boolean partitionIncludeSchemaTable) {
            this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
            return this;
        }

        public final void setPartitionIncludeSchemaTable(Boolean partitionIncludeSchemaTable) {
            this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
        }

        public final Boolean getIncludeTableAlterOperations() {
            return includeTableAlterOperations;
        }

        @Override
        public final Builder includeTableAlterOperations(Boolean includeTableAlterOperations) {
            this.includeTableAlterOperations = includeTableAlterOperations;
            return this;
        }

        public final void setIncludeTableAlterOperations(Boolean includeTableAlterOperations) {
            this.includeTableAlterOperations = includeTableAlterOperations;
        }

        public final Boolean getIncludeControlDetails() {
            return includeControlDetails;
        }

        @Override
        public final Builder includeControlDetails(Boolean includeControlDetails) {
            this.includeControlDetails = includeControlDetails;
            return this;
        }

        public final void setIncludeControlDetails(Boolean includeControlDetails) {
            this.includeControlDetails = includeControlDetails;
        }

        @Override
        public KinesisSettings build() {
            return new KinesisSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
