/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that describes an Apache Kafka endpoint. This information includes the output format of records
 * applied to the endpoint and details of transaction and control table data information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KafkaSettings implements SdkPojo, Serializable, ToCopyableBuilder<KafkaSettings.Builder, KafkaSettings> {
    private static final SdkField<String> BROKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(KafkaSettings::broker)).setter(setter(Builder::broker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Broker").build()).build();

    private static final SdkField<String> TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(KafkaSettings::topic)).setter(setter(Builder::topic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Topic").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_FIELD, TOPIC_FIELD));

    private static final long serialVersionUID = 1L;

    private final String broker;

    private final String topic;

    private KafkaSettings(BuilderImpl builder) {
        this.broker = builder.broker;
        this.topic = builder.topic;
    }

    /**
     * <p>
     * The broker location and port of the Kafka broker that hosts your Kafka instance. Specify the broker in the form
     * <code> <i>broker-hostname-or-ip</i>:<i>port</i> </code>. For example,
     * <code>"ec2-12-345-678-901.compute-1.amazonaws.com:2345"</code>.
     * </p>
     * 
     * @return The broker location and port of the Kafka broker that hosts your Kafka instance. Specify the broker in
     *         the form <code> <i>broker-hostname-or-ip</i>:<i>port</i> </code>. For example,
     *         <code>"ec2-12-345-678-901.compute-1.amazonaws.com:2345"</code>.
     */
    public String broker() {
        return broker;
    }

    /**
     * <p>
     * The topic to which you migrate the data. If you don't specify a topic, AWS DMS specifies
     * <code>"kafka-default-topic"</code> as the migration topic.
     * </p>
     * 
     * @return The topic to which you migrate the data. If you don't specify a topic, AWS DMS specifies
     *         <code>"kafka-default-topic"</code> as the migration topic.
     */
    public String topic() {
        return topic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(broker());
        hashCode = 31 * hashCode + Objects.hashCode(topic());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KafkaSettings)) {
            return false;
        }
        KafkaSettings other = (KafkaSettings) obj;
        return Objects.equals(broker(), other.broker()) && Objects.equals(topic(), other.topic());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("KafkaSettings").add("Broker", broker()).add("Topic", topic()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Broker":
            return Optional.ofNullable(clazz.cast(broker()));
        case "Topic":
            return Optional.ofNullable(clazz.cast(topic()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KafkaSettings, T> g) {
        return obj -> g.apply((KafkaSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KafkaSettings> {
        /**
         * <p>
         * The broker location and port of the Kafka broker that hosts your Kafka instance. Specify the broker in the
         * form <code> <i>broker-hostname-or-ip</i>:<i>port</i> </code>. For example,
         * <code>"ec2-12-345-678-901.compute-1.amazonaws.com:2345"</code>.
         * </p>
         * 
         * @param broker
         *        The broker location and port of the Kafka broker that hosts your Kafka instance. Specify the broker in
         *        the form <code> <i>broker-hostname-or-ip</i>:<i>port</i> </code>. For example,
         *        <code>"ec2-12-345-678-901.compute-1.amazonaws.com:2345"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder broker(String broker);

        /**
         * <p>
         * The topic to which you migrate the data. If you don't specify a topic, AWS DMS specifies
         * <code>"kafka-default-topic"</code> as the migration topic.
         * </p>
         * 
         * @param topic
         *        The topic to which you migrate the data. If you don't specify a topic, AWS DMS specifies
         *        <code>"kafka-default-topic"</code> as the migration topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topic(String topic);
    }

    static final class BuilderImpl implements Builder {
        private String broker;

        private String topic;

        private BuilderImpl() {
        }

        private BuilderImpl(KafkaSettings model) {
            broker(model.broker);
            topic(model.topic);
        }

        public final String getBroker() {
            return broker;
        }

        @Override
        public final Builder broker(String broker) {
            this.broker = broker;
            return this;
        }

        public final void setBroker(String broker) {
            this.broker = broker;
        }

        public final String getTopic() {
            return topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        @Override
        public KafkaSettings build() {
            return new KafkaSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
