/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReplicationSubnetGroupRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<CreateReplicationSubnetGroupRequest.Builder, CreateReplicationSubnetGroupRequest> {
    private static final SdkField<String> REPLICATION_SUBNET_GROUP_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationSubnetGroupRequest::replicationSubnetGroupIdentifier))
            .setter(setter(Builder::replicationSubnetGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSubnetGroupIdentifier")
                    .build()).build();

    private static final SdkField<String> REPLICATION_SUBNET_GROUP_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateReplicationSubnetGroupRequest::replicationSubnetGroupDescription))
            .setter(setter(Builder::replicationSubnetGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSubnetGroupDescription")
                    .build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateReplicationSubnetGroupRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateReplicationSubnetGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLICATION_SUBNET_GROUP_IDENTIFIER_FIELD, REPLICATION_SUBNET_GROUP_DESCRIPTION_FIELD, SUBNET_IDS_FIELD, TAGS_FIELD));

    private final String replicationSubnetGroupIdentifier;

    private final String replicationSubnetGroupDescription;

    private final List<String> subnetIds;

    private final List<Tag> tags;

    private CreateReplicationSubnetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.replicationSubnetGroupIdentifier = builder.replicationSubnetGroupIdentifier;
        this.replicationSubnetGroupDescription = builder.replicationSubnetGroupDescription;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name for the replication subnet group. This value is stored as a lowercase string.
     * </p>
     * <p>
     * Constraints: Must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or hyphens.
     * Must not be "default".
     * </p>
     * <p>
     * Example: <code>mySubnetgroup</code>
     * </p>
     * 
     * @return The name for the replication subnet group. This value is stored as a lowercase string.</p>
     *         <p>
     *         Constraints: Must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or
     *         hyphens. Must not be "default".
     *         </p>
     *         <p>
     *         Example: <code>mySubnetgroup</code>
     */
    public String replicationSubnetGroupIdentifier() {
        return replicationSubnetGroupIdentifier;
    }

    /**
     * <p>
     * The description for the subnet group.
     * </p>
     * 
     * @return The description for the subnet group.
     */
    public String replicationSubnetGroupDescription() {
        return replicationSubnetGroupDescription;
    }

    /**
     * Returns true if the SubnetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more subnet IDs to be assigned to the subnet group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more subnet IDs to be assigned to the subnet group.
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more tags to be assigned to the subnet group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more tags to be assigned to the subnet group.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationSubnetGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(replicationSubnetGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationSubnetGroupRequest)) {
            return false;
        }
        CreateReplicationSubnetGroupRequest other = (CreateReplicationSubnetGroupRequest) obj;
        return Objects.equals(replicationSubnetGroupIdentifier(), other.replicationSubnetGroupIdentifier())
                && Objects.equals(replicationSubnetGroupDescription(), other.replicationSubnetGroupDescription())
                && Objects.equals(subnetIds(), other.subnetIds()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateReplicationSubnetGroupRequest")
                .add("ReplicationSubnetGroupIdentifier", replicationSubnetGroupIdentifier())
                .add("ReplicationSubnetGroupDescription", replicationSubnetGroupDescription()).add("SubnetIds", subnetIds())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationSubnetGroupIdentifier":
            return Optional.ofNullable(clazz.cast(replicationSubnetGroupIdentifier()));
        case "ReplicationSubnetGroupDescription":
            return Optional.ofNullable(clazz.cast(replicationSubnetGroupDescription()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicationSubnetGroupRequest, T> g) {
        return obj -> g.apply((CreateReplicationSubnetGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateReplicationSubnetGroupRequest> {
        /**
         * <p>
         * The name for the replication subnet group. This value is stored as a lowercase string.
         * </p>
         * <p>
         * Constraints: Must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or hyphens.
         * Must not be "default".
         * </p>
         * <p>
         * Example: <code>mySubnetgroup</code>
         * </p>
         * 
         * @param replicationSubnetGroupIdentifier
         *        The name for the replication subnet group. This value is stored as a lowercase string.</p>
         *        <p>
         *        Constraints: Must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or
         *        hyphens. Must not be "default".
         *        </p>
         *        <p>
         *        Example: <code>mySubnetgroup</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier);

        /**
         * <p>
         * The description for the subnet group.
         * </p>
         * 
         * @param replicationSubnetGroupDescription
         *        The description for the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSubnetGroupDescription(String replicationSubnetGroupDescription);

        /**
         * <p>
         * One or more subnet IDs to be assigned to the subnet group.
         * </p>
         * 
         * @param subnetIds
         *        One or more subnet IDs to be assigned to the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * One or more subnet IDs to be assigned to the subnet group.
         * </p>
         * 
         * @param subnetIds
         *        One or more subnet IDs to be assigned to the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * One or more tags to be assigned to the subnet group.
         * </p>
         * 
         * @param tags
         *        One or more tags to be assigned to the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tags to be assigned to the subnet group.
         * </p>
         * 
         * @param tags
         *        One or more tags to be assigned to the subnet group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * One or more tags to be assigned to the subnet group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String replicationSubnetGroupIdentifier;

        private String replicationSubnetGroupDescription;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationSubnetGroupRequest model) {
            super(model);
            replicationSubnetGroupIdentifier(model.replicationSubnetGroupIdentifier);
            replicationSubnetGroupDescription(model.replicationSubnetGroupDescription);
            subnetIds(model.subnetIds);
            tags(model.tags);
        }

        public final String getReplicationSubnetGroupIdentifier() {
            return replicationSubnetGroupIdentifier;
        }

        @Override
        public final Builder replicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier) {
            this.replicationSubnetGroupIdentifier = replicationSubnetGroupIdentifier;
            return this;
        }

        public final void setReplicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier) {
            this.replicationSubnetGroupIdentifier = replicationSubnetGroupIdentifier;
        }

        public final String getReplicationSubnetGroupDescription() {
            return replicationSubnetGroupDescription;
        }

        @Override
        public final Builder replicationSubnetGroupDescription(String replicationSubnetGroupDescription) {
            this.replicationSubnetGroupDescription = replicationSubnetGroupDescription;
            return this;
        }

        public final void setReplicationSubnetGroupDescription(String replicationSubnetGroupDescription) {
            this.replicationSubnetGroupDescription = replicationSubnetGroupDescription;
        }

        public final Collection<String> getSubnetIds() {
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicationSubnetGroupRequest build() {
            return new CreateReplicationSubnetGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
