/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue;
import software.amazon.awssdk.services.databasemigration.model.DmsTransferSettings;
import software.amazon.awssdk.services.databasemigration.model.DynamoDbSettings;
import software.amazon.awssdk.services.databasemigration.model.ElasticsearchSettings;
import software.amazon.awssdk.services.databasemigration.model.KafkaSettings;
import software.amazon.awssdk.services.databasemigration.model.KinesisSettings;
import software.amazon.awssdk.services.databasemigration.model.MongoDbSettings;
import software.amazon.awssdk.services.databasemigration.model.RedshiftSettings;
import software.amazon.awssdk.services.databasemigration.model.ReplicationEndpointTypeValue;
import software.amazon.awssdk.services.databasemigration.model.S3Settings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Endpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Endpoint> {
    private static final SdkField<String> ENDPOINT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Endpoint.getter(Endpoint::endpointIdentifier)).setter(Endpoint.setter(Builder::endpointIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointIdentifier").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Endpoint.getter(Endpoint::endpointTypeAsString)).setter(Endpoint.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final SdkField<String> ENGINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Endpoint.getter(Endpoint::engineName)).setter(Endpoint.setter(Builder::engineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineName").build()}).build();
    private static final SdkField<String> ENGINE_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Endpoint.getter(Endpoint::engineDisplayName)).setter(Endpoint.setter(Builder::engineDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineDisplayName").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Endpoint.getter(Endpoint::username)).setter(Endpoint.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Endpoint.getter(Endpoint::serverName)).setter(Endpoint.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Endpoint.getter(Endpoint::port)).setter(Endpoint.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Endpoint.getter(Endpoint::databaseName)).setter(Endpoint.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> EXTRA_CONNECTION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Endpoint.getter(Endpoint::extraConnectionAttributes)).setter(Endpoint.setter(Builder::extraConnectionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraConnectionAttributes").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Endpoint.getter(Endpoint::status)).setter(Endpoint.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Endpoint.getter(Endpoint::kmsKeyId)).setter(Endpoint.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Endpoint.getter(Endpoint::endpointArn)).setter(Endpoint.setter(Builder::endpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Endpoint.getter(Endpoint::certificateArn)).setter(Endpoint.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()}).build();
    private static final SdkField<String> SSL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Endpoint.getter(Endpoint::sslModeAsString)).setter(Endpoint.setter(Builder::sslMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslMode").build()}).build();
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Endpoint.getter(Endpoint::serviceAccessRoleArn)).setter(Endpoint.setter(Builder::serviceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build()}).build();
    private static final SdkField<String> EXTERNAL_TABLE_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Endpoint.getter(Endpoint::externalTableDefinition)).setter(Endpoint.setter(Builder::externalTableDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalTableDefinition").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Endpoint.getter(Endpoint::externalId)).setter(Endpoint.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalId").build()}).build();
    private static final SdkField<DynamoDbSettings> DYNAMO_DB_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Endpoint.getter(Endpoint::dynamoDbSettings)).setter(Endpoint.setter(Builder::dynamoDbSettings)).constructor(DynamoDbSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamoDbSettings").build()}).build();
    private static final SdkField<S3Settings> S3_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Endpoint.getter(Endpoint::s3Settings)).setter(Endpoint.setter(Builder::s3Settings)).constructor(S3Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Settings").build()}).build();
    private static final SdkField<DmsTransferSettings> DMS_TRANSFER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Endpoint.getter(Endpoint::dmsTransferSettings)).setter(Endpoint.setter(Builder::dmsTransferSettings)).constructor(DmsTransferSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DmsTransferSettings").build()}).build();
    private static final SdkField<MongoDbSettings> MONGO_DB_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Endpoint.getter(Endpoint::mongoDbSettings)).setter(Endpoint.setter(Builder::mongoDbSettings)).constructor(MongoDbSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MongoDbSettings").build()}).build();
    private static final SdkField<KinesisSettings> KINESIS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Endpoint.getter(Endpoint::kinesisSettings)).setter(Endpoint.setter(Builder::kinesisSettings)).constructor(KinesisSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisSettings").build()}).build();
    private static final SdkField<KafkaSettings> KAFKA_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Endpoint.getter(Endpoint::kafkaSettings)).setter(Endpoint.setter(Builder::kafkaSettings)).constructor(KafkaSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KafkaSettings").build()}).build();
    private static final SdkField<ElasticsearchSettings> ELASTICSEARCH_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Endpoint.getter(Endpoint::elasticsearchSettings)).setter(Endpoint.setter(Builder::elasticsearchSettings)).constructor(ElasticsearchSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchSettings").build()}).build();
    private static final SdkField<RedshiftSettings> REDSHIFT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Endpoint.getter(Endpoint::redshiftSettings)).setter(Endpoint.setter(Builder::redshiftSettings)).constructor(RedshiftSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_IDENTIFIER_FIELD, ENDPOINT_TYPE_FIELD, ENGINE_NAME_FIELD, ENGINE_DISPLAY_NAME_FIELD, USERNAME_FIELD, SERVER_NAME_FIELD, PORT_FIELD, DATABASE_NAME_FIELD, EXTRA_CONNECTION_ATTRIBUTES_FIELD, STATUS_FIELD, KMS_KEY_ID_FIELD, ENDPOINT_ARN_FIELD, CERTIFICATE_ARN_FIELD, SSL_MODE_FIELD, SERVICE_ACCESS_ROLE_ARN_FIELD, EXTERNAL_TABLE_DEFINITION_FIELD, EXTERNAL_ID_FIELD, DYNAMO_DB_SETTINGS_FIELD, S3_SETTINGS_FIELD, DMS_TRANSFER_SETTINGS_FIELD, MONGO_DB_SETTINGS_FIELD, KINESIS_SETTINGS_FIELD, KAFKA_SETTINGS_FIELD, ELASTICSEARCH_SETTINGS_FIELD, REDSHIFT_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String endpointIdentifier;
    private final String endpointType;
    private final String engineName;
    private final String engineDisplayName;
    private final String username;
    private final String serverName;
    private final Integer port;
    private final String databaseName;
    private final String extraConnectionAttributes;
    private final String status;
    private final String kmsKeyId;
    private final String endpointArn;
    private final String certificateArn;
    private final String sslMode;
    private final String serviceAccessRoleArn;
    private final String externalTableDefinition;
    private final String externalId;
    private final DynamoDbSettings dynamoDbSettings;
    private final S3Settings s3Settings;
    private final DmsTransferSettings dmsTransferSettings;
    private final MongoDbSettings mongoDbSettings;
    private final KinesisSettings kinesisSettings;
    private final KafkaSettings kafkaSettings;
    private final ElasticsearchSettings elasticsearchSettings;
    private final RedshiftSettings redshiftSettings;

    private Endpoint(BuilderImpl builder) {
        this.endpointIdentifier = builder.endpointIdentifier;
        this.endpointType = builder.endpointType;
        this.engineName = builder.engineName;
        this.engineDisplayName = builder.engineDisplayName;
        this.username = builder.username;
        this.serverName = builder.serverName;
        this.port = builder.port;
        this.databaseName = builder.databaseName;
        this.extraConnectionAttributes = builder.extraConnectionAttributes;
        this.status = builder.status;
        this.kmsKeyId = builder.kmsKeyId;
        this.endpointArn = builder.endpointArn;
        this.certificateArn = builder.certificateArn;
        this.sslMode = builder.sslMode;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.externalTableDefinition = builder.externalTableDefinition;
        this.externalId = builder.externalId;
        this.dynamoDbSettings = builder.dynamoDbSettings;
        this.s3Settings = builder.s3Settings;
        this.dmsTransferSettings = builder.dmsTransferSettings;
        this.mongoDbSettings = builder.mongoDbSettings;
        this.kinesisSettings = builder.kinesisSettings;
        this.kafkaSettings = builder.kafkaSettings;
        this.elasticsearchSettings = builder.elasticsearchSettings;
        this.redshiftSettings = builder.redshiftSettings;
    }

    public String endpointIdentifier() {
        return this.endpointIdentifier;
    }

    public ReplicationEndpointTypeValue endpointType() {
        return ReplicationEndpointTypeValue.fromValue(this.endpointType);
    }

    public String endpointTypeAsString() {
        return this.endpointType;
    }

    public String engineName() {
        return this.engineName;
    }

    public String engineDisplayName() {
        return this.engineDisplayName;
    }

    public String username() {
        return this.username;
    }

    public String serverName() {
        return this.serverName;
    }

    public Integer port() {
        return this.port;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String extraConnectionAttributes() {
        return this.extraConnectionAttributes;
    }

    public String status() {
        return this.status;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String endpointArn() {
        return this.endpointArn;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public DmsSslModeValue sslMode() {
        return DmsSslModeValue.fromValue(this.sslMode);
    }

    public String sslModeAsString() {
        return this.sslMode;
    }

    public String serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    public String externalTableDefinition() {
        return this.externalTableDefinition;
    }

    public String externalId() {
        return this.externalId;
    }

    public DynamoDbSettings dynamoDbSettings() {
        return this.dynamoDbSettings;
    }

    public S3Settings s3Settings() {
        return this.s3Settings;
    }

    public DmsTransferSettings dmsTransferSettings() {
        return this.dmsTransferSettings;
    }

    public MongoDbSettings mongoDbSettings() {
        return this.mongoDbSettings;
    }

    public KinesisSettings kinesisSettings() {
        return this.kinesisSettings;
    }

    public KafkaSettings kafkaSettings() {
        return this.kafkaSettings;
    }

    public ElasticsearchSettings elasticsearchSettings() {
        return this.elasticsearchSettings;
    }

    public RedshiftSettings redshiftSettings() {
        return this.redshiftSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.extraConnectionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalTableDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamoDbSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.dmsTransferSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mongoDbSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.kafkaSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        return Objects.equals(this.endpointIdentifier(), other.endpointIdentifier()) && Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString()) && Objects.equals(this.engineName(), other.engineName()) && Objects.equals(this.engineDisplayName(), other.engineDisplayName()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.extraConnectionAttributes(), other.extraConnectionAttributes()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.endpointArn(), other.endpointArn()) && Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.sslModeAsString(), other.sslModeAsString()) && Objects.equals(this.serviceAccessRoleArn(), other.serviceAccessRoleArn()) && Objects.equals(this.externalTableDefinition(), other.externalTableDefinition()) && Objects.equals(this.externalId(), other.externalId()) && Objects.equals(this.dynamoDbSettings(), other.dynamoDbSettings()) && Objects.equals(this.s3Settings(), other.s3Settings()) && Objects.equals(this.dmsTransferSettings(), other.dmsTransferSettings()) && Objects.equals(this.mongoDbSettings(), other.mongoDbSettings()) && Objects.equals(this.kinesisSettings(), other.kinesisSettings()) && Objects.equals(this.kafkaSettings(), other.kafkaSettings()) && Objects.equals(this.elasticsearchSettings(), other.elasticsearchSettings()) && Objects.equals(this.redshiftSettings(), other.redshiftSettings());
    }

    public String toString() {
        return ToString.builder((String)"Endpoint").add("EndpointIdentifier", (Object)this.endpointIdentifier()).add("EndpointType", (Object)this.endpointTypeAsString()).add("EngineName", (Object)this.engineName()).add("EngineDisplayName", (Object)this.engineDisplayName()).add("Username", (Object)this.username()).add("ServerName", (Object)this.serverName()).add("Port", (Object)this.port()).add("DatabaseName", (Object)this.databaseName()).add("ExtraConnectionAttributes", (Object)this.extraConnectionAttributes()).add("Status", (Object)this.status()).add("KmsKeyId", (Object)this.kmsKeyId()).add("EndpointArn", (Object)this.endpointArn()).add("CertificateArn", (Object)this.certificateArn()).add("SslMode", (Object)this.sslModeAsString()).add("ServiceAccessRoleArn", (Object)this.serviceAccessRoleArn()).add("ExternalTableDefinition", (Object)this.externalTableDefinition()).add("ExternalId", (Object)this.externalId()).add("DynamoDbSettings", (Object)this.dynamoDbSettings()).add("S3Settings", (Object)this.s3Settings()).add("DmsTransferSettings", (Object)this.dmsTransferSettings()).add("MongoDbSettings", (Object)this.mongoDbSettings()).add("KinesisSettings", (Object)this.kinesisSettings()).add("KafkaSettings", (Object)this.kafkaSettings()).add("ElasticsearchSettings", (Object)this.elasticsearchSettings()).add("RedshiftSettings", (Object)this.redshiftSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointIdentifier": {
                return Optional.ofNullable(clazz.cast(this.endpointIdentifier()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
            case "EngineName": {
                return Optional.ofNullable(clazz.cast(this.engineName()));
            }
            case "EngineDisplayName": {
                return Optional.ofNullable(clazz.cast(this.engineDisplayName()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "ExtraConnectionAttributes": {
                return Optional.ofNullable(clazz.cast(this.extraConnectionAttributes()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "EndpointArn": {
                return Optional.ofNullable(clazz.cast(this.endpointArn()));
            }
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "SslMode": {
                return Optional.ofNullable(clazz.cast(this.sslModeAsString()));
            }
            case "ServiceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessRoleArn()));
            }
            case "ExternalTableDefinition": {
                return Optional.ofNullable(clazz.cast(this.externalTableDefinition()));
            }
            case "ExternalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
            case "DynamoDbSettings": {
                return Optional.ofNullable(clazz.cast(this.dynamoDbSettings()));
            }
            case "S3Settings": {
                return Optional.ofNullable(clazz.cast(this.s3Settings()));
            }
            case "DmsTransferSettings": {
                return Optional.ofNullable(clazz.cast(this.dmsTransferSettings()));
            }
            case "MongoDbSettings": {
                return Optional.ofNullable(clazz.cast(this.mongoDbSettings()));
            }
            case "KinesisSettings": {
                return Optional.ofNullable(clazz.cast(this.kinesisSettings()));
            }
            case "KafkaSettings": {
                return Optional.ofNullable(clazz.cast(this.kafkaSettings()));
            }
            case "ElasticsearchSettings": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchSettings()));
            }
            case "RedshiftSettings": {
                return Optional.ofNullable(clazz.cast(this.redshiftSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Endpoint, T> g) {
        return obj -> g.apply((Endpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointIdentifier;
        private String endpointType;
        private String engineName;
        private String engineDisplayName;
        private String username;
        private String serverName;
        private Integer port;
        private String databaseName;
        private String extraConnectionAttributes;
        private String status;
        private String kmsKeyId;
        private String endpointArn;
        private String certificateArn;
        private String sslMode;
        private String serviceAccessRoleArn;
        private String externalTableDefinition;
        private String externalId;
        private DynamoDbSettings dynamoDbSettings;
        private S3Settings s3Settings;
        private DmsTransferSettings dmsTransferSettings;
        private MongoDbSettings mongoDbSettings;
        private KinesisSettings kinesisSettings;
        private KafkaSettings kafkaSettings;
        private ElasticsearchSettings elasticsearchSettings;
        private RedshiftSettings redshiftSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(Endpoint model) {
            this.endpointIdentifier(model.endpointIdentifier);
            this.endpointType(model.endpointType);
            this.engineName(model.engineName);
            this.engineDisplayName(model.engineDisplayName);
            this.username(model.username);
            this.serverName(model.serverName);
            this.port(model.port);
            this.databaseName(model.databaseName);
            this.extraConnectionAttributes(model.extraConnectionAttributes);
            this.status(model.status);
            this.kmsKeyId(model.kmsKeyId);
            this.endpointArn(model.endpointArn);
            this.certificateArn(model.certificateArn);
            this.sslMode(model.sslMode);
            this.serviceAccessRoleArn(model.serviceAccessRoleArn);
            this.externalTableDefinition(model.externalTableDefinition);
            this.externalId(model.externalId);
            this.dynamoDbSettings(model.dynamoDbSettings);
            this.s3Settings(model.s3Settings);
            this.dmsTransferSettings(model.dmsTransferSettings);
            this.mongoDbSettings(model.mongoDbSettings);
            this.kinesisSettings(model.kinesisSettings);
            this.kafkaSettings(model.kafkaSettings);
            this.elasticsearchSettings(model.elasticsearchSettings);
            this.redshiftSettings(model.redshiftSettings);
        }

        public final String getEndpointIdentifier() {
            return this.endpointIdentifier;
        }

        @Override
        public final Builder endpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
            return this;
        }

        public final void setEndpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
        }

        public final String getEndpointTypeAsString() {
            return this.endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(ReplicationEndpointTypeValue endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        public final String getEngineName() {
            return this.engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        public final String getEngineDisplayName() {
            return this.engineDisplayName;
        }

        @Override
        public final Builder engineDisplayName(String engineDisplayName) {
            this.engineDisplayName = engineDisplayName;
            return this;
        }

        public final void setEngineDisplayName(String engineDisplayName) {
            this.engineDisplayName = engineDisplayName;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getExtraConnectionAttributes() {
            return this.extraConnectionAttributes;
        }

        @Override
        public final Builder extraConnectionAttributes(String extraConnectionAttributes) {
            this.extraConnectionAttributes = extraConnectionAttributes;
            return this;
        }

        public final void setExtraConnectionAttributes(String extraConnectionAttributes) {
            this.extraConnectionAttributes = extraConnectionAttributes;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getSslModeAsString() {
            return this.sslMode;
        }

        @Override
        public final Builder sslMode(String sslMode) {
            this.sslMode = sslMode;
            return this;
        }

        @Override
        public final Builder sslMode(DmsSslModeValue sslMode) {
            this.sslMode(sslMode == null ? null : sslMode.toString());
            return this;
        }

        public final void setSslMode(String sslMode) {
            this.sslMode = sslMode;
        }

        public final String getServiceAccessRoleArn() {
            return this.serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        public final String getExternalTableDefinition() {
            return this.externalTableDefinition;
        }

        @Override
        public final Builder externalTableDefinition(String externalTableDefinition) {
            this.externalTableDefinition = externalTableDefinition;
            return this;
        }

        public final void setExternalTableDefinition(String externalTableDefinition) {
            this.externalTableDefinition = externalTableDefinition;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public final DynamoDbSettings.Builder getDynamoDbSettings() {
            return this.dynamoDbSettings != null ? this.dynamoDbSettings.toBuilder() : null;
        }

        @Override
        public final Builder dynamoDbSettings(DynamoDbSettings dynamoDbSettings) {
            this.dynamoDbSettings = dynamoDbSettings;
            return this;
        }

        public final void setDynamoDbSettings(DynamoDbSettings.BuilderImpl dynamoDbSettings) {
            this.dynamoDbSettings = dynamoDbSettings != null ? dynamoDbSettings.build() : null;
        }

        public final S3Settings.Builder getS3Settings() {
            return this.s3Settings != null ? this.s3Settings.toBuilder() : null;
        }

        @Override
        public final Builder s3Settings(S3Settings s3Settings) {
            this.s3Settings = s3Settings;
            return this;
        }

        public final void setS3Settings(S3Settings.BuilderImpl s3Settings) {
            this.s3Settings = s3Settings != null ? s3Settings.build() : null;
        }

        public final DmsTransferSettings.Builder getDmsTransferSettings() {
            return this.dmsTransferSettings != null ? this.dmsTransferSettings.toBuilder() : null;
        }

        @Override
        public final Builder dmsTransferSettings(DmsTransferSettings dmsTransferSettings) {
            this.dmsTransferSettings = dmsTransferSettings;
            return this;
        }

        public final void setDmsTransferSettings(DmsTransferSettings.BuilderImpl dmsTransferSettings) {
            this.dmsTransferSettings = dmsTransferSettings != null ? dmsTransferSettings.build() : null;
        }

        public final MongoDbSettings.Builder getMongoDbSettings() {
            return this.mongoDbSettings != null ? this.mongoDbSettings.toBuilder() : null;
        }

        @Override
        public final Builder mongoDbSettings(MongoDbSettings mongoDbSettings) {
            this.mongoDbSettings = mongoDbSettings;
            return this;
        }

        public final void setMongoDbSettings(MongoDbSettings.BuilderImpl mongoDbSettings) {
            this.mongoDbSettings = mongoDbSettings != null ? mongoDbSettings.build() : null;
        }

        public final KinesisSettings.Builder getKinesisSettings() {
            return this.kinesisSettings != null ? this.kinesisSettings.toBuilder() : null;
        }

        @Override
        public final Builder kinesisSettings(KinesisSettings kinesisSettings) {
            this.kinesisSettings = kinesisSettings;
            return this;
        }

        public final void setKinesisSettings(KinesisSettings.BuilderImpl kinesisSettings) {
            this.kinesisSettings = kinesisSettings != null ? kinesisSettings.build() : null;
        }

        public final KafkaSettings.Builder getKafkaSettings() {
            return this.kafkaSettings != null ? this.kafkaSettings.toBuilder() : null;
        }

        @Override
        public final Builder kafkaSettings(KafkaSettings kafkaSettings) {
            this.kafkaSettings = kafkaSettings;
            return this;
        }

        public final void setKafkaSettings(KafkaSettings.BuilderImpl kafkaSettings) {
            this.kafkaSettings = kafkaSettings != null ? kafkaSettings.build() : null;
        }

        public final ElasticsearchSettings.Builder getElasticsearchSettings() {
            return this.elasticsearchSettings != null ? this.elasticsearchSettings.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchSettings(ElasticsearchSettings elasticsearchSettings) {
            this.elasticsearchSettings = elasticsearchSettings;
            return this;
        }

        public final void setElasticsearchSettings(ElasticsearchSettings.BuilderImpl elasticsearchSettings) {
            this.elasticsearchSettings = elasticsearchSettings != null ? elasticsearchSettings.build() : null;
        }

        public final RedshiftSettings.Builder getRedshiftSettings() {
            return this.redshiftSettings != null ? this.redshiftSettings.toBuilder() : null;
        }

        @Override
        public final Builder redshiftSettings(RedshiftSettings redshiftSettings) {
            this.redshiftSettings = redshiftSettings;
            return this;
        }

        public final void setRedshiftSettings(RedshiftSettings.BuilderImpl redshiftSettings) {
            this.redshiftSettings = redshiftSettings != null ? redshiftSettings.build() : null;
        }

        public Endpoint build() {
            return new Endpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Endpoint> {
        public Builder endpointIdentifier(String var1);

        public Builder endpointType(String var1);

        public Builder endpointType(ReplicationEndpointTypeValue var1);

        public Builder engineName(String var1);

        public Builder engineDisplayName(String var1);

        public Builder username(String var1);

        public Builder serverName(String var1);

        public Builder port(Integer var1);

        public Builder databaseName(String var1);

        public Builder extraConnectionAttributes(String var1);

        public Builder status(String var1);

        public Builder kmsKeyId(String var1);

        public Builder endpointArn(String var1);

        public Builder certificateArn(String var1);

        public Builder sslMode(String var1);

        public Builder sslMode(DmsSslModeValue var1);

        public Builder serviceAccessRoleArn(String var1);

        public Builder externalTableDefinition(String var1);

        public Builder externalId(String var1);

        public Builder dynamoDbSettings(DynamoDbSettings var1);

        default public Builder dynamoDbSettings(Consumer<DynamoDbSettings.Builder> dynamoDbSettings) {
            return this.dynamoDbSettings((DynamoDbSettings)((DynamoDbSettings.Builder)DynamoDbSettings.builder().applyMutation(dynamoDbSettings)).build());
        }

        public Builder s3Settings(S3Settings var1);

        default public Builder s3Settings(Consumer<S3Settings.Builder> s3Settings) {
            return this.s3Settings((S3Settings)((S3Settings.Builder)S3Settings.builder().applyMutation(s3Settings)).build());
        }

        public Builder dmsTransferSettings(DmsTransferSettings var1);

        default public Builder dmsTransferSettings(Consumer<DmsTransferSettings.Builder> dmsTransferSettings) {
            return this.dmsTransferSettings((DmsTransferSettings)((DmsTransferSettings.Builder)DmsTransferSettings.builder().applyMutation(dmsTransferSettings)).build());
        }

        public Builder mongoDbSettings(MongoDbSettings var1);

        default public Builder mongoDbSettings(Consumer<MongoDbSettings.Builder> mongoDbSettings) {
            return this.mongoDbSettings((MongoDbSettings)((MongoDbSettings.Builder)MongoDbSettings.builder().applyMutation(mongoDbSettings)).build());
        }

        public Builder kinesisSettings(KinesisSettings var1);

        default public Builder kinesisSettings(Consumer<KinesisSettings.Builder> kinesisSettings) {
            return this.kinesisSettings((KinesisSettings)((KinesisSettings.Builder)KinesisSettings.builder().applyMutation(kinesisSettings)).build());
        }

        public Builder kafkaSettings(KafkaSettings var1);

        default public Builder kafkaSettings(Consumer<KafkaSettings.Builder> kafkaSettings) {
            return this.kafkaSettings((KafkaSettings)((KafkaSettings.Builder)KafkaSettings.builder().applyMutation(kafkaSettings)).build());
        }

        public Builder elasticsearchSettings(ElasticsearchSettings var1);

        default public Builder elasticsearchSettings(Consumer<ElasticsearchSettings.Builder> elasticsearchSettings) {
            return this.elasticsearchSettings((ElasticsearchSettings)((ElasticsearchSettings.Builder)ElasticsearchSettings.builder().applyMutation(elasticsearchSettings)).build());
        }

        public Builder redshiftSettings(RedshiftSettings var1);

        default public Builder redshiftSettings(Consumer<RedshiftSettings.Builder> redshiftSettings) {
            return this.redshiftSettings((RedshiftSettings)((RedshiftSettings.Builder)RedshiftSettings.builder().applyMutation(redshiftSettings)).build());
        }
    }
}

