/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EncryptionModeValue {
    SSE_S3("sse-s3"),
    SSE_KMS("sse-kms"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EncryptionModeValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EncryptionModeValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EncryptionModeValue.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EncryptionModeValue> knownValues() {
        return Stream.of(EncryptionModeValue.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

