/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableStatistics implements SdkPojo, Serializable, ToCopyableBuilder<TableStatistics.Builder, TableStatistics> {
    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableStatistics::schemaName)).setter(setter(Builder::schemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableStatistics::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<Long> INSERTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TableStatistics::inserts)).setter(setter(Builder::inserts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inserts").build()).build();

    private static final SdkField<Long> DELETES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TableStatistics::deletes)).setter(setter(Builder::deletes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deletes").build()).build();

    private static final SdkField<Long> UPDATES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TableStatistics::updates)).setter(setter(Builder::updates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build()).build();

    private static final SdkField<Long> DDLS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TableStatistics::ddls)).setter(setter(Builder::ddls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ddls").build()).build();

    private static final SdkField<Long> FULL_LOAD_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TableStatistics::fullLoadRows)).setter(setter(Builder::fullLoadRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadRows").build()).build();

    private static final SdkField<Long> FULL_LOAD_CONDTNL_CHK_FAILED_ROWS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(TableStatistics::fullLoadCondtnlChkFailedRows))
            .setter(setter(Builder::fullLoadCondtnlChkFailedRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadCondtnlChkFailedRows")
                    .build()).build();

    private static final SdkField<Long> FULL_LOAD_ERROR_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TableStatistics::fullLoadErrorRows)).setter(setter(Builder::fullLoadErrorRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadErrorRows").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TableStatistics::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()).build();

    private static final SdkField<String> TABLE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableStatistics::tableState)).setter(setter(Builder::tableState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableState").build()).build();

    private static final SdkField<Long> VALIDATION_PENDING_RECORDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TableStatistics::validationPendingRecords)).setter(setter(Builder::validationPendingRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationPendingRecords").build())
            .build();

    private static final SdkField<Long> VALIDATION_FAILED_RECORDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(TableStatistics::validationFailedRecords)).setter(setter(Builder::validationFailedRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationFailedRecords").build())
            .build();

    private static final SdkField<Long> VALIDATION_SUSPENDED_RECORDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(TableStatistics::validationSuspendedRecords))
            .setter(setter(Builder::validationSuspendedRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationSuspendedRecords").build())
            .build();

    private static final SdkField<String> VALIDATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableStatistics::validationState)).setter(setter(Builder::validationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationState").build()).build();

    private static final SdkField<String> VALIDATION_STATE_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TableStatistics::validationStateDetails)).setter(setter(Builder::validationStateDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStateDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_NAME_FIELD,
            TABLE_NAME_FIELD, INSERTS_FIELD, DELETES_FIELD, UPDATES_FIELD, DDLS_FIELD, FULL_LOAD_ROWS_FIELD,
            FULL_LOAD_CONDTNL_CHK_FAILED_ROWS_FIELD, FULL_LOAD_ERROR_ROWS_FIELD, LAST_UPDATE_TIME_FIELD, TABLE_STATE_FIELD,
            VALIDATION_PENDING_RECORDS_FIELD, VALIDATION_FAILED_RECORDS_FIELD, VALIDATION_SUSPENDED_RECORDS_FIELD,
            VALIDATION_STATE_FIELD, VALIDATION_STATE_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String schemaName;

    private final String tableName;

    private final Long inserts;

    private final Long deletes;

    private final Long updates;

    private final Long ddls;

    private final Long fullLoadRows;

    private final Long fullLoadCondtnlChkFailedRows;

    private final Long fullLoadErrorRows;

    private final Instant lastUpdateTime;

    private final String tableState;

    private final Long validationPendingRecords;

    private final Long validationFailedRecords;

    private final Long validationSuspendedRecords;

    private final String validationState;

    private final String validationStateDetails;

    private TableStatistics(BuilderImpl builder) {
        this.schemaName = builder.schemaName;
        this.tableName = builder.tableName;
        this.inserts = builder.inserts;
        this.deletes = builder.deletes;
        this.updates = builder.updates;
        this.ddls = builder.ddls;
        this.fullLoadRows = builder.fullLoadRows;
        this.fullLoadCondtnlChkFailedRows = builder.fullLoadCondtnlChkFailedRows;
        this.fullLoadErrorRows = builder.fullLoadErrorRows;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.tableState = builder.tableState;
        this.validationPendingRecords = builder.validationPendingRecords;
        this.validationFailedRecords = builder.validationFailedRecords;
        this.validationSuspendedRecords = builder.validationSuspendedRecords;
        this.validationState = builder.validationState;
        this.validationStateDetails = builder.validationStateDetails;
    }

    /**
     * <p>
     * The schema name.
     * </p>
     * 
     * @return The schema name.
     */
    public String schemaName() {
        return schemaName;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The number of insert actions performed on a table.
     * </p>
     * 
     * @return The number of insert actions performed on a table.
     */
    public Long inserts() {
        return inserts;
    }

    /**
     * <p>
     * The number of delete actions performed on a table.
     * </p>
     * 
     * @return The number of delete actions performed on a table.
     */
    public Long deletes() {
        return deletes;
    }

    /**
     * <p>
     * The number of update actions performed on a table.
     * </p>
     * 
     * @return The number of update actions performed on a table.
     */
    public Long updates() {
        return updates;
    }

    /**
     * <p>
     * The Data Definition Language (DDL) used to build and modify the structure of your tables.
     * </p>
     * 
     * @return The Data Definition Language (DDL) used to build and modify the structure of your tables.
     */
    public Long ddls() {
        return ddls;
    }

    /**
     * <p>
     * The number of rows added during the Full Load operation.
     * </p>
     * 
     * @return The number of rows added during the Full Load operation.
     */
    public Long fullLoadRows() {
        return fullLoadRows;
    }

    /**
     * <p>
     * The number of rows that failed conditional checks during the Full Load operation (valid only for DynamoDB as a
     * target migrations).
     * </p>
     * 
     * @return The number of rows that failed conditional checks during the Full Load operation (valid only for DynamoDB
     *         as a target migrations).
     */
    public Long fullLoadCondtnlChkFailedRows() {
        return fullLoadCondtnlChkFailedRows;
    }

    /**
     * <p>
     * The number of rows that failed to load during the Full Load operation (valid only for DynamoDB as a target
     * migrations).
     * </p>
     * 
     * @return The number of rows that failed to load during the Full Load operation (valid only for DynamoDB as a
     *         target migrations).
     */
    public Long fullLoadErrorRows() {
        return fullLoadErrorRows;
    }

    /**
     * <p>
     * The last time the table was updated.
     * </p>
     * 
     * @return The last time the table was updated.
     */
    public Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The state of the tables described.
     * </p>
     * <p>
     * Valid states: Table does not exist | Before load | Full load | Table completed | Table cancelled | Table error |
     * Table all | Table updates | Table is being reloaded
     * </p>
     * 
     * @return The state of the tables described.</p>
     *         <p>
     *         Valid states: Table does not exist | Before load | Full load | Table completed | Table cancelled | Table
     *         error | Table all | Table updates | Table is being reloaded
     */
    public String tableState() {
        return tableState;
    }

    /**
     * <p>
     * The number of records that have yet to be validated.
     * </p>
     * 
     * @return The number of records that have yet to be validated.
     */
    public Long validationPendingRecords() {
        return validationPendingRecords;
    }

    /**
     * <p>
     * The number of records that failed validation.
     * </p>
     * 
     * @return The number of records that failed validation.
     */
    public Long validationFailedRecords() {
        return validationFailedRecords;
    }

    /**
     * <p>
     * The number of records that could not be validated.
     * </p>
     * 
     * @return The number of records that could not be validated.
     */
    public Long validationSuspendedRecords() {
        return validationSuspendedRecords;
    }

    /**
     * <p>
     * The validation state of the table.
     * </p>
     * <p>
     * The parameter can have the following values
     * </p>
     * <ul>
     * <li>
     * <p>
     * Not enabled—Validation is not enabled for the table in the migration task.
     * </p>
     * </li>
     * <li>
     * <p>
     * Pending records—Some records in the table are waiting for validation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Mismatched records—Some records in the table do not match between the source and target.
     * </p>
     * </li>
     * <li>
     * <p>
     * Suspended records—Some records in the table could not be validated.
     * </p>
     * </li>
     * <li>
     * <p>
     * No primary key—The table could not be validated because it had no primary key.
     * </p>
     * </li>
     * <li>
     * <p>
     * Table error—The table was not validated because it was in an error state and some data was not migrated.
     * </p>
     * </li>
     * <li>
     * <p>
     * Validated—All rows in the table were validated. If the table is updated, the status can change from Validated.
     * </p>
     * </li>
     * <li>
     * <p>
     * Error—The table could not be validated because of an unexpected error.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The validation state of the table.</p>
     *         <p>
     *         The parameter can have the following values
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Not enabled—Validation is not enabled for the table in the migration task.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Pending records—Some records in the table are waiting for validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Mismatched records—Some records in the table do not match between the source and target.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Suspended records—Some records in the table could not be validated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         No primary key—The table could not be validated because it had no primary key.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Table error—The table was not validated because it was in an error state and some data was not migrated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Validated—All rows in the table were validated. If the table is updated, the status can change from
     *         Validated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Error—The table could not be validated because of an unexpected error.
     *         </p>
     *         </li>
     */
    public String validationState() {
        return validationState;
    }

    /**
     * <p>
     * Additional details about the state of validation.
     * </p>
     * 
     * @return Additional details about the state of validation.
     */
    public String validationStateDetails() {
        return validationStateDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(inserts());
        hashCode = 31 * hashCode + Objects.hashCode(deletes());
        hashCode = 31 * hashCode + Objects.hashCode(updates());
        hashCode = 31 * hashCode + Objects.hashCode(ddls());
        hashCode = 31 * hashCode + Objects.hashCode(fullLoadRows());
        hashCode = 31 * hashCode + Objects.hashCode(fullLoadCondtnlChkFailedRows());
        hashCode = 31 * hashCode + Objects.hashCode(fullLoadErrorRows());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(tableState());
        hashCode = 31 * hashCode + Objects.hashCode(validationPendingRecords());
        hashCode = 31 * hashCode + Objects.hashCode(validationFailedRecords());
        hashCode = 31 * hashCode + Objects.hashCode(validationSuspendedRecords());
        hashCode = 31 * hashCode + Objects.hashCode(validationState());
        hashCode = 31 * hashCode + Objects.hashCode(validationStateDetails());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableStatistics)) {
            return false;
        }
        TableStatistics other = (TableStatistics) obj;
        return Objects.equals(schemaName(), other.schemaName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(inserts(), other.inserts()) && Objects.equals(deletes(), other.deletes())
                && Objects.equals(updates(), other.updates()) && Objects.equals(ddls(), other.ddls())
                && Objects.equals(fullLoadRows(), other.fullLoadRows())
                && Objects.equals(fullLoadCondtnlChkFailedRows(), other.fullLoadCondtnlChkFailedRows())
                && Objects.equals(fullLoadErrorRows(), other.fullLoadErrorRows())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(tableState(), other.tableState())
                && Objects.equals(validationPendingRecords(), other.validationPendingRecords())
                && Objects.equals(validationFailedRecords(), other.validationFailedRecords())
                && Objects.equals(validationSuspendedRecords(), other.validationSuspendedRecords())
                && Objects.equals(validationState(), other.validationState())
                && Objects.equals(validationStateDetails(), other.validationStateDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TableStatistics").add("SchemaName", schemaName()).add("TableName", tableName())
                .add("Inserts", inserts()).add("Deletes", deletes()).add("Updates", updates()).add("Ddls", ddls())
                .add("FullLoadRows", fullLoadRows()).add("FullLoadCondtnlChkFailedRows", fullLoadCondtnlChkFailedRows())
                .add("FullLoadErrorRows", fullLoadErrorRows()).add("LastUpdateTime", lastUpdateTime())
                .add("TableState", tableState()).add("ValidationPendingRecords", validationPendingRecords())
                .add("ValidationFailedRecords", validationFailedRecords())
                .add("ValidationSuspendedRecords", validationSuspendedRecords()).add("ValidationState", validationState())
                .add("ValidationStateDetails", validationStateDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaName":
            return Optional.ofNullable(clazz.cast(schemaName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "Inserts":
            return Optional.ofNullable(clazz.cast(inserts()));
        case "Deletes":
            return Optional.ofNullable(clazz.cast(deletes()));
        case "Updates":
            return Optional.ofNullable(clazz.cast(updates()));
        case "Ddls":
            return Optional.ofNullable(clazz.cast(ddls()));
        case "FullLoadRows":
            return Optional.ofNullable(clazz.cast(fullLoadRows()));
        case "FullLoadCondtnlChkFailedRows":
            return Optional.ofNullable(clazz.cast(fullLoadCondtnlChkFailedRows()));
        case "FullLoadErrorRows":
            return Optional.ofNullable(clazz.cast(fullLoadErrorRows()));
        case "LastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "TableState":
            return Optional.ofNullable(clazz.cast(tableState()));
        case "ValidationPendingRecords":
            return Optional.ofNullable(clazz.cast(validationPendingRecords()));
        case "ValidationFailedRecords":
            return Optional.ofNullable(clazz.cast(validationFailedRecords()));
        case "ValidationSuspendedRecords":
            return Optional.ofNullable(clazz.cast(validationSuspendedRecords()));
        case "ValidationState":
            return Optional.ofNullable(clazz.cast(validationState()));
        case "ValidationStateDetails":
            return Optional.ofNullable(clazz.cast(validationStateDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableStatistics, T> g) {
        return obj -> g.apply((TableStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableStatistics> {
        /**
         * <p>
         * The schema name.
         * </p>
         * 
         * @param schemaName
         *        The schema name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaName(String schemaName);

        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param tableName
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The number of insert actions performed on a table.
         * </p>
         * 
         * @param inserts
         *        The number of insert actions performed on a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inserts(Long inserts);

        /**
         * <p>
         * The number of delete actions performed on a table.
         * </p>
         * 
         * @param deletes
         *        The number of delete actions performed on a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletes(Long deletes);

        /**
         * <p>
         * The number of update actions performed on a table.
         * </p>
         * 
         * @param updates
         *        The number of update actions performed on a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updates(Long updates);

        /**
         * <p>
         * The Data Definition Language (DDL) used to build and modify the structure of your tables.
         * </p>
         * 
         * @param ddls
         *        The Data Definition Language (DDL) used to build and modify the structure of your tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ddls(Long ddls);

        /**
         * <p>
         * The number of rows added during the Full Load operation.
         * </p>
         * 
         * @param fullLoadRows
         *        The number of rows added during the Full Load operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullLoadRows(Long fullLoadRows);

        /**
         * <p>
         * The number of rows that failed conditional checks during the Full Load operation (valid only for DynamoDB as
         * a target migrations).
         * </p>
         * 
         * @param fullLoadCondtnlChkFailedRows
         *        The number of rows that failed conditional checks during the Full Load operation (valid only for
         *        DynamoDB as a target migrations).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullLoadCondtnlChkFailedRows(Long fullLoadCondtnlChkFailedRows);

        /**
         * <p>
         * The number of rows that failed to load during the Full Load operation (valid only for DynamoDB as a target
         * migrations).
         * </p>
         * 
         * @param fullLoadErrorRows
         *        The number of rows that failed to load during the Full Load operation (valid only for DynamoDB as a
         *        target migrations).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullLoadErrorRows(Long fullLoadErrorRows);

        /**
         * <p>
         * The last time the table was updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The last time the table was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The state of the tables described.
         * </p>
         * <p>
         * Valid states: Table does not exist | Before load | Full load | Table completed | Table cancelled | Table
         * error | Table all | Table updates | Table is being reloaded
         * </p>
         * 
         * @param tableState
         *        The state of the tables described.</p>
         *        <p>
         *        Valid states: Table does not exist | Before load | Full load | Table completed | Table cancelled |
         *        Table error | Table all | Table updates | Table is being reloaded
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableState(String tableState);

        /**
         * <p>
         * The number of records that have yet to be validated.
         * </p>
         * 
         * @param validationPendingRecords
         *        The number of records that have yet to be validated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationPendingRecords(Long validationPendingRecords);

        /**
         * <p>
         * The number of records that failed validation.
         * </p>
         * 
         * @param validationFailedRecords
         *        The number of records that failed validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationFailedRecords(Long validationFailedRecords);

        /**
         * <p>
         * The number of records that could not be validated.
         * </p>
         * 
         * @param validationSuspendedRecords
         *        The number of records that could not be validated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationSuspendedRecords(Long validationSuspendedRecords);

        /**
         * <p>
         * The validation state of the table.
         * </p>
         * <p>
         * The parameter can have the following values
         * </p>
         * <ul>
         * <li>
         * <p>
         * Not enabled—Validation is not enabled for the table in the migration task.
         * </p>
         * </li>
         * <li>
         * <p>
         * Pending records—Some records in the table are waiting for validation.
         * </p>
         * </li>
         * <li>
         * <p>
         * Mismatched records—Some records in the table do not match between the source and target.
         * </p>
         * </li>
         * <li>
         * <p>
         * Suspended records—Some records in the table could not be validated.
         * </p>
         * </li>
         * <li>
         * <p>
         * No primary key—The table could not be validated because it had no primary key.
         * </p>
         * </li>
         * <li>
         * <p>
         * Table error—The table was not validated because it was in an error state and some data was not migrated.
         * </p>
         * </li>
         * <li>
         * <p>
         * Validated—All rows in the table were validated. If the table is updated, the status can change from
         * Validated.
         * </p>
         * </li>
         * <li>
         * <p>
         * Error—The table could not be validated because of an unexpected error.
         * </p>
         * </li>
         * </ul>
         * 
         * @param validationState
         *        The validation state of the table.</p>
         *        <p>
         *        The parameter can have the following values
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Not enabled—Validation is not enabled for the table in the migration task.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Pending records—Some records in the table are waiting for validation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Mismatched records—Some records in the table do not match between the source and target.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Suspended records—Some records in the table could not be validated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        No primary key—The table could not be validated because it had no primary key.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Table error—The table was not validated because it was in an error state and some data was not
         *        migrated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Validated—All rows in the table were validated. If the table is updated, the status can change from
         *        Validated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Error—The table could not be validated because of an unexpected error.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationState(String validationState);

        /**
         * <p>
         * Additional details about the state of validation.
         * </p>
         * 
         * @param validationStateDetails
         *        Additional details about the state of validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationStateDetails(String validationStateDetails);
    }

    static final class BuilderImpl implements Builder {
        private String schemaName;

        private String tableName;

        private Long inserts;

        private Long deletes;

        private Long updates;

        private Long ddls;

        private Long fullLoadRows;

        private Long fullLoadCondtnlChkFailedRows;

        private Long fullLoadErrorRows;

        private Instant lastUpdateTime;

        private String tableState;

        private Long validationPendingRecords;

        private Long validationFailedRecords;

        private Long validationSuspendedRecords;

        private String validationState;

        private String validationStateDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(TableStatistics model) {
            schemaName(model.schemaName);
            tableName(model.tableName);
            inserts(model.inserts);
            deletes(model.deletes);
            updates(model.updates);
            ddls(model.ddls);
            fullLoadRows(model.fullLoadRows);
            fullLoadCondtnlChkFailedRows(model.fullLoadCondtnlChkFailedRows);
            fullLoadErrorRows(model.fullLoadErrorRows);
            lastUpdateTime(model.lastUpdateTime);
            tableState(model.tableState);
            validationPendingRecords(model.validationPendingRecords);
            validationFailedRecords(model.validationFailedRecords);
            validationSuspendedRecords(model.validationSuspendedRecords);
            validationState(model.validationState);
            validationStateDetails(model.validationStateDetails);
        }

        public final String getSchemaName() {
            return schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Long getInserts() {
            return inserts;
        }

        @Override
        public final Builder inserts(Long inserts) {
            this.inserts = inserts;
            return this;
        }

        public final void setInserts(Long inserts) {
            this.inserts = inserts;
        }

        public final Long getDeletes() {
            return deletes;
        }

        @Override
        public final Builder deletes(Long deletes) {
            this.deletes = deletes;
            return this;
        }

        public final void setDeletes(Long deletes) {
            this.deletes = deletes;
        }

        public final Long getUpdates() {
            return updates;
        }

        @Override
        public final Builder updates(Long updates) {
            this.updates = updates;
            return this;
        }

        public final void setUpdates(Long updates) {
            this.updates = updates;
        }

        public final Long getDdls() {
            return ddls;
        }

        @Override
        public final Builder ddls(Long ddls) {
            this.ddls = ddls;
            return this;
        }

        public final void setDdls(Long ddls) {
            this.ddls = ddls;
        }

        public final Long getFullLoadRows() {
            return fullLoadRows;
        }

        @Override
        public final Builder fullLoadRows(Long fullLoadRows) {
            this.fullLoadRows = fullLoadRows;
            return this;
        }

        public final void setFullLoadRows(Long fullLoadRows) {
            this.fullLoadRows = fullLoadRows;
        }

        public final Long getFullLoadCondtnlChkFailedRows() {
            return fullLoadCondtnlChkFailedRows;
        }

        @Override
        public final Builder fullLoadCondtnlChkFailedRows(Long fullLoadCondtnlChkFailedRows) {
            this.fullLoadCondtnlChkFailedRows = fullLoadCondtnlChkFailedRows;
            return this;
        }

        public final void setFullLoadCondtnlChkFailedRows(Long fullLoadCondtnlChkFailedRows) {
            this.fullLoadCondtnlChkFailedRows = fullLoadCondtnlChkFailedRows;
        }

        public final Long getFullLoadErrorRows() {
            return fullLoadErrorRows;
        }

        @Override
        public final Builder fullLoadErrorRows(Long fullLoadErrorRows) {
            this.fullLoadErrorRows = fullLoadErrorRows;
            return this;
        }

        public final void setFullLoadErrorRows(Long fullLoadErrorRows) {
            this.fullLoadErrorRows = fullLoadErrorRows;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public final String getTableState() {
            return tableState;
        }

        @Override
        public final Builder tableState(String tableState) {
            this.tableState = tableState;
            return this;
        }

        public final void setTableState(String tableState) {
            this.tableState = tableState;
        }

        public final Long getValidationPendingRecords() {
            return validationPendingRecords;
        }

        @Override
        public final Builder validationPendingRecords(Long validationPendingRecords) {
            this.validationPendingRecords = validationPendingRecords;
            return this;
        }

        public final void setValidationPendingRecords(Long validationPendingRecords) {
            this.validationPendingRecords = validationPendingRecords;
        }

        public final Long getValidationFailedRecords() {
            return validationFailedRecords;
        }

        @Override
        public final Builder validationFailedRecords(Long validationFailedRecords) {
            this.validationFailedRecords = validationFailedRecords;
            return this;
        }

        public final void setValidationFailedRecords(Long validationFailedRecords) {
            this.validationFailedRecords = validationFailedRecords;
        }

        public final Long getValidationSuspendedRecords() {
            return validationSuspendedRecords;
        }

        @Override
        public final Builder validationSuspendedRecords(Long validationSuspendedRecords) {
            this.validationSuspendedRecords = validationSuspendedRecords;
            return this;
        }

        public final void setValidationSuspendedRecords(Long validationSuspendedRecords) {
            this.validationSuspendedRecords = validationSuspendedRecords;
        }

        public final String getValidationState() {
            return validationState;
        }

        @Override
        public final Builder validationState(String validationState) {
            this.validationState = validationState;
            return this;
        }

        public final void setValidationState(String validationState) {
            this.validationState = validationState;
        }

        public final String getValidationStateDetails() {
            return validationStateDetails;
        }

        @Override
        public final Builder validationStateDetails(String validationStateDetails) {
            this.validationStateDetails = validationStateDetails;
            return this;
        }

        public final void setValidationStateDetails(String validationStateDetails) {
            this.validationStateDetails = validationStateDetails;
        }

        @Override
        public TableStatistics build() {
            return new TableStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
