/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for exporting data to Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Settings implements SdkPojo, Serializable, ToCopyableBuilder<S3Settings.Builder, S3Settings> {
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3Settings::serviceAccessRoleArn)).setter(setter(Builder::serviceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build())
            .build();

    private static final SdkField<String> EXTERNAL_TABLE_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3Settings::externalTableDefinition)).setter(setter(Builder::externalTableDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalTableDefinition").build())
            .build();

    private static final SdkField<String> CSV_ROW_DELIMITER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3Settings::csvRowDelimiter)).setter(setter(Builder::csvRowDelimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvRowDelimiter").build()).build();

    private static final SdkField<String> CSV_DELIMITER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3Settings::csvDelimiter)).setter(setter(Builder::csvDelimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvDelimiter").build()).build();

    private static final SdkField<String> BUCKET_FOLDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3Settings::bucketFolder)).setter(setter(Builder::bucketFolder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketFolder").build()).build();

    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3Settings::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()).build();

    private static final SdkField<String> COMPRESSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3Settings::compressionTypeAsString)).setter(setter(Builder::compressionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionType").build()).build();

    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3Settings::encryptionModeAsString)).setter(setter(Builder::encryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionMode").build()).build();

    private static final SdkField<String> SERVER_SIDE_ENCRYPTION_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(S3Settings::serverSideEncryptionKmsKeyId))
            .setter(setter(Builder::serverSideEncryptionKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideEncryptionKmsKeyId")
                    .build()).build();

    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3Settings::dataFormatAsString)).setter(setter(Builder::dataFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()).build();

    private static final SdkField<String> ENCODING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3Settings::encodingTypeAsString)).setter(setter(Builder::encodingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncodingType").build()).build();

    private static final SdkField<Integer> DICT_PAGE_SIZE_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(S3Settings::dictPageSizeLimit)).setter(setter(Builder::dictPageSizeLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DictPageSizeLimit").build()).build();

    private static final SdkField<Integer> ROW_GROUP_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(S3Settings::rowGroupLength)).setter(setter(Builder::rowGroupLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowGroupLength").build()).build();

    private static final SdkField<Integer> DATA_PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(S3Settings::dataPageSize)).setter(setter(Builder::dataPageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPageSize").build()).build();

    private static final SdkField<String> PARQUET_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3Settings::parquetVersionAsString)).setter(setter(Builder::parquetVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParquetVersion").build()).build();

    private static final SdkField<Boolean> ENABLE_STATISTICS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(S3Settings::enableStatistics)).setter(setter(Builder::enableStatistics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableStatistics").build()).build();

    private static final SdkField<Boolean> INCLUDE_OP_FOR_FULL_LOAD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(S3Settings::includeOpForFullLoad)).setter(setter(Builder::includeOpForFullLoad))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeOpForFullLoad").build())
            .build();

    private static final SdkField<Boolean> CDC_INSERTS_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(S3Settings::cdcInsertsOnly)).setter(setter(Builder::cdcInsertsOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcInsertsOnly").build()).build();

    private static final SdkField<String> TIMESTAMP_COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3Settings::timestampColumnName)).setter(setter(Builder::timestampColumnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampColumnName").build())
            .build();

    private static final SdkField<Boolean> PARQUET_TIMESTAMP_IN_MILLISECOND_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(S3Settings::parquetTimestampInMillisecond))
            .setter(setter(Builder::parquetTimestampInMillisecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParquetTimestampInMillisecond")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACCESS_ROLE_ARN_FIELD,
            EXTERNAL_TABLE_DEFINITION_FIELD, CSV_ROW_DELIMITER_FIELD, CSV_DELIMITER_FIELD, BUCKET_FOLDER_FIELD,
            BUCKET_NAME_FIELD, COMPRESSION_TYPE_FIELD, ENCRYPTION_MODE_FIELD, SERVER_SIDE_ENCRYPTION_KMS_KEY_ID_FIELD,
            DATA_FORMAT_FIELD, ENCODING_TYPE_FIELD, DICT_PAGE_SIZE_LIMIT_FIELD, ROW_GROUP_LENGTH_FIELD, DATA_PAGE_SIZE_FIELD,
            PARQUET_VERSION_FIELD, ENABLE_STATISTICS_FIELD, INCLUDE_OP_FOR_FULL_LOAD_FIELD, CDC_INSERTS_ONLY_FIELD,
            TIMESTAMP_COLUMN_NAME_FIELD, PARQUET_TIMESTAMP_IN_MILLISECOND_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceAccessRoleArn;

    private final String externalTableDefinition;

    private final String csvRowDelimiter;

    private final String csvDelimiter;

    private final String bucketFolder;

    private final String bucketName;

    private final String compressionType;

    private final String encryptionMode;

    private final String serverSideEncryptionKmsKeyId;

    private final String dataFormat;

    private final String encodingType;

    private final Integer dictPageSizeLimit;

    private final Integer rowGroupLength;

    private final Integer dataPageSize;

    private final String parquetVersion;

    private final Boolean enableStatistics;

    private final Boolean includeOpForFullLoad;

    private final Boolean cdcInsertsOnly;

    private final String timestampColumnName;

    private final Boolean parquetTimestampInMillisecond;

    private S3Settings(BuilderImpl builder) {
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.externalTableDefinition = builder.externalTableDefinition;
        this.csvRowDelimiter = builder.csvRowDelimiter;
        this.csvDelimiter = builder.csvDelimiter;
        this.bucketFolder = builder.bucketFolder;
        this.bucketName = builder.bucketName;
        this.compressionType = builder.compressionType;
        this.encryptionMode = builder.encryptionMode;
        this.serverSideEncryptionKmsKeyId = builder.serverSideEncryptionKmsKeyId;
        this.dataFormat = builder.dataFormat;
        this.encodingType = builder.encodingType;
        this.dictPageSizeLimit = builder.dictPageSizeLimit;
        this.rowGroupLength = builder.rowGroupLength;
        this.dataPageSize = builder.dataPageSize;
        this.parquetVersion = builder.parquetVersion;
        this.enableStatistics = builder.enableStatistics;
        this.includeOpForFullLoad = builder.includeOpForFullLoad;
        this.cdcInsertsOnly = builder.cdcInsertsOnly;
        this.timestampColumnName = builder.timestampColumnName;
        this.parquetTimestampInMillisecond = builder.parquetTimestampInMillisecond;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) used by the service access IAM role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) used by the service access IAM role.
     */
    public String serviceAccessRoleArn() {
        return serviceAccessRoleArn;
    }

    /**
     * <p>
     * The external table definition.
     * </p>
     * 
     * @return The external table definition.
     */
    public String externalTableDefinition() {
        return externalTableDefinition;
    }

    /**
     * <p>
     * The delimiter used to separate rows in the source files. The default is a carriage return (<code>\n</code>).
     * </p>
     * 
     * @return The delimiter used to separate rows in the source files. The default is a carriage return (
     *         <code>\n</code>).
     */
    public String csvRowDelimiter() {
        return csvRowDelimiter;
    }

    /**
     * <p>
     * The delimiter used to separate columns in the source files. The default is a comma.
     * </p>
     * 
     * @return The delimiter used to separate columns in the source files. The default is a comma.
     */
    public String csvDelimiter() {
        return csvDelimiter;
    }

    /**
     * <p>
     * An optional parameter to set a folder name in the S3 bucket. If provided, tables are created in the path
     * <code> <i>bucketFolder</i>/<i>schema_name</i>/<i>table_name</i>/</code>. If this parameter is not specified, then
     * the path used is <code> <i>schema_name</i>/<i>table_name</i>/</code>.
     * </p>
     * 
     * @return An optional parameter to set a folder name in the S3 bucket. If provided, tables are created in the path
     *         <code> <i>bucketFolder</i>/<i>schema_name</i>/<i>table_name</i>/</code>. If this parameter is not
     *         specified, then the path used is <code> <i>schema_name</i>/<i>table_name</i>/</code>.
     */
    public String bucketFolder() {
        return bucketFolder;
    }

    /**
     * <p>
     * The name of the S3 bucket.
     * </p>
     * 
     * @return The name of the S3 bucket.
     */
    public String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * An optional parameter to use GZIP to compress the target files. Set to GZIP to compress the target files. Set to
     * NONE (the default) or do not use to leave the files uncompressed. Applies to both .csv and .parquet file formats.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compressionType}
     * will return {@link CompressionTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #compressionTypeAsString}.
     * </p>
     * 
     * @return An optional parameter to use GZIP to compress the target files. Set to GZIP to compress the target files.
     *         Set to NONE (the default) or do not use to leave the files uncompressed. Applies to both .csv and
     *         .parquet file formats.
     * @see CompressionTypeValue
     */
    public CompressionTypeValue compressionType() {
        return CompressionTypeValue.fromValue(compressionType);
    }

    /**
     * <p>
     * An optional parameter to use GZIP to compress the target files. Set to GZIP to compress the target files. Set to
     * NONE (the default) or do not use to leave the files uncompressed. Applies to both .csv and .parquet file formats.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compressionType}
     * will return {@link CompressionTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #compressionTypeAsString}.
     * </p>
     * 
     * @return An optional parameter to use GZIP to compress the target files. Set to GZIP to compress the target files.
     *         Set to NONE (the default) or do not use to leave the files uncompressed. Applies to both .csv and
     *         .parquet file formats.
     * @see CompressionTypeValue
     */
    public String compressionTypeAsString() {
        return compressionType;
    }

    /**
     * <p>
     * The type of server-side encryption that you want to use for your data. This encryption type is part of the
     * endpoint settings or the extra connections attributes for Amazon S3. You can choose either <code>SSE_S3</code>
     * (the default) or <code>SSE_KMS</code>. To use <code>SSE_S3</code>, you need an AWS Identity and Access Management
     * (IAM) role with permission to allow <code>"arn:aws:s3:::dms-*"</code> to use the following actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>s3:CreateBucket</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:ListBucket</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:DeleteBucket</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:GetBucketLocation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:GetObject</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:PutObject</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:DeleteObject</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:GetObjectVersion</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:GetBucketPolicy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:PutBucketPolicy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:DeleteBucketPolicy</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionMode}
     * will return {@link EncryptionModeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #encryptionModeAsString}.
     * </p>
     * 
     * @return The type of server-side encryption that you want to use for your data. This encryption type is part of
     *         the endpoint settings or the extra connections attributes for Amazon S3. You can choose either
     *         <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. To use <code>SSE_S3</code>, you need an AWS
     *         Identity and Access Management (IAM) role with permission to allow <code>"arn:aws:s3:::dms-*"</code> to
     *         use the following actions:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>s3:CreateBucket</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:ListBucket</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:DeleteBucket</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:GetBucketLocation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:GetObject</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:PutObject</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:DeleteObject</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:GetObjectVersion</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:GetBucketPolicy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:PutBucketPolicy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:DeleteBucketPolicy</code>
     *         </p>
     *         </li>
     * @see EncryptionModeValue
     */
    public EncryptionModeValue encryptionMode() {
        return EncryptionModeValue.fromValue(encryptionMode);
    }

    /**
     * <p>
     * The type of server-side encryption that you want to use for your data. This encryption type is part of the
     * endpoint settings or the extra connections attributes for Amazon S3. You can choose either <code>SSE_S3</code>
     * (the default) or <code>SSE_KMS</code>. To use <code>SSE_S3</code>, you need an AWS Identity and Access Management
     * (IAM) role with permission to allow <code>"arn:aws:s3:::dms-*"</code> to use the following actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>s3:CreateBucket</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:ListBucket</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:DeleteBucket</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:GetBucketLocation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:GetObject</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:PutObject</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:DeleteObject</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:GetObjectVersion</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:GetBucketPolicy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:PutBucketPolicy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3:DeleteBucketPolicy</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionMode}
     * will return {@link EncryptionModeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #encryptionModeAsString}.
     * </p>
     * 
     * @return The type of server-side encryption that you want to use for your data. This encryption type is part of
     *         the endpoint settings or the extra connections attributes for Amazon S3. You can choose either
     *         <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. To use <code>SSE_S3</code>, you need an AWS
     *         Identity and Access Management (IAM) role with permission to allow <code>"arn:aws:s3:::dms-*"</code> to
     *         use the following actions:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>s3:CreateBucket</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:ListBucket</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:DeleteBucket</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:GetBucketLocation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:GetObject</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:PutObject</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:DeleteObject</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:GetObjectVersion</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:GetBucketPolicy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:PutBucketPolicy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3:DeleteBucketPolicy</code>
     *         </p>
     *         </li>
     * @see EncryptionModeValue
     */
    public String encryptionModeAsString() {
        return encryptionMode;
    }

    /**
     * <p>
     * If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide the AWS KMS key ID. The key
     * that you use needs an attached policy that enables AWS Identity and Access Management (IAM) user permissions and
     * allows use of the key.
     * </p>
     * <p>
     * Here is a CLI example:
     * <code>aws dms create-endpoint --endpoint-identifier <i>value</i> --endpoint-type target --engine-name s3 --s3-settings ServiceAccessRoleArn=<i>value</i>,BucketFolder=<i>value</i>,BucketName=<i>value</i>,EncryptionMode=SSE_KMS,ServerSideEncryptionKmsKeyId=<i>value</i> </code>
     * </p>
     * 
     * @return If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide the AWS KMS key ID.
     *         The key that you use needs an attached policy that enables AWS Identity and Access Management (IAM) user
     *         permissions and allows use of the key.</p>
     *         <p>
     *         Here is a CLI example:
     *         <code>aws dms create-endpoint --endpoint-identifier <i>value</i> --endpoint-type target --engine-name s3 --s3-settings ServiceAccessRoleArn=<i>value</i>,BucketFolder=<i>value</i>,BucketName=<i>value</i>,EncryptionMode=SSE_KMS,ServerSideEncryptionKmsKeyId=<i>value</i> </code>
     */
    public String serverSideEncryptionKmsKeyId() {
        return serverSideEncryptionKmsKeyId;
    }

    /**
     * <p>
     * The format of the data that you want to use for output. You can choose one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>csv</code> : This is a row-based file format with comma-separated values (.csv).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format that features efficient
     * compression and provides faster query response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link DataFormatValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataFormatAsString}.
     * </p>
     * 
     * @return The format of the data that you want to use for output. You can choose one of the following: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>csv</code> : This is a row-based file format with comma-separated values (.csv).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format that features
     *         efficient compression and provides faster query response.
     *         </p>
     *         </li>
     * @see DataFormatValue
     */
    public DataFormatValue dataFormat() {
        return DataFormatValue.fromValue(dataFormat);
    }

    /**
     * <p>
     * The format of the data that you want to use for output. You can choose one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>csv</code> : This is a row-based file format with comma-separated values (.csv).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format that features efficient
     * compression and provides faster query response.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link DataFormatValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataFormatAsString}.
     * </p>
     * 
     * @return The format of the data that you want to use for output. You can choose one of the following: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>csv</code> : This is a row-based file format with comma-separated values (.csv).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format that features
     *         efficient compression and provides faster query response.
     *         </p>
     *         </li>
     * @see DataFormatValue
     */
    public String dataFormatAsString() {
        return dataFormat;
    }

    /**
     * <p>
     * The type of encoding you are using:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length encoding to store repeated values
     * more efficiently. This is the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PLAIN</code> doesn't use encoding at all. Values are stored as they are.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a given column. The dictionary is
     * stored in a dictionary page for each column chunk.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encodingType} will
     * return {@link EncodingTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #encodingTypeAsString}.
     * </p>
     * 
     * @return The type of encoding you are using: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length encoding to store repeated
     *         values more efficiently. This is the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PLAIN</code> doesn't use encoding at all. Values are stored as they are.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a given column. The
     *         dictionary is stored in a dictionary page for each column chunk.
     *         </p>
     *         </li>
     * @see EncodingTypeValue
     */
    public EncodingTypeValue encodingType() {
        return EncodingTypeValue.fromValue(encodingType);
    }

    /**
     * <p>
     * The type of encoding you are using:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length encoding to store repeated values
     * more efficiently. This is the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PLAIN</code> doesn't use encoding at all. Values are stored as they are.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a given column. The dictionary is
     * stored in a dictionary page for each column chunk.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encodingType} will
     * return {@link EncodingTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #encodingTypeAsString}.
     * </p>
     * 
     * @return The type of encoding you are using: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length encoding to store repeated
     *         values more efficiently. This is the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PLAIN</code> doesn't use encoding at all. Values are stored as they are.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a given column. The
     *         dictionary is stored in a dictionary page for each column chunk.
     *         </p>
     *         </li>
     * @see EncodingTypeValue
     */
    public String encodingTypeAsString() {
        return encodingType;
    }

    /**
     * <p>
     * The maximum size of an encoded dictionary page of a column. If the dictionary page exceeds this, this column is
     * stored using an encoding type of <code>PLAIN</code>. This parameter defaults to 1024 * 1024 bytes (1 MiB), the
     * maximum size of a dictionary page before it reverts to <code>PLAIN</code> encoding. This size is used for
     * .parquet file format only.
     * </p>
     * 
     * @return The maximum size of an encoded dictionary page of a column. If the dictionary page exceeds this, this
     *         column is stored using an encoding type of <code>PLAIN</code>. This parameter defaults to 1024 * 1024
     *         bytes (1 MiB), the maximum size of a dictionary page before it reverts to <code>PLAIN</code> encoding.
     *         This size is used for .parquet file format only.
     */
    public Integer dictPageSizeLimit() {
        return dictPageSizeLimit;
    }

    /**
     * <p>
     * The number of rows in a row group. A smaller row group size provides faster reads. But as the number of row
     * groups grows, the slower writes become. This parameter defaults to 10,000 rows. This number is used for .parquet
     * file format only.
     * </p>
     * <p>
     * If you choose a value larger than the maximum, <code>RowGroupLength</code> is set to the max row group length in
     * bytes (64 * 1024 * 1024).
     * </p>
     * 
     * @return The number of rows in a row group. A smaller row group size provides faster reads. But as the number of
     *         row groups grows, the slower writes become. This parameter defaults to 10,000 rows. This number is used
     *         for .parquet file format only. </p>
     *         <p>
     *         If you choose a value larger than the maximum, <code>RowGroupLength</code> is set to the max row group
     *         length in bytes (64 * 1024 * 1024).
     */
    public Integer rowGroupLength() {
        return rowGroupLength;
    }

    /**
     * <p>
     * The size of one data page in bytes. This parameter defaults to 1024 * 1024 bytes (1 MiB). This number is used for
     * .parquet file format only.
     * </p>
     * 
     * @return The size of one data page in bytes. This parameter defaults to 1024 * 1024 bytes (1 MiB). This number is
     *         used for .parquet file format only.
     */
    public Integer dataPageSize() {
        return dataPageSize;
    }

    /**
     * <p>
     * The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code> (the default) or
     * <code>parquet_2_0</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parquetVersion}
     * will return {@link ParquetVersionValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #parquetVersionAsString}.
     * </p>
     * 
     * @return The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code> (the default) or
     *         <code>parquet_2_0</code>.
     * @see ParquetVersionValue
     */
    public ParquetVersionValue parquetVersion() {
        return ParquetVersionValue.fromValue(parquetVersion);
    }

    /**
     * <p>
     * The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code> (the default) or
     * <code>parquet_2_0</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parquetVersion}
     * will return {@link ParquetVersionValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #parquetVersionAsString}.
     * </p>
     * 
     * @return The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code> (the default) or
     *         <code>parquet_2_0</code>.
     * @see ParquetVersionValue
     */
    public String parquetVersionAsString() {
        return parquetVersion;
    }

    /**
     * <p>
     * A value that enables statistics for Parquet pages and row groups. Choose <code>true</code> to enable statistics,
     * <code>false</code> to disable. Statistics include <code>NULL</code>, <code>DISTINCT</code>, <code>MAX</code>, and
     * <code>MIN</code> values. This parameter defaults to <code>true</code>. This value is used for .parquet file
     * format only.
     * </p>
     * 
     * @return A value that enables statistics for Parquet pages and row groups. Choose <code>true</code> to enable
     *         statistics, <code>false</code> to disable. Statistics include <code>NULL</code>, <code>DISTINCT</code>,
     *         <code>MAX</code>, and <code>MIN</code> values. This parameter defaults to <code>true</code>. This value
     *         is used for .parquet file format only.
     */
    public Boolean enableStatistics() {
        return enableStatistics;
    }

    /**
     * <p>
     * A value that enables a full load to write INSERT operations to the comma-separated value (.csv) output files only
     * to indicate how the rows were added to the source database.
     * </p>
     * <note>
     * <p>
     * AWS DMS supports the <code>IncludeOpForFullLoad</code> parameter in versions 3.1.4 and later.
     * </p>
     * </note>
     * <p>
     * For full load, records can only be inserted. By default (the <code>false</code> setting), no information is
     * recorded in these output files for a full load to indicate that the rows were inserted at the source database. If
     * <code>IncludeOpForFullLoad</code> is set to <code>true</code> or <code>y</code>, the INSERT is recorded as an I
     * annotation in the first field of the .csv file. This allows the format of your target records from a full load to
     * be consistent with the target records from a CDC load.
     * </p>
     * <note>
     * <p>
     * This setting works together with the <code>CdcInsertsOnly</code> parameter for output to .csv files only. For
     * more information about how these settings work together, see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps"
     * >Indicating Source DB Operations in Migrated S3 Data</a> in the <i>AWS Database Migration Service User
     * Guide.</i>.
     * </p>
     * </note>
     * 
     * @return A value that enables a full load to write INSERT operations to the comma-separated value (.csv) output
     *         files only to indicate how the rows were added to the source database.</p> <note>
     *         <p>
     *         AWS DMS supports the <code>IncludeOpForFullLoad</code> parameter in versions 3.1.4 and later.
     *         </p>
     *         </note>
     *         <p>
     *         For full load, records can only be inserted. By default (the <code>false</code> setting), no information
     *         is recorded in these output files for a full load to indicate that the rows were inserted at the source
     *         database. If <code>IncludeOpForFullLoad</code> is set to <code>true</code> or <code>y</code>, the INSERT
     *         is recorded as an I annotation in the first field of the .csv file. This allows the format of your target
     *         records from a full load to be consistent with the target records from a CDC load.
     *         </p>
     *         <note>
     *         <p>
     *         This setting works together with the <code>CdcInsertsOnly</code> parameter for output to .csv files only.
     *         For more information about how these settings work together, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps"
     *         >Indicating Source DB Operations in Migrated S3 Data</a> in the <i>AWS Database Migration Service User
     *         Guide.</i>.
     *         </p>
     */
    public Boolean includeOpForFullLoad() {
        return includeOpForFullLoad;
    }

    /**
     * <p>
     * A value that enables a change data capture (CDC) load to write only INSERT operations to .csv or columnar storage
     * (.parquet) output files. By default (the <code>false</code> setting), the first field in a .csv or .parquet
     * record contains the letter I (INSERT), U (UPDATE), or D (DELETE). These values indicate whether the row was
     * inserted, updated, or deleted at the source database for a CDC load to the target.
     * </p>
     * <p>
     * If <code>CdcInsertsOnly</code> is set to <code>true</code> or <code>y</code>, only INSERTs from the source
     * database are migrated to the .csv or .parquet file. For .csv format only, how these INSERTs are recorded depends
     * on the value of <code>IncludeOpForFullLoad</code>. If <code>IncludeOpForFullLoad</code> is set to
     * <code>true</code>, the first field of every CDC record is set to I to indicate the INSERT operation at the
     * source. If <code>IncludeOpForFullLoad</code> is set to <code>false</code>, every CDC record is written without a
     * first field to indicate the INSERT operation at the source. For more information about how these settings work
     * together, see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps"
     * >Indicating Source DB Operations in Migrated S3 Data</a> in the <i>AWS Database Migration Service User
     * Guide.</i>.
     * </p>
     * <note>
     * <p>
     * AWS DMS supports this interaction between the <code>CdcInsertsOnly</code> and <code>IncludeOpForFullLoad</code>
     * parameters in versions 3.1.4 and later.
     * </p>
     * </note>
     * 
     * @return A value that enables a change data capture (CDC) load to write only INSERT operations to .csv or columnar
     *         storage (.parquet) output files. By default (the <code>false</code> setting), the first field in a .csv
     *         or .parquet record contains the letter I (INSERT), U (UPDATE), or D (DELETE). These values indicate
     *         whether the row was inserted, updated, or deleted at the source database for a CDC load to the
     *         target.</p>
     *         <p>
     *         If <code>CdcInsertsOnly</code> is set to <code>true</code> or <code>y</code>, only INSERTs from the
     *         source database are migrated to the .csv or .parquet file. For .csv format only, how these INSERTs are
     *         recorded depends on the value of <code>IncludeOpForFullLoad</code>. If <code>IncludeOpForFullLoad</code>
     *         is set to <code>true</code>, the first field of every CDC record is set to I to indicate the INSERT
     *         operation at the source. If <code>IncludeOpForFullLoad</code> is set to <code>false</code>, every CDC
     *         record is written without a first field to indicate the INSERT operation at the source. For more
     *         information about how these settings work together, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps"
     *         >Indicating Source DB Operations in Migrated S3 Data</a> in the <i>AWS Database Migration Service User
     *         Guide.</i>.
     *         </p>
     *         <note>
     *         <p>
     *         AWS DMS supports this interaction between the <code>CdcInsertsOnly</code> and
     *         <code>IncludeOpForFullLoad</code> parameters in versions 3.1.4 and later.
     *         </p>
     */
    public Boolean cdcInsertsOnly() {
        return cdcInsertsOnly;
    }

    /**
     * <p>
     * A value that when nonblank causes AWS DMS to add a column with timestamp information to the endpoint data for an
     * Amazon S3 target.
     * </p>
     * <note>
     * <p>
     * AWS DMS supports the <code>TimestampColumnName</code> parameter in versions 3.1.4 and later.
     * </p>
     * </note>
     * <p>
     * DMS includes an additional <code>STRING</code> column in the .csv or .parquet object files of your migrated data
     * when you set <code>TimestampColumnName</code> to a nonblank value.
     * </p>
     * <p>
     * For a full load, each row of this timestamp column contains a timestamp for when the data was transferred from
     * the source to the target by DMS.
     * </p>
     * <p>
     * For a change data capture (CDC) load, each row of the timestamp column contains the timestamp for the commit of
     * that row in the source database.
     * </p>
     * <p>
     * The string format for this timestamp column value is <code>yyyy-MM-dd HH:mm:ss.SSSSSS</code>. By default, the
     * precision of this value is in microseconds. For a CDC load, the rounding of the precision depends on the commit
     * timestamp supported by DMS for the source database.
     * </p>
     * <p>
     * When the <code>AddColumnName</code> parameter is set to <code>true</code>, DMS also includes a name for the
     * timestamp column that you set with <code>TimestampColumnName</code>.
     * </p>
     * 
     * @return A value that when nonblank causes AWS DMS to add a column with timestamp information to the endpoint data
     *         for an Amazon S3 target.</p> <note>
     *         <p>
     *         AWS DMS supports the <code>TimestampColumnName</code> parameter in versions 3.1.4 and later.
     *         </p>
     *         </note>
     *         <p>
     *         DMS includes an additional <code>STRING</code> column in the .csv or .parquet object files of your
     *         migrated data when you set <code>TimestampColumnName</code> to a nonblank value.
     *         </p>
     *         <p>
     *         For a full load, each row of this timestamp column contains a timestamp for when the data was transferred
     *         from the source to the target by DMS.
     *         </p>
     *         <p>
     *         For a change data capture (CDC) load, each row of the timestamp column contains the timestamp for the
     *         commit of that row in the source database.
     *         </p>
     *         <p>
     *         The string format for this timestamp column value is <code>yyyy-MM-dd HH:mm:ss.SSSSSS</code>. By default,
     *         the precision of this value is in microseconds. For a CDC load, the rounding of the precision depends on
     *         the commit timestamp supported by DMS for the source database.
     *         </p>
     *         <p>
     *         When the <code>AddColumnName</code> parameter is set to <code>true</code>, DMS also includes a name for
     *         the timestamp column that you set with <code>TimestampColumnName</code>.
     */
    public String timestampColumnName() {
        return timestampColumnName;
    }

    /**
     * <p>
     * A value that specifies the precision of any <code>TIMESTAMP</code> column values that are written to an Amazon S3
     * object file in .parquet format.
     * </p>
     * <note>
     * <p>
     * AWS DMS supports the <code>ParquetTimestampInMillisecond</code> parameter in versions 3.1.4 and later.
     * </p>
     * </note>
     * <p>
     * When <code>ParquetTimestampInMillisecond</code> is set to <code>true</code> or <code>y</code>, AWS DMS writes all
     * <code>TIMESTAMP</code> columns in a .parquet formatted file with millisecond precision. Otherwise, DMS writes
     * them with microsecond precision.
     * </p>
     * <p>
     * Currently, Amazon Athena and AWS Glue can handle only millisecond precision for <code>TIMESTAMP</code> values.
     * Set this parameter to <code>true</code> for S3 endpoint object files that are .parquet formatted only if you plan
     * to query or process the data with Athena or AWS Glue.
     * </p>
     * <note>
     * <p>
     * AWS DMS writes any <code>TIMESTAMP</code> column values written to an S3 file in .csv format with microsecond
     * precision.
     * </p>
     * <p>
     * Setting <code>ParquetTimestampInMillisecond</code> has no effect on the string format of the timestamp column
     * value that is inserted by setting the <code>TimestampColumnName</code> parameter.
     * </p>
     * </note>
     * 
     * @return A value that specifies the precision of any <code>TIMESTAMP</code> column values that are written to an
     *         Amazon S3 object file in .parquet format.</p> <note>
     *         <p>
     *         AWS DMS supports the <code>ParquetTimestampInMillisecond</code> parameter in versions 3.1.4 and later.
     *         </p>
     *         </note>
     *         <p>
     *         When <code>ParquetTimestampInMillisecond</code> is set to <code>true</code> or <code>y</code>, AWS DMS
     *         writes all <code>TIMESTAMP</code> columns in a .parquet formatted file with millisecond precision.
     *         Otherwise, DMS writes them with microsecond precision.
     *         </p>
     *         <p>
     *         Currently, Amazon Athena and AWS Glue can handle only millisecond precision for <code>TIMESTAMP</code>
     *         values. Set this parameter to <code>true</code> for S3 endpoint object files that are .parquet formatted
     *         only if you plan to query or process the data with Athena or AWS Glue.
     *         </p>
     *         <note>
     *         <p>
     *         AWS DMS writes any <code>TIMESTAMP</code> column values written to an S3 file in .csv format with
     *         microsecond precision.
     *         </p>
     *         <p>
     *         Setting <code>ParquetTimestampInMillisecond</code> has no effect on the string format of the timestamp
     *         column value that is inserted by setting the <code>TimestampColumnName</code> parameter.
     *         </p>
     */
    public Boolean parquetTimestampInMillisecond() {
        return parquetTimestampInMillisecond;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(externalTableDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(csvRowDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(csvDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(bucketFolder());
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(compressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideEncryptionKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encodingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dictPageSizeLimit());
        hashCode = 31 * hashCode + Objects.hashCode(rowGroupLength());
        hashCode = 31 * hashCode + Objects.hashCode(dataPageSize());
        hashCode = 31 * hashCode + Objects.hashCode(parquetVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enableStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(includeOpForFullLoad());
        hashCode = 31 * hashCode + Objects.hashCode(cdcInsertsOnly());
        hashCode = 31 * hashCode + Objects.hashCode(timestampColumnName());
        hashCode = 31 * hashCode + Objects.hashCode(parquetTimestampInMillisecond());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Settings)) {
            return false;
        }
        S3Settings other = (S3Settings) obj;
        return Objects.equals(serviceAccessRoleArn(), other.serviceAccessRoleArn())
                && Objects.equals(externalTableDefinition(), other.externalTableDefinition())
                && Objects.equals(csvRowDelimiter(), other.csvRowDelimiter())
                && Objects.equals(csvDelimiter(), other.csvDelimiter()) && Objects.equals(bucketFolder(), other.bucketFolder())
                && Objects.equals(bucketName(), other.bucketName())
                && Objects.equals(compressionTypeAsString(), other.compressionTypeAsString())
                && Objects.equals(encryptionModeAsString(), other.encryptionModeAsString())
                && Objects.equals(serverSideEncryptionKmsKeyId(), other.serverSideEncryptionKmsKeyId())
                && Objects.equals(dataFormatAsString(), other.dataFormatAsString())
                && Objects.equals(encodingTypeAsString(), other.encodingTypeAsString())
                && Objects.equals(dictPageSizeLimit(), other.dictPageSizeLimit())
                && Objects.equals(rowGroupLength(), other.rowGroupLength())
                && Objects.equals(dataPageSize(), other.dataPageSize())
                && Objects.equals(parquetVersionAsString(), other.parquetVersionAsString())
                && Objects.equals(enableStatistics(), other.enableStatistics())
                && Objects.equals(includeOpForFullLoad(), other.includeOpForFullLoad())
                && Objects.equals(cdcInsertsOnly(), other.cdcInsertsOnly())
                && Objects.equals(timestampColumnName(), other.timestampColumnName())
                && Objects.equals(parquetTimestampInMillisecond(), other.parquetTimestampInMillisecond());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("S3Settings").add("ServiceAccessRoleArn", serviceAccessRoleArn())
                .add("ExternalTableDefinition", externalTableDefinition()).add("CsvRowDelimiter", csvRowDelimiter())
                .add("CsvDelimiter", csvDelimiter()).add("BucketFolder", bucketFolder()).add("BucketName", bucketName())
                .add("CompressionType", compressionTypeAsString()).add("EncryptionMode", encryptionModeAsString())
                .add("ServerSideEncryptionKmsKeyId", serverSideEncryptionKmsKeyId()).add("DataFormat", dataFormatAsString())
                .add("EncodingType", encodingTypeAsString()).add("DictPageSizeLimit", dictPageSizeLimit())
                .add("RowGroupLength", rowGroupLength()).add("DataPageSize", dataPageSize())
                .add("ParquetVersion", parquetVersionAsString()).add("EnableStatistics", enableStatistics())
                .add("IncludeOpForFullLoad", includeOpForFullLoad()).add("CdcInsertsOnly", cdcInsertsOnly())
                .add("TimestampColumnName", timestampColumnName())
                .add("ParquetTimestampInMillisecond", parquetTimestampInMillisecond()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(serviceAccessRoleArn()));
        case "ExternalTableDefinition":
            return Optional.ofNullable(clazz.cast(externalTableDefinition()));
        case "CsvRowDelimiter":
            return Optional.ofNullable(clazz.cast(csvRowDelimiter()));
        case "CsvDelimiter":
            return Optional.ofNullable(clazz.cast(csvDelimiter()));
        case "BucketFolder":
            return Optional.ofNullable(clazz.cast(bucketFolder()));
        case "BucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "CompressionType":
            return Optional.ofNullable(clazz.cast(compressionTypeAsString()));
        case "EncryptionMode":
            return Optional.ofNullable(clazz.cast(encryptionModeAsString()));
        case "ServerSideEncryptionKmsKeyId":
            return Optional.ofNullable(clazz.cast(serverSideEncryptionKmsKeyId()));
        case "DataFormat":
            return Optional.ofNullable(clazz.cast(dataFormatAsString()));
        case "EncodingType":
            return Optional.ofNullable(clazz.cast(encodingTypeAsString()));
        case "DictPageSizeLimit":
            return Optional.ofNullable(clazz.cast(dictPageSizeLimit()));
        case "RowGroupLength":
            return Optional.ofNullable(clazz.cast(rowGroupLength()));
        case "DataPageSize":
            return Optional.ofNullable(clazz.cast(dataPageSize()));
        case "ParquetVersion":
            return Optional.ofNullable(clazz.cast(parquetVersionAsString()));
        case "EnableStatistics":
            return Optional.ofNullable(clazz.cast(enableStatistics()));
        case "IncludeOpForFullLoad":
            return Optional.ofNullable(clazz.cast(includeOpForFullLoad()));
        case "CdcInsertsOnly":
            return Optional.ofNullable(clazz.cast(cdcInsertsOnly()));
        case "TimestampColumnName":
            return Optional.ofNullable(clazz.cast(timestampColumnName()));
        case "ParquetTimestampInMillisecond":
            return Optional.ofNullable(clazz.cast(parquetTimestampInMillisecond()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Settings, T> g) {
        return obj -> g.apply((S3Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Settings> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) used by the service access IAM role.
         * </p>
         * 
         * @param serviceAccessRoleArn
         *        The Amazon Resource Name (ARN) used by the service access IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccessRoleArn(String serviceAccessRoleArn);

        /**
         * <p>
         * The external table definition.
         * </p>
         * 
         * @param externalTableDefinition
         *        The external table definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalTableDefinition(String externalTableDefinition);

        /**
         * <p>
         * The delimiter used to separate rows in the source files. The default is a carriage return (<code>\n</code>).
         * </p>
         * 
         * @param csvRowDelimiter
         *        The delimiter used to separate rows in the source files. The default is a carriage return (
         *        <code>\n</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvRowDelimiter(String csvRowDelimiter);

        /**
         * <p>
         * The delimiter used to separate columns in the source files. The default is a comma.
         * </p>
         * 
         * @param csvDelimiter
         *        The delimiter used to separate columns in the source files. The default is a comma.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvDelimiter(String csvDelimiter);

        /**
         * <p>
         * An optional parameter to set a folder name in the S3 bucket. If provided, tables are created in the path
         * <code> <i>bucketFolder</i>/<i>schema_name</i>/<i>table_name</i>/</code>. If this parameter is not specified,
         * then the path used is <code> <i>schema_name</i>/<i>table_name</i>/</code>.
         * </p>
         * 
         * @param bucketFolder
         *        An optional parameter to set a folder name in the S3 bucket. If provided, tables are created in the
         *        path <code> <i>bucketFolder</i>/<i>schema_name</i>/<i>table_name</i>/</code>. If this parameter is not
         *        specified, then the path used is <code> <i>schema_name</i>/<i>table_name</i>/</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketFolder(String bucketFolder);

        /**
         * <p>
         * The name of the S3 bucket.
         * </p>
         * 
         * @param bucketName
         *        The name of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * An optional parameter to use GZIP to compress the target files. Set to GZIP to compress the target files. Set
         * to NONE (the default) or do not use to leave the files uncompressed. Applies to both .csv and .parquet file
         * formats.
         * </p>
         * 
         * @param compressionType
         *        An optional parameter to use GZIP to compress the target files. Set to GZIP to compress the target
         *        files. Set to NONE (the default) or do not use to leave the files uncompressed. Applies to both .csv
         *        and .parquet file formats.
         * @see CompressionTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionTypeValue
         */
        Builder compressionType(String compressionType);

        /**
         * <p>
         * An optional parameter to use GZIP to compress the target files. Set to GZIP to compress the target files. Set
         * to NONE (the default) or do not use to leave the files uncompressed. Applies to both .csv and .parquet file
         * formats.
         * </p>
         * 
         * @param compressionType
         *        An optional parameter to use GZIP to compress the target files. Set to GZIP to compress the target
         *        files. Set to NONE (the default) or do not use to leave the files uncompressed. Applies to both .csv
         *        and .parquet file formats.
         * @see CompressionTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompressionTypeValue
         */
        Builder compressionType(CompressionTypeValue compressionType);

        /**
         * <p>
         * The type of server-side encryption that you want to use for your data. This encryption type is part of the
         * endpoint settings or the extra connections attributes for Amazon S3. You can choose either
         * <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. To use <code>SSE_S3</code>, you need an AWS
         * Identity and Access Management (IAM) role with permission to allow <code>"arn:aws:s3:::dms-*"</code> to use
         * the following actions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>s3:CreateBucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:ListBucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:DeleteBucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:GetBucketLocation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:GetObject</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:PutObject</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:DeleteObject</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:GetObjectVersion</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:GetBucketPolicy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:PutBucketPolicy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:DeleteBucketPolicy</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param encryptionMode
         *        The type of server-side encryption that you want to use for your data. This encryption type is part of
         *        the endpoint settings or the extra connections attributes for Amazon S3. You can choose either
         *        <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. To use <code>SSE_S3</code>, you need an AWS
         *        Identity and Access Management (IAM) role with permission to allow <code>"arn:aws:s3:::dms-*"</code>
         *        to use the following actions:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>s3:CreateBucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:ListBucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:DeleteBucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:GetBucketLocation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:GetObject</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:PutObject</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:DeleteObject</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:GetObjectVersion</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:GetBucketPolicy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:PutBucketPolicy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:DeleteBucketPolicy</code>
         *        </p>
         *        </li>
         * @see EncryptionModeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionModeValue
         */
        Builder encryptionMode(String encryptionMode);

        /**
         * <p>
         * The type of server-side encryption that you want to use for your data. This encryption type is part of the
         * endpoint settings or the extra connections attributes for Amazon S3. You can choose either
         * <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. To use <code>SSE_S3</code>, you need an AWS
         * Identity and Access Management (IAM) role with permission to allow <code>"arn:aws:s3:::dms-*"</code> to use
         * the following actions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>s3:CreateBucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:ListBucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:DeleteBucket</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:GetBucketLocation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:GetObject</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:PutObject</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:DeleteObject</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:GetObjectVersion</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:GetBucketPolicy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:PutBucketPolicy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3:DeleteBucketPolicy</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param encryptionMode
         *        The type of server-side encryption that you want to use for your data. This encryption type is part of
         *        the endpoint settings or the extra connections attributes for Amazon S3. You can choose either
         *        <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. To use <code>SSE_S3</code>, you need an AWS
         *        Identity and Access Management (IAM) role with permission to allow <code>"arn:aws:s3:::dms-*"</code>
         *        to use the following actions:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>s3:CreateBucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:ListBucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:DeleteBucket</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:GetBucketLocation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:GetObject</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:PutObject</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:DeleteObject</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:GetObjectVersion</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:GetBucketPolicy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:PutBucketPolicy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3:DeleteBucketPolicy</code>
         *        </p>
         *        </li>
         * @see EncryptionModeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionModeValue
         */
        Builder encryptionMode(EncryptionModeValue encryptionMode);

        /**
         * <p>
         * If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide the AWS KMS key ID. The
         * key that you use needs an attached policy that enables AWS Identity and Access Management (IAM) user
         * permissions and allows use of the key.
         * </p>
         * <p>
         * Here is a CLI example:
         * <code>aws dms create-endpoint --endpoint-identifier <i>value</i> --endpoint-type target --engine-name s3 --s3-settings ServiceAccessRoleArn=<i>value</i>,BucketFolder=<i>value</i>,BucketName=<i>value</i>,EncryptionMode=SSE_KMS,ServerSideEncryptionKmsKeyId=<i>value</i> </code>
         * </p>
         * 
         * @param serverSideEncryptionKmsKeyId
         *        If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide the AWS KMS key ID.
         *        The key that you use needs an attached policy that enables AWS Identity and Access Management (IAM)
         *        user permissions and allows use of the key.</p>
         *        <p>
         *        Here is a CLI example:
         *        <code>aws dms create-endpoint --endpoint-identifier <i>value</i> --endpoint-type target --engine-name s3 --s3-settings ServiceAccessRoleArn=<i>value</i>,BucketFolder=<i>value</i>,BucketName=<i>value</i>,EncryptionMode=SSE_KMS,ServerSideEncryptionKmsKeyId=<i>value</i> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId);

        /**
         * <p>
         * The format of the data that you want to use for output. You can choose one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>csv</code> : This is a row-based file format with comma-separated values (.csv).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format that features efficient
         * compression and provides faster query response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dataFormat
         *        The format of the data that you want to use for output. You can choose one of the following: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>csv</code> : This is a row-based file format with comma-separated values (.csv).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format that features
         *        efficient compression and provides faster query response.
         *        </p>
         *        </li>
         * @see DataFormatValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataFormatValue
         */
        Builder dataFormat(String dataFormat);

        /**
         * <p>
         * The format of the data that you want to use for output. You can choose one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>csv</code> : This is a row-based file format with comma-separated values (.csv).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format that features efficient
         * compression and provides faster query response.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dataFormat
         *        The format of the data that you want to use for output. You can choose one of the following: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>csv</code> : This is a row-based file format with comma-separated values (.csv).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format that features
         *        efficient compression and provides faster query response.
         *        </p>
         *        </li>
         * @see DataFormatValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataFormatValue
         */
        Builder dataFormat(DataFormatValue dataFormat);

        /**
         * <p>
         * The type of encoding you are using:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length encoding to store repeated
         * values more efficiently. This is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLAIN</code> doesn't use encoding at all. Values are stored as they are.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a given column. The dictionary
         * is stored in a dictionary page for each column chunk.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encodingType
         *        The type of encoding you are using: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length encoding to store
         *        repeated values more efficiently. This is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PLAIN</code> doesn't use encoding at all. Values are stored as they are.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a given column. The
         *        dictionary is stored in a dictionary page for each column chunk.
         *        </p>
         *        </li>
         * @see EncodingTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingTypeValue
         */
        Builder encodingType(String encodingType);

        /**
         * <p>
         * The type of encoding you are using:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length encoding to store repeated
         * values more efficiently. This is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLAIN</code> doesn't use encoding at all. Values are stored as they are.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a given column. The dictionary
         * is stored in a dictionary page for each column chunk.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encodingType
         *        The type of encoding you are using: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length encoding to store
         *        repeated values more efficiently. This is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PLAIN</code> doesn't use encoding at all. Values are stored as they are.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a given column. The
         *        dictionary is stored in a dictionary page for each column chunk.
         *        </p>
         *        </li>
         * @see EncodingTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingTypeValue
         */
        Builder encodingType(EncodingTypeValue encodingType);

        /**
         * <p>
         * The maximum size of an encoded dictionary page of a column. If the dictionary page exceeds this, this column
         * is stored using an encoding type of <code>PLAIN</code>. This parameter defaults to 1024 * 1024 bytes (1 MiB),
         * the maximum size of a dictionary page before it reverts to <code>PLAIN</code> encoding. This size is used for
         * .parquet file format only.
         * </p>
         * 
         * @param dictPageSizeLimit
         *        The maximum size of an encoded dictionary page of a column. If the dictionary page exceeds this, this
         *        column is stored using an encoding type of <code>PLAIN</code>. This parameter defaults to 1024 * 1024
         *        bytes (1 MiB), the maximum size of a dictionary page before it reverts to <code>PLAIN</code> encoding.
         *        This size is used for .parquet file format only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dictPageSizeLimit(Integer dictPageSizeLimit);

        /**
         * <p>
         * The number of rows in a row group. A smaller row group size provides faster reads. But as the number of row
         * groups grows, the slower writes become. This parameter defaults to 10,000 rows. This number is used for
         * .parquet file format only.
         * </p>
         * <p>
         * If you choose a value larger than the maximum, <code>RowGroupLength</code> is set to the max row group length
         * in bytes (64 * 1024 * 1024).
         * </p>
         * 
         * @param rowGroupLength
         *        The number of rows in a row group. A smaller row group size provides faster reads. But as the number
         *        of row groups grows, the slower writes become. This parameter defaults to 10,000 rows. This number is
         *        used for .parquet file format only. </p>
         *        <p>
         *        If you choose a value larger than the maximum, <code>RowGroupLength</code> is set to the max row group
         *        length in bytes (64 * 1024 * 1024).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowGroupLength(Integer rowGroupLength);

        /**
         * <p>
         * The size of one data page in bytes. This parameter defaults to 1024 * 1024 bytes (1 MiB). This number is used
         * for .parquet file format only.
         * </p>
         * 
         * @param dataPageSize
         *        The size of one data page in bytes. This parameter defaults to 1024 * 1024 bytes (1 MiB). This number
         *        is used for .parquet file format only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPageSize(Integer dataPageSize);

        /**
         * <p>
         * The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code> (the default) or
         * <code>parquet_2_0</code>.
         * </p>
         * 
         * @param parquetVersion
         *        The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code> (the default)
         *        or <code>parquet_2_0</code>.
         * @see ParquetVersionValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParquetVersionValue
         */
        Builder parquetVersion(String parquetVersion);

        /**
         * <p>
         * The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code> (the default) or
         * <code>parquet_2_0</code>.
         * </p>
         * 
         * @param parquetVersion
         *        The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code> (the default)
         *        or <code>parquet_2_0</code>.
         * @see ParquetVersionValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParquetVersionValue
         */
        Builder parquetVersion(ParquetVersionValue parquetVersion);

        /**
         * <p>
         * A value that enables statistics for Parquet pages and row groups. Choose <code>true</code> to enable
         * statistics, <code>false</code> to disable. Statistics include <code>NULL</code>, <code>DISTINCT</code>,
         * <code>MAX</code>, and <code>MIN</code> values. This parameter defaults to <code>true</code>. This value is
         * used for .parquet file format only.
         * </p>
         * 
         * @param enableStatistics
         *        A value that enables statistics for Parquet pages and row groups. Choose <code>true</code> to enable
         *        statistics, <code>false</code> to disable. Statistics include <code>NULL</code>, <code>DISTINCT</code>
         *        , <code>MAX</code>, and <code>MIN</code> values. This parameter defaults to <code>true</code>. This
         *        value is used for .parquet file format only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableStatistics(Boolean enableStatistics);

        /**
         * <p>
         * A value that enables a full load to write INSERT operations to the comma-separated value (.csv) output files
         * only to indicate how the rows were added to the source database.
         * </p>
         * <note>
         * <p>
         * AWS DMS supports the <code>IncludeOpForFullLoad</code> parameter in versions 3.1.4 and later.
         * </p>
         * </note>
         * <p>
         * For full load, records can only be inserted. By default (the <code>false</code> setting), no information is
         * recorded in these output files for a full load to indicate that the rows were inserted at the source
         * database. If <code>IncludeOpForFullLoad</code> is set to <code>true</code> or <code>y</code>, the INSERT is
         * recorded as an I annotation in the first field of the .csv file. This allows the format of your target
         * records from a full load to be consistent with the target records from a CDC load.
         * </p>
         * <note>
         * <p>
         * This setting works together with the <code>CdcInsertsOnly</code> parameter for output to .csv files only. For
         * more information about how these settings work together, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps"
         * >Indicating Source DB Operations in Migrated S3 Data</a> in the <i>AWS Database Migration Service User
         * Guide.</i>.
         * </p>
         * </note>
         * 
         * @param includeOpForFullLoad
         *        A value that enables a full load to write INSERT operations to the comma-separated value (.csv) output
         *        files only to indicate how the rows were added to the source database.</p> <note>
         *        <p>
         *        AWS DMS supports the <code>IncludeOpForFullLoad</code> parameter in versions 3.1.4 and later.
         *        </p>
         *        </note>
         *        <p>
         *        For full load, records can only be inserted. By default (the <code>false</code> setting), no
         *        information is recorded in these output files for a full load to indicate that the rows were inserted
         *        at the source database. If <code>IncludeOpForFullLoad</code> is set to <code>true</code> or
         *        <code>y</code>, the INSERT is recorded as an I annotation in the first field of the .csv file. This
         *        allows the format of your target records from a full load to be consistent with the target records
         *        from a CDC load.
         *        </p>
         *        <note>
         *        <p>
         *        This setting works together with the <code>CdcInsertsOnly</code> parameter for output to .csv files
         *        only. For more information about how these settings work together, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps"
         *        >Indicating Source DB Operations in Migrated S3 Data</a> in the <i>AWS Database Migration Service User
         *        Guide.</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeOpForFullLoad(Boolean includeOpForFullLoad);

        /**
         * <p>
         * A value that enables a change data capture (CDC) load to write only INSERT operations to .csv or columnar
         * storage (.parquet) output files. By default (the <code>false</code> setting), the first field in a .csv or
         * .parquet record contains the letter I (INSERT), U (UPDATE), or D (DELETE). These values indicate whether the
         * row was inserted, updated, or deleted at the source database for a CDC load to the target.
         * </p>
         * <p>
         * If <code>CdcInsertsOnly</code> is set to <code>true</code> or <code>y</code>, only INSERTs from the source
         * database are migrated to the .csv or .parquet file. For .csv format only, how these INSERTs are recorded
         * depends on the value of <code>IncludeOpForFullLoad</code>. If <code>IncludeOpForFullLoad</code> is set to
         * <code>true</code>, the first field of every CDC record is set to I to indicate the INSERT operation at the
         * source. If <code>IncludeOpForFullLoad</code> is set to <code>false</code>, every CDC record is written
         * without a first field to indicate the INSERT operation at the source. For more information about how these
         * settings work together, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps"
         * >Indicating Source DB Operations in Migrated S3 Data</a> in the <i>AWS Database Migration Service User
         * Guide.</i>.
         * </p>
         * <note>
         * <p>
         * AWS DMS supports this interaction between the <code>CdcInsertsOnly</code> and
         * <code>IncludeOpForFullLoad</code> parameters in versions 3.1.4 and later.
         * </p>
         * </note>
         * 
         * @param cdcInsertsOnly
         *        A value that enables a change data capture (CDC) load to write only INSERT operations to .csv or
         *        columnar storage (.parquet) output files. By default (the <code>false</code> setting), the first field
         *        in a .csv or .parquet record contains the letter I (INSERT), U (UPDATE), or D (DELETE). These values
         *        indicate whether the row was inserted, updated, or deleted at the source database for a CDC load to
         *        the target.</p>
         *        <p>
         *        If <code>CdcInsertsOnly</code> is set to <code>true</code> or <code>y</code>, only INSERTs from the
         *        source database are migrated to the .csv or .parquet file. For .csv format only, how these INSERTs are
         *        recorded depends on the value of <code>IncludeOpForFullLoad</code>. If
         *        <code>IncludeOpForFullLoad</code> is set to <code>true</code>, the first field of every CDC record is
         *        set to I to indicate the INSERT operation at the source. If <code>IncludeOpForFullLoad</code> is set
         *        to <code>false</code>, every CDC record is written without a first field to indicate the INSERT
         *        operation at the source. For more information about how these settings work together, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps"
         *        >Indicating Source DB Operations in Migrated S3 Data</a> in the <i>AWS Database Migration Service User
         *        Guide.</i>.
         *        </p>
         *        <note>
         *        <p>
         *        AWS DMS supports this interaction between the <code>CdcInsertsOnly</code> and
         *        <code>IncludeOpForFullLoad</code> parameters in versions 3.1.4 and later.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcInsertsOnly(Boolean cdcInsertsOnly);

        /**
         * <p>
         * A value that when nonblank causes AWS DMS to add a column with timestamp information to the endpoint data for
         * an Amazon S3 target.
         * </p>
         * <note>
         * <p>
         * AWS DMS supports the <code>TimestampColumnName</code> parameter in versions 3.1.4 and later.
         * </p>
         * </note>
         * <p>
         * DMS includes an additional <code>STRING</code> column in the .csv or .parquet object files of your migrated
         * data when you set <code>TimestampColumnName</code> to a nonblank value.
         * </p>
         * <p>
         * For a full load, each row of this timestamp column contains a timestamp for when the data was transferred
         * from the source to the target by DMS.
         * </p>
         * <p>
         * For a change data capture (CDC) load, each row of the timestamp column contains the timestamp for the commit
         * of that row in the source database.
         * </p>
         * <p>
         * The string format for this timestamp column value is <code>yyyy-MM-dd HH:mm:ss.SSSSSS</code>. By default, the
         * precision of this value is in microseconds. For a CDC load, the rounding of the precision depends on the
         * commit timestamp supported by DMS for the source database.
         * </p>
         * <p>
         * When the <code>AddColumnName</code> parameter is set to <code>true</code>, DMS also includes a name for the
         * timestamp column that you set with <code>TimestampColumnName</code>.
         * </p>
         * 
         * @param timestampColumnName
         *        A value that when nonblank causes AWS DMS to add a column with timestamp information to the endpoint
         *        data for an Amazon S3 target.</p> <note>
         *        <p>
         *        AWS DMS supports the <code>TimestampColumnName</code> parameter in versions 3.1.4 and later.
         *        </p>
         *        </note>
         *        <p>
         *        DMS includes an additional <code>STRING</code> column in the .csv or .parquet object files of your
         *        migrated data when you set <code>TimestampColumnName</code> to a nonblank value.
         *        </p>
         *        <p>
         *        For a full load, each row of this timestamp column contains a timestamp for when the data was
         *        transferred from the source to the target by DMS.
         *        </p>
         *        <p>
         *        For a change data capture (CDC) load, each row of the timestamp column contains the timestamp for the
         *        commit of that row in the source database.
         *        </p>
         *        <p>
         *        The string format for this timestamp column value is <code>yyyy-MM-dd HH:mm:ss.SSSSSS</code>. By
         *        default, the precision of this value is in microseconds. For a CDC load, the rounding of the precision
         *        depends on the commit timestamp supported by DMS for the source database.
         *        </p>
         *        <p>
         *        When the <code>AddColumnName</code> parameter is set to <code>true</code>, DMS also includes a name
         *        for the timestamp column that you set with <code>TimestampColumnName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampColumnName(String timestampColumnName);

        /**
         * <p>
         * A value that specifies the precision of any <code>TIMESTAMP</code> column values that are written to an
         * Amazon S3 object file in .parquet format.
         * </p>
         * <note>
         * <p>
         * AWS DMS supports the <code>ParquetTimestampInMillisecond</code> parameter in versions 3.1.4 and later.
         * </p>
         * </note>
         * <p>
         * When <code>ParquetTimestampInMillisecond</code> is set to <code>true</code> or <code>y</code>, AWS DMS writes
         * all <code>TIMESTAMP</code> columns in a .parquet formatted file with millisecond precision. Otherwise, DMS
         * writes them with microsecond precision.
         * </p>
         * <p>
         * Currently, Amazon Athena and AWS Glue can handle only millisecond precision for <code>TIMESTAMP</code>
         * values. Set this parameter to <code>true</code> for S3 endpoint object files that are .parquet formatted only
         * if you plan to query or process the data with Athena or AWS Glue.
         * </p>
         * <note>
         * <p>
         * AWS DMS writes any <code>TIMESTAMP</code> column values written to an S3 file in .csv format with microsecond
         * precision.
         * </p>
         * <p>
         * Setting <code>ParquetTimestampInMillisecond</code> has no effect on the string format of the timestamp column
         * value that is inserted by setting the <code>TimestampColumnName</code> parameter.
         * </p>
         * </note>
         * 
         * @param parquetTimestampInMillisecond
         *        A value that specifies the precision of any <code>TIMESTAMP</code> column values that are written to
         *        an Amazon S3 object file in .parquet format.</p> <note>
         *        <p>
         *        AWS DMS supports the <code>ParquetTimestampInMillisecond</code> parameter in versions 3.1.4 and later.
         *        </p>
         *        </note>
         *        <p>
         *        When <code>ParquetTimestampInMillisecond</code> is set to <code>true</code> or <code>y</code>, AWS DMS
         *        writes all <code>TIMESTAMP</code> columns in a .parquet formatted file with millisecond precision.
         *        Otherwise, DMS writes them with microsecond precision.
         *        </p>
         *        <p>
         *        Currently, Amazon Athena and AWS Glue can handle only millisecond precision for <code>TIMESTAMP</code>
         *        values. Set this parameter to <code>true</code> for S3 endpoint object files that are .parquet
         *        formatted only if you plan to query or process the data with Athena or AWS Glue.
         *        </p>
         *        <note>
         *        <p>
         *        AWS DMS writes any <code>TIMESTAMP</code> column values written to an S3 file in .csv format with
         *        microsecond precision.
         *        </p>
         *        <p>
         *        Setting <code>ParquetTimestampInMillisecond</code> has no effect on the string format of the timestamp
         *        column value that is inserted by setting the <code>TimestampColumnName</code> parameter.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parquetTimestampInMillisecond(Boolean parquetTimestampInMillisecond);
    }

    static final class BuilderImpl implements Builder {
        private String serviceAccessRoleArn;

        private String externalTableDefinition;

        private String csvRowDelimiter;

        private String csvDelimiter;

        private String bucketFolder;

        private String bucketName;

        private String compressionType;

        private String encryptionMode;

        private String serverSideEncryptionKmsKeyId;

        private String dataFormat;

        private String encodingType;

        private Integer dictPageSizeLimit;

        private Integer rowGroupLength;

        private Integer dataPageSize;

        private String parquetVersion;

        private Boolean enableStatistics;

        private Boolean includeOpForFullLoad;

        private Boolean cdcInsertsOnly;

        private String timestampColumnName;

        private Boolean parquetTimestampInMillisecond;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Settings model) {
            serviceAccessRoleArn(model.serviceAccessRoleArn);
            externalTableDefinition(model.externalTableDefinition);
            csvRowDelimiter(model.csvRowDelimiter);
            csvDelimiter(model.csvDelimiter);
            bucketFolder(model.bucketFolder);
            bucketName(model.bucketName);
            compressionType(model.compressionType);
            encryptionMode(model.encryptionMode);
            serverSideEncryptionKmsKeyId(model.serverSideEncryptionKmsKeyId);
            dataFormat(model.dataFormat);
            encodingType(model.encodingType);
            dictPageSizeLimit(model.dictPageSizeLimit);
            rowGroupLength(model.rowGroupLength);
            dataPageSize(model.dataPageSize);
            parquetVersion(model.parquetVersion);
            enableStatistics(model.enableStatistics);
            includeOpForFullLoad(model.includeOpForFullLoad);
            cdcInsertsOnly(model.cdcInsertsOnly);
            timestampColumnName(model.timestampColumnName);
            parquetTimestampInMillisecond(model.parquetTimestampInMillisecond);
        }

        public final String getServiceAccessRoleArn() {
            return serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        public final String getExternalTableDefinition() {
            return externalTableDefinition;
        }

        @Override
        public final Builder externalTableDefinition(String externalTableDefinition) {
            this.externalTableDefinition = externalTableDefinition;
            return this;
        }

        public final void setExternalTableDefinition(String externalTableDefinition) {
            this.externalTableDefinition = externalTableDefinition;
        }

        public final String getCsvRowDelimiter() {
            return csvRowDelimiter;
        }

        @Override
        public final Builder csvRowDelimiter(String csvRowDelimiter) {
            this.csvRowDelimiter = csvRowDelimiter;
            return this;
        }

        public final void setCsvRowDelimiter(String csvRowDelimiter) {
            this.csvRowDelimiter = csvRowDelimiter;
        }

        public final String getCsvDelimiter() {
            return csvDelimiter;
        }

        @Override
        public final Builder csvDelimiter(String csvDelimiter) {
            this.csvDelimiter = csvDelimiter;
            return this;
        }

        public final void setCsvDelimiter(String csvDelimiter) {
            this.csvDelimiter = csvDelimiter;
        }

        public final String getBucketFolder() {
            return bucketFolder;
        }

        @Override
        public final Builder bucketFolder(String bucketFolder) {
            this.bucketFolder = bucketFolder;
            return this;
        }

        public final void setBucketFolder(String bucketFolder) {
            this.bucketFolder = bucketFolder;
        }

        public final String getBucketName() {
            return bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getCompressionTypeAsString() {
            return compressionType;
        }

        @Override
        public final Builder compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        @Override
        public final Builder compressionType(CompressionTypeValue compressionType) {
            this.compressionType(compressionType == null ? null : compressionType.toString());
            return this;
        }

        public final void setCompressionType(String compressionType) {
            this.compressionType = compressionType;
        }

        public final String getEncryptionModeAsString() {
            return encryptionMode;
        }

        @Override
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        @Override
        public final Builder encryptionMode(EncryptionModeValue encryptionMode) {
            this.encryptionMode(encryptionMode == null ? null : encryptionMode.toString());
            return this;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        public final String getServerSideEncryptionKmsKeyId() {
            return serverSideEncryptionKmsKeyId;
        }

        @Override
        public final Builder serverSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId) {
            this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
            return this;
        }

        public final void setServerSideEncryptionKmsKeyId(String serverSideEncryptionKmsKeyId) {
            this.serverSideEncryptionKmsKeyId = serverSideEncryptionKmsKeyId;
        }

        public final String getDataFormatAsString() {
            return dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(DataFormatValue dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        public final String getEncodingTypeAsString() {
            return encodingType;
        }

        @Override
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingTypeValue encodingType) {
            this.encodingType(encodingType == null ? null : encodingType.toString());
            return this;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        public final Integer getDictPageSizeLimit() {
            return dictPageSizeLimit;
        }

        @Override
        public final Builder dictPageSizeLimit(Integer dictPageSizeLimit) {
            this.dictPageSizeLimit = dictPageSizeLimit;
            return this;
        }

        public final void setDictPageSizeLimit(Integer dictPageSizeLimit) {
            this.dictPageSizeLimit = dictPageSizeLimit;
        }

        public final Integer getRowGroupLength() {
            return rowGroupLength;
        }

        @Override
        public final Builder rowGroupLength(Integer rowGroupLength) {
            this.rowGroupLength = rowGroupLength;
            return this;
        }

        public final void setRowGroupLength(Integer rowGroupLength) {
            this.rowGroupLength = rowGroupLength;
        }

        public final Integer getDataPageSize() {
            return dataPageSize;
        }

        @Override
        public final Builder dataPageSize(Integer dataPageSize) {
            this.dataPageSize = dataPageSize;
            return this;
        }

        public final void setDataPageSize(Integer dataPageSize) {
            this.dataPageSize = dataPageSize;
        }

        public final String getParquetVersionAsString() {
            return parquetVersion;
        }

        @Override
        public final Builder parquetVersion(String parquetVersion) {
            this.parquetVersion = parquetVersion;
            return this;
        }

        @Override
        public final Builder parquetVersion(ParquetVersionValue parquetVersion) {
            this.parquetVersion(parquetVersion == null ? null : parquetVersion.toString());
            return this;
        }

        public final void setParquetVersion(String parquetVersion) {
            this.parquetVersion = parquetVersion;
        }

        public final Boolean getEnableStatistics() {
            return enableStatistics;
        }

        @Override
        public final Builder enableStatistics(Boolean enableStatistics) {
            this.enableStatistics = enableStatistics;
            return this;
        }

        public final void setEnableStatistics(Boolean enableStatistics) {
            this.enableStatistics = enableStatistics;
        }

        public final Boolean getIncludeOpForFullLoad() {
            return includeOpForFullLoad;
        }

        @Override
        public final Builder includeOpForFullLoad(Boolean includeOpForFullLoad) {
            this.includeOpForFullLoad = includeOpForFullLoad;
            return this;
        }

        public final void setIncludeOpForFullLoad(Boolean includeOpForFullLoad) {
            this.includeOpForFullLoad = includeOpForFullLoad;
        }

        public final Boolean getCdcInsertsOnly() {
            return cdcInsertsOnly;
        }

        @Override
        public final Builder cdcInsertsOnly(Boolean cdcInsertsOnly) {
            this.cdcInsertsOnly = cdcInsertsOnly;
            return this;
        }

        public final void setCdcInsertsOnly(Boolean cdcInsertsOnly) {
            this.cdcInsertsOnly = cdcInsertsOnly;
        }

        public final String getTimestampColumnName() {
            return timestampColumnName;
        }

        @Override
        public final Builder timestampColumnName(String timestampColumnName) {
            this.timestampColumnName = timestampColumnName;
            return this;
        }

        public final void setTimestampColumnName(String timestampColumnName) {
            this.timestampColumnName = timestampColumnName;
        }

        public final Boolean getParquetTimestampInMillisecond() {
            return parquetTimestampInMillisecond;
        }

        @Override
        public final Builder parquetTimestampInMillisecond(Boolean parquetTimestampInMillisecond) {
            this.parquetTimestampInMillisecond = parquetTimestampInMillisecond;
            return this;
        }

        public final void setParquetTimestampInMillisecond(Boolean parquetTimestampInMillisecond) {
            this.parquetTimestampInMillisecond = parquetTimestampInMillisecond;
        }

        @Override
        public S3Settings build() {
            return new S3Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
